/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.mongo;

import io.vertx.codegen.annotations.DataObject;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;

@DataObject
public class MongoClientBulkWriteResult {
    public static final String INSERTED_COUNT = "insertedCount";
    public static final String MATCHED_COUNT = "matchedCount";
    public static final String MODIFIED_COUNT = "modifiedCount";
    public static final String DELETED_COUNT = "deletedCount";
    public static final String UPSERTS = "upserts";
    public static final String INSERTS = "inserts";
    public static final String ID = "_id";
    public static final String INDEX = "index";
    public static final long DEFAULT_INSERTED_COUNT = 0L;
    public static final long DEFAULT_MATCHED_COUNT = 0L;
    public static final long DEFAULT_DELETED_COUNT = 0L;
    public static final long DEFAULT_MODIFIED_COUNT = 0L;
    private long insertedCount;
    private long matchedCount;
    private long deletedCount;
    private long modifiedCount;
    private List<JsonObject> upserts;
    private List<JsonObject> inserts;

    public MongoClientBulkWriteResult() {
        this.insertedCount = 0L;
        this.matchedCount = 0L;
        this.deletedCount = 0L;
        this.modifiedCount = 0L;
    }

    public MongoClientBulkWriteResult(long insertedCount, long matchedCount, long deletedCount, long modifiedCount, List<JsonObject> upserts, List<JsonObject> inserts) {
        this.insertedCount = insertedCount;
        this.matchedCount = matchedCount;
        this.deletedCount = deletedCount;
        this.modifiedCount = modifiedCount;
        this.upserts = upserts;
        this.inserts = inserts;
    }

    public MongoClientBulkWriteResult(MongoClientBulkWriteResult other) {
        this.insertedCount = other.insertedCount;
        this.matchedCount = other.matchedCount;
        this.deletedCount = other.deletedCount;
        this.modifiedCount = other.modifiedCount;
        this.upserts = other.upserts != null ? other.upserts.stream().map(JsonObject::copy).collect(Collectors.toList()) : null;
        this.inserts = other.inserts != null ? other.inserts.stream().map(JsonObject::copy).collect(Collectors.toList()) : null;
    }

    public MongoClientBulkWriteResult(JsonObject mongoClientBulkWriteResultJson) {
        JsonArray insertArray;
        this.insertedCount = mongoClientBulkWriteResultJson.getLong(INSERTED_COUNT, 0L);
        this.matchedCount = mongoClientBulkWriteResultJson.getLong(MATCHED_COUNT, 0L);
        this.deletedCount = mongoClientBulkWriteResultJson.getLong(DELETED_COUNT, 0L);
        this.modifiedCount = mongoClientBulkWriteResultJson.getLong(MODIFIED_COUNT, 0L);
        JsonArray upsertArray = mongoClientBulkWriteResultJson.getJsonArray(UPSERTS);
        if (upsertArray != null) {
            this.upserts = upsertArray.stream().filter(object -> object instanceof JsonObject).map(object -> (JsonObject)object).collect(Collectors.toList());
        }
        if ((insertArray = mongoClientBulkWriteResultJson.getJsonArray(INSERTS)) != null) {
            this.inserts = insertArray.stream().filter(object -> object instanceof JsonObject).map(object -> (JsonObject)object).collect(Collectors.toList());
        }
    }

    public JsonObject toJson() {
        JsonObject mongoClientBulkWriteResultJson = new JsonObject();
        if (this.insertedCount != 0L) {
            mongoClientBulkWriteResultJson.put(INSERTED_COUNT, this.insertedCount);
        }
        if (this.matchedCount != 0L) {
            mongoClientBulkWriteResultJson.put(MATCHED_COUNT, this.matchedCount);
        }
        if (this.deletedCount != 0L) {
            mongoClientBulkWriteResultJson.put(DELETED_COUNT, this.deletedCount);
        }
        if (this.modifiedCount != 0L) {
            mongoClientBulkWriteResultJson.put(MODIFIED_COUNT, this.modifiedCount);
        }
        if (this.upserts != null) {
            mongoClientBulkWriteResultJson.put(UPSERTS, new JsonArray(this.upserts));
        }
        if (this.inserts != null) {
            mongoClientBulkWriteResultJson.put(INSERTS, new JsonArray(this.inserts));
        }
        return mongoClientBulkWriteResultJson;
    }

    public long getInsertedCount() {
        return this.insertedCount;
    }

    public long getMatchedCount() {
        return this.matchedCount;
    }

    public long getDeletedCount() {
        return this.deletedCount;
    }

    public long getModifiedCount() {
        return this.modifiedCount;
    }

    public List<JsonObject> getUpserts() {
        if (this.upserts != null) {
            return Collections.unmodifiableList(this.upserts);
        }
        return null;
    }

    public List<JsonObject> getInserts() {
        if (this.inserts != null) {
            return Collections.unmodifiableList(this.inserts);
        }
        return null;
    }

    public int hashCode() {
        int prime = 31;
        int result2 = 1;
        result2 = 31 * result2 + (int)(this.deletedCount ^ this.deletedCount >>> 32);
        result2 = 31 * result2 + (int)(this.insertedCount ^ this.insertedCount >>> 32);
        result2 = 31 * result2 + (int)(this.matchedCount ^ this.matchedCount >>> 32);
        result2 = 31 * result2 + (int)(this.modifiedCount ^ this.modifiedCount >>> 32);
        result2 = 31 * result2 + (this.upserts == null ? 0 : this.upserts.hashCode());
        result2 = 31 * result2 + (this.inserts == null ? 0 : this.inserts.hashCode());
        return result2;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MongoClientBulkWriteResult other = (MongoClientBulkWriteResult)obj;
        if (this.deletedCount != other.deletedCount) {
            return false;
        }
        if (this.insertedCount != other.insertedCount) {
            return false;
        }
        if (this.matchedCount != other.matchedCount) {
            return false;
        }
        if (this.modifiedCount != other.modifiedCount) {
            return false;
        }
        if (this.upserts == null ? other.upserts != null : !this.upserts.equals(other.upserts)) {
            return false;
        }
        return !(this.inserts == null ? other.inserts != null : !this.inserts.equals(other.inserts));
    }
}

