/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.spi;

import io.vertx.core.VertxOptions;
import io.vertx.core.impl.VertxBuilder;
import io.vertx.core.impl.launcher.commands.BareCommand;
import io.vertx.core.json.JsonObject;
import io.vertx.core.metrics.MetricsOptions;
import io.vertx.core.spi.VertxServiceProvider;
import io.vertx.core.spi.metrics.VertxMetrics;

public interface VertxMetricsFactory
extends VertxServiceProvider {
    @Override
    default public void init(VertxBuilder builder) {
        if (builder.metrics() == null) {
            MetricsOptions metricsOptions;
            JsonObject config2 = builder.config();
            VertxOptions options = builder.options();
            metricsOptions = config2 != null && config2.containsKey("metricsOptions") ? this.newOptions(config2.getJsonObject("metricsOptions")) : ((metricsOptions = options.getMetricsOptions()) == null ? this.newOptions() : this.newOptions(metricsOptions));
            BareCommand.configureFromSystemProperties(metricsOptions, "vertx.metrics.options.");
            builder.options().setMetricsOptions(metricsOptions);
            if (options.getMetricsOptions().isEnabled()) {
                builder.metrics(this.metrics(options));
            }
        }
    }

    public VertxMetrics metrics(VertxOptions var1);

    default public MetricsOptions newOptions() {
        return new MetricsOptions();
    }

    default public MetricsOptions newOptions(MetricsOptions options) {
        return this.newOptions(options.toJson());
    }

    default public MetricsOptions newOptions(JsonObject jsonObject) {
        return new MetricsOptions(jsonObject);
    }
}

