/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.http.impl;

import io.netty.handler.codec.DecoderResult;
import io.netty.handler.codec.http.DefaultHttpContent;
import io.netty.handler.codec.http.DefaultHttpRequest;
import io.netty.handler.codec.http.HttpConstants;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.LastHttpContent;
import io.netty.handler.codec.http.multipart.Attribute;
import io.netty.handler.codec.http.multipart.HttpPostRequestDecoder;
import io.netty.handler.codec.http.multipart.InterfaceHttpData;
import io.netty.handler.codec.http2.Http2Headers;
import io.vertx.codegen.annotations.Nullable;
import io.vertx.core.Context;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.MultiMap;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.Cookie;
import io.vertx.core.http.HttpConnection;
import io.vertx.core.http.HttpFrame;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.http.HttpServerFileUpload;
import io.vertx.core.http.HttpServerOptions;
import io.vertx.core.http.HttpServerRequest;
import io.vertx.core.http.HttpVersion;
import io.vertx.core.http.ServerWebSocket;
import io.vertx.core.http.StreamPriority;
import io.vertx.core.http.StreamResetException;
import io.vertx.core.http.impl.Http1xServerRequest;
import io.vertx.core.http.impl.Http2ServerConnection;
import io.vertx.core.http.impl.Http2ServerResponse;
import io.vertx.core.http.impl.Http2ServerStream;
import io.vertx.core.http.impl.Http2ServerStreamHandler;
import io.vertx.core.http.impl.HttpEventHandler;
import io.vertx.core.http.impl.HttpServerRequestInternal;
import io.vertx.core.http.impl.HttpUtils;
import io.vertx.core.http.impl.NettyFileUpload;
import io.vertx.core.http.impl.NettyFileUploadDataFactory;
import io.vertx.core.http.impl.headers.Http2HeadersAdaptor;
import io.vertx.core.impl.ContextInternal;
import io.vertx.core.impl.logging.Logger;
import io.vertx.core.impl.logging.LoggerFactory;
import io.vertx.core.net.HostAndPort;
import io.vertx.core.net.NetSocket;
import io.vertx.core.net.SocketAddress;
import io.vertx.core.spi.observability.HttpRequest;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import java.util.Set;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.security.cert.X509Certificate;

public class Http2ServerRequest
extends HttpServerRequestInternal
implements Http2ServerStreamHandler,
HttpRequest {
    private static final Logger log = LoggerFactory.getLogger(Http1xServerRequest.class);
    protected final ContextInternal context;
    protected final Http2ServerStream stream;
    protected final Http2ServerResponse response;
    private final String serverOrigin;
    private final MultiMap headersMap;
    private Charset paramsCharset = StandardCharsets.UTF_8;
    private MultiMap params;
    private boolean semicolonIsNormalCharInParams;
    private String absoluteURI;
    private MultiMap attributes;
    private HttpEventHandler eventHandler;
    private boolean ended;
    private Handler<HttpServerFileUpload> uploadHandler;
    private boolean expectMultipart;
    private HttpPostRequestDecoder postRequestDecoder;
    private Handler<HttpFrame> customFrameHandler;
    private Handler<StreamPriority> streamPriorityHandler;

    Http2ServerRequest(Http2ServerStream stream2, String serverOrigin, Http2Headers headers, String contentEncoding) {
        this.context = stream2.context;
        this.stream = stream2;
        this.response = new Http2ServerResponse((Http2ServerConnection)stream2.conn, stream2, false, contentEncoding);
        this.serverOrigin = serverOrigin;
        this.headersMap = new Http2HeadersAdaptor(headers);
    }

    private HttpEventHandler eventHandler(boolean create) {
        if (this.eventHandler == null && create) {
            this.eventHandler = new HttpEventHandler(this.context);
        }
        return this.eventHandler;
    }

    @Override
    public void dispatch(Handler<HttpServerRequest> handler) {
        this.context.emit(this, handler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handleException(Throwable cause) {
        boolean notify;
        Http2ServerConnection http2ServerConnection = (Http2ServerConnection)this.stream.conn;
        synchronized (http2ServerConnection) {
            notify = !this.ended;
        }
        if (notify) {
            this.notifyException(cause);
        }
        this.response.handleException(cause);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyException(Throwable failure) {
        HttpEventHandler handler;
        InterfaceHttpData upload = null;
        Http2ServerConnection http2ServerConnection = (Http2ServerConnection)this.stream.conn;
        synchronized (http2ServerConnection) {
            if (this.postRequestDecoder != null) {
                upload = this.postRequestDecoder.currentPartialHttpData();
            }
            handler = this.eventHandler;
        }
        if (handler != null) {
            handler.handleException(failure);
        }
        if (upload instanceof NettyFileUpload) {
            ((NettyFileUpload)upload).handleException(failure);
        }
    }

    @Override
    public void handleClose() {
        this.response.handleClose();
    }

    @Override
    public void handleCustomFrame(HttpFrame frame) {
        if (this.customFrameHandler != null) {
            this.customFrameHandler.handle(frame);
        }
    }

    @Override
    public void handleData(Buffer data) {
        HttpEventHandler handler;
        if (this.postRequestDecoder != null) {
            try {
                this.postRequestDecoder.offer(new DefaultHttpContent(data.getByteBuf()));
            }
            catch (HttpPostRequestDecoder.ErrorDataDecoderException | HttpPostRequestDecoder.TooLongFormFieldException | HttpPostRequestDecoder.TooManyFormFieldsException e) {
                this.postRequestDecoder.destroy();
                this.postRequestDecoder = null;
                this.handleException(e);
            }
        }
        if ((handler = this.eventHandler) != null) {
            handler.handleChunk(data);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handleEnd(MultiMap trailers) {
        HttpEventHandler handler;
        Http2ServerConnection http2ServerConnection = (Http2ServerConnection)this.stream.conn;
        synchronized (http2ServerConnection) {
            this.ended = true;
            if (this.postRequestDecoder != null) {
                try {
                    this.postRequestDecoder.offer(LastHttpContent.EMPTY_LAST_CONTENT);
                    while (this.postRequestDecoder.hasNext()) {
                        InterfaceHttpData data = this.postRequestDecoder.next();
                        if (!(data instanceof Attribute)) continue;
                        Attribute attr = (Attribute)data;
                        try {
                            this.formAttributes().add(attr.getName(), attr.getValue());
                        }
                        catch (Exception e) {
                            this.handleException(e);
                        }
                        finally {
                            attr.release();
                        }
                    }
                }
                catch (HttpPostRequestDecoder.EndOfDataDecoderException data) {
                }
                catch (Exception e) {
                    this.handleException(e);
                }
                finally {
                    this.postRequestDecoder.destroy();
                    this.postRequestDecoder = null;
                }
            }
            handler = this.eventHandler;
        }
        if (handler != null) {
            handler.handleEnd();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handleReset(long errorCode) {
        boolean notify;
        Http2ServerConnection http2ServerConnection = (Http2ServerConnection)this.stream.conn;
        synchronized (http2ServerConnection) {
            notify = !this.ended;
            this.ended = true;
        }
        if (notify) {
            this.notifyException(new StreamResetException(errorCode));
        }
        this.response.handleReset(errorCode);
    }

    private void checkEnded() {
        if (this.ended) {
            throw new IllegalStateException("Request has already been read");
        }
    }

    @Override
    public HttpMethod method() {
        return this.stream.method;
    }

    @Override
    public int id() {
        return this.stream.id();
    }

    @Override
    public Object metric() {
        return this.stream.metric();
    }

    @Override
    public Context context() {
        return this.context;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HttpServerRequest exceptionHandler(Handler<Throwable> handler) {
        Http2ServerConnection http2ServerConnection = (Http2ServerConnection)this.stream.conn;
        synchronized (http2ServerConnection) {
            HttpEventHandler eventHandler = this.eventHandler(handler != null);
            if (eventHandler != null) {
                eventHandler.exceptionHandler(handler);
            }
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HttpServerRequest handler(Handler<Buffer> handler) {
        Http2ServerConnection http2ServerConnection = (Http2ServerConnection)this.stream.conn;
        synchronized (http2ServerConnection) {
            HttpEventHandler eventHandler;
            if (handler != null) {
                this.checkEnded();
            }
            if ((eventHandler = this.eventHandler(handler != null)) != null) {
                eventHandler.chunkHandler(handler);
            }
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HttpServerRequest pause() {
        Http2ServerConnection http2ServerConnection = (Http2ServerConnection)this.stream.conn;
        synchronized (http2ServerConnection) {
            this.checkEnded();
            this.stream.doPause();
        }
        return this;
    }

    @Override
    public HttpServerRequest resume() {
        return this.fetch(Long.MAX_VALUE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HttpServerRequest fetch(long amount) {
        Http2ServerConnection http2ServerConnection = (Http2ServerConnection)this.stream.conn;
        synchronized (http2ServerConnection) {
            this.checkEnded();
            this.stream.doFetch(amount);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HttpServerRequest endHandler(Handler<Void> handler) {
        Http2ServerConnection http2ServerConnection = (Http2ServerConnection)this.stream.conn;
        synchronized (http2ServerConnection) {
            HttpEventHandler eventHandler;
            if (handler != null) {
                this.checkEnded();
            }
            if ((eventHandler = this.eventHandler(handler != null)) != null) {
                eventHandler.endHandler(handler);
            }
        }
        return this;
    }

    @Override
    public HttpVersion version() {
        return HttpVersion.HTTP_2;
    }

    @Override
    public String uri() {
        return this.stream.uri;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String path() {
        Http2ServerConnection http2ServerConnection = (Http2ServerConnection)this.stream.conn;
        synchronized (http2ServerConnection) {
            return this.stream.uri != null ? HttpUtils.parsePath(this.stream.uri) : null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String query() {
        Http2ServerConnection http2ServerConnection = (Http2ServerConnection)this.stream.conn;
        synchronized (http2ServerConnection) {
            if (this.stream.uri == null) {
                return null;
            }
            return HttpUtils.parseQuery(this.stream.uri);
        }
    }

    @Override
    public String scheme() {
        return this.stream.scheme;
    }

    @Override
    public String host() {
        return this.stream.host;
    }

    @Override
    public @Nullable HostAndPort authority() {
        return this.stream.authority;
    }

    @Override
    public long bytesRead() {
        return this.stream.bytesRead();
    }

    @Override
    public Http2ServerResponse response() {
        return this.response;
    }

    @Override
    public MultiMap headers() {
        return this.headersMap;
    }

    @Override
    public HttpServerRequest setParamsCharset(String charset) {
        Objects.requireNonNull(charset, "Charset must not be null");
        Charset current = this.paramsCharset;
        this.paramsCharset = Charset.forName(charset);
        if (!this.paramsCharset.equals(current)) {
            this.params = null;
        }
        return this;
    }

    @Override
    public String getParamsCharset() {
        return this.paramsCharset.name();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MultiMap params(boolean semicolonIsNormalChar) {
        Http2ServerConnection http2ServerConnection = (Http2ServerConnection)this.stream.conn;
        synchronized (http2ServerConnection) {
            if (this.params == null || semicolonIsNormalChar != this.semicolonIsNormalCharInParams) {
                this.params = HttpUtils.params(this.uri(), this.paramsCharset, semicolonIsNormalChar);
                this.semicolonIsNormalCharInParams = semicolonIsNormalChar;
            }
            return this.params;
        }
    }

    @Override
    public X509Certificate[] peerCertificateChain() throws SSLPeerUnverifiedException {
        return ((Http2ServerConnection)this.stream.conn).peerCertificateChain();
    }

    @Override
    public SocketAddress remoteAddress() {
        return super.remoteAddress();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String absoluteURI() {
        if (this.stream.method == HttpMethod.CONNECT) {
            return null;
        }
        Http2ServerConnection http2ServerConnection = (Http2ServerConnection)this.stream.conn;
        synchronized (http2ServerConnection) {
            if (this.absoluteURI == null) {
                this.absoluteURI = HttpUtils.absoluteURI(this.serverOrigin, this);
            }
            return this.absoluteURI;
        }
    }

    @Override
    public Future<NetSocket> toNetSocket() {
        return this.response.netSocket();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HttpServerRequest setExpectMultipart(boolean expect) {
        Http2ServerConnection http2ServerConnection = (Http2ServerConnection)this.stream.conn;
        synchronized (http2ServerConnection) {
            this.checkEnded();
            this.expectMultipart = expect;
            if (expect) {
                if (this.postRequestDecoder == null) {
                    String contentType = this.headersMap.get(HttpHeaderNames.CONTENT_TYPE);
                    if (contentType == null) {
                        throw new IllegalStateException("Request must have a content-type header to decode a multipart request");
                    }
                    if (!HttpUtils.isValidMultipartContentType(contentType)) {
                        throw new IllegalStateException("Request must have a valid content-type header to decode a multipart request");
                    }
                    if (!HttpUtils.isValidMultipartMethod(this.stream.method.toNetty())) {
                        throw new IllegalStateException("Request method must be one of POST, PUT, PATCH or DELETE to decode a multipart request");
                    }
                    DefaultHttpRequest req = new DefaultHttpRequest(io.netty.handler.codec.http.HttpVersion.HTTP_1_1, this.stream.method.toNetty(), this.stream.uri);
                    req.headers().add((CharSequence)HttpHeaderNames.CONTENT_TYPE, (Object)contentType);
                    NettyFileUploadDataFactory factory2 = new NettyFileUploadDataFactory(this.context, this, () -> this.uploadHandler);
                    HttpServerOptions options = ((Http2ServerConnection)this.stream.conn).options;
                    factory2.setMaxLimit(options.getMaxFormAttributeSize());
                    int maxFields = options.getMaxFormFields();
                    int maxBufferedBytes = options.getMaxFormBufferedBytes();
                    this.postRequestDecoder = new HttpPostRequestDecoder(factory2, req, HttpConstants.DEFAULT_CHARSET, maxFields, maxBufferedBytes);
                }
            } else {
                this.postRequestDecoder = null;
            }
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isExpectMultipart() {
        Http2ServerConnection http2ServerConnection = (Http2ServerConnection)this.stream.conn;
        synchronized (http2ServerConnection) {
            return this.expectMultipart;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HttpServerRequest uploadHandler(@Nullable Handler<HttpServerFileUpload> handler) {
        Http2ServerConnection http2ServerConnection = (Http2ServerConnection)this.stream.conn;
        synchronized (http2ServerConnection) {
            if (handler != null) {
                this.checkEnded();
            }
            this.uploadHandler = handler;
            return this;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MultiMap formAttributes() {
        Http2ServerConnection http2ServerConnection = (Http2ServerConnection)this.stream.conn;
        synchronized (http2ServerConnection) {
            if (this.attributes == null) {
                this.attributes = MultiMap.caseInsensitiveMultiMap();
            }
            return this.attributes;
        }
    }

    @Override
    public String getFormAttribute(String attributeName) {
        return this.formAttributes().get(attributeName);
    }

    @Override
    public int streamId() {
        return this.stream.id();
    }

    @Override
    public Future<ServerWebSocket> toWebSocket() {
        return this.context.failedFuture("HTTP/2 request cannot be upgraded to a WebSocket");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isEnded() {
        Http2ServerConnection http2ServerConnection = (Http2ServerConnection)this.stream.conn;
        synchronized (http2ServerConnection) {
            return this.ended;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HttpServerRequest customFrameHandler(Handler<HttpFrame> handler) {
        Http2ServerConnection http2ServerConnection = (Http2ServerConnection)this.stream.conn;
        synchronized (http2ServerConnection) {
            this.customFrameHandler = handler;
        }
        return this;
    }

    @Override
    public HttpConnection connection() {
        return this.stream.conn;
    }

    @Override
    public synchronized Future<Buffer> body() {
        this.checkEnded();
        return this.eventHandler(true).body();
    }

    @Override
    public synchronized Future<Void> end() {
        this.checkEnded();
        return this.eventHandler(true).end();
    }

    @Override
    public StreamPriority streamPriority() {
        return this.stream.priority();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HttpServerRequest streamPriorityHandler(Handler<StreamPriority> handler) {
        Http2ServerConnection http2ServerConnection = (Http2ServerConnection)this.stream.conn;
        synchronized (http2ServerConnection) {
            this.streamPriorityHandler = handler;
        }
        return this;
    }

    @Override
    public DecoderResult decoderResult() {
        return DecoderResult.SUCCESS;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handlePriorityChange(StreamPriority streamPriority) {
        Handler<StreamPriority> handler;
        Http2ServerConnection http2ServerConnection = (Http2ServerConnection)this.stream.conn;
        synchronized (http2ServerConnection) {
            handler = this.streamPriorityHandler;
        }
        if (handler != null) {
            handler.handle(streamPriority);
        }
    }

    @Override
    public Set<Cookie> cookies() {
        return this.response.cookies();
    }

    @Override
    public Set<Cookie> cookies(String name) {
        return this.response.cookies().getAll(name);
    }

    @Override
    public Cookie getCookie(String name) {
        return this.response.cookies().get(name);
    }

    @Override
    public Cookie getCookie(String name, String domain, String path) {
        return this.response.cookies().get(name, domain, path);
    }

    @Override
    public HttpServerRequest routed(String route) {
        this.stream.routed(route);
        return this;
    }
}

