/*
 * Decompiled with CFR 0.152.
 */
package io.sip3.salto.ce.rtpr;

import io.sip3.commons.domain.media.MediaControl;
import io.sip3.commons.domain.payload.RtpReportPayload;
import io.sip3.salto.ce.domain.Address;
import io.sip3.salto.ce.domain.Packet;
import io.sip3.salto.ce.util.MediaUtil;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0010#\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0006\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0005\n\u0002\b\t\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0011\u0012\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0004J\u0016\u0010C\u001a\u00020D2\u0006\u0010E\u001a\u00020F2\u0006\u0010G\u001a\u000201J\u0014\u0010H\u001a\u00020D*\u0002012\u0006\u0010I\u001a\u000201H\u0002R\u001d\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00010\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u001a\u0010\n\u001a\u00020\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u0013\u0010\u0010\u001a\u0004\u0018\u00010\u00078F\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R\u0017\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00070\u0014\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u001a\u0010\u0017\u001a\u00020\u0018X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\u001a\"\u0004\b\u001b\u0010\u001cR\u001a\u0010\u001d\u001a\u00020\u001eX\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001f\u0010 \"\u0004\b!\u0010\"R\u001c\u0010#\u001a\u0004\u0018\u00010$X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b%\u0010&\"\u0004\b'\u0010(R\u0013\u0010)\u001a\u0004\u0018\u00010*8F\u00a2\u0006\u0006\u001a\u0004\b+\u0010,R\u0013\u0010-\u001a\u0004\u0018\u00010*8F\u00a2\u0006\u0006\u001a\u0004\b.\u0010,R\u0012\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010/R\u001a\u00100\u001a\u000201X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b2\u00103\"\u0004\b4\u00105R\u001a\u00106\u001a\u00020\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b7\u0010\r\"\u0004\b8\u0010\u000fR\u0011\u00109\u001a\u00020:8F\u00a2\u0006\u0006\u001a\u0004\b;\u0010<R\u001a\u0010=\u001a\u00020\u001eX\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b>\u0010 \"\u0004\b?\u0010\"R\u001a\u0010@\u001a\u00020\u0018X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bA\u0010\u001a\"\u0004\bB\u0010\u001c\u00a8\u0006J"}, d2={"Lio/sip3/salto/ce/rtpr/RtprStream;", "", "rFactorThreshold", "", "(Ljava/lang/Float;)V", "attributes", "", "", "getAttributes", "()Ljava/util/Map;", "badReportCount", "", "getBadReportCount", "()I", "setBadReportCount", "(I)V", "callId", "getCallId", "()Ljava/lang/String;", "codecNames", "", "getCodecNames", "()Ljava/util/Set;", "createdAt", "", "getCreatedAt", "()J", "setCreatedAt", "(J)V", "dstAddr", "Lio/sip3/salto/ce/domain/Address;", "getDstAddr", "()Lio/sip3/salto/ce/domain/Address;", "setDstAddr", "(Lio/sip3/salto/ce/domain/Address;)V", "mediaControl", "Lio/sip3/commons/domain/media/MediaControl;", "getMediaControl", "()Lio/sip3/commons/domain/media/MediaControl;", "setMediaControl", "(Lio/sip3/commons/domain/media/MediaControl;)V", "mos", "", "getMos", "()Ljava/lang/Double;", "rFactor", "getRFactor", "Ljava/lang/Float;", "report", "Lio/sip3/commons/domain/payload/RtpReportPayload;", "getReport", "()Lio/sip3/commons/domain/payload/RtpReportPayload;", "setReport", "(Lio/sip3/commons/domain/payload/RtpReportPayload;)V", "reportCount", "getReportCount", "setReportCount", "source", "", "getSource", "()B", "srcAddr", "getSrcAddr", "setSrcAddr", "terminatedAt", "getTerminatedAt", "setTerminatedAt", "add", "", "packet", "Lio/sip3/salto/ce/domain/Packet;", "payload", "mergeIn", "other", "sip3-salto-ce"})
public final class RtprStream {
    @Nullable
    private final Float rFactorThreshold;
    private long createdAt;
    private long terminatedAt;
    public Address srcAddr;
    public Address dstAddr;
    @NotNull
    private RtpReportPayload report;
    @Nullable
    private MediaControl mediaControl;
    @NotNull
    private final Set<String> codecNames;
    private int reportCount;
    private int badReportCount;
    @NotNull
    private final Map<String, Object> attributes;

    /*
     * WARNING - void declaration
     */
    public RtprStream(@Nullable Float rFactorThreshold) {
        void $this$report_u24lambda_u240;
        RtpReportPayload rtpReportPayload;
        this.rFactorThreshold = rFactorThreshold;
        RtpReportPayload rtpReportPayload2 = rtpReportPayload = new RtpReportPayload();
        RtprStream rtprStream = this;
        boolean bl = false;
        $this$report_u24lambda_u240.setCreatedAt(System.currentTimeMillis());
        rtprStream.report = rtpReportPayload;
        this.codecNames = new LinkedHashSet();
        this.attributes = new LinkedHashMap();
    }

    public /* synthetic */ RtprStream(Float f, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            f = null;
        }
        this(f);
    }

    public final long getCreatedAt() {
        return this.createdAt;
    }

    public final void setCreatedAt(long l) {
        this.createdAt = l;
    }

    public final long getTerminatedAt() {
        return this.terminatedAt;
    }

    public final void setTerminatedAt(long l) {
        this.terminatedAt = l;
    }

    @NotNull
    public final Address getSrcAddr() {
        Address address = this.srcAddr;
        if (address != null) {
            return address;
        }
        Intrinsics.throwUninitializedPropertyAccessException("srcAddr");
        return null;
    }

    public final void setSrcAddr(@NotNull Address address) {
        Intrinsics.checkNotNullParameter(address, "<set-?>");
        this.srcAddr = address;
    }

    @NotNull
    public final Address getDstAddr() {
        Address address = this.dstAddr;
        if (address != null) {
            return address;
        }
        Intrinsics.throwUninitializedPropertyAccessException("dstAddr");
        return null;
    }

    public final void setDstAddr(@NotNull Address address) {
        Intrinsics.checkNotNullParameter(address, "<set-?>");
        this.dstAddr = address;
    }

    @NotNull
    public final RtpReportPayload getReport() {
        return this.report;
    }

    public final void setReport(@NotNull RtpReportPayload rtpReportPayload) {
        Intrinsics.checkNotNullParameter(rtpReportPayload, "<set-?>");
        this.report = rtpReportPayload;
    }

    public final byte getSource() {
        return this.report.getSource();
    }

    @Nullable
    public final MediaControl getMediaControl() {
        return this.mediaControl;
    }

    public final void setMediaControl(@Nullable MediaControl mediaControl) {
        this.mediaControl = mediaControl;
    }

    @NotNull
    public final Set<String> getCodecNames() {
        return this.codecNames;
    }

    @Nullable
    public final String getCallId() {
        MediaControl mediaControl = this.mediaControl;
        return mediaControl != null ? mediaControl.getCallId() : null;
    }

    @Nullable
    public final Double getMos() {
        Float f = Float.valueOf(this.report.getMos());
        float it = ((Number)f).floatValue();
        boolean bl = false;
        Float f2 = !(it == 1.0f) ? f : null;
        return f2 != null ? Double.valueOf(f2.floatValue()) : null;
    }

    @Nullable
    public final Double getRFactor() {
        Float f = Float.valueOf(this.report.getRFactor());
        float it = ((Number)f).floatValue();
        boolean bl = false;
        Float f2 = !(it == 0.0f) ? f : null;
        return f2 != null ? Double.valueOf(f2.floatValue()) : null;
    }

    public final int getReportCount() {
        return this.reportCount;
    }

    public final void setReportCount(int n) {
        this.reportCount = n;
    }

    public final int getBadReportCount() {
        return this.badReportCount;
    }

    public final void setBadReportCount(int n) {
        this.badReportCount = n;
    }

    @NotNull
    public final Map<String, Object> getAttributes() {
        return this.attributes;
    }

    public final void add(@NotNull Packet packet, @NotNull RtpReportPayload payload) {
        block5: {
            Object object;
            Intrinsics.checkNotNullParameter(packet, "packet");
            Intrinsics.checkNotNullParameter(payload, "payload");
            if (this.createdAt == 0L) {
                this.setSrcAddr(packet.getSrcAddr());
                this.setDstAddr(packet.getDstAddr());
            }
            if ((object = payload.getCodecName()) == null) {
                object = "UNDEFINED(" + payload.getPayloadType() + ")";
            }
            this.codecNames.add((String)object);
            this.mergeIn(this.report, payload);
            this.createdAt = this.report.getCreatedAt();
            this.terminatedAt = this.report.getCreatedAt() + (long)this.report.getDuration();
            int n = this.reportCount;
            this.reportCount = n + 1;
            Float f = this.rFactorThreshold;
            if (f != null) {
                float it = ((Number)f).floatValue();
                boolean bl = false;
                Float f2 = this.rFactorThreshold;
                float f3 = this.report.getRFactor();
                boolean bl2 = 0.0f <= f3 ? f3 <= f2.floatValue() : false;
                if (bl2) {
                    int n2 = this.badReportCount;
                    this.badReportCount = n2 + 1;
                }
            }
            Map<String, Object> map2 = packet.getAttributes();
            if (map2 == null) break block5;
            Map<String, Object> $this$forEach$iv = map2;
            boolean $i$f$forEach = false;
            Iterator<Map.Entry<String, Object>> iterator2 = $this$forEach$iv.entrySet().iterator();
            while (iterator2.hasNext()) {
                Map.Entry<String, Object> element$iv;
                Map.Entry<String, Object> entry = element$iv = iterator2.next();
                boolean bl = false;
                String name = entry.getKey();
                Object value = entry.getValue();
                this.attributes.put(name, value);
            }
        }
    }

    private final void mergeIn(RtpReportPayload $this$mergeIn, RtpReportPayload other) {
        if ($this$mergeIn.getSource() < 0) {
            $this$mergeIn.setSource(other.getSource());
        }
        if ($this$mergeIn.getSsrc() == 0L) {
            $this$mergeIn.setSsrc(other.getSsrc());
        }
        if ($this$mergeIn.getCallId() == null) {
            $this$mergeIn.setCallId(other.getCallId());
        }
        if ($this$mergeIn.getCodecName() == null) {
            $this$mergeIn.setCodecName(other.getCodecName());
        }
        if ($this$mergeIn.getPayloadType() < 0) {
            $this$mergeIn.setPayloadType(other.getPayloadType());
        }
        $this$mergeIn.setExpectedPacketCount($this$mergeIn.getExpectedPacketCount() + other.getExpectedPacketCount());
        $this$mergeIn.setReceivedPacketCount($this$mergeIn.getReceivedPacketCount() + other.getReceivedPacketCount());
        $this$mergeIn.setRejectedPacketCount($this$mergeIn.getRejectedPacketCount() + other.getRejectedPacketCount());
        $this$mergeIn.setLostPacketCount($this$mergeIn.getLostPacketCount() + other.getLostPacketCount());
        $this$mergeIn.setMarkerPacketCount($this$mergeIn.getMarkerPacketCount() + other.getMarkerPacketCount());
        $this$mergeIn.setDuration($this$mergeIn.getDuration() + other.getDuration());
        if ($this$mergeIn.getReportedAt() < other.getReportedAt()) {
            $this$mergeIn.setLastJitter(other.getLastJitter());
        }
        $this$mergeIn.setAvgJitter(($this$mergeIn.getAvgJitter() * (float)this.reportCount + other.getAvgJitter()) / (float)(this.reportCount + 1));
        $this$mergeIn.setMinJitter(Math.min($this$mergeIn.getMinJitter(), other.getMinJitter()));
        $this$mergeIn.setMaxJitter(Math.max($this$mergeIn.getMaxJitter(), other.getMaxJitter()));
        if ($this$mergeIn.getRFactor() > 0.0f || other.getRFactor() > 0.0f) {
            $this$mergeIn.setRFactor(($this$mergeIn.getRFactor() * (float)this.reportCount + other.getRFactor()) / (float)(this.reportCount + 1));
            $this$mergeIn.setMos(MediaUtil.INSTANCE.computeMos($this$mergeIn.getRFactor()));
        }
        $this$mergeIn.setFractionLost((float)$this$mergeIn.getLostPacketCount() / (float)$this$mergeIn.getExpectedPacketCount());
        $this$mergeIn.setCreatedAt(Math.min($this$mergeIn.getCreatedAt(), other.getCreatedAt()));
        $this$mergeIn.setReportedAt(Math.max($this$mergeIn.getReportedAt(), other.getReportedAt()));
    }

    public RtprStream() {
        this(null, 1, null);
    }
}

