/*
 * Decompiled with CFR 0.152.
 */
package io.sip3.salto.ce.router;

import io.micrometer.core.instrument.Counter;
import io.sip3.commons.domain.payload.RawPayload;
import io.sip3.commons.micrometer.Metrics;
import io.sip3.commons.vertx.annotations.Instance;
import io.sip3.commons.vertx.util.EventBusUtilKt;
import io.sip3.salto.ce.RoutesCE;
import io.sip3.salto.ce.domain.Address;
import io.sip3.salto.ce.domain.Packet;
import io.sip3.salto.ce.management.host.HostRegistry;
import io.sip3.salto.ce.router.Router;
import io.sip3.salto.ce.udf.UdfExecutor;
import io.vertx.core.AbstractVerticle;
import io.vertx.core.AsyncResult;
import io.vertx.core.Vertx;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.eventbus.EventBus;
import io.vertx.core.eventbus.Message;
import io.vertx.core.json.JsonObject;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import mu.KLogger;
import mu.KotlinLogging;
import org.jetbrains.annotations.NotNull;

@Instance
@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0017\u0018\u0000 \u001c2\u00020\u0001:\u0001\u001cB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u0018\u0010\u0015\u001a\u00020\u00122\u0006\u0010\u0016\u001a\u00020\u00142\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J\u0010\u0010\u0019\u001a\u00020\u00122\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J\u0018\u0010\u001a\u001a\u00020\u00122\u0006\u0010\u0016\u001a\u00020\u00142\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J\b\u0010\u001b\u001a\u00020\u0012H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u001a\u0010\u000b\u001a\u00020\fX\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010\u00a8\u0006\u001d"}, d2={"Lio/sip3/salto/ce/router/Router;", "Lio/vertx/core/AbstractVerticle;", "()V", "hostRegistry", "Lio/sip3/salto/ce/management/host/HostRegistry;", "logger", "Lmu/KLogger;", "packetsRouted", "Lio/micrometer/core/instrument/Counter;", "getPacketsRouted", "()Lio/micrometer/core/instrument/Counter;", "udfExecutor", "Lio/sip3/salto/ce/udf/UdfExecutor;", "getUdfExecutor", "()Lio/sip3/salto/ce/udf/UdfExecutor;", "setUdfExecutor", "(Lio/sip3/salto/ce/udf/UdfExecutor;)V", "assignHost", "", "address", "Lio/sip3/salto/ce/domain/Address;", "handle", "sender", "packet", "Lio/sip3/salto/ce/domain/Packet;", "route", "routeRaw", "start", "Companion", "sip3-salto-ce"})
public class Router
extends AbstractVerticle {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final KLogger logger = KotlinLogging.INSTANCE.logger(logger.1.INSTANCE);
    @NotNull
    private final Counter packetsRouted = Metrics.counter$default(Metrics.INSTANCE, "packets_routed", null, 2, null);
    public UdfExecutor udfExecutor;
    private HostRegistry hostRegistry;
    @NotNull
    public static final String PROTO_HEP3 = "HEP3";

    @NotNull
    public final Counter getPacketsRouted() {
        return this.packetsRouted;
    }

    @NotNull
    public final UdfExecutor getUdfExecutor() {
        UdfExecutor udfExecutor = this.udfExecutor;
        if (udfExecutor != null) {
            return udfExecutor;
        }
        Intrinsics.throwUninitializedPropertyAccessException("udfExecutor");
        return null;
    }

    public final void setUdfExecutor(@NotNull UdfExecutor udfExecutor) {
        Intrinsics.checkNotNullParameter(udfExecutor, "<set-?>");
        this.udfExecutor = udfExecutor;
    }

    @Override
    public void start() {
        Vertx vertx = this.vertx;
        Intrinsics.checkNotNullExpressionValue(vertx, "vertx");
        this.setUdfExecutor(new UdfExecutor(vertx));
        Vertx vertx2 = this.vertx;
        Intrinsics.checkNotNullExpressionValue(vertx2, "vertx");
        JsonObject jsonObject = this.config();
        Intrinsics.checkNotNullExpressionValue(jsonObject, "config()");
        this.hostRegistry = HostRegistry.INSTANCE.getInstance(vertx2, jsonObject);
        this.vertx.eventBus().localConsumer(RoutesCE.Companion.getRouter(), arg_0 -> Router.start$lambda$1(this, arg_0));
    }

    public void handle(@NotNull Address sender, @NotNull Packet packet) {
        Intrinsics.checkNotNullParameter(sender, "sender");
        Intrinsics.checkNotNullParameter(packet, "packet");
        if (packet.getType() == 2) {
            this.routeRaw(sender, packet);
            return;
        }
        this.assignHost(sender);
        this.assignHost(packet.getSrcAddr());
        this.assignHost(packet.getDstAddr());
        this.getUdfExecutor().execute(RoutesCE.Companion.getPacket_udf(), (Function0<? extends Map<String, Object>>)new Function0<Map<String, Object>>(sender, packet){
            final /* synthetic */ Address $sender;
            final /* synthetic */ Packet $packet;
            {
                this.$sender = $sender;
                this.$packet = $packet;
                super(0);
            }

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final Map<String, Object> invoke() {
                void $this$invoke_u24lambda_u244_u24lambda_u243;
                Map map2;
                Map map3 = new LinkedHashMap<K, V>();
                Address address = this.$sender;
                Packet packet = this.$packet;
                Map $this$invoke_u24lambda_u244 = map3;
                boolean bl = false;
                $this$invoke_u24lambda_u244.put("sender_addr", address.getAddr());
                $this$invoke_u24lambda_u244.put("sender_port", address.getPort());
                String string = address.getHost();
                if (string != null) {
                    String it = string;
                    boolean bl2 = false;
                    $this$invoke_u24lambda_u244.put("sender_host", it);
                }
                Map map4 = map2 = (Map)new LinkedHashMap<K, V>();
                String string2 = "payload";
                Map map5 = $this$invoke_u24lambda_u244;
                boolean bl3 = false;
                Address src = packet.getSrcAddr();
                $this$invoke_u24lambda_u244_u24lambda_u243.put("src_addr", src.getAddr());
                $this$invoke_u24lambda_u244_u24lambda_u243.put("src_port", src.getPort());
                String string3 = src.getHost();
                if (string3 != null) {
                    String it = string3;
                    boolean bl4 = false;
                    $this$invoke_u24lambda_u244_u24lambda_u243.put("src_host", it);
                }
                Address dst = packet.getDstAddr();
                $this$invoke_u24lambda_u244_u24lambda_u243.put("dst_addr", dst.getAddr());
                $this$invoke_u24lambda_u244_u24lambda_u243.put("dst_port", dst.getPort());
                String string4 = dst.getHost();
                if (string4 != null) {
                    String it = string4;
                    boolean bl5 = false;
                    $this$invoke_u24lambda_u244_u24lambda_u243.put("dst_host", it);
                }
                Unit unit = Unit.INSTANCE;
                map5.put(string2, map2);
                return map3;
            }
        }, (Function1<? super AsyncResult<Pair<Boolean, Map<String, Object>>>, Unit>)new Function1<AsyncResult<Pair<? extends Boolean, ? extends Map<String, ? extends Object>>>, Unit>(this, packet){
            final /* synthetic */ Router this$0;
            final /* synthetic */ Packet $packet;
            {
                this.this$0 = $receiver;
                this.$packet = $packet;
                super(1);
            }

            public final void invoke(@NotNull AsyncResult<Pair<Boolean, Map<String, Object>>> asr) {
                Intrinsics.checkNotNullParameter(asr, "asr");
                boolean result2 = asr.result().component1();
                if (result2) {
                    this.this$0.route(this.$packet);
                }
            }
        });
    }

    public void routeRaw(@NotNull Address sender, @NotNull Packet packet) {
        RawPayload rawPayload;
        Intrinsics.checkNotNullParameter(sender, "sender");
        Intrinsics.checkNotNullParameter(packet, "packet");
        RawPayload $this$routeRaw_u24lambda_u242 = rawPayload = new RawPayload();
        boolean bl = false;
        $this$routeRaw_u24lambda_u242.decode(packet.getPayload());
        RawPayload rawPayload2 = rawPayload;
        Buffer buffer = Buffer.buffer(rawPayload2.getPayload());
        if (Intrinsics.areEqual(buffer.getString(0, 4), PROTO_HEP3)) {
            EventBus eventBus = this.vertx.eventBus();
            Intrinsics.checkNotNullExpressionValue(eventBus, "vertx.eventBus()");
            EventBusUtilKt.localSend$default(eventBus, RoutesCE.Companion.getHep3(), new Pair<Address, Buffer>(sender, buffer), null, 4, null);
        }
    }

    public void assignHost(@NotNull Address address) {
        block1: {
            Intrinsics.checkNotNullParameter(address, "address");
            HostRegistry hostRegistry = this.hostRegistry;
            if (hostRegistry == null) {
                Intrinsics.throwUninitializedPropertyAccessException("hostRegistry");
                hostRegistry = null;
            }
            String string = hostRegistry.getHostName(address.getAddr(), address.getPort());
            if (string == null) break block1;
            String it = string;
            boolean bl = false;
            address.setHost(it);
        }
    }

    public void route(@NotNull Packet packet) {
        String route;
        Intrinsics.checkNotNullParameter(packet, "packet");
        byte by = packet.getProtocolCode();
        String string = by == 3 ? RoutesCE.Companion.getSip() : (by == 1 ? RoutesCE.Companion.getRtcp() : (by == 5 ? RoutesCE.Companion.getRtpr() : (by == 8 ? RoutesCE.Companion.getRtpe() : (route = by == 7 ? RoutesCE.Companion.getRec() : null))));
        if (route != null) {
            this.packetsRouted.increment();
            EventBus eventBus = this.vertx.eventBus();
            Intrinsics.checkNotNullExpressionValue(eventBus, "vertx.eventBus()");
            EventBusUtilKt.localSend$default(eventBus, route, packet, null, 4, null);
        }
    }

    private static final void start$lambda$1(Router this$0, Message event) {
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        Pair pair = (Pair)event.body();
        Address sender = (Address)pair.component1();
        List packets = (List)pair.component2();
        Iterable $this$forEach$iv = packets;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Packet packet = (Packet)element$iv;
            boolean bl = false;
            try {
                this$0.handle(sender, packet);
            }
            catch (Exception e) {
                this$0.logger.error("Router 'handle()' failed.", e);
            }
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lio/sip3/salto/ce/router/Router$Companion;", "", "()V", "PROTO_HEP3", "", "sip3-salto-ce"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

