/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.shaded.reactor.core.publisher;

import io.micrometer.shaded.reactor.core.CoreSubscriber;
import io.micrometer.shaded.reactor.core.Fuseable;
import io.micrometer.shaded.reactor.core.Scannable;
import io.micrometer.shaded.reactor.core.observability.SignalListener;
import io.micrometer.shaded.reactor.core.observability.SignalListenerFactory;
import io.micrometer.shaded.reactor.core.publisher.ContextPropagation;
import io.micrometer.shaded.reactor.core.publisher.ContextPropagationSupport;
import io.micrometer.shaded.reactor.core.publisher.FluxTap;
import io.micrometer.shaded.reactor.core.publisher.InternalMonoOperator;
import io.micrometer.shaded.reactor.core.publisher.Mono;
import io.micrometer.shaded.reactor.core.publisher.Operators;
import io.micrometer.shaded.reactor.util.annotation.Nullable;
import io.micrometer.shaded.reactor.util.context.Context;

final class MonoTap<T, STATE>
extends InternalMonoOperator<T, T> {
    final SignalListenerFactory<T, STATE> tapFactory;
    final STATE commonTapState;

    MonoTap(Mono<? extends T> source2, SignalListenerFactory<T, STATE> tapFactory) {
        super(source2);
        this.tapFactory = tapFactory;
        this.commonTapState = tapFactory.initializePublisherState(source2);
    }

    @Override
    public CoreSubscriber<? super T> subscribeOrReturn(CoreSubscriber<? super T> actual) throws Throwable {
        Context ctx;
        SignalListener<T> signalListener;
        try {
            signalListener = this.tapFactory.createListener(this.source, actual.currentContext().readOnly(), this.commonTapState);
        }
        catch (Throwable generatorError) {
            Operators.error(actual, generatorError);
            return null;
        }
        signalListener = ContextPropagationSupport.isContextPropagationAvailable() ? ContextPropagation.contextRestoreForTap(signalListener, actual::currentContext) : signalListener;
        try {
            signalListener.doFirst();
        }
        catch (Throwable listenerError) {
            signalListener.handleListenerError(listenerError);
            Operators.error(actual, listenerError);
            return null;
        }
        try {
            ctx = signalListener.addToContext(actual.currentContext());
        }
        catch (Throwable e) {
            IllegalStateException listenerError = new IllegalStateException("Unable to augment tap Context at subscription via addToContext", e);
            signalListener.handleListenerError(listenerError);
            Operators.error(actual, listenerError);
            return null;
        }
        if (actual instanceof Fuseable.ConditionalSubscriber) {
            return new FluxTap.TapConditionalSubscriber<T>((Fuseable.ConditionalSubscriber)actual, signalListener, ctx);
        }
        return new FluxTap.TapSubscriber<T>(actual, signalListener, ctx);
    }

    @Override
    @Nullable
    public Object scanUnsafe(Scannable.Attr key) {
        if (key == Scannable.Attr.PREFETCH) {
            return -1;
        }
        if (key == Scannable.Attr.RUN_STYLE) {
            return Scannable.Attr.RunStyle.SYNC;
        }
        return super.scanUnsafe(key);
    }
}

