/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.core.instrument.config.validate;

import io.micrometer.core.annotation.Incubating;
import io.micrometer.core.instrument.config.MeterRegistryConfig;
import io.micrometer.core.instrument.config.validate.DurationValidator;
import io.micrometer.core.instrument.config.validate.InvalidReason;
import io.micrometer.core.instrument.config.validate.Validated;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.URI;
import java.time.Duration;
import java.util.Arrays;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;

@Incubating(since="1.5.0")
public class PropertyValidator {
    private PropertyValidator() {
    }

    public static Validated<Duration> getDuration(MeterRegistryConfig config2, String property) {
        String prefixedProperty = PropertyValidator.prefixedProperty(config2, property);
        return DurationValidator.validate(prefixedProperty, config2.get(prefixedProperty));
    }

    public static Validated<TimeUnit> getTimeUnit(MeterRegistryConfig config2, String property) {
        String prefixedProperty = PropertyValidator.prefixedProperty(config2, property);
        return DurationValidator.validateTimeUnit(prefixedProperty, config2.get(prefixedProperty));
    }

    public static Validated<Integer> getInteger(MeterRegistryConfig config2, String property) {
        String prefixedProperty = PropertyValidator.prefixedProperty(config2, property);
        String value = config2.get(prefixedProperty);
        try {
            return Validated.valid(prefixedProperty, value == null ? null : Integer.valueOf(value));
        }
        catch (NumberFormatException e) {
            return Validated.invalid(prefixedProperty, value, "must be an integer", InvalidReason.MALFORMED, e);
        }
    }

    public static <E extends Enum<E>> Validated<E> getEnum(MeterRegistryConfig config2, Class<E> enumClass, String property) {
        String prefixedProperty = PropertyValidator.prefixedProperty(config2, property);
        String value = config2.get(prefixedProperty);
        if (value == null) {
            return Validated.valid(prefixedProperty, null);
        }
        try {
            Enum[] values2;
            for (Enum enumValue : values2 = (Enum[])enumClass.getDeclaredMethod("values", new Class[0]).invoke(enumClass, new Object[0])) {
                if (!enumValue.name().equalsIgnoreCase(value)) continue;
                return Validated.valid(prefixedProperty, enumValue);
            }
            return Validated.invalid(prefixedProperty, value, "should be one of " + Arrays.stream(values2).map(v -> '\'' + v.name() + '\'').collect(Collectors.joining(", ")), InvalidReason.MALFORMED);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static Validated<Boolean> getBoolean(MeterRegistryConfig config2, String property) {
        String prefixedProperty;
        String value = config2.get(prefixedProperty = PropertyValidator.prefixedProperty(config2, property));
        return Validated.valid(prefixedProperty, value == null ? null : Boolean.valueOf(value));
    }

    public static Validated<String> getSecret(MeterRegistryConfig config2, String property) {
        String prefixedProperty = PropertyValidator.prefixedProperty(config2, property);
        return Validated.validSecret(prefixedProperty, config2.get(prefixedProperty));
    }

    public static Validated<String> getString(MeterRegistryConfig config2, String property) {
        String prefixedProperty = PropertyValidator.prefixedProperty(config2, property);
        return Validated.valid(prefixedProperty, config2.get(prefixedProperty));
    }

    public static Validated<String> getUrlString(MeterRegistryConfig config2, String property) {
        String prefixedProperty = PropertyValidator.prefixedProperty(config2, property);
        String value = config2.get(prefixedProperty);
        try {
            return Validated.valid(prefixedProperty, value == null ? null : URI.create(value).toURL()).map(url -> value);
        }
        catch (IllegalArgumentException | MalformedURLException ex) {
            return Validated.invalid(prefixedProperty, value, "must be a valid URL", InvalidReason.MALFORMED, ex);
        }
    }

    public static Validated<String> getUriString(MeterRegistryConfig config2, String property) {
        String prefixedProperty = PropertyValidator.prefixedProperty(config2, property);
        String value = config2.get(prefixedProperty);
        try {
            return Validated.valid(prefixedProperty, value == null ? null : URI.create(value)).map(uri -> value);
        }
        catch (IllegalArgumentException ex) {
            return Validated.invalid(prefixedProperty, value, "must be a valid URI", InvalidReason.MALFORMED, ex);
        }
    }

    private static String prefixedProperty(MeterRegistryConfig config2, String property) {
        return config2.prefix() + '.' + property;
    }
}

