/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.core;

import gov.nist.core.CommonLoggerLog4j;
import gov.nist.core.StackLogger;
import java.util.Properties;
import org.apache.log4j.Logger;

public class CommonLogger
implements StackLogger {
    private String name;
    private StackLogger otherLogger;
    public static boolean useLegacyLogger = true;
    public static StackLogger legacyLogger;

    public CommonLogger(String name) {
        this.name = name;
    }

    private StackLogger logger() {
        if (useLegacyLogger) {
            if (legacyLogger == null) {
                return new CommonLoggerLog4j(Logger.getLogger(this.name));
            }
            return legacyLogger;
        }
        if (this.otherLogger == null) {
            this.otherLogger = new CommonLoggerLog4j(Logger.getLogger(this.name));
        }
        return this.otherLogger;
    }

    public static StackLogger getLogger(String name) {
        return new CommonLogger(name);
    }

    public static StackLogger getLogger(Class clazz) {
        return CommonLogger.getLogger(clazz.getName());
    }

    public static void init(Properties p) {
    }

    @Override
    public void disableLogging() {
        this.logger().disableLogging();
    }

    @Override
    public void enableLogging() {
        this.logger().enableLogging();
    }

    @Override
    public int getLineCount() {
        return this.logger().getLineCount();
    }

    @Override
    public String getLoggerName() {
        return this.logger().getLoggerName();
    }

    @Override
    public boolean isLoggingEnabled() {
        return this.logger().isLoggingEnabled();
    }

    @Override
    public boolean isLoggingEnabled(int logLevel) {
        return this.logger().isLoggingEnabled(logLevel);
    }

    @Override
    public void logDebug(String message) {
        this.logger().logDebug(message);
    }

    @Override
    public void logDebug(String message, Exception ex) {
        this.logger().logDebug(message, ex);
    }

    @Override
    public void logError(String message) {
        this.logger().logError(message);
    }

    @Override
    public void logError(String message, Exception ex) {
        this.logger().logError(message, ex);
    }

    @Override
    public void logException(Throwable ex) {
        this.logger().logException(ex);
    }

    @Override
    public void logFatalError(String message) {
        this.logger().logFatalError(message);
    }

    @Override
    public void logInfo(String string) {
        this.logger().logInfo(string);
    }

    @Override
    public void logStackTrace() {
        this.logger().logStackTrace();
    }

    @Override
    public void logStackTrace(int traceLevel) {
        this.logger().logStackTrace(traceLevel);
    }

    @Override
    public void logTrace(String message) {
        this.logger().logTrace(message);
    }

    @Override
    public void logWarning(String string) {
        this.logger().logWarning(string);
    }

    @Override
    public void setBuildTimeStamp(String buildTimeStamp) {
        this.logger().setBuildTimeStamp(buildTimeStamp);
    }

    @Override
    public void setStackProperties(Properties stackProperties) {
        legacyLogger.setStackProperties(stackProperties);
    }
}

