/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.media.sdp.fields.parser;

import java.util.regex.Pattern;
import org.restcomm.media.sdp.SdpException;
import org.restcomm.media.sdp.SdpParser;
import org.restcomm.media.sdp.fields.VersionField;

public class VersionFieldParser
implements SdpParser<VersionField> {
    private static final String REGEX = "^v=\\d+$";
    private static final Pattern PATTERN = Pattern.compile("^v=\\d+$");

    @Override
    public boolean canParse(String sdp) {
        if (sdp == null || sdp.isEmpty()) {
            return false;
        }
        return PATTERN.matcher(sdp.trim()).matches();
    }

    @Override
    public VersionField parse(String sdp) throws SdpException {
        try {
            short version = Short.parseShort(sdp.trim().substring(2));
            return new VersionField(version);
        }
        catch (Exception e) {
            throw new SdpException("Could not parse SDP: " + sdp, e);
        }
    }

    @Override
    public void parse(VersionField field, String sdp) throws SdpException {
        try {
            short version = Short.parseShort(sdp.trim().substring(2));
            field.setVersion(version);
        }
        catch (Exception e) {
            throw new SdpException("Could not parse SDP: " + sdp, e);
        }
    }
}

