/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.media.sdp.attributes.parser;

import java.util.regex.Pattern;
import org.restcomm.media.sdp.SdpException;
import org.restcomm.media.sdp.SdpParser;
import org.restcomm.media.sdp.attributes.ConnectionModeAttribute;

public class ConnectionModeAttributeParser
implements SdpParser<ConnectionModeAttribute> {
    private static final String REGEX = "^a=(sendonly|recvonly|sendrecv|inactive)$";
    private static final Pattern PATTERN = Pattern.compile("^a=(sendonly|recvonly|sendrecv|inactive)$");

    private boolean isTypeValid(String type) {
        return "sendonly".equals(type) || "recvonly".equals(type) || "sendrecv".equals(type) || "inactive".equals(type);
    }

    @Override
    public boolean canParse(String sdp) {
        if (sdp == null || sdp.isEmpty()) {
            return false;
        }
        return PATTERN.matcher(sdp.trim()).matches();
    }

    @Override
    public ConnectionModeAttribute parse(String sdp) throws SdpException {
        try {
            String mode = sdp.trim().substring(2);
            if (!this.isTypeValid(mode)) {
                throw new IllegalArgumentException("Unknown connection mode");
            }
            return new ConnectionModeAttribute(mode);
        }
        catch (Exception e) {
            throw new SdpException("Could not parse SDP: " + sdp, e);
        }
    }

    @Override
    public void parse(ConnectionModeAttribute field, String sdp) throws SdpException {
        try {
            String mode = sdp.trim().substring(2);
            if (!this.isTypeValid(mode)) {
                throw new IllegalArgumentException("Unknown connection mode");
            }
            field.setMode(mode);
        }
        catch (Exception e) {
            throw new SdpException("Could not parse SDP: " + sdp, e);
        }
    }
}

