/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.mongo.impl.config;

import com.mongodb.ConnectionString;
import com.mongodb.ReadConcern;
import com.mongodb.ReadConcernLevel;
import io.vertx.core.json.JsonObject;

class ReadConcernLevelParser {
    private final ReadConcern readConcern;

    ReadConcernLevelParser(ConnectionString connectionString, JsonObject config2) {
        ReadConcern readConcern = this.fromConfig(config2);
        if (readConcern == null && connectionString != null) {
            readConcern = connectionString.getReadConcern();
        }
        this.readConcern = readConcern;
    }

    private ReadConcern fromConfig(JsonObject config2) {
        String readConcernLevel = config2.getString("readConcernLevel");
        return readConcernLevel != null ? new ReadConcern(ReadConcernLevel.fromString(readConcernLevel)) : null;
    }

    ReadConcern readConcern() {
        return this.readConcern;
    }
}

