/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.javax.sip.header;

import gov.nist.javax.sip.header.SIPHeader;
import javax.sip.header.ExtensionHeader;

public class ExtensionHeaderImpl
extends SIPHeader
implements ExtensionHeader {
    private static final long serialVersionUID = -8693922839612081849L;
    protected String value;

    public ExtensionHeaderImpl() {
    }

    public ExtensionHeaderImpl(String headerName) {
        super(headerName);
    }

    public void setName(String headerName) {
        this.headerName = headerName;
    }

    @Override
    public void setValue(String value) {
        this.value = value;
    }

    @Override
    public String getHeaderValue() {
        if (this.value != null) {
            return this.value;
        }
        String encodedHdr = null;
        try {
            encodedHdr = this.encode();
        }
        catch (Exception ex) {
            return null;
        }
        StringBuilder buffer = new StringBuilder(encodedHdr);
        while (buffer.length() > 0 && buffer.charAt(0) != ':') {
            buffer.deleteCharAt(0);
        }
        buffer.deleteCharAt(0);
        this.value = buffer.toString().trim();
        return this.value;
    }

    @Override
    public String encode() {
        return new StringBuffer(this.headerName).append(":").append(" ").append(this.value).append("\r\n").toString();
    }

    @Override
    public StringBuilder encodeBody(StringBuilder buffer) {
        return buffer.append(this.encodeBody());
    }

    public String encodeBody() {
        return this.getHeaderValue();
    }
}

