/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.javax.sip.address;

import gov.nist.javax.sip.address.NetObject;
import gov.nist.javax.sip.address.SipUri;
import java.text.ParseException;
import javax.sip.address.URI;

public class GenericURI
extends NetObject
implements URI {
    private static final long serialVersionUID = 3237685256878068790L;
    public static final String SIP = "sip";
    public static final String SIPS = "sips";
    public static final String TEL = "tel";
    public static final String POSTDIAL = "postdial";
    public static final String PHONE_CONTEXT_TAG = "context-tag";
    public static final String ISUB = "isub";
    public static final String PROVIDER_TAG = "provider-tag";
    protected String uriString;
    protected String scheme;

    protected GenericURI() {
    }

    public GenericURI(String uriString) throws ParseException {
        try {
            this.uriString = uriString;
            int i2 = uriString.indexOf(":");
            this.scheme = uriString.substring(0, i2);
        }
        catch (Exception e) {
            throw new ParseException("GenericURI, Bad URI format", 0);
        }
    }

    @Override
    public String encode() {
        return this.uriString;
    }

    @Override
    public StringBuilder encode(StringBuilder buffer) {
        return buffer.append(this.uriString);
    }

    @Override
    public String toString() {
        return this.encode();
    }

    @Override
    public String getScheme() {
        return this.scheme;
    }

    @Override
    public boolean isSipURI() {
        return this instanceof SipUri;
    }

    @Override
    public boolean equals(Object that) {
        if (this == that) {
            return true;
        }
        if (that instanceof URI) {
            URI o = (URI)that;
            return this.toString().equalsIgnoreCase(o.toString());
        }
        return false;
    }

    public int hashCode() {
        return this.toString().hashCode();
    }
}

