/*
 * Decompiled with CFR 0.152.
 */
package org.pcap4j.packet;

import java.util.Arrays;
import org.pcap4j.packet.IllegalRawDataException;
import org.pcap4j.packet.LengthBuilder;
import org.pcap4j.packet.SctpPacket;
import org.pcap4j.packet.namednumber.SctpChunkType;
import org.pcap4j.util.ByteArrays;

public final class UnknownSctpChunk
implements SctpPacket.SctpChunk {
    private static final long serialVersionUID = 2870805088630768174L;
    private final SctpChunkType type;
    private final byte flags;
    private final short length;
    private final byte[] value;
    private final byte[] padding;

    public static UnknownSctpChunk newInstance(byte[] rawData, int offset, int length) throws IllegalRawDataException {
        ByteArrays.validateBounds(rawData, offset, length);
        return new UnknownSctpChunk(rawData, offset, length);
    }

    private UnknownSctpChunk(byte[] rawData, int offset, int length) throws IllegalRawDataException {
        if (length < 4) {
            StringBuilder sb = new StringBuilder(100);
            sb.append("The raw data length must be more than 3. rawData: ").append(ByteArrays.toHexString(rawData, " ")).append(", offset: ").append(offset).append(", length: ").append(length);
            throw new IllegalRawDataException(sb.toString());
        }
        this.type = SctpChunkType.getInstance(rawData[offset]);
        this.flags = rawData[1 + offset];
        this.length = ByteArrays.getShort(rawData, 2 + offset);
        int lengthAsInt = this.getLengthAsInt();
        if (length < lengthAsInt) {
            StringBuilder sb = new StringBuilder(100);
            sb.append("The raw data is too short to build this option (").append(lengthAsInt).append("). data: ").append(ByteArrays.toHexString(rawData, " ")).append(", offset: ").append(offset).append(", length: ").append(length);
            throw new IllegalRawDataException(sb.toString());
        }
        if (lengthAsInt < 4) {
            StringBuilder sb = new StringBuilder(100);
            sb.append("The value of the length field must be more than 3. data: ").append(ByteArrays.toHexString(rawData, " ")).append(", offset: ").append(offset).append(", length: ").append(length);
            throw new IllegalRawDataException(sb.toString());
        }
        if (lengthAsInt > 4) {
            this.value = ByteArrays.getSubArray(rawData, 4 + offset, lengthAsInt - 4);
            int paddingLen = 4 - lengthAsInt % 4;
            if (paddingLen != 0 && paddingLen != 4 && length >= lengthAsInt + paddingLen) {
                this.padding = new byte[paddingLen];
                System.arraycopy(rawData, lengthAsInt + offset, this.padding, 0, paddingLen);
            } else {
                this.padding = new byte[0];
            }
        } else {
            this.value = new byte[0];
            this.padding = new byte[0];
        }
    }

    private UnknownSctpChunk(Builder builder) {
        int paddingLen;
        if (builder == null || builder.type == null) {
            StringBuilder sb = new StringBuilder();
            sb.append("builder: ").append(builder).append(" builder.type: ").append(builder.type);
            throw new NullPointerException(sb.toString());
        }
        if (builder.value.length + 4 > 65535) {
            StringBuilder sb = new StringBuilder().append("(value.length + 4) must be less than or equal to 0xFFFF. builder.value: ").append(ByteArrays.toHexString(builder.value, " "));
            throw new IllegalArgumentException(sb.toString());
        }
        this.type = builder.type;
        this.flags = builder.flags;
        this.value = builder.value != null ? ByteArrays.clone(builder.value) : new byte[0];
        this.length = builder.correctLengthAtBuild ? (short)(4 + this.value.length) : builder.length;
        this.padding = builder.paddingAtBuild ? ((paddingLen = 4 - (this.value.length + 4) % 4) != 0 && paddingLen != 4 ? new byte[paddingLen] : new byte[0]) : (builder.padding != null ? ByteArrays.clone(builder.padding) : new byte[0]);
    }

    @Override
    public SctpChunkType getType() {
        return this.type;
    }

    public byte getFlags() {
        return this.flags;
    }

    public short getLength() {
        return this.length;
    }

    public int getLengthAsInt() {
        return 0xFFFF & this.length;
    }

    public byte[] getValue() {
        return ByteArrays.clone(this.value);
    }

    public byte[] getPadding() {
        return ByteArrays.clone(this.padding);
    }

    @Override
    public byte[] getRawData() {
        byte[] rawData = new byte[this.length()];
        rawData[0] = (Byte)this.type.value();
        rawData[1] = this.flags;
        rawData[2] = (byte)(this.length >> 8);
        rawData[3] = (byte)this.length;
        if (this.value.length != 0) {
            System.arraycopy(this.value, 0, rawData, 4, this.value.length);
        }
        if (this.padding.length != 0) {
            System.arraycopy(this.padding, 0, rawData, 4 + this.value.length, this.padding.length);
        }
        return rawData;
    }

    @Override
    public int length() {
        return 4 + this.value.length + this.padding.length;
    }

    public Builder getBuilder() {
        return new Builder(this);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("[Type: ").append(this.type).append(", Flags: 0x").append(ByteArrays.toHexString(this.flags, " ")).append(", Length: ").append(this.getLengthAsInt()).append(" bytes");
        if (this.value.length != 0) {
            sb.append(", Value: 0x").append(ByteArrays.toHexString(this.value, ""));
        }
        if (this.padding.length != 0) {
            sb.append(", Padding: 0x").append(ByteArrays.toHexString(this.padding, ""));
        }
        sb.append("]");
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int result2 = 1;
        result2 = 31 * result2 + this.flags;
        result2 = 31 * result2 + this.length;
        result2 = 31 * result2 + Arrays.hashCode(this.padding);
        result2 = 31 * result2 + this.type.hashCode();
        result2 = 31 * result2 + Arrays.hashCode(this.value);
        return result2;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        UnknownSctpChunk other = (UnknownSctpChunk)obj;
        if (this.flags != other.flags) {
            return false;
        }
        if (this.length != other.length) {
            return false;
        }
        if (!Arrays.equals(this.padding, other.padding)) {
            return false;
        }
        if (!this.type.equals(other.type)) {
            return false;
        }
        return Arrays.equals(this.value, other.value);
    }

    public static final class Builder
    implements LengthBuilder<UnknownSctpChunk> {
        private SctpChunkType type;
        private byte flags;
        private short length;
        private byte[] value;
        private byte[] padding;
        private boolean correctLengthAtBuild;
        private boolean paddingAtBuild;

        public Builder() {
        }

        private Builder(UnknownSctpChunk obj) {
            this.type = obj.type;
            this.flags = obj.flags;
            this.length = obj.length;
            this.value = obj.value;
            this.padding = obj.padding;
        }

        public Builder type(SctpChunkType type) {
            this.type = type;
            return this;
        }

        public Builder flags(byte flags) {
            this.flags = flags;
            return this;
        }

        public Builder length(short length) {
            this.length = length;
            return this;
        }

        public Builder value(byte[] value) {
            this.value = value;
            return this;
        }

        public Builder padding(byte[] padding) {
            this.padding = padding;
            return this;
        }

        public Builder paddingAtBuild(boolean paddingAtBuild) {
            this.paddingAtBuild = paddingAtBuild;
            return this;
        }

        public Builder correctLengthAtBuild(boolean correctLengthAtBuild) {
            this.correctLengthAtBuild = correctLengthAtBuild;
            return this;
        }

        @Override
        public UnknownSctpChunk build() {
            return new UnknownSctpChunk(this);
        }
    }
}

