/*
 * Decompiled with CFR 0.152.
 */
package org.junit.jupiter.engine.descriptor;

import org.junit.jupiter.api.DynamicTest;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.InvocationInterceptor;
import org.junit.jupiter.engine.config.JupiterConfiguration;
import org.junit.jupiter.engine.descriptor.DefaultDynamicTestInvocationContext;
import org.junit.jupiter.engine.descriptor.DynamicNodeTestDescriptor;
import org.junit.jupiter.engine.execution.InvocationInterceptorChain;
import org.junit.jupiter.engine.execution.JupiterEngineExecutionContext;
import org.junit.jupiter.engine.extension.MutableExtensionRegistry;
import org.junit.platform.engine.TestDescriptor;
import org.junit.platform.engine.TestSource;
import org.junit.platform.engine.UniqueId;
import org.junit.platform.engine.support.hierarchical.Node;

class DynamicTestTestDescriptor
extends DynamicNodeTestDescriptor {
    private static final InvocationInterceptorChain interceptorChain = new InvocationInterceptorChain();
    private DynamicTest dynamicTest;

    DynamicTestTestDescriptor(UniqueId uniqueId, int index, DynamicTest dynamicTest, TestSource source2, JupiterConfiguration configuration) {
        super(uniqueId, index, dynamicTest, source2, configuration);
        this.dynamicTest = dynamicTest;
    }

    @Override
    public TestDescriptor.Type getType() {
        return TestDescriptor.Type.TEST;
    }

    @Override
    public JupiterEngineExecutionContext execute(JupiterEngineExecutionContext context, Node.DynamicTestExecutor dynamicTestExecutor) {
        InvocationInterceptor.Invocation<Void> invocation = () -> {
            this.dynamicTest.getExecutable().execute();
            return null;
        };
        DefaultDynamicTestInvocationContext dynamicTestInvocationContext = new DefaultDynamicTestInvocationContext(this.dynamicTest.getExecutable());
        ExtensionContext extensionContext = context.getExtensionContext();
        MutableExtensionRegistry extensionRegistry = context.getExtensionRegistry();
        interceptorChain.invoke(invocation, extensionRegistry, InvocationInterceptorChain.InterceptorCall.ofVoid((interceptor, wrappedInvocation) -> interceptor.interceptDynamicTest(wrappedInvocation, dynamicTestInvocationContext, extensionContext)));
        return context;
    }

    @Override
    public void after(JupiterEngineExecutionContext context) throws Exception {
        super.after(context);
        this.dynamicTest = null;
    }
}

