/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.telemetry.spans;

import com.newrelic.telemetry.Attributes;
import com.newrelic.telemetry.Telemetry;
import com.newrelic.telemetry.util.Utils;

public final class Span
implements Telemetry {
    private final String id;
    private final Attributes attributes;
    private final String traceId;
    private final long timestamp;
    private final String serviceName;
    private final Double durationMs;
    private final String name;
    private final String parentId;
    private final boolean error;

    private Span(SpanBuilder spanBuilder) {
        Utils.verifyNonNull(spanBuilder.id, "id");
        this.id = spanBuilder.id;
        this.attributes = spanBuilder.attributes;
        this.traceId = spanBuilder.traceId;
        this.timestamp = spanBuilder.timestamp;
        this.serviceName = spanBuilder.serviceName;
        this.durationMs = spanBuilder.durationMs;
        this.name = spanBuilder.name;
        this.parentId = spanBuilder.parentId;
        this.error = spanBuilder.error;
    }

    public static SpanBuilder builder(String spanId) {
        return new SpanBuilder(spanId);
    }

    public String getId() {
        return this.id;
    }

    public Attributes getAttributes() {
        return this.attributes;
    }

    public String getTraceId() {
        return this.traceId;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public Double getDurationMs() {
        return this.durationMs;
    }

    public String getName() {
        return this.name;
    }

    public String getParentId() {
        return this.parentId;
    }

    public boolean isError() {
        return this.error;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Span span = (Span)o;
        if (this.getTimestamp() != span.getTimestamp()) {
            return false;
        }
        if (this.isError() != span.isError()) {
            return false;
        }
        if (this.getId() != null ? !this.getId().equals(span.getId()) : span.getId() != null) {
            return false;
        }
        if (this.getAttributes() != null ? !this.getAttributes().equals(span.getAttributes()) : span.getAttributes() != null) {
            return false;
        }
        if (this.getTraceId() != null ? !this.getTraceId().equals(span.getTraceId()) : span.getTraceId() != null) {
            return false;
        }
        if (this.getServiceName() != null ? !this.getServiceName().equals(span.getServiceName()) : span.getServiceName() != null) {
            return false;
        }
        if (this.getDurationMs() != null ? !this.getDurationMs().equals(span.getDurationMs()) : span.getDurationMs() != null) {
            return false;
        }
        if (this.getName() != null ? !this.getName().equals(span.getName()) : span.getName() != null) {
            return false;
        }
        return this.getParentId() != null ? this.getParentId().equals(span.getParentId()) : span.getParentId() == null;
    }

    public int hashCode() {
        int result2 = this.getId() != null ? this.getId().hashCode() : 0;
        result2 = 31 * result2 + (this.getAttributes() != null ? this.getAttributes().hashCode() : 0);
        result2 = 31 * result2 + (this.getTraceId() != null ? this.getTraceId().hashCode() : 0);
        result2 = 31 * result2 + (int)(this.getTimestamp() ^ this.getTimestamp() >>> 32);
        result2 = 31 * result2 + (this.getServiceName() != null ? this.getServiceName().hashCode() : 0);
        result2 = 31 * result2 + (this.getDurationMs() != null ? this.getDurationMs().hashCode() : 0);
        result2 = 31 * result2 + (this.getName() != null ? this.getName().hashCode() : 0);
        result2 = 31 * result2 + (this.getParentId() != null ? this.getParentId().hashCode() : 0);
        result2 = 31 * result2 + (this.isError() ? 1 : 0);
        return result2;
    }

    public String toString() {
        return "Span{id='" + this.id + '\'' + ", attributes=" + this.attributes + ", traceId='" + this.traceId + '\'' + ", timestamp=" + this.timestamp + ", serviceName='" + this.serviceName + '\'' + ", durationMs=" + this.durationMs + ", name='" + this.name + '\'' + ", parentId='" + this.parentId + '\'' + ", error=" + this.error + '}';
    }

    public static class SpanBuilder {
        private String id;
        private Attributes attributes = new Attributes();
        private String traceId;
        private long timestamp = System.currentTimeMillis();
        private String serviceName;
        private Double durationMs;
        private String name;
        private String parentId;
        private boolean error = false;

        SpanBuilder(String spanId) {
            this.id = spanId;
        }

        public SpanBuilder attributes(Attributes attributes) {
            this.attributes = attributes;
            return this;
        }

        public SpanBuilder traceId(String traceId) {
            this.traceId = traceId;
            return this;
        }

        public SpanBuilder timestamp(long timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        public SpanBuilder serviceName(String serviceName) {
            this.serviceName = serviceName;
            return this;
        }

        public SpanBuilder durationMs(double durationMs) {
            this.durationMs = durationMs;
            return this;
        }

        public SpanBuilder name(String name) {
            this.name = name;
            return this;
        }

        public SpanBuilder parentId(String parentId) {
            this.parentId = parentId;
            return this;
        }

        public SpanBuilder withError() {
            return this.withError(null, null);
        }

        public SpanBuilder withError(String errorMessage) {
            return this.withError(errorMessage, null);
        }

        public SpanBuilder withError(String errorMessage, String errorClass) {
            this.error = true;
            if (errorMessage != null) {
                this.attributes.put("error.message", errorMessage);
            }
            if (errorClass != null) {
                this.attributes.put("error.class", errorClass);
            }
            return this;
        }

        public Span build() {
            return new Span(this);
        }

        public String toString() {
            return "SpanBuilder{id='" + this.id + '\'' + ", attributes=" + this.attributes + ", traceId='" + this.traceId + '\'' + ", timestamp=" + this.timestamp + ", serviceName='" + this.serviceName + '\'' + ", durationMs=" + this.durationMs + ", name='" + this.name + '\'' + ", parentId='" + this.parentId + '\'' + ", error=" + this.error + '}';
        }
    }
}

