/*
 * Decompiled with CFR 0.152.
 */
package org.pcap4j.packet;

import java.util.ArrayList;
import java.util.List;
import org.pcap4j.packet.AbstractPacket;
import org.pcap4j.packet.IllegalRawDataException;
import org.pcap4j.packet.Ssh2Boolean;
import org.pcap4j.packet.Ssh2String;
import org.pcap4j.packet.namednumber.Ssh2MessageNumber;
import org.pcap4j.util.ByteArrays;

public final class Ssh2DebugPacket
extends AbstractPacket {
    private static final long serialVersionUID = 2146867728898738559L;
    private final Ssh2DebugHeader header;

    public static Ssh2DebugPacket newPacket(byte[] rawData, int offset, int length) throws IllegalRawDataException {
        ByteArrays.validateBounds(rawData, offset, length);
        return new Ssh2DebugPacket(rawData, offset, length);
    }

    private Ssh2DebugPacket(byte[] rawData, int offset, int length) throws IllegalRawDataException {
        this.header = new Ssh2DebugHeader(rawData, offset, length);
    }

    private Ssh2DebugPacket(Builder builder) {
        if (builder == null || builder.alwaysDisplay == null || builder.message == null || builder.languageTag == null) {
            StringBuilder sb = new StringBuilder();
            sb.append("builder: ").append(builder).append(" builder.alwaysDisplay: ").append(builder.alwaysDisplay).append(" builder.message: ").append(builder.message).append(" builder.languageTag: ").append(builder.languageTag);
            throw new NullPointerException(sb.toString());
        }
        this.header = new Ssh2DebugHeader(builder);
    }

    @Override
    public Ssh2DebugHeader getHeader() {
        return this.header;
    }

    @Override
    public Builder getBuilder() {
        return new Builder(this);
    }

    public static final class Ssh2DebugHeader
    extends AbstractPacket.AbstractHeader {
        private static final long serialVersionUID = 873479096967096846L;
        private final Ssh2MessageNumber messageNumber = Ssh2MessageNumber.SSH_MSG_DEBUG;
        private final Ssh2Boolean alwaysDisplay;
        private final Ssh2String message;
        private final Ssh2String languageTag;

        private Ssh2DebugHeader(byte[] rawData, int offset, int length) throws IllegalRawDataException {
            if (length < 10) {
                StringBuilder sb = new StringBuilder(80);
                sb.append("The data is too short to build an SSH2 Debug header. data: ").append(new String(rawData)).append(", offset: ").append(offset).append(", length: ").append(length);
                throw new IllegalRawDataException(sb.toString());
            }
            if (!Ssh2MessageNumber.getInstance(rawData[offset]).equals(Ssh2MessageNumber.SSH_MSG_DEBUG)) {
                StringBuilder sb = new StringBuilder(120);
                sb.append("The data is not an SSH2 Debug message. data: ").append(new String(rawData)).append(", offset: ").append(offset).append(", length: ").append(length);
                throw new IllegalRawDataException(sb.toString());
            }
            int currentOffset = 1 + offset;
            int remainingLength = length - 1;
            this.alwaysDisplay = new Ssh2Boolean(rawData, currentOffset);
            this.message = new Ssh2String(rawData, currentOffset += this.alwaysDisplay.length(), remainingLength -= this.alwaysDisplay.length());
            this.languageTag = new Ssh2String(rawData, currentOffset += this.message.length(), remainingLength -= this.message.length());
        }

        private Ssh2DebugHeader(Builder builder) {
            this.alwaysDisplay = builder.alwaysDisplay;
            this.message = builder.message;
            this.languageTag = builder.languageTag;
        }

        public Ssh2MessageNumber getMessageNumber() {
            return this.messageNumber;
        }

        public Ssh2Boolean getAlwaysDisplay() {
            return this.alwaysDisplay;
        }

        public Ssh2String getMessage() {
            return this.message;
        }

        public Ssh2String getLanguageTag() {
            return this.languageTag;
        }

        @Override
        protected List<byte[]> getRawFields() {
            ArrayList<byte[]> rawFields = new ArrayList<byte[]>();
            rawFields.add(new byte[]{(Byte)this.messageNumber.value()});
            rawFields.add(this.alwaysDisplay.getRawData());
            rawFields.add(this.message.getRawData());
            rawFields.add(this.languageTag.getRawData());
            return rawFields;
        }

        @Override
        protected int calcLength() {
            return this.getRawData().length;
        }

        @Override
        protected String buildString() {
            StringBuilder sb = new StringBuilder();
            String ls = System.getProperty("line.separator");
            sb.append("[SSH2 Debug Header (").append(this.length()).append(" bytes)]").append(ls);
            sb.append("  Message Number: ").append(this.messageNumber).append(ls);
            sb.append("  always_display: ").append(this.alwaysDisplay).append(ls);
            sb.append("  message: ").append(this.message).append(ls);
            sb.append("  language tag: ").append(this.languageTag).append(ls);
            return sb.toString();
        }

        @Override
        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!this.getClass().isInstance(obj)) {
                return false;
            }
            Ssh2DebugHeader other = (Ssh2DebugHeader)obj;
            return this.message.equals(other.message) && this.languageTag.equals(other.languageTag) && this.alwaysDisplay.equals(other.alwaysDisplay);
        }

        @Override
        protected int calcHashCode() {
            int result2 = 17;
            result2 = 31 * result2 + this.alwaysDisplay.hashCode();
            result2 = 31 * result2 + this.message.hashCode();
            result2 = 31 * result2 + this.languageTag.hashCode();
            return result2;
        }
    }

    public static final class Builder
    extends AbstractPacket.AbstractBuilder {
        private Ssh2Boolean alwaysDisplay;
        private Ssh2String message;
        private Ssh2String languageTag;

        public Builder() {
        }

        private Builder(Ssh2DebugPacket packet) {
            this.alwaysDisplay = packet.header.alwaysDisplay;
            this.message = packet.header.message;
            this.languageTag = packet.header.languageTag;
        }

        public Builder alwaysDisplay(Ssh2Boolean alwaysDisplay) {
            this.alwaysDisplay = alwaysDisplay;
            return this;
        }

        public Builder message(Ssh2String message) {
            this.message = message;
            return this;
        }

        public Builder languageTag(Ssh2String languageTag) {
            this.languageTag = languageTag;
            return this;
        }

        @Override
        public Ssh2DebugPacket build() {
            return new Ssh2DebugPacket(this);
        }
    }
}

