/*
 * Decompiled with CFR 0.152.
 */
package io.sip3.commons.util;

import io.netty.buffer.ByteBuf;
import java.nio.charset.Charset;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.collections.IntIterator;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=2, xi=48, d1={"\u0000\"\n\u0000\n\u0002\u0010\u0012\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0000\u001a\n\u0010\u0000\u001a\u00020\u0001*\u00020\u0002\u001a\u001a\u0010\u0000\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0004\u001a\u001a\u0010\u0006\u001a\u00020\u0007*\u00020\u00022\u0006\u0010\b\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\n\u00a8\u0006\u000b"}, d2={"getBytes", "", "Lio/netty/buffer/ByteBuf;", "index", "", "length", "writeTlv", "", "tag", "value", "", "sip3-commons"})
public final class ByteBufUtilKt {
    public static final void writeTlv(@NotNull ByteBuf $this$writeTlv, int tag, @NotNull Object value) {
        Intrinsics.checkNotNullParameter($this$writeTlv, "<this>");
        Intrinsics.checkNotNullParameter(value, "value");
        Object object = value;
        if (object instanceof Byte) {
            $this$writeTlv.writeByte(tag);
            $this$writeTlv.writeShort(4);
            $this$writeTlv.writeByte(((Number)value).byteValue());
        } else if (object instanceof Boolean) {
            $this$writeTlv.writeByte(tag);
            $this$writeTlv.writeShort(4);
            $this$writeTlv.writeBoolean((Boolean)value);
        } else if (object instanceof Short) {
            $this$writeTlv.writeByte(tag);
            $this$writeTlv.writeShort(5);
            $this$writeTlv.writeShort(((Number)value).shortValue());
        } else if (object instanceof Integer) {
            $this$writeTlv.writeByte(tag);
            $this$writeTlv.writeShort(7);
            $this$writeTlv.writeInt(((Number)value).intValue());
        } else if (object instanceof Float) {
            $this$writeTlv.writeByte(tag);
            $this$writeTlv.writeShort(7);
            $this$writeTlv.writeFloat(((Number)value).floatValue());
        } else if (object instanceof Long) {
            $this$writeTlv.writeByte(tag);
            $this$writeTlv.writeShort(11);
            $this$writeTlv.writeLong(((Number)value).longValue());
        } else if (object instanceof String) {
            $this$writeTlv.writeByte(tag);
            String string = (String)value;
            Charset charset = Charset.defaultCharset();
            Intrinsics.checkNotNullExpressionValue(charset, "defaultCharset()");
            byte[] byArray = string.getBytes(charset);
            Intrinsics.checkNotNullExpressionValue(byArray, "this as java.lang.String).getBytes(charset)");
            byte[] bytes = byArray;
            $this$writeTlv.writeShort(3 + bytes.length);
            $this$writeTlv.writeBytes(bytes);
        } else if (object instanceof byte[]) {
            $this$writeTlv.writeByte(tag);
            $this$writeTlv.writeShort(3 + ((byte[])value).length);
            $this$writeTlv.writeBytes((byte[])value);
        } else if (object instanceof ByteBuf) {
            $this$writeTlv.writeByte(tag);
            $this$writeTlv.writeShort(3 + ((ByteBuf)value).capacity());
            $this$writeTlv.writeBytes((ByteBuf)value);
        } else {
            throw new IllegalArgumentException("Type of value " + value + " for tag " + tag + " is not supported");
        }
    }

    @NotNull
    public static final byte[] getBytes(@NotNull ByteBuf $this$getBytes, int index, int length) {
        byte[] byArray;
        Intrinsics.checkNotNullParameter($this$getBytes, "<this>");
        byte[] $this$getBytes_u24lambda_u241 = byArray = new byte[length];
        boolean bl = false;
        Iterable $this$forEach$iv = RangesKt.until(0, length);
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv.iterator();
        while (iterator2.hasNext()) {
            int element$iv;
            int i2 = element$iv = ((IntIterator)iterator2).nextInt();
            boolean bl2 = false;
            $this$getBytes_u24lambda_u241[i2] = $this$getBytes.getByte(index + i2);
        }
        return byArray;
    }

    @NotNull
    public static final byte[] getBytes(@NotNull ByteBuf $this$getBytes) {
        Intrinsics.checkNotNullParameter($this$getBytes, "<this>");
        return ByteBufUtilKt.getBytes($this$getBytes, $this$getBytes.readerIndex(), $this$getBytes.readableBytes());
    }
}

