/*
 * Decompiled with CFR 0.152.
 */
package org.pcap4j.packet;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.pcap4j.packet.Dot11ChannelEntry;
import org.pcap4j.packet.Dot11InformationElement;
import org.pcap4j.packet.IllegalRawDataException;
import org.pcap4j.packet.namednumber.Dot11ChannelUsageMode;
import org.pcap4j.packet.namednumber.Dot11InformationElementId;
import org.pcap4j.util.ByteArrays;

public final class Dot11ChannelUsageElement
extends Dot11InformationElement {
    private static final long serialVersionUID = -6935079967608347323L;
    private final Dot11ChannelUsageMode usageMode;
    private final List<Dot11ChannelEntry> channelEntries;

    public static Dot11ChannelUsageElement newInstance(byte[] rawData, int offset, int length) throws IllegalRawDataException {
        ByteArrays.validateBounds(rawData, offset, length);
        return new Dot11ChannelUsageElement(rawData, offset, length);
    }

    private Dot11ChannelUsageElement(byte[] rawData, int offset, int length) throws IllegalRawDataException {
        super(rawData, offset, length, Dot11InformationElementId.CHANNEL_USAGE);
        int infoLen = this.getLengthAsInt();
        if (infoLen < 1) {
            throw new IllegalRawDataException("The length must be more than 0 but is actually: " + infoLen);
        }
        if ((infoLen - 1) % 2 != 0) {
            throw new IllegalRawDataException("The ((length - 1) % 2) must be 0. length: " + infoLen);
        }
        this.usageMode = Dot11ChannelUsageMode.getInstance(rawData[offset + 2]);
        this.channelEntries = new ArrayList<Dot11ChannelEntry>((--infoLen - 1) / 2);
        int i2 = offset + 3;
        while (infoLen > 0) {
            this.channelEntries.add(new Dot11ChannelEntry(rawData[i2], rawData[i2 + 1]));
            infoLen -= 2;
            i2 += 2;
        }
    }

    private Dot11ChannelUsageElement(Builder builder) {
        super(builder);
        if (builder.channelEntries.size() > 127) {
            throw new IllegalArgumentException("Too long channelEntries: " + builder.channelEntries);
        }
        this.usageMode = builder.usageMode;
        this.channelEntries = builder.channelEntries == null ? Collections.emptyList() : new ArrayList<Dot11ChannelEntry>(builder.channelEntries);
    }

    public Dot11ChannelUsageMode getUsageMode() {
        return this.usageMode;
    }

    public ArrayList<Dot11ChannelEntry> getChannelEntries() {
        return new ArrayList<Dot11ChannelEntry>(this.channelEntries);
    }

    @Override
    public int length() {
        return 3 + this.channelEntries.size() * 2;
    }

    @Override
    public byte[] getRawData() {
        byte[] rawData = new byte[this.length()];
        rawData[0] = (Byte)this.getElementId().value();
        rawData[1] = this.getLength();
        rawData[2] = (Byte)this.usageMode.value();
        Iterator<Dot11ChannelEntry> iter = this.channelEntries.iterator();
        int i2 = 3;
        while (iter.hasNext()) {
            Dot11ChannelEntry next = iter.next();
            rawData[i2] = next.getOperatingClass();
            rawData[i2 + 1] = next.getChannel();
            i2 += 2;
        }
        return rawData;
    }

    public Builder getBuilder() {
        return new Builder(this);
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result2 = super.hashCode();
        result2 = 31 * result2 + this.channelEntries.hashCode();
        result2 = 31 * result2 + this.usageMode.hashCode();
        return result2;
    }

    @Override
    public boolean equals(Object obj) {
        if (!super.equals(obj)) {
            return false;
        }
        Dot11ChannelUsageElement other = (Dot11ChannelUsageElement)obj;
        if (!this.channelEntries.equals(other.channelEntries)) {
            return false;
        }
        return this.usageMode.equals(other.usageMode);
    }

    public String toString() {
        return this.toString("");
    }

    public String toString(String indent) {
        StringBuilder sb = new StringBuilder();
        String ls = System.getProperty("line.separator");
        sb.append(indent).append("Channel Usage:").append(ls);
        sb.append(indent).append("  Element ID: ").append(this.getElementId()).append(ls);
        sb.append(indent).append("  Length: ").append(this.getLengthAsInt()).append(" bytes").append(ls);
        sb.append(indent).append("  Usage Mode: ").append(this.usageMode).append(ls);
        for (Dot11ChannelEntry ce : this.channelEntries) {
            sb.append(indent).append("  Channel Entry: ").append(ce).append(ls);
        }
        return sb.toString();
    }

    public static final class Builder
    extends Dot11InformationElement.Builder {
        private Dot11ChannelUsageMode usageMode;
        private List<Dot11ChannelEntry> channelEntries;

        public Builder() {
            this.elementId(Dot11InformationElementId.getInstance((Byte)Dot11InformationElementId.CHANNEL_USAGE.value()));
        }

        private Builder(Dot11ChannelUsageElement elem) {
            super(elem);
            this.usageMode = elem.usageMode;
            this.channelEntries = elem.channelEntries;
        }

        public Builder usageMode(Dot11ChannelUsageMode usageMode) {
            this.usageMode = usageMode;
            return this;
        }

        public Builder channelEntries(List<Dot11ChannelEntry> channelEntries) {
            this.channelEntries = channelEntries;
            return this;
        }

        @Override
        public Builder length(byte length) {
            super.length(length);
            return this;
        }

        @Override
        public Builder correctLengthAtBuild(boolean correctLengthAtBuild) {
            super.correctLengthAtBuild(correctLengthAtBuild);
            return this;
        }

        @Override
        public Dot11ChannelUsageElement build() {
            if (this.usageMode == null) {
                throw new NullPointerException("usageMode is null.");
            }
            if (this.getCorrectLengthAtBuild()) {
                this.length((byte)(this.channelEntries.size() * 2 + 1));
            }
            return new Dot11ChannelUsageElement(this);
        }
    }
}

