/*
 * Decompiled with CFR 0.152.
 */
package io.sip3.captain.ce.pipeline;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.sip3.captain.ce.RoutesCE;
import io.sip3.captain.ce.domain.IpHeader;
import io.sip3.captain.ce.domain.Packet;
import io.sip3.captain.ce.pipeline.IpFragmentHandler;
import io.sip3.captain.ce.pipeline.Ipv4Handler;
import io.sip3.captain.ce.pipeline.Ipv6Handler;
import io.sip3.commons.domain.payload.ByteBufPayload;
import io.sip3.commons.domain.payload.Encodable;
import io.sip3.commons.domain.payload.Payload;
import io.sip3.commons.util.IpUtil;
import io.sip3.commons.vertx.annotations.Instance;
import io.sip3.commons.vertx.collections.PeriodicallyExpiringHashMap;
import io.vertx.core.AbstractVerticle;
import io.vertx.core.Vertx;
import io.vertx.core.eventbus.Message;
import io.vertx.core.json.JsonObject;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import mu.KLogger;
import mu.KotlinLogging;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Instance(singleton=true)
@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0007\u0018\u00002\u00020\u0001:\u0001\u0017B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015J\b\u0010\u0016\u001a\u00020\u0011H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lio/sip3/captain/ce/pipeline/IpFragmentHandler;", "Lio/vertx/core/AbstractVerticle;", "()V", "aggregationTimeout", "", "defragmentators", "Lio/sip3/commons/vertx/collections/PeriodicallyExpiringHashMap;", "", "Lio/sip3/captain/ce/pipeline/IpFragmentHandler$Defragmentator;", "expirationDelay", "ipv4Handler", "Lio/sip3/captain/ce/pipeline/Ipv4Handler;", "ipv6Handler", "Lio/sip3/captain/ce/pipeline/Ipv6Handler;", "logger", "Lmu/KLogger;", "onPacket", "", "header", "Lio/sip3/captain/ce/domain/IpHeader;", "packet", "Lio/sip3/captain/ce/domain/Packet;", "start", "Defragmentator", "sip3-captain-ce"})
public final class IpFragmentHandler
extends AbstractVerticle {
    @NotNull
    private final KLogger logger = KotlinLogging.INSTANCE.logger(logger.1.INSTANCE);
    private long expirationDelay = 5000L;
    private long aggregationTimeout = 30000L;
    private PeriodicallyExpiringHashMap<String, Defragmentator> defragmentators;
    private Ipv4Handler ipv4Handler;
    private Ipv6Handler ipv6Handler;

    @Override
    public void start() {
        JsonObject jsonObject = this.config().getJsonObject("ip");
        if (jsonObject != null && (jsonObject = jsonObject.getJsonObject("fragment")) != null) {
            long it;
            Long l;
            JsonObject config2 = jsonObject;
            boolean bl = false;
            Long l2 = l = config2.getLong("expiration_delay");
            if (l2 != null) {
                Intrinsics.checkNotNullExpressionValue(l2, "getLong(\"expiration_delay\")");
                it = ((Number)l).longValue();
                boolean bl2 = false;
                this.expirationDelay = it;
            }
            Long l3 = l = config2.getLong("aggregation_timeout");
            if (l3 != null) {
                Intrinsics.checkNotNullExpressionValue(l3, "getLong(\"aggregation_timeout\")");
                it = ((Number)l).longValue();
                boolean bl3 = false;
                this.aggregationTimeout = it;
            }
        }
        PeriodicallyExpiringHashMap.Builder builder = new PeriodicallyExpiringHashMap.Builder(0L, 0, null, null, null, 31, null).delay(this.expirationDelay).period((int)(this.aggregationTimeout / this.expirationDelay)).expireAt((Function2)new Function2<String, Defragmentator, Long>(this){
            final /* synthetic */ IpFragmentHandler this$0;
            {
                this.this$0 = $receiver;
                super(2);
            }

            @NotNull
            public final Long invoke(@NotNull String string, @NotNull Defragmentator defragmentator2) {
                Intrinsics.checkNotNullParameter(string, "<anonymous parameter 0>");
                Intrinsics.checkNotNullParameter(defragmentator2, "defragmentator");
                return defragmentator2.getTimestamp() + IpFragmentHandler.access$getAggregationTimeout$p(this.this$0);
            }
        });
        Vertx vertx = this.vertx;
        Intrinsics.checkNotNullExpressionValue(vertx, "vertx");
        this.defragmentators = builder.build(vertx);
        Vertx vertx2 = this.vertx;
        Intrinsics.checkNotNullExpressionValue(vertx2, "vertx");
        JsonObject jsonObject2 = this.config();
        Intrinsics.checkNotNullExpressionValue(jsonObject2, "config()");
        this.ipv4Handler = new Ipv4Handler(vertx2, jsonObject2, false);
        Vertx vertx3 = this.vertx;
        Intrinsics.checkNotNullExpressionValue(vertx3, "vertx");
        JsonObject jsonObject3 = this.config();
        Intrinsics.checkNotNullExpressionValue(jsonObject3, "config()");
        this.ipv6Handler = new Ipv6Handler(vertx3, jsonObject3, false);
        this.vertx.eventBus().localConsumer(RoutesCE.Companion.getFragment(), arg_0 -> IpFragmentHandler.start$lambda$4(this, arg_0));
    }

    public final void onPacket(@NotNull IpHeader header, @NotNull Packet packet) {
        block6: {
            PeriodicallyExpiringHashMap<String, Defragmentator> periodicallyExpiringHashMap;
            Packet packet2;
            Intrinsics.checkNotNullParameter(header, "header");
            Intrinsics.checkNotNullParameter(packet, "packet");
            String key = IpUtil.INSTANCE.convertToString(header.getSrcAddr()) + ":" + IpUtil.INSTANCE.convertToString(header.getSrcAddr()) + ":" + header.getIdentification();
            PeriodicallyExpiringHashMap<String, Defragmentator> periodicallyExpiringHashMap2 = this.defragmentators;
            if (periodicallyExpiringHashMap2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException("defragmentators");
                periodicallyExpiringHashMap2 = null;
            }
            Defragmentator defragmentator2 = periodicallyExpiringHashMap2.getOrPut(key, new Function0<Defragmentator>(packet){
                final /* synthetic */ Packet $packet;
                {
                    this.$packet = $packet;
                    super(0);
                }

                @NotNull
                public final Defragmentator invoke() {
                    Defragmentator defragmentator2 = new Defragmentator();
                    Packet packet = this.$packet;
                    Defragmentator $this$invoke_u24lambda_u240 = defragmentator2;
                    boolean bl = false;
                    $this$invoke_u24lambda_u240.setTimestamp(packet.getTimestamp());
                    $this$invoke_u24lambda_u240.setNanos(packet.getNanos());
                    return defragmentator2;
                }
            });
            Payload payload = packet.getPayload();
            Intrinsics.checkNotNull(payload, "null cannot be cast to non-null type io.sip3.commons.domain.payload.Encodable");
            ByteBuf byteBuf = defragmentator2.onPacket(header, ((Encodable)payload).encode());
            if (byteBuf == null) break block6;
            ByteBuf buffer = byteBuf;
            boolean bl = false;
            Packet $this$onPacket_u24lambda_u246_u24lambda_u245 = packet2 = new Packet();
            boolean bl2 = false;
            $this$onPacket_u24lambda_u246_u24lambda_u245.setTimestamp(defragmentator2.getTimestamp());
            $this$onPacket_u24lambda_u246_u24lambda_u245.setNanos(defragmentator2.getNanos());
            $this$onPacket_u24lambda_u246_u24lambda_u245.setSrcAddr(header.getSrcAddr());
            $this$onPacket_u24lambda_u246_u24lambda_u245.setDstAddr(header.getDstAddr());
            $this$onPacket_u24lambda_u246_u24lambda_u245.setProtocolNumber(header.getProtocolNumber());
            $this$onPacket_u24lambda_u246_u24lambda_u245.setPayload(new ByteBufPayload(buffer));
            Packet p = packet2;
            if (header.getSrcAddr().length == 4) {
                Ipv4Handler ipv4Handler2 = this.ipv4Handler;
                if (ipv4Handler2 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException("ipv4Handler");
                    ipv4Handler2 = null;
                }
                ipv4Handler2.routePacket(p);
            } else {
                Ipv6Handler ipv6Handler2 = this.ipv6Handler;
                if (ipv6Handler2 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException("ipv6Handler");
                    ipv6Handler2 = null;
                }
                ipv6Handler2.routePacket(p);
            }
            if ((periodicallyExpiringHashMap = this.defragmentators) == null) {
                Intrinsics.throwUninitializedPropertyAccessException("defragmentators");
                periodicallyExpiringHashMap = null;
            }
            periodicallyExpiringHashMap.remove(key);
        }
    }

    private static final void start$lambda$4(IpFragmentHandler this$0, Message event) {
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        List packets = (List)event.body();
        Intrinsics.checkNotNullExpressionValue(packets, "packets");
        Iterable $this$forEach$iv = packets;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Pair pair = (Pair)element$iv;
            boolean bl = false;
            IpHeader header = (IpHeader)pair.component1();
            Packet packet = (Packet)pair.component2();
            try {
                this$0.onPacket(header, packet);
            }
            catch (Exception e) {
                this$0.logger.error("IpFragmentHandler 'onPacket()' failed.", e);
            }
        }
    }

    public static final /* synthetic */ long access$getAggregationTimeout$p(IpFragmentHandler $this) {
        return $this.aggregationTimeout;
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010\t\n\u0002\b\b\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0016\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0017\u001a\u00020\b2\u0006\u0010\u0018\u001a\u00020\u0006R\u001a\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\b0\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000b\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u001a\u0010\u0010\u001a\u00020\u0011X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015\u00a8\u0006\u0019"}, d2={"Lio/sip3/captain/ce/pipeline/IpFragmentHandler$Defragmentator;", "", "()V", "buffers", "Ljava/util/TreeMap;", "", "Lio/netty/buffer/ByteBuf;", "headers", "Lio/sip3/captain/ce/domain/IpHeader;", "lastFragmentReceived", "", "nanos", "getNanos", "()I", "setNanos", "(I)V", "timestamp", "", "getTimestamp", "()J", "setTimestamp", "(J)V", "onPacket", "header", "buffer", "sip3-captain-ce"})
    public static final class Defragmentator {
        private long timestamp;
        private int nanos;
        @NotNull
        private final TreeMap<Integer, IpHeader> headers = new TreeMap();
        @NotNull
        private final TreeMap<Integer, ByteBuf> buffers = new TreeMap();
        private boolean lastFragmentReceived;

        public final long getTimestamp() {
            return this.timestamp;
        }

        public final void setTimestamp(long l) {
            this.timestamp = l;
        }

        public final int getNanos() {
            return this.nanos;
        }

        public final void setNanos(int n) {
            this.nanos = n;
        }

        @Nullable
        public final ByteBuf onPacket(@NotNull IpHeader header, @NotNull ByteBuf buffer) {
            ByteBuf byteBuf;
            Intrinsics.checkNotNullParameter(header, "header");
            Intrinsics.checkNotNullParameter(buffer, "buffer");
            ((Map)this.headers).put(8 * header.getFragmentOffset(), header);
            ((Map)this.buffers).put(8 * header.getFragmentOffset(), buffer);
            boolean bl = this.lastFragmentReceived = this.lastFragmentReceived || !header.getMoreFragments();
            if (!this.lastFragmentReceived) {
                return null;
            }
            int expectedOffset = 0;
            Map $this$forEach$iv = this.headers;
            boolean $i$f$forEach = false;
            Iterator iterator2 = $this$forEach$iv.entrySet().iterator();
            while (iterator2.hasNext()) {
                Map.Entry element$iv;
                Map.Entry entry = element$iv = iterator2.next();
                boolean bl2 = false;
                int offset = ((Number)entry.getKey()).intValue();
                IpHeader header2 = (IpHeader)entry.getValue();
                if (offset != expectedOffset) {
                    return null;
                }
                expectedOffset = offset + header2.getTotalLength() - header2.getHeaderLength();
            }
            ByteBuf $this$onPacket_u24lambda_u242 = byteBuf = Unpooled.buffer(expectedOffset);
            boolean bl3 = false;
            Map $this$forEach$iv2 = this.buffers;
            boolean $i$f$forEach2 = false;
            Iterator iterator3 = $this$forEach$iv2.entrySet().iterator();
            while (iterator3.hasNext()) {
                Map.Entry element$iv;
                Map.Entry entry = element$iv = iterator3.next();
                boolean bl4 = false;
                ByteBuf b = (ByteBuf)entry.getValue();
                $this$onPacket_u24lambda_u242.writeBytes(b);
            }
            return byteBuf;
        }
    }
}

