/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.shaded.reactor.core.scheduler;

import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.binder.jvm.ExecutorServiceMetrics;
import io.micrometer.core.instrument.search.Search;
import io.micrometer.shaded.reactor.core.Disposable;
import io.micrometer.shaded.reactor.core.Scannable;
import io.micrometer.shaded.reactor.core.scheduler.DelegatingScheduledExecutorService;
import io.micrometer.shaded.reactor.core.scheduler.Scheduler;
import io.micrometer.shaded.reactor.util.Metrics;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiFunction;

@Deprecated
final class SchedulerMetricDecorator
implements BiFunction<Scheduler, ScheduledExecutorService, ScheduledExecutorService>,
Disposable {
    static final String TAG_SCHEDULER_ID = "io.micrometer.shaded.reactor.scheduler.id";
    static final String METRICS_DECORATOR_KEY = "io.micrometer.shaded.reactor.metrics.decorator";
    final WeakHashMap<Scheduler, String> seenSchedulers = new WeakHashMap();
    final Map<String, AtomicInteger> schedulerDifferentiator = new HashMap<String, AtomicInteger>();
    final WeakHashMap<Scheduler, AtomicInteger> executorDifferentiator = new WeakHashMap();
    final MeterRegistry registry = Metrics.MicrometerConfiguration.getRegistry();

    SchedulerMetricDecorator() {
    }

    @Override
    public synchronized ScheduledExecutorService apply(Scheduler scheduler, final ScheduledExecutorService service) {
        String schedulerName = Scannable.from(scheduler).scanOrDefault(Scannable.Attr.NAME, scheduler.getClass().getName());
        String schedulerId = this.seenSchedulers.computeIfAbsent(scheduler, s -> {
            int schedulerDifferentiator = this.schedulerDifferentiator.computeIfAbsent(schedulerName, k -> new AtomicInteger(0)).getAndIncrement();
            return schedulerDifferentiator == 0 ? schedulerName : schedulerName + "#" + schedulerDifferentiator;
        });
        final String executorId = schedulerId + "-" + this.executorDifferentiator.computeIfAbsent(scheduler, key -> new AtomicInteger(0)).getAndIncrement();
        final Tag[] tags = new Tag[]{Tag.of(TAG_SCHEDULER_ID, schedulerId)};
        class MetricsRemovingScheduledExecutorService
        extends DelegatingScheduledExecutorService {
            MetricsRemovingScheduledExecutorService() {
                super(ExecutorServiceMetrics.monitor(SchedulerMetricDecorator.this.registry, scheduledExecutorService, string, tagArray));
            }

            @Override
            public List<Runnable> shutdownNow() {
                this.removeMetrics();
                return super.shutdownNow();
            }

            @Override
            public void shutdown() {
                this.removeMetrics();
                super.shutdown();
            }

            void removeMetrics() {
                Search.in(SchedulerMetricDecorator.this.registry).tag("name", executorId).meters().forEach(SchedulerMetricDecorator.this.registry::remove);
            }
        }
        return new MetricsRemovingScheduledExecutorService();
    }

    @Override
    public void dispose() {
        Search.in(this.registry).tagKeys(TAG_SCHEDULER_ID).meters().forEach(this.registry::remove);
        this.seenSchedulers.clear();
        this.schedulerDifferentiator.clear();
        this.executorDifferentiator.clear();
    }
}

