/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.telemetry.metrics.json;

import com.newrelic.telemetry.metrics.Count;
import com.newrelic.telemetry.metrics.Gauge;
import com.newrelic.telemetry.metrics.Metric;
import com.newrelic.telemetry.metrics.MetricBatch;
import com.newrelic.telemetry.metrics.Summary;
import com.newrelic.telemetry.metrics.json.MetricToJson;
import java.util.Collection;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetricBatchJsonTelemetryBlockWriter {
    private static final Logger logger = LoggerFactory.getLogger(MetricBatchJsonTelemetryBlockWriter.class);
    private final MetricToJson metricToJson;

    public MetricBatchJsonTelemetryBlockWriter(MetricToJson metricToJson) {
        this.metricToJson = metricToJson;
    }

    public void appendTelemetryJson(MetricBatch batch, StringBuilder builder) {
        builder.append("\"metrics\":").append("[");
        Collection<Metric> metrics = batch.getTelemetry();
        AtomicInteger retainedCount = new AtomicInteger();
        builder.append(metrics.stream().filter(this::isValid).map(this::toJsonString).peek(x -> retainedCount.getAndIncrement()).collect(Collectors.joining(",")));
        if (retainedCount.get() != metrics.size()) {
            logger.info("Dropped " + (metrics.size() - retainedCount.get()) + " metrics from batch due to invalid metric contents (you should fix this)");
            this.logAllInvalid(metrics);
        }
        builder.append("]");
    }

    private void logAllInvalid(Collection<Metric> metrics) {
        metrics.stream().filter(this::isInvalid).forEach(this::logInvalid);
    }

    private void logInvalid(Metric invalidMetric) {
        logger.debug("  * Dropped " + this.typeDispatch(invalidMetric, count2 -> "Count(name=" + count2.getName() + ",  value = " + count2.getValue() + ")", gauge -> "Gauge(name=" + gauge.getName() + ", value = " + gauge.getValue() + ")", summary -> "Summary(name=" + summary.getName() + ", value = " + summary.getSum()));
    }

    private boolean isInvalid(Metric metric) {
        return !this.isValid(metric);
    }

    private boolean isValid(Metric metric) {
        return this.typeDispatch(metric, count2 -> Double.isFinite(count2.getValue()), gauge -> Double.isFinite(gauge.getValue()), summary -> Double.isFinite(summary.getSum()));
    }

    private String toJsonString(Metric metric) {
        return this.typeDispatch(metric, this.metricToJson::writeCountJson, this.metricToJson::writeGaugeJson, this.metricToJson::writeSummaryJson);
    }

    private <T> T typeDispatch(Metric metric, Function<Count, T> countFunction, Function<Gauge, T> gaugeFunction, Function<Summary, T> summaryFunction) {
        if (metric instanceof Count) {
            return countFunction.apply((Count)metric);
        }
        if (metric instanceof Gauge) {
            return gaugeFunction.apply((Gauge)metric);
        }
        if (metric instanceof Summary) {
            return summaryFunction.apply((Summary)metric);
        }
        throw new UnsupportedOperationException("Unknown metric type: " + metric.getClass());
    }
}

