/*
 * Decompiled with CFR 0.152.
 */
package org.pcap4j.packet;

import java.net.Inet4Address;
import java.util.ArrayList;
import java.util.List;
import org.pcap4j.packet.AbstractPacket;
import org.pcap4j.packet.IcmpV4InvokingPacketPacket;
import org.pcap4j.packet.IllegalRawDataException;
import org.pcap4j.packet.Packet;
import org.pcap4j.util.ByteArrays;

public final class IcmpV4RedirectPacket
extends IcmpV4InvokingPacketPacket {
    private static final long serialVersionUID = 5987521162450318499L;
    private final IcmpV4RedirectHeader header;

    public static IcmpV4RedirectPacket newPacket(byte[] rawData, int offset, int length) throws IllegalRawDataException {
        ByteArrays.validateBounds(rawData, offset, length);
        IcmpV4RedirectHeader header = new IcmpV4RedirectHeader(rawData, offset, length);
        int payloadLength = length - header.length();
        if (payloadLength > 0) {
            return new IcmpV4RedirectPacket(header, rawData, offset + header.length(), payloadLength);
        }
        return new IcmpV4RedirectPacket(header);
    }

    private IcmpV4RedirectPacket(IcmpV4RedirectHeader header) {
        this.header = header;
    }

    private IcmpV4RedirectPacket(IcmpV4RedirectHeader header, byte[] rawData, int payloadOffset, int payloadLength) {
        super(rawData, payloadOffset, payloadLength);
        this.header = header;
    }

    private IcmpV4RedirectPacket(Builder builder) {
        super(builder);
        if (builder.gatewayInternetAddress == null) {
            StringBuilder sb = new StringBuilder();
            sb.append("builder.gatewayInternetAddress: ").append(builder.gatewayInternetAddress);
            throw new NullPointerException(sb.toString());
        }
        this.header = new IcmpV4RedirectHeader(builder);
    }

    @Override
    public IcmpV4RedirectHeader getHeader() {
        return this.header;
    }

    @Override
    public Builder getBuilder() {
        return new Builder(this);
    }

    public static final class IcmpV4RedirectHeader
    extends AbstractPacket.AbstractHeader {
        private static final long serialVersionUID = -7093717116891501880L;
        private static final int GATEWAY_INTERNET_ADDRESS_OFFSET = 0;
        private static final int GATEWAY_INTERNET_ADDRESS_SIZE = 4;
        private static final int ICMPV4_REDIRECT_HEADER_SIZE = 4;
        private final Inet4Address gatewayInternetAddress;

        private IcmpV4RedirectHeader(byte[] rawData, int offset, int length) throws IllegalRawDataException {
            if (length < 4) {
                StringBuilder sb = new StringBuilder(80);
                sb.append("The data is too short to build an ICMPv4 Redirect Header(").append(4).append(" bytes). data: ").append(ByteArrays.toHexString(rawData, " ")).append(", offset: ").append(offset).append(", length: ").append(length);
                throw new IllegalRawDataException(sb.toString());
            }
            this.gatewayInternetAddress = ByteArrays.getInet4Address(rawData, 0 + offset);
        }

        private IcmpV4RedirectHeader(Builder builder) {
            this.gatewayInternetAddress = builder.gatewayInternetAddress;
        }

        public Inet4Address getGatewayInternetAddress() {
            return this.gatewayInternetAddress;
        }

        @Override
        protected List<byte[]> getRawFields() {
            ArrayList<byte[]> rawFields = new ArrayList<byte[]>();
            rawFields.add(ByteArrays.toByteArray(this.gatewayInternetAddress));
            return rawFields;
        }

        @Override
        public int length() {
            return 4;
        }

        @Override
        protected String buildString() {
            StringBuilder sb = new StringBuilder();
            String ls = System.getProperty("line.separator");
            sb.append("[ICMPv4 Redirect Header (").append(this.length()).append(" bytes)]").append(ls);
            sb.append("  Gateway Internet Address: ").append(this.gatewayInternetAddress).append(ls);
            return sb.toString();
        }

        @Override
        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!this.getClass().isInstance(obj)) {
                return false;
            }
            IcmpV4RedirectHeader other = (IcmpV4RedirectHeader)obj;
            return this.gatewayInternetAddress.equals(other.gatewayInternetAddress);
        }

        @Override
        protected int calcHashCode() {
            int result2 = 17;
            result2 = 31 * result2 + this.gatewayInternetAddress.hashCode();
            return result2;
        }
    }

    public static final class Builder
    extends IcmpV4InvokingPacketPacket.Builder {
        private Inet4Address gatewayInternetAddress;

        public Builder() {
        }

        private Builder(IcmpV4RedirectPacket packet) {
            super(packet);
            this.gatewayInternetAddress = packet.header.gatewayInternetAddress;
        }

        public Builder gatewayInternetAddress(Inet4Address gatewayInternetAddress) {
            this.gatewayInternetAddress = gatewayInternetAddress;
            return this;
        }

        @Override
        public Builder payload(Packet payload) {
            super.payload(payload);
            return this;
        }

        @Override
        public IcmpV4RedirectPacket build() {
            return new IcmpV4RedirectPacket(this);
        }
    }
}

