/*
 * Decompiled with CFR 0.152.
 */
package org.pcap4j.packet;

import java.nio.ByteOrder;
import java.util.Arrays;
import org.pcap4j.packet.Dot11InformationElement;
import org.pcap4j.packet.IllegalRawDataException;
import org.pcap4j.packet.namednumber.Dot11InformationElementId;
import org.pcap4j.util.ByteArrays;

public final class Dot11HTCapabilitiesElement
extends Dot11InformationElement {
    private static final long serialVersionUID = -5174208022820530840L;
    private final boolean ldpcCodingSupported;
    private final boolean both20and40MhzSupported;
    private final SmPowerSaveMode smPowerSaveMode;
    private final boolean htGreenfieldSupported;
    private final boolean shortGiFor20MhzSupported;
    private final boolean shortGiFor40MhzSupported;
    private final boolean txStbcSupported;
    private final StbcSupport rxStbcSupport;
    private final boolean htDelayedBlockAckSupported;
    private final AMsduLength maxAMsduLength;
    private final boolean dsssCckModeIn40MhzSupported;
    private final boolean bit13OfHtCapabilitiesInfo;
    private final boolean fortyMhzIntolerant;
    private final boolean lSigTxopProtectionSupported;
    private final AMpduLength maxAMpduLength;
    private final MpduStartSpacing minMpduStartSpacing;
    private final boolean bit5OfAMpduParameters;
    private final boolean bit6OfAMpduParameters;
    private final boolean bit7OfAMpduParameters;
    private final boolean[] supportedRxMcsIndexes;
    private final boolean bit77OfSupportedMcsSet;
    private final boolean bit78OfSupportedMcsSet;
    private final boolean bit79OfSupportedMcsSet;
    private final short rxHighestSupportedDataRate;
    private final boolean bit90OfSupportedMcsSet;
    private final boolean bit91OfSupportedMcsSet;
    private final boolean bit92OfSupportedMcsSet;
    private final boolean bit93OfSupportedMcsSet;
    private final boolean bit94OfSupportedMcsSet;
    private final boolean bit95OfSupportedMcsSet;
    private final boolean txMcsSetDefined;
    private final boolean txRxMcsSetNotEqual;
    private final NumSpatialStreams txMaxNumSpatialStreamsSupported;
    private final boolean txUnequalModulationSupported;
    private final boolean bit101OfSupportedMcsSet;
    private final boolean bit102OfSupportedMcsSet;
    private final boolean bit103OfSupportedMcsSet;
    private final boolean bit104OfSupportedMcsSet;
    private final boolean bit105OfSupportedMcsSet;
    private final boolean bit106OfSupportedMcsSet;
    private final boolean bit107OfSupportedMcsSet;
    private final boolean bit108OfSupportedMcsSet;
    private final boolean bit109OfSupportedMcsSet;
    private final boolean bit110OfSupportedMcsSet;
    private final boolean bit111OfSupportedMcsSet;
    private final boolean bit112OfSupportedMcsSet;
    private final boolean bit113OfSupportedMcsSet;
    private final boolean bit114OfSupportedMcsSet;
    private final boolean bit115OfSupportedMcsSet;
    private final boolean bit116OfSupportedMcsSet;
    private final boolean bit117OfSupportedMcsSet;
    private final boolean bit118OfSupportedMcsSet;
    private final boolean bit119OfSupportedMcsSet;
    private final boolean bit120OfSupportedMcsSet;
    private final boolean bit121OfSupportedMcsSet;
    private final boolean bit122OfSupportedMcsSet;
    private final boolean bit123OfSupportedMcsSet;
    private final boolean bit124OfSupportedMcsSet;
    private final boolean bit125OfSupportedMcsSet;
    private final boolean bit126OfSupportedMcsSet;
    private final boolean bit127OfSupportedMcsSet;
    private final boolean pcoSupported;
    private final PcoTransitionTime pcoTransitionTime;
    private final boolean bit3OfHtExtendedCapabilities;
    private final boolean bit4OfHtExtendedCapabilities;
    private final boolean bit5OfHtExtendedCapabilities;
    private final boolean bit6OfHtExtendedCapabilities;
    private final boolean bit7OfHtExtendedCapabilities;
    private final McsFeedbackCapability mcsFeedbackCapability;
    private final boolean htControlFieldSupported;
    private final boolean rdResponderSupported;
    private final boolean bit12OfHtExtendedCapabilities;
    private final boolean bit13OfHtExtendedCapabilities;
    private final boolean bit14OfHtExtendedCapabilities;
    private final boolean bit15OfHtExtendedCapabilities;
    private final boolean implicitTxBeamformingReceivingSupported;
    private final boolean rxStaggeredSoundingSupported;
    private final boolean txStaggeredSoundingSupported;
    private final boolean rxNdpSupported;
    private final boolean txNdpSupported;
    private final boolean implicitTxBeamformingSupported;
    private final Calibration calibration;
    private final boolean explicitCsiTxBeamformingSupported;
    private final boolean explicitNoncompressedSteeringSupported;
    private final boolean explicitCompressedSteeringSupported;
    private final BeamformingFeedbackCapability explicitTxBeamformingCsiFeedbackCapability;
    private final BeamformingFeedbackCapability explicitNoncompressedBeamformingFeedbackCapability;
    private final BeamformingFeedbackCapability explicitCompressedBeamformingFeedbackCapability;
    private final Grouping minGrouping;
    private final NumBeamformerAntennas csiNumBeamformerAntennasSupported;
    private final NumBeamformerAntennas noncompressedSteeringNumBeamformerAntennasSupported;
    private final NumBeamformerAntennas compressedSteeringNumBeamformerAntennasSupported;
    private final CsiNumRows csiMaxNumRowsBeamformerSupported;
    private final ChannelEstimationCapability channelEstimationCapability;
    private final boolean bit29OfTransmitBeamformingCapabilities;
    private final boolean bit30OfTransmitBeamformingCapabilities;
    private final boolean bit31OfTransmitBeamformingCapabilities;
    private final boolean antennaSelectionSupported;
    private final boolean explicitCsiFeedbackBasedTxAselSupported;
    private final boolean antennaIndicesFeedbackBasedTxAselSupported;
    private final boolean explicitCsiFeedbackSupported;
    private final boolean antennaIndicesFeedbackSupported;
    private final boolean rxAselSupported;
    private final boolean txSoundingPpdusSupported;
    private final boolean bit7OfAselCapability;

    public static Dot11HTCapabilitiesElement newInstance(byte[] rawData, int offset, int length) throws IllegalRawDataException {
        ByteArrays.validateBounds(rawData, offset, length);
        return new Dot11HTCapabilitiesElement(rawData, offset, length);
    }

    private Dot11HTCapabilitiesElement(byte[] rawData, int offset, int length) throws IllegalRawDataException {
        super(rawData, offset, length, Dot11InformationElementId.HT_CAPABILITIES);
        if (this.getLengthAsInt() != 26) {
            throw new IllegalRawDataException("The length must be 26 but is actually: " + this.getLengthAsInt());
        }
        byte data = rawData[offset + 2];
        this.ldpcCodingSupported = (data & 1) != 0;
        this.both20and40MhzSupported = (data & 2) != 0;
        this.smPowerSaveMode = SmPowerSaveMode.getInstance(data >> 2 & 3);
        this.htGreenfieldSupported = (data & 0x10) != 0;
        this.shortGiFor20MhzSupported = (data & 0x20) != 0;
        this.shortGiFor40MhzSupported = (data & 0x40) != 0;
        this.txStbcSupported = (data & 0x80) != 0;
        data = rawData[offset + 3];
        this.rxStbcSupport = StbcSupport.getInstance(data & 3);
        this.htDelayedBlockAckSupported = (data & 4) != 0;
        this.maxAMsduLength = AMsduLength.getInstance(data >> 3 & 1);
        this.dsssCckModeIn40MhzSupported = (data & 0x10) != 0;
        this.bit13OfHtCapabilitiesInfo = (data & 0x20) != 0;
        this.fortyMhzIntolerant = (data & 0x40) != 0;
        this.lSigTxopProtectionSupported = (data & 0x80) != 0;
        data = rawData[offset + 4];
        this.maxAMpduLength = AMpduLength.getInstance(data & 3);
        this.minMpduStartSpacing = MpduStartSpacing.getInstance(data >> 2 & 7);
        this.bit5OfAMpduParameters = (data & 0x20) != 0;
        this.bit6OfAMpduParameters = (data & 0x40) != 0;
        this.bit7OfAMpduParameters = (data & 0x80) != 0;
        this.supportedRxMcsIndexes = new boolean[77];
        for (int i2 = 0; i2 < 9; ++i2) {
            data = rawData[offset + 5 + i2];
            int bitOffset = i2 * 8;
            for (int bit = 0; bit < 8; ++bit) {
                this.supportedRxMcsIndexes[bitOffset + bit] = (data & 1) != 0;
                data = (byte)(data >> 1);
            }
        }
        data = rawData[offset + 14];
        for (int bit = 0; bit < 5; ++bit) {
            this.supportedRxMcsIndexes[72 + bit] = (data & 1) != 0;
            data = (byte)(data >> 1);
        }
        this.bit77OfSupportedMcsSet = (data & 1) != 0;
        this.bit78OfSupportedMcsSet = (data & 2) != 0;
        this.bit79OfSupportedMcsSet = (data & 4) != 0;
        data = rawData[offset + 16];
        this.rxHighestSupportedDataRate = (short)((rawData[offset + 15] | data << 8) & 0x3FF);
        this.bit90OfSupportedMcsSet = (data & 4) != 0;
        this.bit91OfSupportedMcsSet = (data & 8) != 0;
        this.bit92OfSupportedMcsSet = (data & 0x10) != 0;
        this.bit93OfSupportedMcsSet = (data & 0x20) != 0;
        this.bit94OfSupportedMcsSet = (data & 0x40) != 0;
        this.bit95OfSupportedMcsSet = (data & 0x80) != 0;
        data = rawData[offset + 17];
        this.txMcsSetDefined = (data & 1) != 0;
        this.txRxMcsSetNotEqual = (data & 2) != 0;
        this.txMaxNumSpatialStreamsSupported = NumSpatialStreams.getInstance(data >> 2 & 3);
        this.txUnequalModulationSupported = (data & 0x10) != 0;
        this.bit101OfSupportedMcsSet = (data & 0x20) != 0;
        this.bit102OfSupportedMcsSet = (data & 0x40) != 0;
        this.bit103OfSupportedMcsSet = (data & 0x80) != 0;
        data = rawData[offset + 18];
        this.bit104OfSupportedMcsSet = (data & 1) != 0;
        this.bit105OfSupportedMcsSet = (data & 2) != 0;
        this.bit106OfSupportedMcsSet = (data & 4) != 0;
        this.bit107OfSupportedMcsSet = (data & 8) != 0;
        this.bit108OfSupportedMcsSet = (data & 0x10) != 0;
        this.bit109OfSupportedMcsSet = (data & 0x20) != 0;
        this.bit110OfSupportedMcsSet = (data & 0x40) != 0;
        this.bit111OfSupportedMcsSet = (data & 0x80) != 0;
        data = rawData[offset + 19];
        this.bit112OfSupportedMcsSet = (data & 1) != 0;
        this.bit113OfSupportedMcsSet = (data & 2) != 0;
        this.bit114OfSupportedMcsSet = (data & 4) != 0;
        this.bit115OfSupportedMcsSet = (data & 8) != 0;
        this.bit116OfSupportedMcsSet = (data & 0x10) != 0;
        this.bit117OfSupportedMcsSet = (data & 0x20) != 0;
        this.bit118OfSupportedMcsSet = (data & 0x40) != 0;
        this.bit119OfSupportedMcsSet = (data & 0x80) != 0;
        data = rawData[offset + 20];
        this.bit120OfSupportedMcsSet = (data & 1) != 0;
        this.bit121OfSupportedMcsSet = (data & 2) != 0;
        this.bit122OfSupportedMcsSet = (data & 4) != 0;
        this.bit123OfSupportedMcsSet = (data & 8) != 0;
        this.bit124OfSupportedMcsSet = (data & 0x10) != 0;
        this.bit125OfSupportedMcsSet = (data & 0x20) != 0;
        this.bit126OfSupportedMcsSet = (data & 0x40) != 0;
        this.bit127OfSupportedMcsSet = (data & 0x80) != 0;
        data = rawData[offset + 21];
        this.pcoSupported = (data & 1) != 0;
        this.pcoTransitionTime = PcoTransitionTime.getInstance(data >> 1 & 3);
        this.bit3OfHtExtendedCapabilities = (data & 8) != 0;
        this.bit4OfHtExtendedCapabilities = (data & 0x10) != 0;
        this.bit5OfHtExtendedCapabilities = (data & 0x20) != 0;
        this.bit6OfHtExtendedCapabilities = (data & 0x40) != 0;
        this.bit7OfHtExtendedCapabilities = (data & 0x80) != 0;
        data = rawData[offset + 22];
        this.mcsFeedbackCapability = McsFeedbackCapability.getInstance(data & 3);
        this.htControlFieldSupported = (data & 4) != 0;
        this.rdResponderSupported = (data & 8) != 0;
        this.bit12OfHtExtendedCapabilities = (data & 0x10) != 0;
        this.bit13OfHtExtendedCapabilities = (data & 0x20) != 0;
        this.bit14OfHtExtendedCapabilities = (data & 0x40) != 0;
        this.bit15OfHtExtendedCapabilities = (data & 0x80) != 0;
        data = rawData[offset + 23];
        this.implicitTxBeamformingReceivingSupported = (data & 1) != 0;
        this.rxStaggeredSoundingSupported = (data & 2) != 0;
        this.txStaggeredSoundingSupported = (data & 4) != 0;
        this.rxNdpSupported = (data & 8) != 0;
        this.txNdpSupported = (data & 0x10) != 0;
        this.implicitTxBeamformingSupported = (data & 0x20) != 0;
        this.calibration = Calibration.getInstance(data >> 6 & 3);
        int intData = ByteArrays.getInt(rawData, offset + 24, ByteOrder.LITTLE_ENDIAN);
        this.explicitCsiTxBeamformingSupported = (intData & 1) != 0;
        this.explicitNoncompressedSteeringSupported = (intData & 2) != 0;
        this.explicitCompressedSteeringSupported = (intData & 4) != 0;
        this.explicitTxBeamformingCsiFeedbackCapability = BeamformingFeedbackCapability.getInstance(intData >> 3 & 3);
        this.explicitNoncompressedBeamformingFeedbackCapability = BeamformingFeedbackCapability.getInstance(intData >> 5 & 3);
        this.explicitCompressedBeamformingFeedbackCapability = BeamformingFeedbackCapability.getInstance(intData >> 7 & 3);
        this.minGrouping = Grouping.getInstance(intData >> 9 & 3);
        this.csiNumBeamformerAntennasSupported = NumBeamformerAntennas.getInstance(intData >> 11 & 3);
        this.noncompressedSteeringNumBeamformerAntennasSupported = NumBeamformerAntennas.getInstance(intData >> 13 & 3);
        this.compressedSteeringNumBeamformerAntennasSupported = NumBeamformerAntennas.getInstance(intData >> 15 & 3);
        this.csiMaxNumRowsBeamformerSupported = CsiNumRows.getInstance(intData >> 17 & 3);
        this.channelEstimationCapability = ChannelEstimationCapability.getInstance(intData >> 19 & 3);
        this.bit29OfTransmitBeamformingCapabilities = (intData & 0x200000) != 0;
        this.bit30OfTransmitBeamformingCapabilities = (intData & 0x400000) != 0;
        this.bit31OfTransmitBeamformingCapabilities = (intData & 0x800000) != 0;
        this.antennaSelectionSupported = (intData & 0x1000000) != 0;
        this.explicitCsiFeedbackBasedTxAselSupported = (intData & 0x2000000) != 0;
        this.antennaIndicesFeedbackBasedTxAselSupported = (intData & 0x4000000) != 0;
        this.explicitCsiFeedbackSupported = (intData & 0x8000000) != 0;
        this.antennaIndicesFeedbackSupported = (intData & 0x10000000) != 0;
        this.rxAselSupported = (intData & 0x20000000) != 0;
        this.txSoundingPpdusSupported = (intData & 0x40000000) != 0;
        this.bit7OfAselCapability = (intData & Integer.MIN_VALUE) != 0;
    }

    private Dot11HTCapabilitiesElement(Builder builder) {
        super(builder);
        if (builder == null || builder.smPowerSaveMode == null || builder.rxStbcSupport == null || builder.maxAMsduLength == null || builder.maxAMpduLength == null || builder.minMpduStartSpacing == null || builder.supportedRxMcsIndexes == null || builder.txMaxNumSpatialStreamsSupported == null || builder.pcoTransitionTime == null || builder.mcsFeedbackCapability == null || builder.calibration == null || builder.explicitTxBeamformingCsiFeedbackCapability == null || builder.explicitNoncompressedBeamformingFeedbackCapability == null || builder.explicitCompressedBeamformingFeedbackCapability == null || builder.minGrouping == null || builder.csiNumBeamformerAntennasSupported == null || builder.noncompressedSteeringNumBeamformerAntennasSupported == null || builder.compressedSteeringNumBeamformerAntennasSupported == null || builder.csiMaxNumRowsBeamformerSupported == null || builder.channelEstimationCapability == null) {
            StringBuilder sb = new StringBuilder();
            sb.append("builder: ").append(builder).append(" builder.smPowerSaveMode: ").append((Object)builder.smPowerSaveMode).append(" builder.rxStbcSupport: ").append((Object)builder.rxStbcSupport).append(" builder.maxAMsduLength: ").append((Object)builder.maxAMsduLength).append(" builder.maxAMpduLength: ").append((Object)builder.maxAMpduLength).append(" builder.minMpduStartSpacing: ").append((Object)builder.minMpduStartSpacing).append(" builder.supportedRxMcsIndexes: ").append(builder.supportedRxMcsIndexes).append(" builder.txMaxNumSpatialStreamsSupported: ").append((Object)builder.txMaxNumSpatialStreamsSupported).append(" builder.pcoTransitionTime: ").append((Object)builder.pcoTransitionTime).append(" builder.mcsFeedbackCapability: ").append((Object)builder.mcsFeedbackCapability).append(" builder.calibration: ").append((Object)builder.calibration).append(" builder.explicitTxBeamformingCsiFeedbackCapability: ").append((Object)builder.explicitTxBeamformingCsiFeedbackCapability).append(" builder.explicitNoncompressedBeamformingFeedbackCapability: ").append((Object)builder.explicitNoncompressedBeamformingFeedbackCapability).append(" builder.explicitCompressedBeamformingFeedbackCapability: ").append((Object)builder.explicitCompressedBeamformingFeedbackCapability).append(" builder.minGrouping: ").append((Object)builder.minGrouping).append(" builder.csiNumBeamformerAntennasSupported: ").append((Object)builder.csiNumBeamformerAntennasSupported).append(" builder.noncompressedSteeringNumBeamformerAntennasSupported: ").append((Object)builder.noncompressedSteeringNumBeamformerAntennasSupported).append(" builder.compressedSteeringNumBeamformerAntennasSupported: ").append((Object)builder.compressedSteeringNumBeamformerAntennasSupported).append(" builder.csiMaxNumRowsBeamformerSupported: ").append((Object)builder.csiMaxNumRowsBeamformerSupported).append(" builder.channelEstimationCapability: ").append((Object)builder.channelEstimationCapability);
            throw new NullPointerException(sb.toString());
        }
        if (builder.supportedRxMcsIndexes.length != 77) {
            throw new IllegalArgumentException("supportedRxMcsIndexes.length must be 77. builder.supportedRxMcsIndexes.length: " + builder.supportedRxMcsIndexes.length);
        }
        if ((builder.rxHighestSupportedDataRate & 0xFC00) != 0) {
            throw new IllegalArgumentException("(rxHighestSupportedDataRate & 0xFC00) must be zero. builder.rxHighestSupportedDataRate: " + builder.rxHighestSupportedDataRate);
        }
        this.ldpcCodingSupported = builder.ldpcCodingSupported;
        this.both20and40MhzSupported = builder.both20and40MhzSupported;
        this.smPowerSaveMode = builder.smPowerSaveMode;
        this.htGreenfieldSupported = builder.htGreenfieldSupported;
        this.shortGiFor20MhzSupported = builder.shortGiFor20MhzSupported;
        this.shortGiFor40MhzSupported = builder.shortGiFor40MhzSupported;
        this.txStbcSupported = builder.txStbcSupported;
        this.rxStbcSupport = builder.rxStbcSupport;
        this.htDelayedBlockAckSupported = builder.htDelayedBlockAckSupported;
        this.maxAMsduLength = builder.maxAMsduLength;
        this.dsssCckModeIn40MhzSupported = builder.dsssCckModeIn40MhzSupported;
        this.bit13OfHtCapabilitiesInfo = builder.bit13OfHtCapabilitiesInfo;
        this.fortyMhzIntolerant = builder.fortyMhzIntolerant;
        this.lSigTxopProtectionSupported = builder.lSigTxopProtectionSupported;
        this.maxAMpduLength = builder.maxAMpduLength;
        this.minMpduStartSpacing = builder.minMpduStartSpacing;
        this.bit5OfAMpduParameters = builder.bit5OfAMpduParameters;
        this.bit6OfAMpduParameters = builder.bit6OfAMpduParameters;
        this.bit7OfAMpduParameters = builder.bit7OfAMpduParameters;
        this.supportedRxMcsIndexes = builder.supportedRxMcsIndexes;
        this.bit77OfSupportedMcsSet = builder.bit77OfSupportedMcsSet;
        this.bit78OfSupportedMcsSet = builder.bit78OfSupportedMcsSet;
        this.bit79OfSupportedMcsSet = builder.bit79OfSupportedMcsSet;
        this.rxHighestSupportedDataRate = builder.rxHighestSupportedDataRate;
        this.bit90OfSupportedMcsSet = builder.bit90OfSupportedMcsSet;
        this.bit91OfSupportedMcsSet = builder.bit91OfSupportedMcsSet;
        this.bit92OfSupportedMcsSet = builder.bit92OfSupportedMcsSet;
        this.bit93OfSupportedMcsSet = builder.bit93OfSupportedMcsSet;
        this.bit94OfSupportedMcsSet = builder.bit94OfSupportedMcsSet;
        this.bit95OfSupportedMcsSet = builder.bit95OfSupportedMcsSet;
        this.txMcsSetDefined = builder.txMcsSetDefined;
        this.txRxMcsSetNotEqual = builder.txRxMcsSetNotEqual;
        this.txMaxNumSpatialStreamsSupported = builder.txMaxNumSpatialStreamsSupported;
        this.txUnequalModulationSupported = builder.txUnequalModulationSupported;
        this.bit101OfSupportedMcsSet = builder.bit101OfSupportedMcsSet;
        this.bit102OfSupportedMcsSet = builder.bit102OfSupportedMcsSet;
        this.bit103OfSupportedMcsSet = builder.bit103OfSupportedMcsSet;
        this.bit104OfSupportedMcsSet = builder.bit104OfSupportedMcsSet;
        this.bit105OfSupportedMcsSet = builder.bit105OfSupportedMcsSet;
        this.bit106OfSupportedMcsSet = builder.bit106OfSupportedMcsSet;
        this.bit107OfSupportedMcsSet = builder.bit107OfSupportedMcsSet;
        this.bit108OfSupportedMcsSet = builder.bit108OfSupportedMcsSet;
        this.bit109OfSupportedMcsSet = builder.bit109OfSupportedMcsSet;
        this.bit110OfSupportedMcsSet = builder.bit110OfSupportedMcsSet;
        this.bit111OfSupportedMcsSet = builder.bit111OfSupportedMcsSet;
        this.bit112OfSupportedMcsSet = builder.bit112OfSupportedMcsSet;
        this.bit113OfSupportedMcsSet = builder.bit113OfSupportedMcsSet;
        this.bit114OfSupportedMcsSet = builder.bit114OfSupportedMcsSet;
        this.bit115OfSupportedMcsSet = builder.bit115OfSupportedMcsSet;
        this.bit116OfSupportedMcsSet = builder.bit116OfSupportedMcsSet;
        this.bit117OfSupportedMcsSet = builder.bit117OfSupportedMcsSet;
        this.bit118OfSupportedMcsSet = builder.bit118OfSupportedMcsSet;
        this.bit119OfSupportedMcsSet = builder.bit119OfSupportedMcsSet;
        this.bit120OfSupportedMcsSet = builder.bit120OfSupportedMcsSet;
        this.bit121OfSupportedMcsSet = builder.bit121OfSupportedMcsSet;
        this.bit122OfSupportedMcsSet = builder.bit122OfSupportedMcsSet;
        this.bit123OfSupportedMcsSet = builder.bit123OfSupportedMcsSet;
        this.bit124OfSupportedMcsSet = builder.bit124OfSupportedMcsSet;
        this.bit125OfSupportedMcsSet = builder.bit125OfSupportedMcsSet;
        this.bit126OfSupportedMcsSet = builder.bit126OfSupportedMcsSet;
        this.bit127OfSupportedMcsSet = builder.bit127OfSupportedMcsSet;
        this.pcoSupported = builder.pcoSupported;
        this.pcoTransitionTime = builder.pcoTransitionTime;
        this.bit3OfHtExtendedCapabilities = builder.bit3OfHtExtendedCapabilities;
        this.bit4OfHtExtendedCapabilities = builder.bit4OfHtExtendedCapabilities;
        this.bit5OfHtExtendedCapabilities = builder.bit5OfHtExtendedCapabilities;
        this.bit6OfHtExtendedCapabilities = builder.bit6OfHtExtendedCapabilities;
        this.bit7OfHtExtendedCapabilities = builder.bit7OfHtExtendedCapabilities;
        this.mcsFeedbackCapability = builder.mcsFeedbackCapability;
        this.htControlFieldSupported = builder.htControlFieldSupported;
        this.rdResponderSupported = builder.rdResponderSupported;
        this.bit12OfHtExtendedCapabilities = builder.bit12OfHtExtendedCapabilities;
        this.bit13OfHtExtendedCapabilities = builder.bit13OfHtExtendedCapabilities;
        this.bit14OfHtExtendedCapabilities = builder.bit14OfHtExtendedCapabilities;
        this.bit15OfHtExtendedCapabilities = builder.bit15OfHtExtendedCapabilities;
        this.implicitTxBeamformingReceivingSupported = builder.implicitTxBeamformingReceivingSupported;
        this.rxStaggeredSoundingSupported = builder.rxStaggeredSoundingSupported;
        this.txStaggeredSoundingSupported = builder.txStaggeredSoundingSupported;
        this.rxNdpSupported = builder.rxNdpSupported;
        this.txNdpSupported = builder.txNdpSupported;
        this.implicitTxBeamformingSupported = builder.implicitTxBeamformingSupported;
        this.calibration = builder.calibration;
        this.explicitCsiTxBeamformingSupported = builder.explicitCsiTxBeamformingSupported;
        this.explicitNoncompressedSteeringSupported = builder.explicitNoncompressedSteeringSupported;
        this.explicitCompressedSteeringSupported = builder.explicitCompressedSteeringSupported;
        this.explicitTxBeamformingCsiFeedbackCapability = builder.explicitTxBeamformingCsiFeedbackCapability;
        this.explicitNoncompressedBeamformingFeedbackCapability = builder.explicitNoncompressedBeamformingFeedbackCapability;
        this.explicitCompressedBeamformingFeedbackCapability = builder.explicitCompressedBeamformingFeedbackCapability;
        this.minGrouping = builder.minGrouping;
        this.csiNumBeamformerAntennasSupported = builder.csiNumBeamformerAntennasSupported;
        this.noncompressedSteeringNumBeamformerAntennasSupported = builder.noncompressedSteeringNumBeamformerAntennasSupported;
        this.compressedSteeringNumBeamformerAntennasSupported = builder.compressedSteeringNumBeamformerAntennasSupported;
        this.csiMaxNumRowsBeamformerSupported = builder.csiMaxNumRowsBeamformerSupported;
        this.channelEstimationCapability = builder.channelEstimationCapability;
        this.bit29OfTransmitBeamformingCapabilities = builder.bit29OfTransmitBeamformingCapabilities;
        this.bit30OfTransmitBeamformingCapabilities = builder.bit30OfTransmitBeamformingCapabilities;
        this.bit31OfTransmitBeamformingCapabilities = builder.bit31OfTransmitBeamformingCapabilities;
        this.antennaSelectionSupported = builder.antennaSelectionSupported;
        this.explicitCsiFeedbackBasedTxAselSupported = builder.explicitCsiFeedbackBasedTxAselSupported;
        this.antennaIndicesFeedbackBasedTxAselSupported = builder.antennaIndicesFeedbackBasedTxAselSupported;
        this.explicitCsiFeedbackSupported = builder.explicitCsiFeedbackSupported;
        this.antennaIndicesFeedbackSupported = builder.antennaIndicesFeedbackSupported;
        this.rxAselSupported = builder.rxAselSupported;
        this.txSoundingPpdusSupported = builder.txSoundingPpdusSupported;
        this.bit7OfAselCapability = builder.bit7OfAselCapability;
    }

    public boolean isLdpcCodingSupported() {
        return this.ldpcCodingSupported;
    }

    public boolean isBoth20and40MhzSupported() {
        return this.both20and40MhzSupported;
    }

    public SmPowerSaveMode getSmPowerSaveMode() {
        return this.smPowerSaveMode;
    }

    public boolean isHtGreenfieldSupported() {
        return this.htGreenfieldSupported;
    }

    public boolean isShortGiFor20MhzSupported() {
        return this.shortGiFor20MhzSupported;
    }

    public boolean isShortGiFor40MhzSupported() {
        return this.shortGiFor40MhzSupported;
    }

    public boolean isTxStbcSupported() {
        return this.txStbcSupported;
    }

    public StbcSupport getRxStbcSupport() {
        return this.rxStbcSupport;
    }

    public boolean isHtDelayedBlockAckSupported() {
        return this.htDelayedBlockAckSupported;
    }

    public AMsduLength getMaxAMsduLength() {
        return this.maxAMsduLength;
    }

    public boolean isDsssCckModeIn40MhzSupported() {
        return this.dsssCckModeIn40MhzSupported;
    }

    public boolean getBit13OfHtCapabilitiesInfo() {
        return this.bit13OfHtCapabilitiesInfo;
    }

    public boolean isFortyMhzIntolerant() {
        return this.fortyMhzIntolerant;
    }

    public boolean islSigTxopProtectionSupported() {
        return this.lSigTxopProtectionSupported;
    }

    public AMpduLength getMaxAMpduLength() {
        return this.maxAMpduLength;
    }

    public MpduStartSpacing getMinMpduStartSpacing() {
        return this.minMpduStartSpacing;
    }

    public boolean getBit5OfAMpduParameters() {
        return this.bit5OfAMpduParameters;
    }

    public boolean getBit6OfAMpduParameters() {
        return this.bit6OfAMpduParameters;
    }

    public boolean getBit7OfAMpduParameters() {
        return this.bit7OfAMpduParameters;
    }

    public boolean[] getSupportedRxMcsIndexes() {
        boolean[] clone = new boolean[77];
        System.arraycopy(this.supportedRxMcsIndexes, 0, clone, 0, clone.length);
        return clone;
    }

    public boolean getBit77OfSupportedMcsSet() {
        return this.bit77OfSupportedMcsSet;
    }

    public boolean getBit78OfSupportedMcsSet() {
        return this.bit78OfSupportedMcsSet;
    }

    public boolean getBit79OfSupportedMcsSet() {
        return this.bit79OfSupportedMcsSet;
    }

    public short getRxHighestSupportedDataRate() {
        return this.rxHighestSupportedDataRate;
    }

    public int getRxHighestSupportedDataRateAsInt() {
        return this.rxHighestSupportedDataRate;
    }

    public boolean getBit90OfSupportedMcsSet() {
        return this.bit90OfSupportedMcsSet;
    }

    public boolean getBit91OfSupportedMcsSet() {
        return this.bit91OfSupportedMcsSet;
    }

    public boolean getBit92OfSupportedMcsSet() {
        return this.bit92OfSupportedMcsSet;
    }

    public boolean getBit93OfSupportedMcsSet() {
        return this.bit93OfSupportedMcsSet;
    }

    public boolean getBit94OfSupportedMcsSet() {
        return this.bit94OfSupportedMcsSet;
    }

    public boolean getBit95OfSupportedMcsSet() {
        return this.bit95OfSupportedMcsSet;
    }

    public boolean isTxMcsSetDefined() {
        return this.txMcsSetDefined;
    }

    public boolean isTxRxMcsSetNotEqual() {
        return this.txRxMcsSetNotEqual;
    }

    public NumSpatialStreams getTxMaxNumSpatialStreamsSupported() {
        return this.txMaxNumSpatialStreamsSupported;
    }

    public boolean isTxUnequalModulationSupported() {
        return this.txUnequalModulationSupported;
    }

    public boolean getBit101OfSupportedMcsSet() {
        return this.bit101OfSupportedMcsSet;
    }

    public boolean getBit102OfSupportedMcsSet() {
        return this.bit102OfSupportedMcsSet;
    }

    public boolean getBit103OfSupportedMcsSet() {
        return this.bit103OfSupportedMcsSet;
    }

    public boolean getBit104OfSupportedMcsSet() {
        return this.bit104OfSupportedMcsSet;
    }

    public boolean getBit105OfSupportedMcsSet() {
        return this.bit105OfSupportedMcsSet;
    }

    public boolean getBit106OfSupportedMcsSet() {
        return this.bit106OfSupportedMcsSet;
    }

    public boolean getBit107OfSupportedMcsSet() {
        return this.bit107OfSupportedMcsSet;
    }

    public boolean getBit108OfSupportedMcsSet() {
        return this.bit108OfSupportedMcsSet;
    }

    public boolean getBit109OfSupportedMcsSet() {
        return this.bit109OfSupportedMcsSet;
    }

    public boolean getBit110OfSupportedMcsSet() {
        return this.bit110OfSupportedMcsSet;
    }

    public boolean getBit111OfSupportedMcsSet() {
        return this.bit111OfSupportedMcsSet;
    }

    public boolean getBit112OfSupportedMcsSet() {
        return this.bit112OfSupportedMcsSet;
    }

    public boolean getBit113OfSupportedMcsSet() {
        return this.bit113OfSupportedMcsSet;
    }

    public boolean getBit114OfSupportedMcsSet() {
        return this.bit114OfSupportedMcsSet;
    }

    public boolean getBit115OfSupportedMcsSet() {
        return this.bit115OfSupportedMcsSet;
    }

    public boolean getBit116OfSupportedMcsSet() {
        return this.bit116OfSupportedMcsSet;
    }

    public boolean getBit117OfSupportedMcsSet() {
        return this.bit117OfSupportedMcsSet;
    }

    public boolean getBit118OfSupportedMcsSet() {
        return this.bit118OfSupportedMcsSet;
    }

    public boolean getBit119OfSupportedMcsSet() {
        return this.bit119OfSupportedMcsSet;
    }

    public boolean getBit120OfSupportedMcsSet() {
        return this.bit120OfSupportedMcsSet;
    }

    public boolean getBit121OfSupportedMcsSet() {
        return this.bit121OfSupportedMcsSet;
    }

    public boolean getBit122OfSupportedMcsSet() {
        return this.bit122OfSupportedMcsSet;
    }

    public boolean getBit123OfSupportedMcsSet() {
        return this.bit123OfSupportedMcsSet;
    }

    public boolean getBit124OfSupportedMcsSet() {
        return this.bit124OfSupportedMcsSet;
    }

    public boolean getBit125OfSupportedMcsSet() {
        return this.bit125OfSupportedMcsSet;
    }

    public boolean getBit126OfSupportedMcsSet() {
        return this.bit126OfSupportedMcsSet;
    }

    public boolean getBit127OfSupportedMcsSet() {
        return this.bit127OfSupportedMcsSet;
    }

    public boolean isPcoSupported() {
        return this.pcoSupported;
    }

    public PcoTransitionTime getPcoTransitionTime() {
        return this.pcoTransitionTime;
    }

    public boolean getBit3OfHtExtendedCapabilities() {
        return this.bit3OfHtExtendedCapabilities;
    }

    public boolean getBit4OfHtExtendedCapabilities() {
        return this.bit4OfHtExtendedCapabilities;
    }

    public boolean getBit5OfHtExtendedCapabilities() {
        return this.bit5OfHtExtendedCapabilities;
    }

    public boolean getBit6OfHtExtendedCapabilities() {
        return this.bit6OfHtExtendedCapabilities;
    }

    public boolean getBit7OfHtExtendedCapabilities() {
        return this.bit7OfHtExtendedCapabilities;
    }

    public McsFeedbackCapability getMcsFeedbackCapability() {
        return this.mcsFeedbackCapability;
    }

    public boolean isHtControlFieldSupported() {
        return this.htControlFieldSupported;
    }

    public boolean isRdResponderSupported() {
        return this.rdResponderSupported;
    }

    public boolean getBit12OfHtExtendedCapabilities() {
        return this.bit12OfHtExtendedCapabilities;
    }

    public boolean getBit13OfHtExtendedCapabilities() {
        return this.bit13OfHtExtendedCapabilities;
    }

    public boolean getBit14OfHtExtendedCapabilities() {
        return this.bit14OfHtExtendedCapabilities;
    }

    public boolean getBit15OfHtExtendedCapabilities() {
        return this.bit15OfHtExtendedCapabilities;
    }

    public boolean isImplicitTxBeamformingReceivingSupported() {
        return this.implicitTxBeamformingReceivingSupported;
    }

    public boolean isRxStaggeredSoundingSupported() {
        return this.rxStaggeredSoundingSupported;
    }

    public boolean isTxStaggeredSoundingSupported() {
        return this.txStaggeredSoundingSupported;
    }

    public boolean isRxNdpSupported() {
        return this.rxNdpSupported;
    }

    public boolean isTxNdpSupported() {
        return this.txNdpSupported;
    }

    public boolean isImplicitTxBeamformingSupported() {
        return this.implicitTxBeamformingSupported;
    }

    public Calibration getCalibration() {
        return this.calibration;
    }

    public boolean isExplicitCsiTxBeamformingSupported() {
        return this.explicitCsiTxBeamformingSupported;
    }

    public boolean isExplicitNoncompressedSteeringSupported() {
        return this.explicitNoncompressedSteeringSupported;
    }

    public boolean isExplicitCompressedSteeringSupported() {
        return this.explicitCompressedSteeringSupported;
    }

    public BeamformingFeedbackCapability getExplicitTxBeamformingCsiFeedbackCapability() {
        return this.explicitTxBeamformingCsiFeedbackCapability;
    }

    public BeamformingFeedbackCapability getExplicitNoncompressedBeamformingFeedbackCapability() {
        return this.explicitNoncompressedBeamformingFeedbackCapability;
    }

    public BeamformingFeedbackCapability getExplicitCompressedBeamformingFeedbackCapability() {
        return this.explicitCompressedBeamformingFeedbackCapability;
    }

    public Grouping getMinGrouping() {
        return this.minGrouping;
    }

    public NumBeamformerAntennas getCsiNumBeamformerAntennasSupported() {
        return this.csiNumBeamformerAntennasSupported;
    }

    public NumBeamformerAntennas getNoncompressedSteeringNumBeamformerAntennasSupported() {
        return this.noncompressedSteeringNumBeamformerAntennasSupported;
    }

    public NumBeamformerAntennas getCompressedSteeringNumBeamformerAntennasSupported() {
        return this.compressedSteeringNumBeamformerAntennasSupported;
    }

    public CsiNumRows getCsiMaxNumRowsBeamformerSupported() {
        return this.csiMaxNumRowsBeamformerSupported;
    }

    public ChannelEstimationCapability getChannelEstimationCapability() {
        return this.channelEstimationCapability;
    }

    public boolean getBit29OfTransmitBeamformingCapabilities() {
        return this.bit29OfTransmitBeamformingCapabilities;
    }

    public boolean getBit30OfTransmitBeamformingCapabilities() {
        return this.bit30OfTransmitBeamformingCapabilities;
    }

    public boolean getBit31OfTransmitBeamformingCapabilities() {
        return this.bit31OfTransmitBeamformingCapabilities;
    }

    public boolean isAntennaSelectionSupported() {
        return this.antennaSelectionSupported;
    }

    public boolean isExplicitCsiFeedbackBasedTxAselSupported() {
        return this.explicitCsiFeedbackBasedTxAselSupported;
    }

    public boolean isAntennaIndicesFeedbackBasedTxAselSupported() {
        return this.antennaIndicesFeedbackBasedTxAselSupported;
    }

    public boolean isExplicitCsiFeedbackSupported() {
        return this.explicitCsiFeedbackSupported;
    }

    public boolean isAntennaIndicesFeedbackSupported() {
        return this.antennaIndicesFeedbackSupported;
    }

    public boolean isRxAselSupported() {
        return this.rxAselSupported;
    }

    public boolean isTxSoundingPpdusSupported() {
        return this.txSoundingPpdusSupported;
    }

    public boolean getBit7OfAselCapability() {
        return this.bit7OfAselCapability;
    }

    @Override
    public int length() {
        return 28;
    }

    @Override
    public byte[] getRawData() {
        byte[] rawData = new byte[this.length()];
        rawData[0] = (Byte)this.getElementId().value();
        rawData[1] = this.getLength();
        int idx = 2;
        rawData[idx] = (byte)(this.smPowerSaveMode.value << 2);
        if (this.ldpcCodingSupported) {
            int n = idx;
            rawData[n] = (byte)(rawData[n] | 1);
        }
        if (this.both20and40MhzSupported) {
            int n = idx;
            rawData[n] = (byte)(rawData[n] | 2);
        }
        if (this.htGreenfieldSupported) {
            int n = idx;
            rawData[n] = (byte)(rawData[n] | 0x10);
        }
        if (this.shortGiFor20MhzSupported) {
            int n = idx;
            rawData[n] = (byte)(rawData[n] | 0x20);
        }
        if (this.shortGiFor40MhzSupported) {
            int n = idx;
            rawData[n] = (byte)(rawData[n] | 0x40);
        }
        if (this.txStbcSupported) {
            int n = idx;
            rawData[n] = (byte)(rawData[n] | 0x80);
        }
        idx = 3;
        rawData[idx] = (byte)(this.rxStbcSupport.value | this.maxAMsduLength.value << 3);
        if (this.htDelayedBlockAckSupported) {
            int n = idx;
            rawData[n] = (byte)(rawData[n] | 4);
        }
        if (this.dsssCckModeIn40MhzSupported) {
            int n = idx;
            rawData[n] = (byte)(rawData[n] | 0x10);
        }
        if (this.bit13OfHtCapabilitiesInfo) {
            int n = idx;
            rawData[n] = (byte)(rawData[n] | 0x20);
        }
        if (this.fortyMhzIntolerant) {
            int n = idx;
            rawData[n] = (byte)(rawData[n] | 0x40);
        }
        if (this.lSigTxopProtectionSupported) {
            int n = idx;
            rawData[n] = (byte)(rawData[n] | 0x80);
        }
        idx = 4;
        rawData[idx] = (byte)(this.maxAMpduLength.value | this.minMpduStartSpacing.value << 2);
        if (this.bit5OfAMpduParameters) {
            int n = idx;
            rawData[n] = (byte)(rawData[n] | 0x20);
        }
        if (this.bit6OfAMpduParameters) {
            int n = idx;
            rawData[n] = (byte)(rawData[n] | 0x40);
        }
        if (this.bit7OfAMpduParameters) {
            int n = idx;
            rawData[n] = (byte)(rawData[n] | 0x80);
        }
        block10: for (int i2 = 0; i2 < this.supportedRxMcsIndexes.length; ++i2) {
            if (!this.supportedRxMcsIndexes[i2]) continue;
            idx = 5 + i2 / 8;
            switch (i2 % 8) {
                case 0: {
                    int n = idx;
                    rawData[n] = (byte)(rawData[n] | 1);
                    continue block10;
                }
                case 1: {
                    int n = idx;
                    rawData[n] = (byte)(rawData[n] | 2);
                    continue block10;
                }
                case 2: {
                    int n = idx;
                    rawData[n] = (byte)(rawData[n] | 4);
                    continue block10;
                }
                case 3: {
                    int n = idx;
                    rawData[n] = (byte)(rawData[n] | 8);
                    continue block10;
                }
                case 4: {
                    int n = idx;
                    rawData[n] = (byte)(rawData[n] | 0x10);
                    continue block10;
                }
                case 5: {
                    int n = idx;
                    rawData[n] = (byte)(rawData[n] | 0x20);
                    continue block10;
                }
                case 6: {
                    int n = idx;
                    rawData[n] = (byte)(rawData[n] | 0x40);
                    continue block10;
                }
                case 7: {
                    int n = idx;
                    rawData[n] = (byte)(rawData[n] | 0x80);
                }
            }
        }
        idx = 14;
        if (this.bit77OfSupportedMcsSet) {
            int n = idx;
            rawData[n] = (byte)(rawData[n] | 0x20);
        }
        if (this.bit78OfSupportedMcsSet) {
            int n = idx;
            rawData[n] = (byte)(rawData[n] | 0x40);
        }
        if (this.bit79OfSupportedMcsSet) {
            int n = idx;
            rawData[n] = (byte)(rawData[n] | 0x80);
        }
        System.arraycopy(ByteArrays.toByteArray(this.rxHighestSupportedDataRate, ByteOrder.LITTLE_ENDIAN), 0, rawData, 15, 2);
        idx = 16;
        if (this.bit90OfSupportedMcsSet) {
            int n = idx;
            rawData[n] = (byte)(rawData[n] | 4);
        }
        if (this.bit91OfSupportedMcsSet) {
            int n = idx;
            rawData[n] = (byte)(rawData[n] | 8);
        }
        if (this.bit92OfSupportedMcsSet) {
            int n = idx;
            rawData[n] = (byte)(rawData[n] | 0x10);
        }
        if (this.bit93OfSupportedMcsSet) {
            int n = idx;
            rawData[n] = (byte)(rawData[n] | 0x20);
        }
        if (this.bit94OfSupportedMcsSet) {
            int n = idx;
            rawData[n] = (byte)(rawData[n] | 0x40);
        }
        if (this.bit95OfSupportedMcsSet) {
            int n = idx;
            rawData[n] = (byte)(rawData[n] | 0x80);
        }
        idx = 17;
        rawData[idx] = (byte)(this.txMaxNumSpatialStreamsSupported.value << 2);
        if (this.txMcsSetDefined) {
            int n = idx;
            rawData[n] = (byte)(rawData[n] | 1);
        }
        if (this.txRxMcsSetNotEqual) {
            int n = idx;
            rawData[n] = (byte)(rawData[n] | 2);
        }
        if (this.txUnequalModulationSupported) {
            int n = idx;
            rawData[n] = (byte)(rawData[n] | 0x10);
        }
        if (this.bit101OfSupportedMcsSet) {
            int n = idx;
            rawData[n] = (byte)(rawData[n] | 0x20);
        }
        if (this.bit102OfSupportedMcsSet) {
            int n = idx;
            rawData[n] = (byte)(rawData[n] | 0x40);
        }
        if (this.bit103OfSupportedMcsSet) {
            int n = idx;
            rawData[n] = (byte)(rawData[n] | 0x80);
        }
        idx = 18;
        if (this.bit104OfSupportedMcsSet) {
            int n = idx;
            rawData[n] = (byte)(rawData[n] | 1);
        }
        if (this.bit105OfSupportedMcsSet) {
            int n = idx;
            rawData[n] = (byte)(rawData[n] | 2);
        }
        if (this.bit106OfSupportedMcsSet) {
            int n = idx;
            rawData[n] = (byte)(rawData[n] | 4);
        }
        if (this.bit107OfSupportedMcsSet) {
            int n = idx;
            rawData[n] = (byte)(rawData[n] | 8);
        }
        if (this.bit108OfSupportedMcsSet) {
            int n = idx;
            rawData[n] = (byte)(rawData[n] | 0x10);
        }
        if (this.bit109OfSupportedMcsSet) {
            int n = idx;
            rawData[n] = (byte)(rawData[n] | 0x20);
        }
        if (this.bit110OfSupportedMcsSet) {
            int n = idx;
            rawData[n] = (byte)(rawData[n] | 0x40);
        }
        if (this.bit111OfSupportedMcsSet) {
            int n = idx;
            rawData[n] = (byte)(rawData[n] | 0x80);
        }
        idx = 19;
        if (this.bit112OfSupportedMcsSet) {
            int n = idx;
            rawData[n] = (byte)(rawData[n] | 1);
        }
        if (this.bit113OfSupportedMcsSet) {
            int n = idx;
            rawData[n] = (byte)(rawData[n] | 2);
        }
        if (this.bit114OfSupportedMcsSet) {
            int n = idx;
            rawData[n] = (byte)(rawData[n] | 4);
        }
        if (this.bit115OfSupportedMcsSet) {
            int n = idx;
            rawData[n] = (byte)(rawData[n] | 8);
        }
        if (this.bit116OfSupportedMcsSet) {
            int n = idx;
            rawData[n] = (byte)(rawData[n] | 0x10);
        }
        if (this.bit117OfSupportedMcsSet) {
            int n = idx;
            rawData[n] = (byte)(rawData[n] | 0x20);
        }
        if (this.bit118OfSupportedMcsSet) {
            int n = idx;
            rawData[n] = (byte)(rawData[n] | 0x40);
        }
        if (this.bit119OfSupportedMcsSet) {
            int n = idx;
            rawData[n] = (byte)(rawData[n] | 0x80);
        }
        idx = 20;
        if (this.bit120OfSupportedMcsSet) {
            int n = idx;
            rawData[n] = (byte)(rawData[n] | 1);
        }
        if (this.bit121OfSupportedMcsSet) {
            int n = idx;
            rawData[n] = (byte)(rawData[n] | 2);
        }
        if (this.bit122OfSupportedMcsSet) {
            int n = idx;
            rawData[n] = (byte)(rawData[n] | 4);
        }
        if (this.bit123OfSupportedMcsSet) {
            int n = idx;
            rawData[n] = (byte)(rawData[n] | 8);
        }
        if (this.bit124OfSupportedMcsSet) {
            int n = idx;
            rawData[n] = (byte)(rawData[n] | 0x10);
        }
        if (this.bit125OfSupportedMcsSet) {
            int n = idx;
            rawData[n] = (byte)(rawData[n] | 0x20);
        }
        if (this.bit126OfSupportedMcsSet) {
            int n = idx;
            rawData[n] = (byte)(rawData[n] | 0x40);
        }
        if (this.bit127OfSupportedMcsSet) {
            int n = idx;
            rawData[n] = (byte)(rawData[n] | 0x80);
        }
        idx = 21;
        rawData[idx] = (byte)(this.pcoTransitionTime.value << 1);
        if (this.pcoSupported) {
            int n = idx;
            rawData[n] = (byte)(rawData[n] | 1);
        }
        if (this.bit3OfHtExtendedCapabilities) {
            int n = idx;
            rawData[n] = (byte)(rawData[n] | 8);
        }
        if (this.bit4OfHtExtendedCapabilities) {
            int n = idx;
            rawData[n] = (byte)(rawData[n] | 0x10);
        }
        if (this.bit5OfHtExtendedCapabilities) {
            int n = idx;
            rawData[n] = (byte)(rawData[n] | 0x20);
        }
        if (this.bit6OfHtExtendedCapabilities) {
            int n = idx;
            rawData[n] = (byte)(rawData[n] | 0x40);
        }
        if (this.bit7OfHtExtendedCapabilities) {
            int n = idx;
            rawData[n] = (byte)(rawData[n] | 0x80);
        }
        idx = 22;
        rawData[idx] = (byte)this.mcsFeedbackCapability.value;
        if (this.htControlFieldSupported) {
            int n = idx;
            rawData[n] = (byte)(rawData[n] | 4);
        }
        if (this.rdResponderSupported) {
            int n = idx;
            rawData[n] = (byte)(rawData[n] | 8);
        }
        if (this.bit12OfHtExtendedCapabilities) {
            int n = idx;
            rawData[n] = (byte)(rawData[n] | 0x10);
        }
        if (this.bit13OfHtExtendedCapabilities) {
            int n = idx;
            rawData[n] = (byte)(rawData[n] | 0x20);
        }
        if (this.bit14OfHtExtendedCapabilities) {
            int n = idx;
            rawData[n] = (byte)(rawData[n] | 0x40);
        }
        if (this.bit15OfHtExtendedCapabilities) {
            int n = idx;
            rawData[n] = (byte)(rawData[n] | 0x80);
        }
        idx = 23;
        rawData[idx] = (byte)(this.calibration.value << 6);
        if (this.implicitTxBeamformingReceivingSupported) {
            int n = idx;
            rawData[n] = (byte)(rawData[n] | 1);
        }
        if (this.rxStaggeredSoundingSupported) {
            int n = idx;
            rawData[n] = (byte)(rawData[n] | 2);
        }
        if (this.txStaggeredSoundingSupported) {
            int n = idx;
            rawData[n] = (byte)(rawData[n] | 4);
        }
        if (this.rxNdpSupported) {
            int n = idx;
            rawData[n] = (byte)(rawData[n] | 8);
        }
        if (this.txNdpSupported) {
            int n = idx;
            rawData[n] = (byte)(rawData[n] | 0x10);
        }
        if (this.implicitTxBeamformingSupported) {
            int n = idx;
            rawData[n] = (byte)(rawData[n] | 0x20);
        }
        int lastData = this.explicitTxBeamformingCsiFeedbackCapability.value << 3 | this.explicitNoncompressedBeamformingFeedbackCapability.value << 5 | this.explicitCompressedBeamformingFeedbackCapability.value << 7 | this.minGrouping.value << 9 | this.csiNumBeamformerAntennasSupported.value << 11 | this.noncompressedSteeringNumBeamformerAntennasSupported.value << 13 | this.compressedSteeringNumBeamformerAntennasSupported.value << 15 | this.csiMaxNumRowsBeamformerSupported.value << 17 | this.channelEstimationCapability.value << 19;
        if (this.explicitCsiTxBeamformingSupported) {
            lastData |= 1;
        }
        if (this.explicitNoncompressedSteeringSupported) {
            lastData |= 2;
        }
        if (this.explicitCompressedSteeringSupported) {
            lastData |= 4;
        }
        if (this.bit29OfTransmitBeamformingCapabilities) {
            lastData |= 0x200000;
        }
        if (this.bit30OfTransmitBeamformingCapabilities) {
            lastData |= 0x400000;
        }
        if (this.bit31OfTransmitBeamformingCapabilities) {
            lastData |= 0x800000;
        }
        if (this.antennaSelectionSupported) {
            lastData |= 0x1000000;
        }
        if (this.explicitCsiFeedbackBasedTxAselSupported) {
            lastData |= 0x2000000;
        }
        if (this.antennaIndicesFeedbackBasedTxAselSupported) {
            lastData |= 0x4000000;
        }
        if (this.explicitCsiFeedbackSupported) {
            lastData |= 0x8000000;
        }
        if (this.antennaIndicesFeedbackSupported) {
            lastData |= 0x10000000;
        }
        if (this.rxAselSupported) {
            lastData |= 0x20000000;
        }
        if (this.txSoundingPpdusSupported) {
            lastData |= 0x40000000;
        }
        if (this.bit7OfAselCapability) {
            lastData |= Integer.MIN_VALUE;
        }
        System.arraycopy(ByteArrays.toByteArray(lastData, ByteOrder.LITTLE_ENDIAN), 0, rawData, 24, 4);
        return rawData;
    }

    public Builder getBuilder() {
        return new Builder(this);
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result2 = super.hashCode();
        result2 = 31 * result2 + (this.antennaIndicesFeedbackBasedTxAselSupported ? 1231 : 1237);
        result2 = 31 * result2 + (this.antennaIndicesFeedbackSupported ? 1231 : 1237);
        result2 = 31 * result2 + (this.antennaSelectionSupported ? 1231 : 1237);
        result2 = 31 * result2 + (this.bit101OfSupportedMcsSet ? 1231 : 1237);
        result2 = 31 * result2 + (this.bit102OfSupportedMcsSet ? 1231 : 1237);
        result2 = 31 * result2 + (this.bit103OfSupportedMcsSet ? 1231 : 1237);
        result2 = 31 * result2 + (this.bit104OfSupportedMcsSet ? 1231 : 1237);
        result2 = 31 * result2 + (this.bit105OfSupportedMcsSet ? 1231 : 1237);
        result2 = 31 * result2 + (this.bit106OfSupportedMcsSet ? 1231 : 1237);
        result2 = 31 * result2 + (this.bit107OfSupportedMcsSet ? 1231 : 1237);
        result2 = 31 * result2 + (this.bit108OfSupportedMcsSet ? 1231 : 1237);
        result2 = 31 * result2 + (this.bit109OfSupportedMcsSet ? 1231 : 1237);
        result2 = 31 * result2 + (this.bit110OfSupportedMcsSet ? 1231 : 1237);
        result2 = 31 * result2 + (this.bit111OfSupportedMcsSet ? 1231 : 1237);
        result2 = 31 * result2 + (this.bit112OfSupportedMcsSet ? 1231 : 1237);
        result2 = 31 * result2 + (this.bit113OfSupportedMcsSet ? 1231 : 1237);
        result2 = 31 * result2 + (this.bit114OfSupportedMcsSet ? 1231 : 1237);
        result2 = 31 * result2 + (this.bit115OfSupportedMcsSet ? 1231 : 1237);
        result2 = 31 * result2 + (this.bit116OfSupportedMcsSet ? 1231 : 1237);
        result2 = 31 * result2 + (this.bit117OfSupportedMcsSet ? 1231 : 1237);
        result2 = 31 * result2 + (this.bit118OfSupportedMcsSet ? 1231 : 1237);
        result2 = 31 * result2 + (this.bit119OfSupportedMcsSet ? 1231 : 1237);
        result2 = 31 * result2 + (this.bit120OfSupportedMcsSet ? 1231 : 1237);
        result2 = 31 * result2 + (this.bit121OfSupportedMcsSet ? 1231 : 1237);
        result2 = 31 * result2 + (this.bit122OfSupportedMcsSet ? 1231 : 1237);
        result2 = 31 * result2 + (this.bit123OfSupportedMcsSet ? 1231 : 1237);
        result2 = 31 * result2 + (this.bit124OfSupportedMcsSet ? 1231 : 1237);
        result2 = 31 * result2 + (this.bit125OfSupportedMcsSet ? 1231 : 1237);
        result2 = 31 * result2 + (this.bit126OfSupportedMcsSet ? 1231 : 1237);
        result2 = 31 * result2 + (this.bit127OfSupportedMcsSet ? 1231 : 1237);
        result2 = 31 * result2 + (this.bit12OfHtExtendedCapabilities ? 1231 : 1237);
        result2 = 31 * result2 + (this.bit13OfHtCapabilitiesInfo ? 1231 : 1237);
        result2 = 31 * result2 + (this.bit13OfHtExtendedCapabilities ? 1231 : 1237);
        result2 = 31 * result2 + (this.bit14OfHtExtendedCapabilities ? 1231 : 1237);
        result2 = 31 * result2 + (this.bit15OfHtExtendedCapabilities ? 1231 : 1237);
        result2 = 31 * result2 + (this.bit29OfTransmitBeamformingCapabilities ? 1231 : 1237);
        result2 = 31 * result2 + (this.bit30OfTransmitBeamformingCapabilities ? 1231 : 1237);
        result2 = 31 * result2 + (this.bit31OfTransmitBeamformingCapabilities ? 1231 : 1237);
        result2 = 31 * result2 + (this.bit3OfHtExtendedCapabilities ? 1231 : 1237);
        result2 = 31 * result2 + (this.bit4OfHtExtendedCapabilities ? 1231 : 1237);
        result2 = 31 * result2 + (this.bit5OfAMpduParameters ? 1231 : 1237);
        result2 = 31 * result2 + (this.bit5OfHtExtendedCapabilities ? 1231 : 1237);
        result2 = 31 * result2 + (this.bit6OfAMpduParameters ? 1231 : 1237);
        result2 = 31 * result2 + (this.bit6OfHtExtendedCapabilities ? 1231 : 1237);
        result2 = 31 * result2 + (this.bit77OfSupportedMcsSet ? 1231 : 1237);
        result2 = 31 * result2 + (this.bit78OfSupportedMcsSet ? 1231 : 1237);
        result2 = 31 * result2 + (this.bit79OfSupportedMcsSet ? 1231 : 1237);
        result2 = 31 * result2 + (this.bit7OfAMpduParameters ? 1231 : 1237);
        result2 = 31 * result2 + (this.bit7OfAselCapability ? 1231 : 1237);
        result2 = 31 * result2 + (this.bit7OfHtExtendedCapabilities ? 1231 : 1237);
        result2 = 31 * result2 + (this.bit90OfSupportedMcsSet ? 1231 : 1237);
        result2 = 31 * result2 + (this.bit91OfSupportedMcsSet ? 1231 : 1237);
        result2 = 31 * result2 + (this.bit92OfSupportedMcsSet ? 1231 : 1237);
        result2 = 31 * result2 + (this.bit93OfSupportedMcsSet ? 1231 : 1237);
        result2 = 31 * result2 + (this.bit94OfSupportedMcsSet ? 1231 : 1237);
        result2 = 31 * result2 + (this.bit95OfSupportedMcsSet ? 1231 : 1237);
        result2 = 31 * result2 + (this.both20and40MhzSupported ? 1231 : 1237);
        result2 = 31 * result2 + this.calibration.hashCode();
        result2 = 31 * result2 + this.channelEstimationCapability.hashCode();
        result2 = 31 * result2 + this.compressedSteeringNumBeamformerAntennasSupported.hashCode();
        result2 = 31 * result2 + this.csiMaxNumRowsBeamformerSupported.hashCode();
        result2 = 31 * result2 + this.csiNumBeamformerAntennasSupported.hashCode();
        result2 = 31 * result2 + (this.dsssCckModeIn40MhzSupported ? 1231 : 1237);
        result2 = 31 * result2 + this.explicitCompressedBeamformingFeedbackCapability.hashCode();
        result2 = 31 * result2 + (this.explicitCompressedSteeringSupported ? 1231 : 1237);
        result2 = 31 * result2 + (this.explicitCsiFeedbackBasedTxAselSupported ? 1231 : 1237);
        result2 = 31 * result2 + (this.explicitCsiFeedbackSupported ? 1231 : 1237);
        result2 = 31 * result2 + (this.explicitCsiTxBeamformingSupported ? 1231 : 1237);
        result2 = 31 * result2 + this.explicitNoncompressedBeamformingFeedbackCapability.hashCode();
        result2 = 31 * result2 + (this.explicitNoncompressedSteeringSupported ? 1231 : 1237);
        result2 = 31 * result2 + this.explicitTxBeamformingCsiFeedbackCapability.hashCode();
        result2 = 31 * result2 + (this.fortyMhzIntolerant ? 1231 : 1237);
        result2 = 31 * result2 + (this.htControlFieldSupported ? 1231 : 1237);
        result2 = 31 * result2 + (this.htDelayedBlockAckSupported ? 1231 : 1237);
        result2 = 31 * result2 + (this.htGreenfieldSupported ? 1231 : 1237);
        result2 = 31 * result2 + (this.implicitTxBeamformingReceivingSupported ? 1231 : 1237);
        result2 = 31 * result2 + (this.implicitTxBeamformingSupported ? 1231 : 1237);
        result2 = 31 * result2 + (this.lSigTxopProtectionSupported ? 1231 : 1237);
        result2 = 31 * result2 + (this.ldpcCodingSupported ? 1231 : 1237);
        result2 = 31 * result2 + this.maxAMpduLength.hashCode();
        result2 = 31 * result2 + this.maxAMsduLength.hashCode();
        result2 = 31 * result2 + this.mcsFeedbackCapability.hashCode();
        result2 = 31 * result2 + this.minGrouping.hashCode();
        result2 = 31 * result2 + this.minMpduStartSpacing.hashCode();
        result2 = 31 * result2 + this.noncompressedSteeringNumBeamformerAntennasSupported.hashCode();
        result2 = 31 * result2 + (this.pcoSupported ? 1231 : 1237);
        result2 = 31 * result2 + this.pcoTransitionTime.hashCode();
        result2 = 31 * result2 + (this.rdResponderSupported ? 1231 : 1237);
        result2 = 31 * result2 + (this.rxAselSupported ? 1231 : 1237);
        result2 = 31 * result2 + this.rxHighestSupportedDataRate;
        result2 = 31 * result2 + (this.rxNdpSupported ? 1231 : 1237);
        result2 = 31 * result2 + (this.rxStaggeredSoundingSupported ? 1231 : 1237);
        result2 = 31 * result2 + this.rxStbcSupport.hashCode();
        result2 = 31 * result2 + (this.shortGiFor20MhzSupported ? 1231 : 1237);
        result2 = 31 * result2 + (this.shortGiFor40MhzSupported ? 1231 : 1237);
        result2 = 31 * result2 + this.smPowerSaveMode.hashCode();
        result2 = 31 * result2 + Arrays.hashCode(this.supportedRxMcsIndexes);
        result2 = 31 * result2 + this.txMaxNumSpatialStreamsSupported.hashCode();
        result2 = 31 * result2 + (this.txMcsSetDefined ? 1231 : 1237);
        result2 = 31 * result2 + (this.txNdpSupported ? 1231 : 1237);
        result2 = 31 * result2 + (this.txRxMcsSetNotEqual ? 1231 : 1237);
        result2 = 31 * result2 + (this.txSoundingPpdusSupported ? 1231 : 1237);
        result2 = 31 * result2 + (this.txStaggeredSoundingSupported ? 1231 : 1237);
        result2 = 31 * result2 + (this.txStbcSupported ? 1231 : 1237);
        result2 = 31 * result2 + (this.txUnequalModulationSupported ? 1231 : 1237);
        return result2;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Dot11HTCapabilitiesElement other = (Dot11HTCapabilitiesElement)obj;
        if (this.antennaIndicesFeedbackBasedTxAselSupported != other.antennaIndicesFeedbackBasedTxAselSupported) {
            return false;
        }
        if (this.antennaIndicesFeedbackSupported != other.antennaIndicesFeedbackSupported) {
            return false;
        }
        if (this.antennaSelectionSupported != other.antennaSelectionSupported) {
            return false;
        }
        if (this.bit101OfSupportedMcsSet != other.bit101OfSupportedMcsSet) {
            return false;
        }
        if (this.bit102OfSupportedMcsSet != other.bit102OfSupportedMcsSet) {
            return false;
        }
        if (this.bit103OfSupportedMcsSet != other.bit103OfSupportedMcsSet) {
            return false;
        }
        if (this.bit104OfSupportedMcsSet != other.bit104OfSupportedMcsSet) {
            return false;
        }
        if (this.bit105OfSupportedMcsSet != other.bit105OfSupportedMcsSet) {
            return false;
        }
        if (this.bit106OfSupportedMcsSet != other.bit106OfSupportedMcsSet) {
            return false;
        }
        if (this.bit107OfSupportedMcsSet != other.bit107OfSupportedMcsSet) {
            return false;
        }
        if (this.bit108OfSupportedMcsSet != other.bit108OfSupportedMcsSet) {
            return false;
        }
        if (this.bit109OfSupportedMcsSet != other.bit109OfSupportedMcsSet) {
            return false;
        }
        if (this.bit110OfSupportedMcsSet != other.bit110OfSupportedMcsSet) {
            return false;
        }
        if (this.bit111OfSupportedMcsSet != other.bit111OfSupportedMcsSet) {
            return false;
        }
        if (this.bit112OfSupportedMcsSet != other.bit112OfSupportedMcsSet) {
            return false;
        }
        if (this.bit113OfSupportedMcsSet != other.bit113OfSupportedMcsSet) {
            return false;
        }
        if (this.bit114OfSupportedMcsSet != other.bit114OfSupportedMcsSet) {
            return false;
        }
        if (this.bit115OfSupportedMcsSet != other.bit115OfSupportedMcsSet) {
            return false;
        }
        if (this.bit116OfSupportedMcsSet != other.bit116OfSupportedMcsSet) {
            return false;
        }
        if (this.bit117OfSupportedMcsSet != other.bit117OfSupportedMcsSet) {
            return false;
        }
        if (this.bit118OfSupportedMcsSet != other.bit118OfSupportedMcsSet) {
            return false;
        }
        if (this.bit119OfSupportedMcsSet != other.bit119OfSupportedMcsSet) {
            return false;
        }
        if (this.bit120OfSupportedMcsSet != other.bit120OfSupportedMcsSet) {
            return false;
        }
        if (this.bit121OfSupportedMcsSet != other.bit121OfSupportedMcsSet) {
            return false;
        }
        if (this.bit122OfSupportedMcsSet != other.bit122OfSupportedMcsSet) {
            return false;
        }
        if (this.bit123OfSupportedMcsSet != other.bit123OfSupportedMcsSet) {
            return false;
        }
        if (this.bit124OfSupportedMcsSet != other.bit124OfSupportedMcsSet) {
            return false;
        }
        if (this.bit125OfSupportedMcsSet != other.bit125OfSupportedMcsSet) {
            return false;
        }
        if (this.bit126OfSupportedMcsSet != other.bit126OfSupportedMcsSet) {
            return false;
        }
        if (this.bit127OfSupportedMcsSet != other.bit127OfSupportedMcsSet) {
            return false;
        }
        if (this.bit12OfHtExtendedCapabilities != other.bit12OfHtExtendedCapabilities) {
            return false;
        }
        if (this.bit13OfHtCapabilitiesInfo != other.bit13OfHtCapabilitiesInfo) {
            return false;
        }
        if (this.bit13OfHtExtendedCapabilities != other.bit13OfHtExtendedCapabilities) {
            return false;
        }
        if (this.bit14OfHtExtendedCapabilities != other.bit14OfHtExtendedCapabilities) {
            return false;
        }
        if (this.bit15OfHtExtendedCapabilities != other.bit15OfHtExtendedCapabilities) {
            return false;
        }
        if (this.bit29OfTransmitBeamformingCapabilities != other.bit29OfTransmitBeamformingCapabilities) {
            return false;
        }
        if (this.bit30OfTransmitBeamformingCapabilities != other.bit30OfTransmitBeamformingCapabilities) {
            return false;
        }
        if (this.bit31OfTransmitBeamformingCapabilities != other.bit31OfTransmitBeamformingCapabilities) {
            return false;
        }
        if (this.bit3OfHtExtendedCapabilities != other.bit3OfHtExtendedCapabilities) {
            return false;
        }
        if (this.bit4OfHtExtendedCapabilities != other.bit4OfHtExtendedCapabilities) {
            return false;
        }
        if (this.bit5OfAMpduParameters != other.bit5OfAMpduParameters) {
            return false;
        }
        if (this.bit5OfHtExtendedCapabilities != other.bit5OfHtExtendedCapabilities) {
            return false;
        }
        if (this.bit6OfAMpduParameters != other.bit6OfAMpduParameters) {
            return false;
        }
        if (this.bit6OfHtExtendedCapabilities != other.bit6OfHtExtendedCapabilities) {
            return false;
        }
        if (this.bit77OfSupportedMcsSet != other.bit77OfSupportedMcsSet) {
            return false;
        }
        if (this.bit78OfSupportedMcsSet != other.bit78OfSupportedMcsSet) {
            return false;
        }
        if (this.bit79OfSupportedMcsSet != other.bit79OfSupportedMcsSet) {
            return false;
        }
        if (this.bit7OfAMpduParameters != other.bit7OfAMpduParameters) {
            return false;
        }
        if (this.bit7OfAselCapability != other.bit7OfAselCapability) {
            return false;
        }
        if (this.bit7OfHtExtendedCapabilities != other.bit7OfHtExtendedCapabilities) {
            return false;
        }
        if (this.bit90OfSupportedMcsSet != other.bit90OfSupportedMcsSet) {
            return false;
        }
        if (this.bit91OfSupportedMcsSet != other.bit91OfSupportedMcsSet) {
            return false;
        }
        if (this.bit92OfSupportedMcsSet != other.bit92OfSupportedMcsSet) {
            return false;
        }
        if (this.bit93OfSupportedMcsSet != other.bit93OfSupportedMcsSet) {
            return false;
        }
        if (this.bit94OfSupportedMcsSet != other.bit94OfSupportedMcsSet) {
            return false;
        }
        if (this.bit95OfSupportedMcsSet != other.bit95OfSupportedMcsSet) {
            return false;
        }
        if (this.both20and40MhzSupported != other.both20and40MhzSupported) {
            return false;
        }
        if (this.calibration != other.calibration) {
            return false;
        }
        if (this.channelEstimationCapability != other.channelEstimationCapability) {
            return false;
        }
        if (this.compressedSteeringNumBeamformerAntennasSupported != other.compressedSteeringNumBeamformerAntennasSupported) {
            return false;
        }
        if (this.csiMaxNumRowsBeamformerSupported != other.csiMaxNumRowsBeamformerSupported) {
            return false;
        }
        if (this.csiNumBeamformerAntennasSupported != other.csiNumBeamformerAntennasSupported) {
            return false;
        }
        if (this.dsssCckModeIn40MhzSupported != other.dsssCckModeIn40MhzSupported) {
            return false;
        }
        if (this.explicitCompressedBeamformingFeedbackCapability != other.explicitCompressedBeamformingFeedbackCapability) {
            return false;
        }
        if (this.explicitCompressedSteeringSupported != other.explicitCompressedSteeringSupported) {
            return false;
        }
        if (this.explicitCsiFeedbackBasedTxAselSupported != other.explicitCsiFeedbackBasedTxAselSupported) {
            return false;
        }
        if (this.explicitCsiFeedbackSupported != other.explicitCsiFeedbackSupported) {
            return false;
        }
        if (this.explicitCsiTxBeamformingSupported != other.explicitCsiTxBeamformingSupported) {
            return false;
        }
        if (this.explicitNoncompressedBeamformingFeedbackCapability != other.explicitNoncompressedBeamformingFeedbackCapability) {
            return false;
        }
        if (this.explicitNoncompressedSteeringSupported != other.explicitNoncompressedSteeringSupported) {
            return false;
        }
        if (this.explicitTxBeamformingCsiFeedbackCapability != other.explicitTxBeamformingCsiFeedbackCapability) {
            return false;
        }
        if (this.fortyMhzIntolerant != other.fortyMhzIntolerant) {
            return false;
        }
        if (this.htControlFieldSupported != other.htControlFieldSupported) {
            return false;
        }
        if (this.htDelayedBlockAckSupported != other.htDelayedBlockAckSupported) {
            return false;
        }
        if (this.htGreenfieldSupported != other.htGreenfieldSupported) {
            return false;
        }
        if (this.implicitTxBeamformingReceivingSupported != other.implicitTxBeamformingReceivingSupported) {
            return false;
        }
        if (this.implicitTxBeamformingSupported != other.implicitTxBeamformingSupported) {
            return false;
        }
        if (this.lSigTxopProtectionSupported != other.lSigTxopProtectionSupported) {
            return false;
        }
        if (this.ldpcCodingSupported != other.ldpcCodingSupported) {
            return false;
        }
        if (this.maxAMpduLength != other.maxAMpduLength) {
            return false;
        }
        if (this.maxAMsduLength != other.maxAMsduLength) {
            return false;
        }
        if (this.mcsFeedbackCapability != other.mcsFeedbackCapability) {
            return false;
        }
        if (this.minGrouping != other.minGrouping) {
            return false;
        }
        if (this.minMpduStartSpacing != other.minMpduStartSpacing) {
            return false;
        }
        if (this.noncompressedSteeringNumBeamformerAntennasSupported != other.noncompressedSteeringNumBeamformerAntennasSupported) {
            return false;
        }
        if (this.pcoSupported != other.pcoSupported) {
            return false;
        }
        if (this.pcoTransitionTime != other.pcoTransitionTime) {
            return false;
        }
        if (this.rdResponderSupported != other.rdResponderSupported) {
            return false;
        }
        if (this.rxAselSupported != other.rxAselSupported) {
            return false;
        }
        if (this.rxHighestSupportedDataRate != other.rxHighestSupportedDataRate) {
            return false;
        }
        if (this.rxNdpSupported != other.rxNdpSupported) {
            return false;
        }
        if (this.rxStaggeredSoundingSupported != other.rxStaggeredSoundingSupported) {
            return false;
        }
        if (this.rxStbcSupport != other.rxStbcSupport) {
            return false;
        }
        if (this.shortGiFor20MhzSupported != other.shortGiFor20MhzSupported) {
            return false;
        }
        if (this.shortGiFor40MhzSupported != other.shortGiFor40MhzSupported) {
            return false;
        }
        if (this.smPowerSaveMode != other.smPowerSaveMode) {
            return false;
        }
        if (!Arrays.equals(this.supportedRxMcsIndexes, other.supportedRxMcsIndexes)) {
            return false;
        }
        if (this.txMaxNumSpatialStreamsSupported != other.txMaxNumSpatialStreamsSupported) {
            return false;
        }
        if (this.txMcsSetDefined != other.txMcsSetDefined) {
            return false;
        }
        if (this.txNdpSupported != other.txNdpSupported) {
            return false;
        }
        if (this.txRxMcsSetNotEqual != other.txRxMcsSetNotEqual) {
            return false;
        }
        if (this.txSoundingPpdusSupported != other.txSoundingPpdusSupported) {
            return false;
        }
        if (this.txStaggeredSoundingSupported != other.txStaggeredSoundingSupported) {
            return false;
        }
        if (this.txStbcSupported != other.txStbcSupported) {
            return false;
        }
        return this.txUnequalModulationSupported == other.txUnequalModulationSupported;
    }

    public String toString() {
        return this.toString("");
    }

    public String toString(String indent) {
        StringBuilder sb = new StringBuilder();
        String ls = System.getProperty("line.separator");
        sb.append(indent).append("HT Capabilities:").append(ls);
        sb.append(indent).append("  Element ID: ").append(this.getElementId()).append(ls);
        sb.append(indent).append("  Length: ").append(this.getLengthAsInt()).append(" bytes").append(ls);
        sb.append(indent).append("  HT Capabilities Info:").append(ls).append(indent).append("    LDPC Coding is Supported: ").append(this.ldpcCodingSupported).append(ls).append(indent).append("    Supported Channel Width Set: ").append(this.both20and40MhzSupported ? "20 MHz and 40 MHz" : "20 MHz").append(ls).append(indent).append("    SM Power Save: ").append((Object)this.smPowerSaveMode).append(ls).append(indent).append("    HT-Greenfield is Supported: ").append(this.htGreenfieldSupported).append(ls).append(indent).append("    Short GI for 20 MHz is Supported: ").append(this.shortGiFor20MhzSupported).append(ls).append(indent).append("    Short GI for 40 MHz is Supported: ").append(this.shortGiFor40MhzSupported).append(ls).append(indent).append("    Tx STBC is Supported: ").append(this.txStbcSupported).append(ls).append(indent).append("    Rx STBC Support: ").append((Object)this.rxStbcSupport).append(ls).append(indent).append("    HT-Delayed Block Ack is Supported: ").append(this.htDelayedBlockAckSupported).append(ls).append(indent).append("    Max A-MSDU Length: ").append((Object)this.maxAMsduLength).append(" octets").append(ls).append(indent).append("    DSSS/CCK Mode in 40 MHz is Supported: ").append(this.dsssCckModeIn40MhzSupported).append(ls).append(indent).append("    Bit 13: ").append(this.bit13OfHtCapabilitiesInfo).append(ls).append(indent).append("    40 MHz is Intolerant: ").append(this.fortyMhzIntolerant).append(ls).append(indent).append("    L-SIG TXOP Protection is Supported: ").append(this.lSigTxopProtectionSupported).append(ls);
        sb.append(indent).append("  A-MPDU Parameters:").append(ls).append(indent).append("    Max A-MPDU Length: ").append((Object)this.maxAMpduLength).append(" octets").append(ls).append(indent).append("    Min MPDU Start Spacing: ").append((Object)this.minMpduStartSpacing).append(ls).append(indent).append("    Bit 5: ").append(this.bit5OfAMpduParameters).append(ls).append(indent).append("    Bit 6: ").append(this.bit6OfAMpduParameters).append(ls).append(indent).append("    Bit 7: ").append(this.bit7OfAMpduParameters).append(ls);
        sb.append(indent).append("  Supported MCS Set:").append(ls).append(indent).append("    Supported Rx MCS Indexes: ");
        boolean firstMcsIdx = true;
        for (int i2 = 0; i2 < this.supportedRxMcsIndexes.length; ++i2) {
            if (!this.supportedRxMcsIndexes[i2]) continue;
            if (!firstMcsIdx) {
                sb.append(", ");
            } else {
                firstMcsIdx = false;
            }
            sb.append(i2);
        }
        sb.append(ls).append(indent).append("    Bit 77: ").append(this.bit77OfSupportedMcsSet).append(ls).append(indent).append("    Bit 78: ").append(this.bit78OfSupportedMcsSet).append(ls).append(indent).append("    Bit 79: ").append(this.bit79OfSupportedMcsSet).append(ls).append(indent).append("    Rx Highest Supported Data Rate: ").append(this.rxHighestSupportedDataRate).append(" Mb/s").append(ls).append(indent).append("    Bit 90: ").append(this.bit90OfSupportedMcsSet).append(ls).append(indent).append("    Bit 91: ").append(this.bit91OfSupportedMcsSet).append(ls).append(indent).append("    Bit 92: ").append(this.bit92OfSupportedMcsSet).append(ls).append(indent).append("    Bit 93: ").append(this.bit93OfSupportedMcsSet).append(ls).append(indent).append("    Bit 94: ").append(this.bit94OfSupportedMcsSet).append(ls).append(indent).append("    Bit 95: ").append(this.bit95OfSupportedMcsSet).append(ls).append(indent).append("    Tx MCS Set is Defined: ").append(this.txMcsSetDefined).append(ls).append(indent).append("    Tx Rx MCS Set Not Equal: ").append(this.txRxMcsSetNotEqual).append(ls).append(indent).append("    Tx Max Number Spatial Streams Supported: ").append((Object)this.txMaxNumSpatialStreamsSupported).append(ls).append(indent).append("    Tx Unequal Modulation is Supported: ").append(this.txUnequalModulationSupported).append(ls).append(indent).append("    Bit 101: ").append(this.bit101OfSupportedMcsSet).append(ls).append(indent).append("    Bit 102: ").append(this.bit102OfSupportedMcsSet).append(ls).append(indent).append("    Bit 103: ").append(this.bit103OfSupportedMcsSet).append(ls).append(indent).append("    Bit 104: ").append(this.bit104OfSupportedMcsSet).append(ls).append(indent).append("    Bit 105: ").append(this.bit105OfSupportedMcsSet).append(ls).append(indent).append("    Bit 106: ").append(this.bit106OfSupportedMcsSet).append(ls).append(indent).append("    Bit 107: ").append(this.bit107OfSupportedMcsSet).append(ls).append(indent).append("    Bit 108: ").append(this.bit108OfSupportedMcsSet).append(ls).append(indent).append("    Bit 109: ").append(this.bit109OfSupportedMcsSet).append(ls).append(indent).append("    Bit 110: ").append(this.bit110OfSupportedMcsSet).append(ls).append(indent).append("    Bit 111: ").append(this.bit111OfSupportedMcsSet).append(ls).append(indent).append("    Bit 112: ").append(this.bit112OfSupportedMcsSet).append(ls).append(indent).append("    Bit 113: ").append(this.bit113OfSupportedMcsSet).append(ls).append(indent).append("    Bit 114: ").append(this.bit114OfSupportedMcsSet).append(ls).append(indent).append("    Bit 115: ").append(this.bit115OfSupportedMcsSet).append(ls).append(indent).append("    Bit 116: ").append(this.bit116OfSupportedMcsSet).append(ls).append(indent).append("    Bit 117: ").append(this.bit117OfSupportedMcsSet).append(ls).append(indent).append("    Bit 118: ").append(this.bit118OfSupportedMcsSet).append(ls).append(indent).append("    Bit 119: ").append(this.bit119OfSupportedMcsSet).append(ls).append(indent).append("    Bit 120: ").append(this.bit120OfSupportedMcsSet).append(ls).append(indent).append("    Bit 121: ").append(this.bit121OfSupportedMcsSet).append(ls).append(indent).append("    Bit 122: ").append(this.bit122OfSupportedMcsSet).append(ls).append(indent).append("    Bit 123: ").append(this.bit123OfSupportedMcsSet).append(ls).append(indent).append("    Bit 124: ").append(this.bit124OfSupportedMcsSet).append(ls).append(indent).append("    Bit 125: ").append(this.bit125OfSupportedMcsSet).append(ls).append(indent).append("    Bit 126: ").append(this.bit126OfSupportedMcsSet).append(ls).append(indent).append("    Bit 127: ").append(this.bit127OfSupportedMcsSet).append(ls);
        sb.append(indent).append("  HT Extended Capabilities:").append(ls).append(indent).append("    PCO is Supported: ").append(this.pcoSupported).append(ls).append(indent).append("    PCO Transition Time: ").append((Object)this.pcoTransitionTime).append(ls).append(indent).append("    Bit 3: ").append(this.bit3OfHtExtendedCapabilities).append(ls).append(indent).append("    Bit 4: ").append(this.bit4OfHtExtendedCapabilities).append(ls).append(indent).append("    Bit 5: ").append(this.bit5OfHtExtendedCapabilities).append(ls).append(indent).append("    Bit 6: ").append(this.bit6OfHtExtendedCapabilities).append(ls).append(indent).append("    Bit 7: ").append(this.bit7OfHtExtendedCapabilities).append(ls).append(indent).append("    MCS Feedback: ").append((Object)this.mcsFeedbackCapability).append(ls).append(indent).append("    HT Control Field is Support: ").append(this.htControlFieldSupported).append(ls).append(indent).append("    RD Responder is Supported: ").append(this.rdResponderSupported).append(ls).append(indent).append("    Bit 12: ").append(this.bit12OfHtExtendedCapabilities).append(ls).append(indent).append("    Bit 13: ").append(this.bit13OfHtExtendedCapabilities).append(ls).append(indent).append("    Bit 14: ").append(this.bit14OfHtExtendedCapabilities).append(ls).append(indent).append("    Bit 15: ").append(this.bit15OfHtExtendedCapabilities).append(ls);
        sb.append(indent).append("  Transmit Beamforming Capabilities:").append(ls).append(indent).append("    Implicit Tx Beamforming Receiving is Supported: ").append(this.implicitTxBeamformingReceivingSupported).append(ls).append(indent).append("    Rx Staggered Sounding is Supported: ").append(this.rxStaggeredSoundingSupported).append(ls).append(indent).append("    Tx Staggered Sounding is Supported: ").append(this.txStaggeredSoundingSupported).append(ls).append(indent).append("    Rx NDP is Supported: ").append(this.rxNdpSupported).append(ls).append(indent).append("    Tx NDP is Supported: ").append(this.txNdpSupported).append(ls).append(indent).append("    Implicit Tx Beamforming is Supported: ").append(this.implicitTxBeamformingSupported).append(ls).append(indent).append("    Calibration: ").append((Object)this.calibration).append(ls).append(indent).append("    Explicit CSI Tx Beamforming is Supported: ").append(this.explicitCsiTxBeamformingSupported).append(ls).append(indent).append("    Explicit Noncompressed Steering is Supported: ").append(this.explicitNoncompressedSteeringSupported).append(ls).append(indent).append("    Explicit Compressed Steering is Supported: ").append(this.explicitCompressedSteeringSupported).append(ls).append(indent).append("    Explicit Tx Beamforming CSI Feedback: ").append((Object)this.explicitTxBeamformingCsiFeedbackCapability).append(ls).append(indent).append("    Explicit Noncompressed Beamforming Feedback: ").append((Object)this.explicitNoncompressedBeamformingFeedbackCapability).append(ls).append(indent).append("    Explicit Compressed Beamforming Feedback: ").append((Object)this.explicitCompressedBeamformingFeedbackCapability).append(ls).append(indent).append("    Min Grouping: ").append((Object)this.minGrouping).append(ls).append(indent).append("    CSI Number of Beamformer Antennas Supported: ").append((Object)this.csiNumBeamformerAntennasSupported).append(ls).append(indent).append("    Noncompressed Steering Number of Beamformer Antennas Supported: ").append((Object)this.noncompressedSteeringNumBeamformerAntennasSupported).append(ls).append(indent).append("    Compressed Steering Number of Beamformer Antennas Supported: ").append((Object)this.compressedSteeringNumBeamformerAntennasSupported).append(ls).append(indent).append("    CSI Max Number of Rows Beamformer Supported: ").append((Object)this.csiMaxNumRowsBeamformerSupported).append(ls).append(indent).append("    Channel Estimation: ").append((Object)this.channelEstimationCapability).append(ls).append(indent).append("    Bit 29: ").append(this.bit29OfTransmitBeamformingCapabilities).append(ls).append(indent).append("    Bit 30: ").append(this.bit30OfTransmitBeamformingCapabilities).append(ls).append(indent).append("    Bit 31: ").append(this.bit31OfTransmitBeamformingCapabilities).append(ls);
        sb.append(indent).append("  ASEL Capabilities:").append(ls).append(indent).append("    Antenna Selection is Supported: ").append(this.antennaSelectionSupported).append(ls).append(indent).append("    Explicit CSI Feedback Based Tx ASEL is Supported: ").append(this.explicitCsiFeedbackBasedTxAselSupported).append(ls).append(indent).append("    Antenna Indices Feedback Based Tx ASEL is Supported: ").append(this.antennaIndicesFeedbackBasedTxAselSupported).append(ls).append(indent).append("    Explicit CSI Feedback is Supported: ").append(this.explicitCsiFeedbackSupported).append(ls).append(indent).append("    Antenna Indices Feedback is Supported: ").append(this.antennaIndicesFeedbackSupported).append(ls).append(indent).append("    Rx ASEL is Supported: ").append(this.rxAselSupported).append(ls).append(indent).append("    Tx Sounding PPDUs is Supported: ").append(this.txSoundingPpdusSupported).append(ls).append(indent).append("    Bit 7: ").append(this.bit7OfAselCapability).append(ls);
        return sb.toString();
    }

    public static final class Builder
    extends Dot11InformationElement.Builder {
        private boolean ldpcCodingSupported;
        private boolean both20and40MhzSupported;
        private SmPowerSaveMode smPowerSaveMode;
        private boolean htGreenfieldSupported;
        private boolean shortGiFor20MhzSupported;
        private boolean shortGiFor40MhzSupported;
        private boolean txStbcSupported;
        private StbcSupport rxStbcSupport;
        private boolean htDelayedBlockAckSupported;
        private AMsduLength maxAMsduLength;
        private boolean dsssCckModeIn40MhzSupported;
        private boolean bit13OfHtCapabilitiesInfo;
        private boolean fortyMhzIntolerant;
        private boolean lSigTxopProtectionSupported;
        private AMpduLength maxAMpduLength;
        private MpduStartSpacing minMpduStartSpacing;
        private boolean bit5OfAMpduParameters;
        private boolean bit6OfAMpduParameters;
        private boolean bit7OfAMpduParameters;
        private boolean[] supportedRxMcsIndexes;
        private boolean bit77OfSupportedMcsSet;
        private boolean bit78OfSupportedMcsSet;
        private boolean bit79OfSupportedMcsSet;
        private short rxHighestSupportedDataRate;
        private boolean bit90OfSupportedMcsSet;
        private boolean bit91OfSupportedMcsSet;
        private boolean bit92OfSupportedMcsSet;
        private boolean bit93OfSupportedMcsSet;
        private boolean bit94OfSupportedMcsSet;
        private boolean bit95OfSupportedMcsSet;
        private boolean txMcsSetDefined;
        private boolean txRxMcsSetNotEqual;
        private NumSpatialStreams txMaxNumSpatialStreamsSupported;
        private boolean txUnequalModulationSupported;
        private boolean bit101OfSupportedMcsSet;
        private boolean bit102OfSupportedMcsSet;
        private boolean bit103OfSupportedMcsSet;
        private boolean bit104OfSupportedMcsSet;
        private boolean bit105OfSupportedMcsSet;
        private boolean bit106OfSupportedMcsSet;
        private boolean bit107OfSupportedMcsSet;
        private boolean bit108OfSupportedMcsSet;
        private boolean bit109OfSupportedMcsSet;
        private boolean bit110OfSupportedMcsSet;
        private boolean bit111OfSupportedMcsSet;
        private boolean bit112OfSupportedMcsSet;
        private boolean bit113OfSupportedMcsSet;
        private boolean bit114OfSupportedMcsSet;
        private boolean bit115OfSupportedMcsSet;
        private boolean bit116OfSupportedMcsSet;
        private boolean bit117OfSupportedMcsSet;
        private boolean bit118OfSupportedMcsSet;
        private boolean bit119OfSupportedMcsSet;
        private boolean bit120OfSupportedMcsSet;
        private boolean bit121OfSupportedMcsSet;
        private boolean bit122OfSupportedMcsSet;
        private boolean bit123OfSupportedMcsSet;
        private boolean bit124OfSupportedMcsSet;
        private boolean bit125OfSupportedMcsSet;
        private boolean bit126OfSupportedMcsSet;
        private boolean bit127OfSupportedMcsSet;
        private boolean pcoSupported;
        private PcoTransitionTime pcoTransitionTime;
        private boolean bit3OfHtExtendedCapabilities;
        private boolean bit4OfHtExtendedCapabilities;
        private boolean bit5OfHtExtendedCapabilities;
        private boolean bit6OfHtExtendedCapabilities;
        private boolean bit7OfHtExtendedCapabilities;
        private McsFeedbackCapability mcsFeedbackCapability;
        private boolean htControlFieldSupported;
        private boolean rdResponderSupported;
        private boolean bit12OfHtExtendedCapabilities;
        private boolean bit13OfHtExtendedCapabilities;
        private boolean bit14OfHtExtendedCapabilities;
        private boolean bit15OfHtExtendedCapabilities;
        private boolean implicitTxBeamformingReceivingSupported;
        private boolean rxStaggeredSoundingSupported;
        private boolean txStaggeredSoundingSupported;
        private boolean rxNdpSupported;
        private boolean txNdpSupported;
        private boolean implicitTxBeamformingSupported;
        private Calibration calibration;
        private boolean explicitCsiTxBeamformingSupported;
        private boolean explicitNoncompressedSteeringSupported;
        private boolean explicitCompressedSteeringSupported;
        private BeamformingFeedbackCapability explicitTxBeamformingCsiFeedbackCapability;
        private BeamformingFeedbackCapability explicitNoncompressedBeamformingFeedbackCapability;
        private BeamformingFeedbackCapability explicitCompressedBeamformingFeedbackCapability;
        private Grouping minGrouping;
        private NumBeamformerAntennas csiNumBeamformerAntennasSupported;
        private NumBeamformerAntennas noncompressedSteeringNumBeamformerAntennasSupported;
        private NumBeamformerAntennas compressedSteeringNumBeamformerAntennasSupported;
        private CsiNumRows csiMaxNumRowsBeamformerSupported;
        private ChannelEstimationCapability channelEstimationCapability;
        private boolean bit29OfTransmitBeamformingCapabilities;
        private boolean bit30OfTransmitBeamformingCapabilities;
        private boolean bit31OfTransmitBeamformingCapabilities;
        private boolean antennaSelectionSupported;
        private boolean explicitCsiFeedbackBasedTxAselSupported;
        private boolean antennaIndicesFeedbackBasedTxAselSupported;
        private boolean explicitCsiFeedbackSupported;
        private boolean antennaIndicesFeedbackSupported;
        private boolean rxAselSupported;
        private boolean txSoundingPpdusSupported;
        private boolean bit7OfAselCapability;

        public Builder() {
            this.elementId(Dot11InformationElementId.getInstance((Byte)Dot11InformationElementId.HT_CAPABILITIES.value()));
        }

        private Builder(Dot11HTCapabilitiesElement obj) {
            super(obj);
            this.ldpcCodingSupported = obj.ldpcCodingSupported;
            this.both20and40MhzSupported = obj.both20and40MhzSupported;
            this.smPowerSaveMode = obj.smPowerSaveMode;
            this.htGreenfieldSupported = obj.htGreenfieldSupported;
            this.shortGiFor20MhzSupported = obj.shortGiFor20MhzSupported;
            this.shortGiFor40MhzSupported = obj.shortGiFor40MhzSupported;
            this.txStbcSupported = obj.txStbcSupported;
            this.rxStbcSupport = obj.rxStbcSupport;
            this.htDelayedBlockAckSupported = obj.htDelayedBlockAckSupported;
            this.maxAMsduLength = obj.maxAMsduLength;
            this.dsssCckModeIn40MhzSupported = obj.dsssCckModeIn40MhzSupported;
            this.bit13OfHtCapabilitiesInfo = obj.bit13OfHtCapabilitiesInfo;
            this.fortyMhzIntolerant = obj.fortyMhzIntolerant;
            this.lSigTxopProtectionSupported = obj.lSigTxopProtectionSupported;
            this.maxAMpduLength = obj.maxAMpduLength;
            this.minMpduStartSpacing = obj.minMpduStartSpacing;
            this.bit5OfAMpduParameters = obj.bit5OfAMpduParameters;
            this.bit6OfAMpduParameters = obj.bit6OfAMpduParameters;
            this.bit7OfAMpduParameters = obj.bit7OfAMpduParameters;
            this.supportedRxMcsIndexes = obj.supportedRxMcsIndexes;
            this.bit77OfSupportedMcsSet = obj.bit77OfSupportedMcsSet;
            this.bit78OfSupportedMcsSet = obj.bit78OfSupportedMcsSet;
            this.bit79OfSupportedMcsSet = obj.bit79OfSupportedMcsSet;
            this.rxHighestSupportedDataRate = obj.rxHighestSupportedDataRate;
            this.bit90OfSupportedMcsSet = obj.bit90OfSupportedMcsSet;
            this.bit91OfSupportedMcsSet = obj.bit91OfSupportedMcsSet;
            this.bit92OfSupportedMcsSet = obj.bit92OfSupportedMcsSet;
            this.bit93OfSupportedMcsSet = obj.bit93OfSupportedMcsSet;
            this.bit94OfSupportedMcsSet = obj.bit94OfSupportedMcsSet;
            this.bit95OfSupportedMcsSet = obj.bit95OfSupportedMcsSet;
            this.txMcsSetDefined = obj.txMcsSetDefined;
            this.txRxMcsSetNotEqual = obj.txRxMcsSetNotEqual;
            this.txMaxNumSpatialStreamsSupported = obj.txMaxNumSpatialStreamsSupported;
            this.txUnequalModulationSupported = obj.txUnequalModulationSupported;
            this.bit101OfSupportedMcsSet = obj.bit101OfSupportedMcsSet;
            this.bit102OfSupportedMcsSet = obj.bit102OfSupportedMcsSet;
            this.bit103OfSupportedMcsSet = obj.bit103OfSupportedMcsSet;
            this.bit104OfSupportedMcsSet = obj.bit104OfSupportedMcsSet;
            this.bit105OfSupportedMcsSet = obj.bit105OfSupportedMcsSet;
            this.bit106OfSupportedMcsSet = obj.bit106OfSupportedMcsSet;
            this.bit107OfSupportedMcsSet = obj.bit107OfSupportedMcsSet;
            this.bit108OfSupportedMcsSet = obj.bit108OfSupportedMcsSet;
            this.bit109OfSupportedMcsSet = obj.bit109OfSupportedMcsSet;
            this.bit110OfSupportedMcsSet = obj.bit110OfSupportedMcsSet;
            this.bit111OfSupportedMcsSet = obj.bit111OfSupportedMcsSet;
            this.bit112OfSupportedMcsSet = obj.bit112OfSupportedMcsSet;
            this.bit113OfSupportedMcsSet = obj.bit113OfSupportedMcsSet;
            this.bit114OfSupportedMcsSet = obj.bit114OfSupportedMcsSet;
            this.bit115OfSupportedMcsSet = obj.bit115OfSupportedMcsSet;
            this.bit116OfSupportedMcsSet = obj.bit116OfSupportedMcsSet;
            this.bit117OfSupportedMcsSet = obj.bit117OfSupportedMcsSet;
            this.bit118OfSupportedMcsSet = obj.bit118OfSupportedMcsSet;
            this.bit119OfSupportedMcsSet = obj.bit119OfSupportedMcsSet;
            this.bit120OfSupportedMcsSet = obj.bit120OfSupportedMcsSet;
            this.bit121OfSupportedMcsSet = obj.bit121OfSupportedMcsSet;
            this.bit122OfSupportedMcsSet = obj.bit122OfSupportedMcsSet;
            this.bit123OfSupportedMcsSet = obj.bit123OfSupportedMcsSet;
            this.bit124OfSupportedMcsSet = obj.bit124OfSupportedMcsSet;
            this.bit125OfSupportedMcsSet = obj.bit125OfSupportedMcsSet;
            this.bit126OfSupportedMcsSet = obj.bit126OfSupportedMcsSet;
            this.bit127OfSupportedMcsSet = obj.bit127OfSupportedMcsSet;
            this.pcoSupported = obj.pcoSupported;
            this.pcoTransitionTime = obj.pcoTransitionTime;
            this.bit3OfHtExtendedCapabilities = obj.bit3OfHtExtendedCapabilities;
            this.bit4OfHtExtendedCapabilities = obj.bit4OfHtExtendedCapabilities;
            this.bit5OfHtExtendedCapabilities = obj.bit5OfHtExtendedCapabilities;
            this.bit6OfHtExtendedCapabilities = obj.bit6OfHtExtendedCapabilities;
            this.bit7OfHtExtendedCapabilities = obj.bit7OfHtExtendedCapabilities;
            this.mcsFeedbackCapability = obj.mcsFeedbackCapability;
            this.htControlFieldSupported = obj.htControlFieldSupported;
            this.rdResponderSupported = obj.rdResponderSupported;
            this.bit12OfHtExtendedCapabilities = obj.bit12OfHtExtendedCapabilities;
            this.bit13OfHtExtendedCapabilities = obj.bit13OfHtExtendedCapabilities;
            this.bit14OfHtExtendedCapabilities = obj.bit14OfHtExtendedCapabilities;
            this.bit15OfHtExtendedCapabilities = obj.bit15OfHtExtendedCapabilities;
            this.implicitTxBeamformingReceivingSupported = obj.implicitTxBeamformingReceivingSupported;
            this.rxStaggeredSoundingSupported = obj.rxStaggeredSoundingSupported;
            this.txStaggeredSoundingSupported = obj.txStaggeredSoundingSupported;
            this.rxNdpSupported = obj.rxNdpSupported;
            this.txNdpSupported = obj.txNdpSupported;
            this.implicitTxBeamformingSupported = obj.implicitTxBeamformingSupported;
            this.calibration = obj.calibration;
            this.explicitCsiTxBeamformingSupported = obj.explicitCsiTxBeamformingSupported;
            this.explicitNoncompressedSteeringSupported = obj.explicitNoncompressedSteeringSupported;
            this.explicitCompressedSteeringSupported = obj.explicitCompressedSteeringSupported;
            this.explicitTxBeamformingCsiFeedbackCapability = obj.explicitTxBeamformingCsiFeedbackCapability;
            this.explicitNoncompressedBeamformingFeedbackCapability = obj.explicitNoncompressedBeamformingFeedbackCapability;
            this.explicitCompressedBeamformingFeedbackCapability = obj.explicitCompressedBeamformingFeedbackCapability;
            this.minGrouping = obj.minGrouping;
            this.csiNumBeamformerAntennasSupported = obj.csiNumBeamformerAntennasSupported;
            this.noncompressedSteeringNumBeamformerAntennasSupported = obj.noncompressedSteeringNumBeamformerAntennasSupported;
            this.compressedSteeringNumBeamformerAntennasSupported = obj.compressedSteeringNumBeamformerAntennasSupported;
            this.csiMaxNumRowsBeamformerSupported = obj.csiMaxNumRowsBeamformerSupported;
            this.channelEstimationCapability = obj.channelEstimationCapability;
            this.bit29OfTransmitBeamformingCapabilities = obj.bit29OfTransmitBeamformingCapabilities;
            this.bit30OfTransmitBeamformingCapabilities = obj.bit30OfTransmitBeamformingCapabilities;
            this.bit31OfTransmitBeamformingCapabilities = obj.bit31OfTransmitBeamformingCapabilities;
            this.antennaSelectionSupported = obj.antennaSelectionSupported;
            this.explicitCsiFeedbackBasedTxAselSupported = obj.explicitCsiFeedbackBasedTxAselSupported;
            this.antennaIndicesFeedbackBasedTxAselSupported = obj.antennaIndicesFeedbackBasedTxAselSupported;
            this.explicitCsiFeedbackSupported = obj.explicitCsiFeedbackSupported;
            this.antennaIndicesFeedbackSupported = obj.antennaIndicesFeedbackSupported;
            this.rxAselSupported = obj.rxAselSupported;
            this.txSoundingPpdusSupported = obj.txSoundingPpdusSupported;
            this.bit7OfAselCapability = obj.bit7OfAselCapability;
        }

        public Builder ldpcCodingSupported(boolean ldpcCodingSupported) {
            this.ldpcCodingSupported = ldpcCodingSupported;
            return this;
        }

        public Builder both20and40MhzSupported(boolean both20and40MhzSupported) {
            this.both20and40MhzSupported = both20and40MhzSupported;
            return this;
        }

        public Builder smPowerSaveMode(SmPowerSaveMode smPowerSaveMode) {
            this.smPowerSaveMode = smPowerSaveMode;
            return this;
        }

        public Builder htGreenfieldSupported(boolean htGreenfieldSupported) {
            this.htGreenfieldSupported = htGreenfieldSupported;
            return this;
        }

        public Builder shortGiFor20MhzSupported(boolean shortGiFor20MhzSupported) {
            this.shortGiFor20MhzSupported = shortGiFor20MhzSupported;
            return this;
        }

        public Builder shortGiFor40MhzSupported(boolean shortGiFor40MhzSupported) {
            this.shortGiFor40MhzSupported = shortGiFor40MhzSupported;
            return this;
        }

        public Builder txStbcSupported(boolean txStbcSupported) {
            this.txStbcSupported = txStbcSupported;
            return this;
        }

        public Builder rxStbcSupport(StbcSupport rxStbcSupport) {
            this.rxStbcSupport = rxStbcSupport;
            return this;
        }

        public Builder htDelayedBlockAckSupported(boolean htDelayedBlockAckSupported) {
            this.htDelayedBlockAckSupported = htDelayedBlockAckSupported;
            return this;
        }

        public Builder maxAMsduLength(AMsduLength maxAMsduLength) {
            this.maxAMsduLength = maxAMsduLength;
            return this;
        }

        public Builder dsssCckModeIn40MhzSupported(boolean dsssCckModeIn40MhzSupported) {
            this.dsssCckModeIn40MhzSupported = dsssCckModeIn40MhzSupported;
            return this;
        }

        public Builder bit13OfHtCapabilitiesInfo(boolean bit13OfHtCapabilitiesInfo) {
            this.bit13OfHtCapabilitiesInfo = bit13OfHtCapabilitiesInfo;
            return this;
        }

        public Builder fortyMhzIntolerant(boolean fortyMhzIntolerant) {
            this.fortyMhzIntolerant = fortyMhzIntolerant;
            return this;
        }

        public Builder lSigTxopProtectionSupported(boolean lSigTxopProtectionSupported) {
            this.lSigTxopProtectionSupported = lSigTxopProtectionSupported;
            return this;
        }

        public Builder maxAMpduLength(AMpduLength maxAMpduLength) {
            this.maxAMpduLength = maxAMpduLength;
            return this;
        }

        public Builder minMpduStartSpacing(MpduStartSpacing minMpduStartSpacing) {
            this.minMpduStartSpacing = minMpduStartSpacing;
            return this;
        }

        public Builder bit5OfAMpduParameters(boolean bit5OfAMpduParameters) {
            this.bit5OfAMpduParameters = bit5OfAMpduParameters;
            return this;
        }

        public Builder bit6OfAMpduParameters(boolean bit6OfAMpduParameters) {
            this.bit6OfAMpduParameters = bit6OfAMpduParameters;
            return this;
        }

        public Builder bit7OfAMpduParameters(boolean bit7OfAMpduParameters) {
            this.bit7OfAMpduParameters = bit7OfAMpduParameters;
            return this;
        }

        public Builder supportedRxMcsIndexes(boolean[] supportedRxMcsIndexes) {
            this.supportedRxMcsIndexes = supportedRxMcsIndexes;
            return this;
        }

        public Builder bit77OfSupportedMcsSet(boolean bit77OfSupportedMcsSet) {
            this.bit77OfSupportedMcsSet = bit77OfSupportedMcsSet;
            return this;
        }

        public Builder bit78OfSupportedMcsSet(boolean bit78OfSupportedMcsSet) {
            this.bit78OfSupportedMcsSet = bit78OfSupportedMcsSet;
            return this;
        }

        public Builder bit79OfSupportedMcsSet(boolean bit79OfSupportedMcsSet) {
            this.bit79OfSupportedMcsSet = bit79OfSupportedMcsSet;
            return this;
        }

        public Builder rxHighestSupportedDataRate(short rxHighestSupportedDataRate) {
            this.rxHighestSupportedDataRate = rxHighestSupportedDataRate;
            return this;
        }

        public Builder bit90OfSupportedMcsSet(boolean bit90OfSupportedMcsSet) {
            this.bit90OfSupportedMcsSet = bit90OfSupportedMcsSet;
            return this;
        }

        public Builder bit91OfSupportedMcsSet(boolean bit91OfSupportedMcsSet) {
            this.bit91OfSupportedMcsSet = bit91OfSupportedMcsSet;
            return this;
        }

        public Builder bit92OfSupportedMcsSet(boolean bit92OfSupportedMcsSet) {
            this.bit92OfSupportedMcsSet = bit92OfSupportedMcsSet;
            return this;
        }

        public Builder bit93OfSupportedMcsSet(boolean bit93OfSupportedMcsSet) {
            this.bit93OfSupportedMcsSet = bit93OfSupportedMcsSet;
            return this;
        }

        public Builder bit94OfSupportedMcsSet(boolean bit94OfSupportedMcsSet) {
            this.bit94OfSupportedMcsSet = bit94OfSupportedMcsSet;
            return this;
        }

        public Builder bit95OfSupportedMcsSet(boolean bit95OfSupportedMcsSet) {
            this.bit95OfSupportedMcsSet = bit95OfSupportedMcsSet;
            return this;
        }

        public Builder txMcsSetDefined(boolean txMcsSetDefined) {
            this.txMcsSetDefined = txMcsSetDefined;
            return this;
        }

        public Builder txRxMcsSetNotEqual(boolean txRxMcsSetNotEqual) {
            this.txRxMcsSetNotEqual = txRxMcsSetNotEqual;
            return this;
        }

        public Builder txMaxNumSpatialStreamsSupported(NumSpatialStreams txMaxNumSpatialStreamsSupported) {
            this.txMaxNumSpatialStreamsSupported = txMaxNumSpatialStreamsSupported;
            return this;
        }

        public Builder txUnequalModulationSupported(boolean txUnequalModulationSupported) {
            this.txUnequalModulationSupported = txUnequalModulationSupported;
            return this;
        }

        public Builder bit101OfSupportedMcsSet(boolean bit101OfSupportedMcsSet) {
            this.bit101OfSupportedMcsSet = bit101OfSupportedMcsSet;
            return this;
        }

        public Builder bit102OfSupportedMcsSet(boolean bit102OfSupportedMcsSet) {
            this.bit102OfSupportedMcsSet = bit102OfSupportedMcsSet;
            return this;
        }

        public Builder bit103OfSupportedMcsSet(boolean bit103OfSupportedMcsSet) {
            this.bit103OfSupportedMcsSet = bit103OfSupportedMcsSet;
            return this;
        }

        public Builder bit104OfSupportedMcsSet(boolean bit104OfSupportedMcsSet) {
            this.bit104OfSupportedMcsSet = bit104OfSupportedMcsSet;
            return this;
        }

        public Builder bit105OfSupportedMcsSet(boolean bit105OfSupportedMcsSet) {
            this.bit105OfSupportedMcsSet = bit105OfSupportedMcsSet;
            return this;
        }

        public Builder bit106OfSupportedMcsSet(boolean bit106OfSupportedMcsSet) {
            this.bit106OfSupportedMcsSet = bit106OfSupportedMcsSet;
            return this;
        }

        public Builder bit107OfSupportedMcsSet(boolean bit107OfSupportedMcsSet) {
            this.bit107OfSupportedMcsSet = bit107OfSupportedMcsSet;
            return this;
        }

        public Builder bit108OfSupportedMcsSet(boolean bit108OfSupportedMcsSet) {
            this.bit108OfSupportedMcsSet = bit108OfSupportedMcsSet;
            return this;
        }

        public Builder bit109OfSupportedMcsSet(boolean bit109OfSupportedMcsSet) {
            this.bit109OfSupportedMcsSet = bit109OfSupportedMcsSet;
            return this;
        }

        public Builder bit110OfSupportedMcsSet(boolean bit110OfSupportedMcsSet) {
            this.bit110OfSupportedMcsSet = bit110OfSupportedMcsSet;
            return this;
        }

        public Builder bit111OfSupportedMcsSet(boolean bit111OfSupportedMcsSet) {
            this.bit111OfSupportedMcsSet = bit111OfSupportedMcsSet;
            return this;
        }

        public Builder bit112OfSupportedMcsSet(boolean bit112OfSupportedMcsSet) {
            this.bit112OfSupportedMcsSet = bit112OfSupportedMcsSet;
            return this;
        }

        public Builder bit113OfSupportedMcsSet(boolean bit113OfSupportedMcsSet) {
            this.bit113OfSupportedMcsSet = bit113OfSupportedMcsSet;
            return this;
        }

        public Builder bit114OfSupportedMcsSet(boolean bit114OfSupportedMcsSet) {
            this.bit114OfSupportedMcsSet = bit114OfSupportedMcsSet;
            return this;
        }

        public Builder bit115OfSupportedMcsSet(boolean bit115OfSupportedMcsSet) {
            this.bit115OfSupportedMcsSet = bit115OfSupportedMcsSet;
            return this;
        }

        public Builder bit116OfSupportedMcsSet(boolean bit116OfSupportedMcsSet) {
            this.bit116OfSupportedMcsSet = bit116OfSupportedMcsSet;
            return this;
        }

        public Builder bit117OfSupportedMcsSet(boolean bit117OfSupportedMcsSet) {
            this.bit117OfSupportedMcsSet = bit117OfSupportedMcsSet;
            return this;
        }

        public Builder bit118OfSupportedMcsSet(boolean bit118OfSupportedMcsSet) {
            this.bit118OfSupportedMcsSet = bit118OfSupportedMcsSet;
            return this;
        }

        public Builder bit119OfSupportedMcsSet(boolean bit119OfSupportedMcsSet) {
            this.bit119OfSupportedMcsSet = bit119OfSupportedMcsSet;
            return this;
        }

        public Builder bit120OfSupportedMcsSet(boolean bit120OfSupportedMcsSet) {
            this.bit120OfSupportedMcsSet = bit120OfSupportedMcsSet;
            return this;
        }

        public Builder bit121OfSupportedMcsSet(boolean bit121OfSupportedMcsSet) {
            this.bit121OfSupportedMcsSet = bit121OfSupportedMcsSet;
            return this;
        }

        public Builder bit122OfSupportedMcsSet(boolean bit122OfSupportedMcsSet) {
            this.bit122OfSupportedMcsSet = bit122OfSupportedMcsSet;
            return this;
        }

        public Builder bit123OfSupportedMcsSet(boolean bit123OfSupportedMcsSet) {
            this.bit123OfSupportedMcsSet = bit123OfSupportedMcsSet;
            return this;
        }

        public Builder bit124OfSupportedMcsSet(boolean bit124OfSupportedMcsSet) {
            this.bit124OfSupportedMcsSet = bit124OfSupportedMcsSet;
            return this;
        }

        public Builder bit125OfSupportedMcsSet(boolean bit125OfSupportedMcsSet) {
            this.bit125OfSupportedMcsSet = bit125OfSupportedMcsSet;
            return this;
        }

        public Builder bit126OfSupportedMcsSet(boolean bit126OfSupportedMcsSet) {
            this.bit126OfSupportedMcsSet = bit126OfSupportedMcsSet;
            return this;
        }

        public Builder bit127OfSupportedMcsSet(boolean bit127OfSupportedMcsSet) {
            this.bit127OfSupportedMcsSet = bit127OfSupportedMcsSet;
            return this;
        }

        public Builder pcoSupported(boolean pcoSupported) {
            this.pcoSupported = pcoSupported;
            return this;
        }

        public Builder pcoTransitionTime(PcoTransitionTime pcoTransitionTime) {
            this.pcoTransitionTime = pcoTransitionTime;
            return this;
        }

        public Builder bit3OfHtExtendedCapabilities(boolean bit3OfHtExtendedCapabilities) {
            this.bit3OfHtExtendedCapabilities = bit3OfHtExtendedCapabilities;
            return this;
        }

        public Builder bit4OfHtExtendedCapabilities(boolean bit4OfHtExtendedCapabilities) {
            this.bit4OfHtExtendedCapabilities = bit4OfHtExtendedCapabilities;
            return this;
        }

        public Builder bit5OfHtExtendedCapabilities(boolean bit5OfHtExtendedCapabilities) {
            this.bit5OfHtExtendedCapabilities = bit5OfHtExtendedCapabilities;
            return this;
        }

        public Builder bit6OfHtExtendedCapabilities(boolean bit6OfHtExtendedCapabilities) {
            this.bit6OfHtExtendedCapabilities = bit6OfHtExtendedCapabilities;
            return this;
        }

        public Builder bit7OfHtExtendedCapabilities(boolean bit7OfHtExtendedCapabilities) {
            this.bit7OfHtExtendedCapabilities = bit7OfHtExtendedCapabilities;
            return this;
        }

        public Builder mcsFeedbackCapability(McsFeedbackCapability mcsFeedbackCapability) {
            this.mcsFeedbackCapability = mcsFeedbackCapability;
            return this;
        }

        public Builder htControlFieldSupported(boolean htControlFieldSupported) {
            this.htControlFieldSupported = htControlFieldSupported;
            return this;
        }

        public Builder rdResponderSupported(boolean rdResponderSupported) {
            this.rdResponderSupported = rdResponderSupported;
            return this;
        }

        public Builder bit12OfHtExtendedCapabilities(boolean bit12OfHtExtendedCapabilities) {
            this.bit12OfHtExtendedCapabilities = bit12OfHtExtendedCapabilities;
            return this;
        }

        public Builder bit13OfHtExtendedCapabilities(boolean bit13OfHtExtendedCapabilities) {
            this.bit13OfHtExtendedCapabilities = bit13OfHtExtendedCapabilities;
            return this;
        }

        public Builder bit14OfHtExtendedCapabilities(boolean bit14OfHtExtendedCapabilities) {
            this.bit14OfHtExtendedCapabilities = bit14OfHtExtendedCapabilities;
            return this;
        }

        public Builder bit15OfHtExtendedCapabilities(boolean bit15OfHtExtendedCapabilities) {
            this.bit15OfHtExtendedCapabilities = bit15OfHtExtendedCapabilities;
            return this;
        }

        public Builder implicitTxBeamformingReceivingSupported(boolean implicitTxBeamformingReceivingSupported) {
            this.implicitTxBeamformingReceivingSupported = implicitTxBeamformingReceivingSupported;
            return this;
        }

        public Builder rxStaggeredSoundingSupported(boolean rxStaggeredSoundingSupported) {
            this.rxStaggeredSoundingSupported = rxStaggeredSoundingSupported;
            return this;
        }

        public Builder txStaggeredSoundingSupported(boolean txStaggeredSoundingSupported) {
            this.txStaggeredSoundingSupported = txStaggeredSoundingSupported;
            return this;
        }

        public Builder rxNdpSupported(boolean rxNdpSupported) {
            this.rxNdpSupported = rxNdpSupported;
            return this;
        }

        public Builder txNdpSupported(boolean txNdpSupported) {
            this.txNdpSupported = txNdpSupported;
            return this;
        }

        public Builder implicitTxBeamformingSupported(boolean implicitTxBeamformingSupported) {
            this.implicitTxBeamformingSupported = implicitTxBeamformingSupported;
            return this;
        }

        public Builder calibration(Calibration calibration) {
            this.calibration = calibration;
            return this;
        }

        public Builder explicitCsiTxBeamformingSupported(boolean explicitCsiTxBeamformingSupported) {
            this.explicitCsiTxBeamformingSupported = explicitCsiTxBeamformingSupported;
            return this;
        }

        public Builder explicitNoncompressedSteeringSupported(boolean explicitNoncompressedSteeringSupported) {
            this.explicitNoncompressedSteeringSupported = explicitNoncompressedSteeringSupported;
            return this;
        }

        public Builder explicitCompressedSteeringSupported(boolean explicitCompressedSteeringSupported) {
            this.explicitCompressedSteeringSupported = explicitCompressedSteeringSupported;
            return this;
        }

        public Builder explicitTxBeamformingCsiFeedbackCapability(BeamformingFeedbackCapability explicitTxBeamformingCsiFeedbackCapability) {
            this.explicitTxBeamformingCsiFeedbackCapability = explicitTxBeamformingCsiFeedbackCapability;
            return this;
        }

        public Builder explicitNoncompressedBeamformingFeedbackCapability(BeamformingFeedbackCapability explicitNoncompressedBeamformingFeedbackCapability) {
            this.explicitNoncompressedBeamformingFeedbackCapability = explicitNoncompressedBeamformingFeedbackCapability;
            return this;
        }

        public Builder explicitCompressedBeamformingFeedbackCapability(BeamformingFeedbackCapability explicitCompressedBeamformingFeedbackCapability) {
            this.explicitCompressedBeamformingFeedbackCapability = explicitCompressedBeamformingFeedbackCapability;
            return this;
        }

        public Builder minGrouping(Grouping minGrouping) {
            this.minGrouping = minGrouping;
            return this;
        }

        public Builder csiNumBeamformerAntennasSupported(NumBeamformerAntennas csiNumBeamformerAntennasSupported) {
            this.csiNumBeamformerAntennasSupported = csiNumBeamformerAntennasSupported;
            return this;
        }

        public Builder noncompressedSteeringNumBeamformerAntennasSupported(NumBeamformerAntennas noncompressedSteeringNumBeamformerAntennasSupported) {
            this.noncompressedSteeringNumBeamformerAntennasSupported = noncompressedSteeringNumBeamformerAntennasSupported;
            return this;
        }

        public Builder compressedSteeringNumBeamformerAntennasSupported(NumBeamformerAntennas compressedSteeringNumBeamformerAntennasSupported) {
            this.compressedSteeringNumBeamformerAntennasSupported = compressedSteeringNumBeamformerAntennasSupported;
            return this;
        }

        public Builder csiMaxNumRowsBeamformerSupported(CsiNumRows csiMaxNumRowsBeamformerSupported) {
            this.csiMaxNumRowsBeamformerSupported = csiMaxNumRowsBeamformerSupported;
            return this;
        }

        public Builder channelEstimationCapability(ChannelEstimationCapability channelEstimationCapability) {
            this.channelEstimationCapability = channelEstimationCapability;
            return this;
        }

        public Builder bit29OfTransmitBeamformingCapabilities(boolean bit29OfTransmitBeamformingCapabilities) {
            this.bit29OfTransmitBeamformingCapabilities = bit29OfTransmitBeamformingCapabilities;
            return this;
        }

        public Builder bit30OfTransmitBeamformingCapabilities(boolean bit30OfTransmitBeamformingCapabilities) {
            this.bit30OfTransmitBeamformingCapabilities = bit30OfTransmitBeamformingCapabilities;
            return this;
        }

        public Builder bit31OfTransmitBeamformingCapabilities(boolean bit31OfTransmitBeamformingCapabilities) {
            this.bit31OfTransmitBeamformingCapabilities = bit31OfTransmitBeamformingCapabilities;
            return this;
        }

        public Builder antennaSelectionSupported(boolean antennaSelectionSupported) {
            this.antennaSelectionSupported = antennaSelectionSupported;
            return this;
        }

        public Builder explicitCsiFeedbackBasedTxAselSupported(boolean explicitCsiFeedbackBasedTxAselSupported) {
            this.explicitCsiFeedbackBasedTxAselSupported = explicitCsiFeedbackBasedTxAselSupported;
            return this;
        }

        public Builder antennaIndicesFeedbackBasedTxAselSupported(boolean antennaIndicesFeedbackBasedTxAselSupported) {
            this.antennaIndicesFeedbackBasedTxAselSupported = antennaIndicesFeedbackBasedTxAselSupported;
            return this;
        }

        public Builder explicitCsiFeedbackSupported(boolean explicitCsiFeedbackSupported) {
            this.explicitCsiFeedbackSupported = explicitCsiFeedbackSupported;
            return this;
        }

        public Builder antennaIndicesFeedbackSupported(boolean antennaIndicesFeedbackSupported) {
            this.antennaIndicesFeedbackSupported = antennaIndicesFeedbackSupported;
            return this;
        }

        public Builder rxAselSupported(boolean rxAselSupported) {
            this.rxAselSupported = rxAselSupported;
            return this;
        }

        public Builder txSoundingPpdusSupported(boolean txSoundingPpdusSupported) {
            this.txSoundingPpdusSupported = txSoundingPpdusSupported;
            return this;
        }

        public Builder bit7OfAselCapability(boolean bit7OfAselCapability) {
            this.bit7OfAselCapability = bit7OfAselCapability;
            return this;
        }

        @Override
        public Builder length(byte length) {
            super.length(length);
            return this;
        }

        @Override
        public Builder correctLengthAtBuild(boolean correctLengthAtBuild) {
            super.correctLengthAtBuild(correctLengthAtBuild);
            return this;
        }

        @Override
        public Dot11HTCapabilitiesElement build() {
            if (this.getCorrectLengthAtBuild()) {
                this.length((byte)26);
            }
            return new Dot11HTCapabilitiesElement(this);
        }
    }

    public static enum ChannelEstimationCapability {
        ONE_SPACE_TIME_STREAM(0, "1 space-time stream"),
        TWO_SPACE_TIME_STREAMS(1, "2 space-time streams"),
        THREE_SPACE_TIME_STREAMS(2, "3 space-time streams"),
        FOUR_SPACE_TIME_STREAMS(3, "4 space-time streams");

        private final int value;
        private final String name;

        private ChannelEstimationCapability(int value, String name) {
            this.value = value;
            this.name = name;
        }

        public int getValue() {
            return this.value;
        }

        public String getName() {
            return this.name;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder(50);
            sb.append(this.value).append(" (").append(this.name).append(")");
            return sb.toString();
        }

        public static ChannelEstimationCapability getInstance(int value) {
            for (ChannelEstimationCapability cp : ChannelEstimationCapability.values()) {
                if (cp.value != value) continue;
                return cp;
            }
            throw new IllegalArgumentException("Invalid value: " + value);
        }
    }

    public static enum CsiNumRows {
        SINGLE(0, "Single row of CSI"),
        TWO(1, "2 rows of CSI"),
        THREE(2, "3 rows of CSI"),
        FOUR(3, "4 rows of CSI");

        private final int value;
        private final String name;

        private CsiNumRows(int value, String name) {
            this.value = value;
            this.name = name;
        }

        public int getValue() {
            return this.value;
        }

        public String getName() {
            return this.name;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder(50);
            sb.append(this.value).append(" (").append(this.name).append(")");
            return sb.toString();
        }

        public static CsiNumRows getInstance(int value) {
            for (CsiNumRows cp : CsiNumRows.values()) {
                if (cp.value != value) continue;
                return cp;
            }
            throw new IllegalArgumentException("Invalid value: " + value);
        }
    }

    public static enum NumBeamformerAntennas {
        SINGLE(0, "Single Tx antenna sounding"),
        TWO(1, "2 Tx antenna sounding"),
        THREE(2, "3 Tx antenna sounding"),
        FOUR(3, "4 Tx antenna sounding");

        private final int value;
        private final String name;

        private NumBeamformerAntennas(int value, String name) {
            this.value = value;
            this.name = name;
        }

        public int getValue() {
            return this.value;
        }

        public String getName() {
            return this.name;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder(50);
            sb.append(this.value).append(" (").append(this.name).append(")");
            return sb.toString();
        }

        public static NumBeamformerAntennas getInstance(int value) {
            for (NumBeamformerAntennas cp : NumBeamformerAntennas.values()) {
                if (cp.value != value) continue;
                return cp;
            }
            throw new IllegalArgumentException("Invalid value: " + value);
        }
    }

    public static enum Grouping {
        NO_GROUPING(0, "No grouping"),
        GROUPS_OF_1_2(1, "Groups of 1, 2"),
        GROUPS_OF_1_4(2, "Groups of 1, 4"),
        GROUPS_OF_1_2_4(3, "Groups of 1, 2, 4");

        private final int value;
        private final String name;

        private Grouping(int value, String name) {
            this.value = value;
            this.name = name;
        }

        public int getValue() {
            return this.value;
        }

        public String getName() {
            return this.name;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder(50);
            sb.append(this.value).append(" (").append(this.name).append(")");
            return sb.toString();
        }

        public static Grouping getInstance(int value) {
            for (Grouping cp : Grouping.values()) {
                if (cp.value != value) continue;
                return cp;
            }
            throw new IllegalArgumentException("Invalid value: " + value);
        }
    }

    public static enum BeamformingFeedbackCapability {
        NOT_SUPPORTED(0, "Not supported"),
        DELAYED(1, "Delayed"),
        IMMEDIATE(2, "Immediate"),
        DELAYED_AND_IMMEDIATE(3, "Delayed and immediate");

        private final int value;
        private final String name;

        private BeamformingFeedbackCapability(int value, String name) {
            this.value = value;
            this.name = name;
        }

        public int getValue() {
            return this.value;
        }

        public String getName() {
            return this.name;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder(50);
            sb.append(this.value).append(" (").append(this.name).append(")");
            return sb.toString();
        }

        public static BeamformingFeedbackCapability getInstance(int value) {
            for (BeamformingFeedbackCapability cp : BeamformingFeedbackCapability.values()) {
                if (cp.value != value) continue;
                return cp;
            }
            throw new IllegalArgumentException("Invalid value: " + value);
        }
    }

    public static enum Calibration {
        NOT_SUPPORTED(0, "Not supported"),
        RESPOND(1, "Respond"),
        RESERVED(2, "reserved"),
        INITIATE_AND_RESPOND(3, "Initiate and respond");

        private final int value;
        private final String name;

        private Calibration(int value, String name) {
            this.value = value;
            this.name = name;
        }

        public int getValue() {
            return this.value;
        }

        public String getName() {
            return this.name;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder(50);
            sb.append(this.value).append(" (").append(this.name).append(")");
            return sb.toString();
        }

        public static Calibration getInstance(int value) {
            for (Calibration cp : Calibration.values()) {
                if (cp.value != value) continue;
                return cp;
            }
            throw new IllegalArgumentException("Invalid value: " + value);
        }
    }

    public static enum McsFeedbackCapability {
        NO_FEEDBACK(0, "No Feedback"),
        RESERVED(1, "reserved"),
        ONLY_UNSOLICITED(2, "Only unsolicited"),
        UNSOLICITED_AND_SOLICITED(3, "Unsolicited and solicited");

        private final int value;
        private final String name;

        private McsFeedbackCapability(int value, String name) {
            this.value = value;
            this.name = name;
        }

        public int getValue() {
            return this.value;
        }

        public String getName() {
            return this.name;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder(50);
            sb.append(this.value).append(" (").append(this.name).append(")");
            return sb.toString();
        }

        public static McsFeedbackCapability getInstance(int value) {
            for (McsFeedbackCapability cp : McsFeedbackCapability.values()) {
                if (cp.value != value) continue;
                return cp;
            }
            throw new IllegalArgumentException("Invalid value: " + value);
        }
    }

    public static enum PcoTransitionTime {
        NO_TRANSITION(0, "No transition"),
        PTT_400_US(1, "400 us"),
        PTT_1_5_MS(2, "1.5 ms"),
        PTT_5_MS(3, "5 ms");

        private final int value;
        private final String name;

        private PcoTransitionTime(int value, String name) {
            this.value = value;
            this.name = name;
        }

        public int getValue() {
            return this.value;
        }

        public String getName() {
            return this.name;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder(50);
            sb.append(this.value).append(" (").append(this.name).append(")");
            return sb.toString();
        }

        public static PcoTransitionTime getInstance(int value) {
            for (PcoTransitionTime cp : PcoTransitionTime.values()) {
                if (cp.value != value) continue;
                return cp;
            }
            throw new IllegalArgumentException("Invalid value: " + value);
        }
    }

    public static enum NumSpatialStreams {
        ONE(0, "1 spatial stream"),
        TWO(1, "2 spatial stream"),
        THREE(2, "3 spatial stream"),
        FOUR(3, "4 spatial stream");

        private final int value;
        private final String name;

        private NumSpatialStreams(int value, String name) {
            this.value = value;
            this.name = name;
        }

        public int getValue() {
            return this.value;
        }

        public String getName() {
            return this.name;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder(50);
            sb.append(this.value).append(" (").append(this.name).append(")");
            return sb.toString();
        }

        public static NumSpatialStreams getInstance(int value) {
            for (NumSpatialStreams cp : NumSpatialStreams.values()) {
                if (cp.value != value) continue;
                return cp;
            }
            throw new IllegalArgumentException("Invalid value: " + value);
        }
    }

    public static enum MpduStartSpacing {
        NO_RESTRICTION(0, "No restriction"),
        ONE_FOURTH_US(1, "1/4 us"),
        HALF_US(2, "1/2 us"),
        ONE_US(3, "1 us"),
        TWO_US(4, "2 us"),
        FOUR_US(5, "4 us"),
        EIGHT_US(6, "8 us"),
        SIXTEEN_US(7, "16 us");

        private final int value;
        private final String name;

        private MpduStartSpacing(int value, String name) {
            this.value = value;
            this.name = name;
        }

        public int getValue() {
            return this.value;
        }

        public String getName() {
            return this.name;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder(50);
            sb.append(this.value).append(" (").append(this.name).append(")");
            return sb.toString();
        }

        public static MpduStartSpacing getInstance(int value) {
            for (MpduStartSpacing cp : MpduStartSpacing.values()) {
                if (cp.value != value) continue;
                return cp;
            }
            throw new IllegalArgumentException("Invalid value: " + value);
        }
    }

    public static enum AMpduLength {
        MAX_8191(0, "8191 octets"),
        MAX_16383(1, "16383 octets"),
        MAX_32767(2, "32767 octets"),
        MAX_65535(3, "65535 octets");

        private final int value;
        private final String name;

        private AMpduLength(int value, String name) {
            this.value = value;
            this.name = name;
        }

        public int getValue() {
            return this.value;
        }

        public String getName() {
            return this.name;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder(50);
            sb.append(this.value).append(" (").append(this.name).append(")");
            return sb.toString();
        }

        public static AMpduLength getInstance(int value) {
            for (AMpduLength val : AMpduLength.values()) {
                if (val.value != value) continue;
                return val;
            }
            throw new IllegalArgumentException("Invalid value: " + value);
        }
    }

    public static enum AMsduLength {
        MAX_3839(0, "3839 octets"),
        MAX_7935(1, "7935 octets");

        private final int value;
        private final String name;

        private AMsduLength(int value, String name) {
            this.value = value;
            this.name = name;
        }

        public int getValue() {
            return this.value;
        }

        public String getName() {
            return this.name;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder(50);
            sb.append(this.value).append(" (").append(this.name).append(")");
            return sb.toString();
        }

        public static AMsduLength getInstance(int value) {
            for (AMsduLength val : AMsduLength.values()) {
                if (val.value != value) continue;
                return val;
            }
            throw new IllegalArgumentException("Invalid value: " + value);
        }
    }

    public static enum StbcSupport {
        NO_SUPPORT(0, "No support"),
        ONE_SPATIAL_STREAM(1, "One spatial stream is supported"),
        ONE_AND_TWO_SPATIAL_STREAMS(2, "One and two spatial streams are supported"),
        ONE_TWO_AND_THREE_SPATIAL_STREAMS(3, "One, two and three spatial streams are supported");

        private final int value;
        private final String name;

        private StbcSupport(int value, String name) {
            this.value = value;
            this.name = name;
        }

        public int getValue() {
            return this.value;
        }

        public String getName() {
            return this.name;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder(60);
            sb.append(this.value).append(" (").append(this.name).append(")");
            return sb.toString();
        }

        public static StbcSupport getInstance(int value) {
            for (StbcSupport val : StbcSupport.values()) {
                if (val.value != value) continue;
                return val;
            }
            throw new IllegalArgumentException("Invalid value: " + value);
        }
    }

    public static enum SmPowerSaveMode {
        STATIC(0),
        DYNAMIC(1),
        RESERVED(2),
        DISABLED(3);

        private final int value;

        private SmPowerSaveMode(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder(20);
            sb.append(this.value).append(" (").append(this.name()).append(")");
            return sb.toString();
        }

        public static SmPowerSaveMode getInstance(int value) {
            for (SmPowerSaveMode mode : SmPowerSaveMode.values()) {
                if (mode.value != value) continue;
                return mode;
            }
            throw new IllegalArgumentException("Invalid value: " + value);
        }
    }
}

