/*
 * Decompiled with CFR 0.152.
 */
package org.pcap4j.packet;

import org.pcap4j.packet.Dot11InformationElement;
import org.pcap4j.packet.IllegalRawDataException;
import org.pcap4j.packet.namednumber.Dot11InformationElementId;
import org.pcap4j.util.ByteArrays;

public final class Dot112040BssCoexistenceElement
extends Dot11InformationElement {
    private static final long serialVersionUID = 8883468584264617141L;
    private final boolean informationRequested;
    private final boolean fortyMhzIntolerant;
    private final boolean twentyMhzBssWidthRequested;
    private final boolean obssScanningExemptionRequested;
    private final boolean obssScanningExemptionGranted;
    private final boolean bit5;
    private final boolean bit6;
    private final boolean bit7;

    public static Dot112040BssCoexistenceElement newInstance(byte[] rawData, int offset, int length) throws IllegalRawDataException {
        ByteArrays.validateBounds(rawData, offset, length);
        return new Dot112040BssCoexistenceElement(rawData, offset, length);
    }

    private Dot112040BssCoexistenceElement(byte[] rawData, int offset, int length) throws IllegalRawDataException {
        super(rawData, offset, length, Dot11InformationElementId.IE_20_40_BSS_COEXISTENCE);
        if (this.getLengthAsInt() != 1) {
            throw new IllegalRawDataException("The length must be 1 but is actually: " + this.getLengthAsInt());
        }
        this.informationRequested = (rawData[offset + 2] & 1) != 0;
        this.fortyMhzIntolerant = (rawData[offset + 2] & 2) != 0;
        this.twentyMhzBssWidthRequested = (rawData[offset + 2] & 4) != 0;
        this.obssScanningExemptionRequested = (rawData[offset + 2] & 8) != 0;
        this.obssScanningExemptionGranted = (rawData[offset + 2] & 0x10) != 0;
        this.bit5 = (rawData[offset + 2] & 0x20) != 0;
        this.bit6 = (rawData[offset + 2] & 0x40) != 0;
        this.bit7 = (rawData[offset + 2] & 0x80) != 0;
    }

    private Dot112040BssCoexistenceElement(Builder builder) {
        super(builder);
        this.informationRequested = builder.informationRequested;
        this.fortyMhzIntolerant = builder.fortyMhzIntolerant;
        this.twentyMhzBssWidthRequested = builder.twentyMhzBssWidthRequested;
        this.obssScanningExemptionRequested = builder.obssScanningExemptionRequested;
        this.obssScanningExemptionGranted = builder.obssScanningExemptionGranted;
        this.bit5 = builder.bit5;
        this.bit6 = builder.bit6;
        this.bit7 = builder.bit7;
    }

    public boolean isInformationRequested() {
        return this.informationRequested;
    }

    public boolean is40MhzIntolerant() {
        return this.fortyMhzIntolerant;
    }

    public boolean is20MhzBssWidthRequested() {
        return this.twentyMhzBssWidthRequested;
    }

    public boolean isObssScanningExemptionRequested() {
        return this.obssScanningExemptionRequested;
    }

    public boolean isObssScanningExemptionGranted() {
        return this.obssScanningExemptionGranted;
    }

    public boolean getBit5() {
        return this.bit5;
    }

    public boolean getBit6() {
        return this.bit6;
    }

    public boolean getBit7() {
        return this.bit7;
    }

    @Override
    public int length() {
        return 3;
    }

    @Override
    public byte[] getRawData() {
        byte[] rawData = new byte[3];
        rawData[0] = (Byte)this.getElementId().value();
        rawData[1] = this.getLength();
        if (this.informationRequested) {
            rawData[2] = (byte)(rawData[2] | 1);
        }
        if (this.fortyMhzIntolerant) {
            rawData[2] = (byte)(rawData[2] | 2);
        }
        if (this.twentyMhzBssWidthRequested) {
            rawData[2] = (byte)(rawData[2] | 4);
        }
        if (this.obssScanningExemptionRequested) {
            rawData[2] = (byte)(rawData[2] | 8);
        }
        if (this.obssScanningExemptionGranted) {
            rawData[2] = (byte)(rawData[2] | 0x10);
        }
        if (this.bit5) {
            rawData[2] = (byte)(rawData[2] | 0x20);
        }
        if (this.bit6) {
            rawData[2] = (byte)(rawData[2] | 0x40);
        }
        if (this.bit7) {
            rawData[2] = (byte)(rawData[2] | 0x80);
        }
        return rawData;
    }

    public Builder getBuilder() {
        return new Builder(this);
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result2 = super.hashCode();
        result2 = 31 * result2 + (this.bit5 ? 1231 : 1237);
        result2 = 31 * result2 + (this.bit6 ? 1231 : 1237);
        result2 = 31 * result2 + (this.bit7 ? 1231 : 1237);
        result2 = 31 * result2 + (this.fortyMhzIntolerant ? 1231 : 1237);
        result2 = 31 * result2 + (this.informationRequested ? 1231 : 1237);
        result2 = 31 * result2 + (this.obssScanningExemptionGranted ? 1231 : 1237);
        result2 = 31 * result2 + (this.obssScanningExemptionRequested ? 1231 : 1237);
        result2 = 31 * result2 + (this.twentyMhzBssWidthRequested ? 1231 : 1237);
        return result2;
    }

    @Override
    public boolean equals(Object obj) {
        if (!super.equals(obj)) {
            return false;
        }
        Dot112040BssCoexistenceElement other = (Dot112040BssCoexistenceElement)obj;
        if (this.fortyMhzIntolerant != other.fortyMhzIntolerant) {
            return false;
        }
        if (this.informationRequested != other.informationRequested) {
            return false;
        }
        if (this.obssScanningExemptionGranted != other.obssScanningExemptionGranted) {
            return false;
        }
        if (this.obssScanningExemptionRequested != other.obssScanningExemptionRequested) {
            return false;
        }
        if (this.twentyMhzBssWidthRequested != other.twentyMhzBssWidthRequested) {
            return false;
        }
        if (this.bit5 != other.bit5) {
            return false;
        }
        if (this.bit6 != other.bit6) {
            return false;
        }
        return this.bit7 == other.bit7;
    }

    public String toString() {
        return this.toString("");
    }

    public String toString(String indent) {
        StringBuilder sb = new StringBuilder();
        String ls = System.getProperty("line.separator");
        sb.append(indent).append("20/40 BSS Coexistence:").append(ls);
        sb.append(indent).append("  Element ID: ").append(this.getElementId()).append(ls);
        sb.append(indent).append("  Length: ").append(this.getLengthAsInt()).append(" bytes").append(ls);
        sb.append(indent).append("  Information Requested: ").append(this.informationRequested).append(ls);
        sb.append(indent).append("  40 MHz Intolerant: ").append(this.fortyMhzIntolerant).append(ls);
        sb.append(indent).append("  20 MHz BSS Width Requested: ").append(this.twentyMhzBssWidthRequested).append(ls);
        sb.append(indent).append("  OBSS Scanning Exemption Requested: ").append(this.obssScanningExemptionRequested).append(ls);
        sb.append(indent).append("  OBSS Scanning Exemption Granted: ").append(this.obssScanningExemptionGranted).append(ls);
        sb.append(indent).append("  Bit 5: ").append(this.bit5).append(ls);
        sb.append(indent).append("  Bit 6: ").append(this.bit6).append(ls);
        sb.append(indent).append("  Bit 7: ").append(this.bit7).append(ls);
        return sb.toString();
    }

    public static final class Builder
    extends Dot11InformationElement.Builder {
        private boolean informationRequested;
        private boolean fortyMhzIntolerant;
        private boolean twentyMhzBssWidthRequested;
        private boolean obssScanningExemptionRequested;
        private boolean obssScanningExemptionGranted;
        private boolean bit5;
        private boolean bit6;
        private boolean bit7;

        public Builder() {
            this.elementId(Dot11InformationElementId.getInstance((Byte)Dot11InformationElementId.IE_20_40_BSS_COEXISTENCE.value()));
        }

        private Builder(Dot112040BssCoexistenceElement elem) {
            super(elem);
            this.informationRequested = elem.informationRequested;
            this.fortyMhzIntolerant = elem.fortyMhzIntolerant;
            this.twentyMhzBssWidthRequested = elem.twentyMhzBssWidthRequested;
            this.obssScanningExemptionRequested = elem.obssScanningExemptionRequested;
            this.obssScanningExemptionGranted = elem.obssScanningExemptionGranted;
            this.bit5 = elem.bit5;
            this.bit6 = elem.bit6;
            this.bit7 = elem.bit7;
        }

        public Builder informationRequested(boolean informationRequested) {
            this.informationRequested = informationRequested;
            return this;
        }

        public Builder fortyMhzIntolerant(boolean fortyMhzIntolerant) {
            this.fortyMhzIntolerant = fortyMhzIntolerant;
            return this;
        }

        public Builder twentyMhzBssWidthRequested(boolean twentyMhzBssWidthRequested) {
            this.twentyMhzBssWidthRequested = twentyMhzBssWidthRequested;
            return this;
        }

        public Builder obssScanningExemptionRequested(boolean obssScanningExemptionRequested) {
            this.obssScanningExemptionRequested = obssScanningExemptionRequested;
            return this;
        }

        public Builder obssScanningExemptionGranted(boolean obssScanningExemptionGranted) {
            this.obssScanningExemptionGranted = obssScanningExemptionGranted;
            return this;
        }

        public Builder bit5(boolean bit5) {
            this.bit5 = bit5;
            return this;
        }

        public Builder bit6(boolean bit6) {
            this.bit6 = bit6;
            return this;
        }

        public Builder bit7(boolean bit7) {
            this.bit7 = bit7;
            return this;
        }

        @Override
        public Builder length(byte length) {
            super.length(length);
            return this;
        }

        @Override
        public Builder correctLengthAtBuild(boolean correctLengthAtBuild) {
            super.correctLengthAtBuild(correctLengthAtBuild);
            return this;
        }

        @Override
        public Dot112040BssCoexistenceElement build() {
            if (this.getCorrectLengthAtBuild()) {
                this.length((byte)1);
            }
            return new Dot112040BssCoexistenceElement(this);
        }
    }
}

