/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.micrometer.impl;

import io.micrometer.core.instrument.Tags;
import io.vertx.core.net.SocketAddress;
import io.vertx.micrometer.Label;
import java.util.Arrays;

public final class Labels {
    private Labels() {
    }

    static String address(SocketAddress address) {
        return Labels.address(address, null);
    }

    static String address(SocketAddress address, String nameOverride) {
        if (address == null) {
            return "?";
        }
        if (nameOverride == null) {
            return address.toString();
        }
        SocketAddress addrOverride = address.port() >= 0 ? SocketAddress.inetSocketAddress(address.port(), nameOverride) : SocketAddress.domainSocketAddress(nameOverride);
        return addrOverride.toString();
    }

    static String getSide(boolean local) {
        return local ? "local" : "remote";
    }

    public static Tags toTags(Label[] keys2, String[] values2) {
        if (keys2.length == 0) {
            return Tags.empty();
        }
        String[] keyValuePairs = new String[2 * keys2.length];
        int count2 = 0;
        for (int i2 = 0; i2 < keys2.length; ++i2) {
            String lowKey;
            String value = values2[i2];
            if (value == null) continue;
            keyValuePairs[2 * count2] = lowKey = keys2[i2].toString();
            keyValuePairs[2 * count2 + 1] = value;
            ++count2;
        }
        if (count2 == 0) {
            return Tags.empty();
        }
        if (count2 == keys2.length) {
            return Tags.of(keyValuePairs);
        }
        return Tags.of(Arrays.copyOf(keyValuePairs, 2 * count2));
    }
}

