/*
 * Decompiled with CFR 0.152.
 */
package io.sip3.captain.ce.pipeline;

import io.netty.buffer.ByteBuf;
import io.sip3.captain.ce.RoutesCE;
import io.sip3.captain.ce.domain.IpHeader;
import io.sip3.captain.ce.domain.Packet;
import io.sip3.captain.ce.pipeline.IpHandler;
import io.sip3.captain.ce.pipeline.UdpHandler;
import io.sip3.commons.domain.payload.ByteArrayPayload;
import io.sip3.commons.domain.payload.Encodable;
import io.sip3.commons.domain.payload.Payload;
import io.sip3.commons.util.ByteBufUtilKt;
import io.sip3.commons.vertx.util.EventBusUtilKt;
import io.vertx.core.Vertx;
import io.vertx.core.eventbus.EventBus;
import io.vertx.core.json.JsonObject;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\u0018\u0000 \u001a2\u00020\u0001:\u0001\u001aB\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\u0014\u001a\u00020\n2\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\rH\u0016R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u000e\u001a\u00020\u000f8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0012\u0010\u0013\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u001b"}, d2={"Lio/sip3/captain/ce/pipeline/Ipv6Handler;", "Lio/sip3/captain/ce/pipeline/IpHandler;", "vertx", "Lio/vertx/core/Vertx;", "config", "Lio/vertx/core/json/JsonObject;", "bulkOperationsEnabled", "", "(Lio/vertx/core/Vertx;Lio/vertx/core/json/JsonObject;Z)V", "header", "Lio/sip3/captain/ce/domain/IpHeader;", "tcpPackets", "", "Lio/sip3/captain/ce/domain/Packet;", "udpHandler", "Lio/sip3/captain/ce/pipeline/UdpHandler;", "getUdpHandler", "()Lio/sip3/captain/ce/pipeline/UdpHandler;", "udpHandler$delegate", "Lkotlin/Lazy;", "readIpHeader", "buffer", "Lio/netty/buffer/ByteBuf;", "routePacket", "", "packet", "Companion", "sip3-captain-ce"})
public final class Ipv6Handler
extends IpHandler {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final IpHeader header;
    @NotNull
    private final List<Packet> tcpPackets;
    @NotNull
    private final Lazy udpHandler$delegate;
    private static final int TYPE_ICMP = 58;
    private static final int TYPE_IPV6 = 41;
    private static final int TYPE_TCP = 6;
    private static final int TYPE_UDP = 17;
    @NotNull
    private static final Set<Integer> UPPER_LAYER_HEADERS;

    public Ipv6Handler(@NotNull Vertx vertx, @NotNull JsonObject config2, boolean bulkOperationsEnabled) {
        Intrinsics.checkNotNullParameter(vertx, "vertx");
        Intrinsics.checkNotNullParameter(config2, "config");
        super(vertx, config2, bulkOperationsEnabled);
        this.header = new IpHeader(16);
        this.tcpPackets = new ArrayList();
        this.udpHandler$delegate = LazyKt.lazy((Function0)new Function0<UdpHandler>(vertx, config2, bulkOperationsEnabled){
            final /* synthetic */ Vertx $vertx;
            final /* synthetic */ JsonObject $config;
            final /* synthetic */ boolean $bulkOperationsEnabled;
            {
                this.$vertx = $vertx;
                this.$config = $config;
                this.$bulkOperationsEnabled = $bulkOperationsEnabled;
                super(0);
            }

            @NotNull
            public final UdpHandler invoke() {
                return new UdpHandler(this.$vertx, this.$config, this.$bulkOperationsEnabled);
            }
        });
    }

    private final UdpHandler getUdpHandler() {
        Lazy lazy = this.udpHandler$delegate;
        return (UdpHandler)lazy.getValue();
    }

    @Override
    @NotNull
    public IpHeader readIpHeader(@NotNull ByteBuf buffer) {
        IpHeader ipHeader;
        Intrinsics.checkNotNullParameter(buffer, "buffer");
        int payloadLength = 0;
        byte nextHeader = 0;
        IpHeader $this$readIpHeader_u24lambda_u240 = ipHeader = this.header;
        boolean bl = false;
        $this$readIpHeader_u24lambda_u240.setIdentification(0);
        $this$readIpHeader_u24lambda_u240.setMoreFragments(false);
        $this$readIpHeader_u24lambda_u240.setFragmentOffset(0);
        IpHeader $this$readIpHeader_u24lambda_u241 = ipHeader = this.header;
        boolean bl2 = false;
        $this$readIpHeader_u24lambda_u241.setHeaderLength(40);
        buffer.skipBytes(4);
        payloadLength = buffer.readUnsignedShort();
        nextHeader = buffer.readByte();
        buffer.skipBytes(1);
        buffer.readBytes($this$readIpHeader_u24lambda_u241.getSrcAddr());
        buffer.readBytes($this$readIpHeader_u24lambda_u241.getDstAddr());
        while (!UPPER_LAYER_HEADERS.contains(nextHeader)) {
            if (nextHeader == 44) {
                nextHeader = buffer.readByte();
                buffer.skipBytes(1);
                int fragmentOffsetAndFlags = buffer.readUnsignedShort();
                $this$readIpHeader_u24lambda_u241.setFragmentOffset(fragmentOffsetAndFlags >> 3);
                $this$readIpHeader_u24lambda_u241.setMoreFragments((fragmentOffsetAndFlags & 1) != 0);
                $this$readIpHeader_u24lambda_u241.setIdentification(buffer.readInt());
                $this$readIpHeader_u24lambda_u241.setHeaderLength($this$readIpHeader_u24lambda_u241.getHeaderLength() + 8);
                continue;
            }
            nextHeader = buffer.readByte();
            int length = 8 * (buffer.readUnsignedByte() + 1);
            buffer.skipBytes(length - 2);
            $this$readIpHeader_u24lambda_u241.setHeaderLength($this$readIpHeader_u24lambda_u241.getHeaderLength() + length);
        }
        $this$readIpHeader_u24lambda_u241.setTotalLength($this$readIpHeader_u24lambda_u241.getHeaderLength() + payloadLength);
        $this$readIpHeader_u24lambda_u241.setProtocolNumber(nextHeader);
        return ipHeader;
    }

    @Override
    public void routePacket(@NotNull Packet packet) {
        Intrinsics.checkNotNullParameter(packet, "packet");
        switch (packet.getProtocolNumber()) {
            case 17: {
                this.getUdpHandler().handle(packet);
                break;
            }
            case 6: {
                Ipv6Handler ipv6Handler2 = this;
                Packet packet2 = packet;
                boolean bl = false;
                Payload payload = packet.getPayload();
                Intrinsics.checkNotNull(payload, "null cannot be cast to non-null type io.sip3.commons.domain.payload.Encodable");
                ByteBuf buffer = ((Encodable)payload).encode();
                packet2.setPayload(ByteArrayPayload.box-impl(ByteArrayPayload.constructor-impl(ByteBufUtilKt.getBytes(buffer))));
                this.tcpPackets.add(packet);
                if (this.tcpPackets.size() < this.getBulkSize()) break;
                EventBus eventBus = this.getVertx().eventBus();
                Intrinsics.checkNotNullExpressionValue(eventBus, "vertx.eventBus()");
                EventBusUtilKt.localSend$default(eventBus, RoutesCE.Companion.getTcp(), CollectionsKt.toList((Iterable)this.tcpPackets), null, 4, null);
                this.tcpPackets.clear();
                break;
            }
            case 58: {
                Packet packet3;
                Packet $this$routePacket_u24lambda_u242;
                Payload payload = packet.getPayload();
                Intrinsics.checkNotNull(payload, "null cannot be cast to non-null type io.sip3.commons.domain.payload.Encodable");
                ByteBuf buffer = ((Encodable)payload).encode();
                Packet $this$routePacket_u24lambda_u243 = $this$routePacket_u24lambda_u242 = packet;
                boolean bl = false;
                $this$routePacket_u24lambda_u243.setProtocolCode((byte)4);
                $this$routePacket_u24lambda_u243.setRecordingMark(buffer.readerIndex());
                byte type = buffer.readByte();
                byte code = buffer.readByte();
                buffer.skipBytes(6);
                if (type != 1 || code != 4) break;
                Packet $this$routePacket_u24lambda_u244 = packet3 = new Packet();
                boolean bl2 = false;
                $this$routePacket_u24lambda_u244.setTimestamp(packet.getTimestamp());
                $this$routePacket_u24lambda_u244.setNanos(packet.getNanos());
                $this$routePacket_u24lambda_u244.setPayload(packet.getPayload());
                $this$routePacket_u24lambda_u244.setRejected(packet);
                Packet p = packet3;
                this.onPacket(p);
                break;
            }
            case 41: {
                this.onPacket(packet);
            }
        }
    }

    static {
        Integer[] integerArray = new Integer[]{58, 41, 6, 17, 59};
        UPPER_LAYER_HEADERS = SetsKt.setOf(integerArray);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\"\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0017\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00040\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\f"}, d2={"Lio/sip3/captain/ce/pipeline/Ipv6Handler$Companion;", "", "()V", "TYPE_ICMP", "", "TYPE_IPV6", "TYPE_TCP", "TYPE_UDP", "UPPER_LAYER_HEADERS", "", "getUPPER_LAYER_HEADERS", "()Ljava/util/Set;", "sip3-captain-ce"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Set<Integer> getUPPER_LAYER_HEADERS() {
            return UPPER_LAYER_HEADERS;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

