/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.influx;

import io.micrometer.common.util.StringUtils;
import io.micrometer.core.ipc.http.HttpSender;
import io.micrometer.influx.InfluxConfig;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;

public enum InfluxApiVersion {
    V1{

        @Override
        String writeEndpoint(InfluxConfig config2) {
            String influxEndpoint = config2.uri() + "/write?consistency=" + config2.consistency().name().toLowerCase() + "&precision=ms&db=" + config2.db();
            if (StringUtils.isNotBlank(config2.retentionPolicy())) {
                influxEndpoint = influxEndpoint + "&rp=" + config2.retentionPolicy();
            }
            return influxEndpoint;
        }

        @Override
        void addHeaderToken(InfluxConfig config2, HttpSender.Request.Builder requestBuilder) {
            if (config2.token() != null) {
                requestBuilder.withHeader("Authorization", "Bearer " + config2.token());
            }
        }
    }
    ,
    V2{

        @Override
        String writeEndpoint(InfluxConfig config2) throws UnsupportedEncodingException {
            String bucket = URLEncoder.encode(config2.bucket(), "UTF-8");
            String org = URLEncoder.encode(config2.org(), "UTF-8");
            return config2.uri() + "/api/v2/write?precision=ms&bucket=" + bucket + "&org=" + org;
        }

        @Override
        void addHeaderToken(InfluxConfig config2, HttpSender.Request.Builder requestBuilder) {
            if (config2.token() != null) {
                requestBuilder.withHeader("Authorization", "Token " + config2.token());
            }
        }
    };


    abstract String writeEndpoint(InfluxConfig var1) throws UnsupportedEncodingException;

    abstract void addHeaderToken(InfluxConfig var1, HttpSender.Request.Builder var2);
}

