/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.telemetry.micrometer.util;

import java.util.Map;
import java.util.Objects;
import java.util.WeakHashMap;

public class LastSeenTracker {
    private final Map<String, LastSeen> lastSeen = new WeakHashMap<String, LastSeen>();

    public LastSeen getAndUpdate(String name, long now, double value, double duration) {
        LastSeen newLastSeen = new LastSeen(now, value, duration);
        LastSeen lastSeenLastSeen = this.lastSeen.get(name);
        if (lastSeenLastSeen == null) {
            lastSeenLastSeen = new LastSeen(newLastSeen.wallTime, 0.0, 0.0);
        }
        this.lastSeen.put(name, newLastSeen);
        return lastSeenLastSeen;
    }

    public static class LastSeen {
        private final double value;
        private final long wallTime;
        private final double duration;

        public LastSeen(long wallTime, double value, double duration) {
            this.value = value;
            this.wallTime = wallTime;
            this.duration = duration;
        }

        public double getValue() {
            return this.value;
        }

        public long getTime() {
            return this.wallTime;
        }

        public double getDuration() {
            return this.duration;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            LastSeen that = (LastSeen)o;
            return Double.compare(that.value, this.value) == 0 && this.wallTime == that.wallTime && Double.compare(that.duration, this.duration) == 0;
        }

        public int hashCode() {
            return Objects.hash(this.value, this.wallTime, this.duration);
        }

        public String toString() {
            return "LastSeen{value=" + this.value + ", wallTime=" + this.wallTime + ", duration=" + this.duration + '}';
        }
    }
}

