/*
 * Decompiled with CFR 0.152.
 */
package org.pcap4j.packet;

import java.util.Arrays;
import org.pcap4j.packet.TcpPacket;
import org.pcap4j.packet.namednumber.TcpOptionKind;
import org.pcap4j.util.ByteArrays;

public final class IllegalTcpOption
implements TcpPacket.TcpOption {
    private static final long serialVersionUID = 4128600756828920489L;
    private final TcpOptionKind kind;
    private final byte[] rawData;

    public static IllegalTcpOption newInstance(byte[] rawData, int offset, int length) {
        ByteArrays.validateBounds(rawData, offset, length);
        return new IllegalTcpOption(rawData, offset, length);
    }

    private IllegalTcpOption(byte[] rawData, int offset, int length) {
        this.kind = TcpOptionKind.getInstance(rawData[offset]);
        this.rawData = new byte[length];
        System.arraycopy(rawData, offset, this.rawData, 0, length);
    }

    private IllegalTcpOption(Builder builder) {
        if (builder == null || builder.kind == null || builder.rawData == null) {
            StringBuilder sb = new StringBuilder();
            sb.append("builder: ").append(builder).append(" builder.kind: ").append(builder.kind).append(" builder.rawData: ").append(builder.rawData);
            throw new NullPointerException(sb.toString());
        }
        this.kind = builder.kind;
        this.rawData = new byte[builder.rawData.length];
        System.arraycopy(builder.rawData, 0, this.rawData, 0, builder.rawData.length);
    }

    @Override
    public TcpOptionKind getKind() {
        return this.kind;
    }

    @Override
    public int length() {
        return this.rawData.length;
    }

    @Override
    public byte[] getRawData() {
        byte[] copy = new byte[this.rawData.length];
        System.arraycopy(this.rawData, 0, copy, 0, copy.length);
        return copy;
    }

    public Builder getBuilder() {
        return new Builder(this);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("[Kind: ").append(this.kind).append("] [Illegal Raw Data: 0x").append(ByteArrays.toHexString(this.rawData, "")).append("]");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!this.getClass().isInstance(obj)) {
            return false;
        }
        IllegalTcpOption other = (IllegalTcpOption)obj;
        return this.kind.equals(other.kind) && Arrays.equals(other.rawData, this.rawData);
    }

    public int hashCode() {
        int result2 = 17;
        result2 = 31 * result2 + this.kind.hashCode();
        result2 = 31 * result2 + Arrays.hashCode(this.rawData);
        return result2;
    }

    public static final class Builder {
        private TcpOptionKind kind;
        private byte[] rawData;

        public Builder() {
        }

        private Builder(IllegalTcpOption option) {
            this.kind = option.kind;
            this.rawData = option.rawData;
        }

        public Builder kind(TcpOptionKind kind) {
            this.kind = kind;
            return this;
        }

        public Builder rawData(byte[] rawData) {
            this.rawData = rawData;
            return this;
        }

        public IllegalTcpOption build() {
            return new IllegalTcpOption(this);
        }
    }
}

