/*
 * Decompiled with CFR 0.152.
 */
package org.pcap4j.packet;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.pcap4j.packet.AbstractPacket;
import org.pcap4j.packet.DnsQuestion;
import org.pcap4j.packet.DnsResourceRecord;
import org.pcap4j.packet.IllegalRawDataException;
import org.pcap4j.packet.namednumber.DnsOpCode;
import org.pcap4j.packet.namednumber.DnsRCode;
import org.pcap4j.util.ByteArrays;

public final class DnsPacket
extends AbstractPacket {
    private static final long serialVersionUID = 2804715680374557063L;
    private final DnsHeader header;

    public static DnsPacket newPacket(byte[] rawData, int offset, int length) throws IllegalRawDataException {
        ByteArrays.validateBounds(rawData, offset, length);
        return new DnsPacket(rawData, offset, length);
    }

    private DnsPacket(byte[] rawData, int offset, int length) throws IllegalRawDataException {
        this.header = new DnsHeader(rawData, offset, length);
    }

    private DnsPacket(Builder builder) {
        if (builder == null || builder.opCode == null || builder.rCode == null) {
            StringBuilder sb = new StringBuilder();
            sb.append("builder: ").append(builder).append(" builder.opCode: ").append(builder.opCode).append(" builder.rCode: ").append(builder.rCode);
            throw new NullPointerException(sb.toString());
        }
        this.header = new DnsHeader(builder);
    }

    @Override
    public DnsHeader getHeader() {
        return this.header;
    }

    @Override
    public Builder getBuilder() {
        return new Builder(this);
    }

    public static final class DnsHeader
    extends AbstractPacket.AbstractHeader {
        private static final long serialVersionUID = -2779530760536525672L;
        private static final int ID_OFFSET = 0;
        private static final int ID_SIZE = 2;
        private static final int FLAGS_OFFSET = 2;
        private static final int FLAGS_SIZE = 2;
        private static final int QDCOUNT_OFFSET = 4;
        private static final int QDCOUNT_SIZE = 2;
        private static final int ANCOUNT_OFFSET = 6;
        private static final int ANCOUNT_SIZE = 2;
        private static final int NSCOUNT_OFFSET = 8;
        private static final int NSCOUNT_SIZE = 2;
        private static final int ARCOUNT_OFFSET = 10;
        private static final int ARCOUNT_SIZE = 2;
        private static final int DNS_MIN_HEADER_SIZE = 12;
        private final short id;
        private final boolean response;
        private final DnsOpCode opCode;
        private final boolean authoritativeAnswer;
        private final boolean truncated;
        private final boolean recursionDesired;
        private final boolean recursionAvailable;
        private final boolean reserved;
        private final boolean authenticData;
        private final boolean checkingDisabled;
        private final DnsRCode rCode;
        private final short qdCount;
        private final short anCount;
        private final short nsCount;
        private final short arCount;
        private final List<DnsQuestion> questions;
        private final List<DnsResourceRecord> answers;
        private final List<DnsResourceRecord> authorities;
        private final List<DnsResourceRecord> additionalInfo;

        private DnsHeader(byte[] rawData, int offset, int length) throws IllegalRawDataException {
            StringBuilder sb;
            int remainingLen;
            int i2;
            if (length < 12) {
                StringBuilder sb2 = new StringBuilder(200);
                sb2.append("The data is too short to build a DnsHeader (").append(12).append(" bytes). data: ").append(ByteArrays.toHexString(rawData, " ")).append(", offset: ").append(offset).append(", length: ").append(length);
                throw new IllegalRawDataException(sb2.toString());
            }
            this.id = ByteArrays.getShort(rawData, 0 + offset);
            short flags = ByteArrays.getShort(rawData, 2 + offset);
            this.response = (flags & 0x8000) != 0;
            this.opCode = DnsOpCode.getInstance((byte)(flags >> 11 & 0xF));
            this.authoritativeAnswer = (flags & 0x400) != 0;
            this.truncated = (flags & 0x200) != 0;
            this.recursionDesired = (flags & 0x100) != 0;
            this.recursionAvailable = (flags & 0x80) != 0;
            this.reserved = (flags & 0x40) != 0;
            this.authenticData = (flags & 0x20) != 0;
            this.checkingDisabled = (flags & 0x10) != 0;
            this.rCode = DnsRCode.getInstance((byte)(flags & 0xF));
            this.qdCount = ByteArrays.getShort(rawData, 4 + offset);
            this.anCount = ByteArrays.getShort(rawData, 6 + offset);
            this.nsCount = ByteArrays.getShort(rawData, 8 + offset);
            this.arCount = ByteArrays.getShort(rawData, 10 + offset);
            int qdCnt = this.getQdCountAsInt();
            int anCnt = this.getAnCountAsInt();
            int nsCnt = this.getNsCountAsInt();
            int arCnt = this.getArCountAsInt();
            this.questions = new ArrayList<DnsQuestion>(qdCnt);
            this.answers = new ArrayList<DnsResourceRecord>(anCnt);
            this.authorities = new ArrayList<DnsResourceRecord>(nsCnt);
            this.additionalInfo = new ArrayList<DnsResourceRecord>(arCnt);
            int cursor = 12;
            for (i2 = 0; i2 < qdCnt; ++i2) {
                remainingLen = length - cursor;
                if (remainingLen == 0) {
                    sb = new StringBuilder(200);
                    sb.append("The data is too short to build a question in DnsHeader. data: ").append(ByteArrays.toHexString(rawData, " ")).append(", offset: ").append(offset).append(", length: ").append(length).append(", cursor: ").append(cursor);
                    throw new IllegalRawDataException(sb.toString());
                }
                DnsQuestion question = DnsQuestion.newInstance(rawData, offset + cursor, remainingLen);
                this.questions.add(question);
                cursor += question.length();
            }
            for (i2 = 0; i2 < anCnt; ++i2) {
                remainingLen = length - cursor;
                if (remainingLen == 0) {
                    sb = new StringBuilder(200);
                    sb.append("The data is too short to build an answer in DnsHeader. data: ").append(ByteArrays.toHexString(rawData, " ")).append(", offset: ").append(offset).append(", length: ").append(length).append(", cursor: ").append(cursor);
                    throw new IllegalRawDataException(sb.toString());
                }
                DnsResourceRecord answer = DnsResourceRecord.newInstance(rawData, offset + cursor, remainingLen);
                this.answers.add(answer);
                cursor += answer.length();
            }
            for (i2 = 0; i2 < nsCnt; ++i2) {
                remainingLen = length - cursor;
                if (remainingLen == 0) {
                    sb = new StringBuilder(200);
                    sb.append("The data is too short to build an authority in DnsHeader. data: ").append(ByteArrays.toHexString(rawData, " ")).append(", offset: ").append(offset).append(", length: ").append(length).append(", cursor: ").append(cursor);
                    throw new IllegalRawDataException(sb.toString());
                }
                DnsResourceRecord authority = DnsResourceRecord.newInstance(rawData, offset + cursor, remainingLen);
                this.authorities.add(authority);
                cursor += authority.length();
            }
            for (i2 = 0; i2 < arCnt; ++i2) {
                remainingLen = length - cursor;
                if (remainingLen == 0) {
                    sb = new StringBuilder(200);
                    sb.append("The data is too short to build additional info in DnsHeader. data: ").append(ByteArrays.toHexString(rawData, " ")).append(", offset: ").append(offset).append(", length: ").append(length).append(", cursor: ").append(cursor);
                    throw new IllegalRawDataException(sb.toString());
                }
                DnsResourceRecord info = DnsResourceRecord.newInstance(rawData, offset + cursor, remainingLen);
                this.additionalInfo.add(info);
                cursor += info.length();
            }
        }

        private DnsHeader(Builder builder) {
            this.id = builder.id;
            this.response = builder.response;
            this.opCode = builder.opCode;
            this.authoritativeAnswer = builder.authoritativeAnswer;
            this.truncated = builder.truncated;
            this.recursionDesired = builder.recursionDesired;
            this.recursionAvailable = builder.recursionAvailable;
            this.reserved = builder.reserved;
            this.authenticData = builder.authenticData;
            this.checkingDisabled = builder.checkingDisabled;
            this.rCode = builder.rCode;
            this.qdCount = builder.qdCount;
            this.anCount = builder.anCount;
            this.nsCount = builder.nsCount;
            this.arCount = builder.arCount;
            if (builder.questions != null) {
                if (builder.questions.size() > 65535) {
                    throw new IllegalArgumentException("The number of questions must be less than 65536. builder.questions.size(): " + builder.questions.size());
                }
                this.questions = new ArrayList<DnsQuestion>(builder.questions);
            } else {
                this.questions = Collections.emptyList();
            }
            if (builder.answers != null) {
                if (builder.answers.size() > 65535) {
                    throw new IllegalArgumentException("The number of answers must be less than 65536. builder.answers.size(): " + builder.answers.size());
                }
                this.answers = new ArrayList<DnsResourceRecord>(builder.answers);
            } else {
                this.answers = Collections.emptyList();
            }
            if (builder.authorities != null) {
                if (builder.authorities.size() > 65535) {
                    throw new IllegalArgumentException("The number of authorities must be less than 65536. builder.authorities.size(): " + builder.authorities.size());
                }
                this.authorities = new ArrayList<DnsResourceRecord>(builder.authorities);
            } else {
                this.authorities = Collections.emptyList();
            }
            if (builder.additionalInfo != null) {
                if (builder.additionalInfo.size() > 65535) {
                    throw new IllegalArgumentException("The number of additionalInfo elements must be less than 65536. builder.additionalInfo.size(): " + builder.additionalInfo.size());
                }
                this.additionalInfo = new ArrayList<DnsResourceRecord>(builder.additionalInfo);
            } else {
                this.additionalInfo = Collections.emptyList();
            }
        }

        public short getId() {
            return this.id;
        }

        public boolean isResponse() {
            return this.response;
        }

        public DnsOpCode getOpCode() {
            return this.opCode;
        }

        public boolean isAuthoritativeAnswer() {
            return this.authoritativeAnswer;
        }

        public boolean isTruncated() {
            return this.truncated;
        }

        public boolean isRecursionDesired() {
            return this.recursionDesired;
        }

        public boolean isRecursionAvailable() {
            return this.recursionAvailable;
        }

        public boolean getReservedBit() {
            return this.reserved;
        }

        public boolean isAuthenticData() {
            return this.authenticData;
        }

        public boolean isCheckingDisabled() {
            return this.checkingDisabled;
        }

        public DnsRCode getrCode() {
            return this.rCode;
        }

        public short getQdCount() {
            return this.qdCount;
        }

        public int getQdCountAsInt() {
            return this.qdCount & 0xFFFF;
        }

        public short getAnCount() {
            return this.anCount;
        }

        public int getAnCountAsInt() {
            return this.anCount & 0xFFFF;
        }

        public short getNsCount() {
            return this.nsCount;
        }

        public int getNsCountAsInt() {
            return this.nsCount & 0xFFFF;
        }

        public short getArCount() {
            return this.arCount;
        }

        public int getArCountAsInt() {
            return this.arCount & 0xFFFF;
        }

        public List<DnsQuestion> getQuestions() {
            return new ArrayList<DnsQuestion>(this.questions);
        }

        public List<DnsResourceRecord> getAnswers() {
            return new ArrayList<DnsResourceRecord>(this.answers);
        }

        public List<DnsResourceRecord> getAuthorities() {
            return new ArrayList<DnsResourceRecord>(this.authorities);
        }

        public List<DnsResourceRecord> getAdditionalInfo() {
            return new ArrayList<DnsResourceRecord>(this.additionalInfo);
        }

        @Override
        protected List<byte[]> getRawFields() {
            ArrayList<byte[]> rawFields = new ArrayList<byte[]>();
            rawFields.add(ByteArrays.toByteArray(this.id));
            byte[] flags = new byte[2];
            flags[0] = (byte)((Byte)this.opCode.value() << 3);
            if (this.response) {
                flags[0] = (byte)(flags[0] | 0x80);
            }
            if (this.authoritativeAnswer) {
                flags[0] = (byte)(flags[0] | 4);
            }
            if (this.truncated) {
                flags[0] = (byte)(flags[0] | 2);
            }
            if (this.recursionDesired) {
                flags[0] = (byte)(flags[0] | 1);
            }
            flags[1] = (Byte)this.rCode.value();
            if (this.recursionAvailable) {
                flags[1] = (byte)(flags[1] | 0x80);
            }
            if (this.reserved) {
                flags[1] = (byte)(flags[1] | 0x40);
            }
            if (this.authenticData) {
                flags[1] = (byte)(flags[1] | 0x20);
            }
            if (this.checkingDisabled) {
                flags[1] = (byte)(flags[1] | 0x10);
            }
            rawFields.add(flags);
            rawFields.add(ByteArrays.toByteArray(this.qdCount));
            rawFields.add(ByteArrays.toByteArray(this.anCount));
            rawFields.add(ByteArrays.toByteArray(this.nsCount));
            rawFields.add(ByteArrays.toByteArray(this.arCount));
            for (DnsQuestion question : this.questions) {
                rawFields.add(question.getRawData());
            }
            for (DnsResourceRecord answer : this.answers) {
                rawFields.add(answer.getRawData());
            }
            for (DnsResourceRecord authority : this.authorities) {
                rawFields.add(authority.getRawData());
            }
            for (DnsResourceRecord info : this.additionalInfo) {
                rawFields.add(info.getRawData());
            }
            return rawFields;
        }

        @Override
        public int length() {
            int len = 12;
            for (DnsQuestion question : this.questions) {
                len += question.length();
            }
            for (DnsResourceRecord answer : this.answers) {
                len += answer.length();
            }
            for (DnsResourceRecord authority : this.authorities) {
                len += authority.length();
            }
            for (DnsResourceRecord info : this.additionalInfo) {
                len += info.length();
            }
            return len;
        }

        @Override
        protected String buildString() {
            StringBuilder sb = new StringBuilder();
            String ls = System.getProperty("line.separator");
            sb.append("[DNS Header (").append(this.length()).append(" bytes)]").append(ls);
            sb.append("  ID: ").append("0x" + ByteArrays.toHexString(this.id, "")).append(ls);
            sb.append("  QR: ").append(this.response ? "response" : "query").append(ls);
            sb.append("  OPCODE: ").append(this.opCode).append(ls);
            sb.append("  Authoritative Answer: ").append(this.authoritativeAnswer).append(ls);
            sb.append("  Truncated: ").append(this.truncated).append(ls);
            sb.append("  Recursion Desired: ").append(this.recursionDesired).append(ls);
            sb.append("  Recursion Available: ").append(this.recursionAvailable).append(ls);
            sb.append("  Reserved Bit: ").append(this.reserved ? 1 : 0).append(ls);
            sb.append("  Authentic Data: ").append(this.authenticData).append(ls);
            sb.append("  Checking Disabled: ").append(this.checkingDisabled).append(ls);
            sb.append("  RCODE: ").append(this.rCode).append(ls);
            sb.append("  QDCOUNT: ").append(this.qdCount).append(ls);
            sb.append("  ANCOUNT: ").append(this.anCount).append(ls);
            sb.append("  NSCOUNT: ").append(this.nsCount).append(ls);
            sb.append("  ARCOUNT: ").append(this.arCount).append(ls);
            byte[] headerRawData = this.getRawData();
            for (DnsQuestion question : this.questions) {
                sb.append("  Question:").append(ls).append(question.toString("    ", headerRawData));
            }
            for (DnsResourceRecord answer : this.answers) {
                sb.append("  Answer:").append(ls).append(answer.toString("    ", headerRawData));
            }
            for (DnsResourceRecord authority : this.authorities) {
                sb.append("  Authority:").append(ls).append(authority.toString("    ", headerRawData));
            }
            for (DnsResourceRecord info : this.additionalInfo) {
                sb.append("  Additional:").append(ls).append(info.toString("    ", headerRawData));
            }
            return sb.toString();
        }

        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!super.equals(obj)) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            DnsHeader other = (DnsHeader)obj;
            if (!this.additionalInfo.equals(other.additionalInfo)) {
                return false;
            }
            if (this.anCount != other.anCount) {
                return false;
            }
            if (!this.answers.equals(other.answers)) {
                return false;
            }
            if (this.arCount != other.arCount) {
                return false;
            }
            if (this.authenticData != other.authenticData) {
                return false;
            }
            if (this.authoritativeAnswer != other.authoritativeAnswer) {
                return false;
            }
            if (!this.authorities.equals(other.authorities)) {
                return false;
            }
            if (this.checkingDisabled != other.checkingDisabled) {
                return false;
            }
            if (this.id != other.id) {
                return false;
            }
            if (this.nsCount != other.nsCount) {
                return false;
            }
            if (!this.opCode.equals(other.opCode)) {
                return false;
            }
            if (this.qdCount != other.qdCount) {
                return false;
            }
            if (!this.questions.equals(other.questions)) {
                return false;
            }
            if (!this.rCode.equals(other.rCode)) {
                return false;
            }
            if (this.recursionAvailable != other.recursionAvailable) {
                return false;
            }
            if (this.recursionDesired != other.recursionDesired) {
                return false;
            }
            if (this.reserved != other.reserved) {
                return false;
            }
            if (this.response != other.response) {
                return false;
            }
            return this.truncated == other.truncated;
        }

        @Override
        protected int calcHashCode() {
            int prime = 31;
            int result2 = 17;
            result2 = 31 * result2 + this.additionalInfo.hashCode();
            result2 = 31 * result2 + this.anCount;
            result2 = 31 * result2 + this.answers.hashCode();
            result2 = 31 * result2 + this.arCount;
            result2 = 31 * result2 + (this.authenticData ? 1231 : 1237);
            result2 = 31 * result2 + (this.authoritativeAnswer ? 1231 : 1237);
            result2 = 31 * result2 + this.authorities.hashCode();
            result2 = 31 * result2 + (this.checkingDisabled ? 1231 : 1237);
            result2 = 31 * result2 + this.id;
            result2 = 31 * result2 + this.nsCount;
            result2 = 31 * result2 + this.opCode.hashCode();
            result2 = 31 * result2 + this.qdCount;
            result2 = 31 * result2 + this.questions.hashCode();
            result2 = 31 * result2 + this.rCode.hashCode();
            result2 = 31 * result2 + (this.recursionAvailable ? 1231 : 1237);
            result2 = 31 * result2 + (this.recursionDesired ? 1231 : 1237);
            result2 = 31 * result2 + (this.reserved ? 1231 : 1237);
            result2 = 31 * result2 + (this.response ? 1231 : 1237);
            result2 = 31 * result2 + (this.truncated ? 1231 : 1237);
            return result2;
        }
    }

    public static final class Builder
    extends AbstractPacket.AbstractBuilder {
        private short id;
        private boolean response;
        private DnsOpCode opCode;
        private boolean authoritativeAnswer;
        private boolean truncated;
        private boolean recursionDesired;
        private boolean recursionAvailable;
        private boolean reserved;
        private boolean authenticData;
        private boolean checkingDisabled;
        private DnsRCode rCode;
        private short qdCount;
        private short anCount;
        private short nsCount;
        private short arCount;
        private List<DnsQuestion> questions;
        private List<DnsResourceRecord> answers;
        private List<DnsResourceRecord> authorities;
        private List<DnsResourceRecord> additionalInfo;

        public Builder() {
        }

        private Builder(DnsPacket packet) {
            this.id = packet.header.id;
            this.response = packet.header.response;
            this.opCode = packet.header.opCode;
            this.authoritativeAnswer = packet.header.authoritativeAnswer;
            this.truncated = packet.header.truncated;
            this.recursionDesired = packet.header.recursionDesired;
            this.recursionAvailable = packet.header.recursionAvailable;
            this.reserved = packet.header.reserved;
            this.authenticData = packet.header.authenticData;
            this.checkingDisabled = packet.header.checkingDisabled;
            this.rCode = packet.header.rCode;
            this.qdCount = packet.header.qdCount;
            this.anCount = packet.header.anCount;
            this.nsCount = packet.header.nsCount;
            this.arCount = packet.header.arCount;
            this.questions = packet.header.questions;
            this.answers = packet.header.answers;
            this.authorities = packet.header.authorities;
            this.additionalInfo = packet.header.additionalInfo;
        }

        public Builder id(short id) {
            this.id = id;
            return this;
        }

        public Builder response(boolean response) {
            this.response = response;
            return this;
        }

        public Builder opCode(DnsOpCode opCode) {
            this.opCode = opCode;
            return this;
        }

        public Builder authoritativeAnswer(boolean authoritativeAnswer) {
            this.authoritativeAnswer = authoritativeAnswer;
            return this;
        }

        public Builder truncated(boolean truncated) {
            this.truncated = truncated;
            return this;
        }

        public Builder recursionDesired(boolean recursionDesired) {
            this.recursionDesired = recursionDesired;
            return this;
        }

        public Builder recursionAvailable(boolean recursionAvailable) {
            this.recursionAvailable = recursionAvailable;
            return this;
        }

        public Builder reserved(boolean reserved) {
            this.reserved = reserved;
            return this;
        }

        public Builder authenticData(boolean authenticData) {
            this.authenticData = authenticData;
            return this;
        }

        public Builder checkingDisabled(boolean checkingDisabled) {
            this.checkingDisabled = checkingDisabled;
            return this;
        }

        public Builder rCode(DnsRCode rCode) {
            this.rCode = rCode;
            return this;
        }

        public Builder qdCount(short qdCount) {
            this.qdCount = qdCount;
            return this;
        }

        public Builder anCount(short anCount) {
            this.anCount = anCount;
            return this;
        }

        public Builder nsCount(short nsCount) {
            this.nsCount = nsCount;
            return this;
        }

        public Builder arCount(short arCount) {
            this.arCount = arCount;
            return this;
        }

        public Builder questions(List<DnsQuestion> questions) {
            this.questions = questions;
            return this;
        }

        public Builder answers(List<DnsResourceRecord> answers) {
            this.answers = answers;
            return this;
        }

        public Builder authorities(List<DnsResourceRecord> authorities) {
            this.authorities = authorities;
            return this;
        }

        public Builder additionalInfo(List<DnsResourceRecord> additionalInfo) {
            this.additionalInfo = additionalInfo;
            return this;
        }

        @Override
        public DnsPacket build() {
            return new DnsPacket(this);
        }
    }
}

