/*
 * Decompiled with CFR 0.152.
 */
package org.pcap4j.packet;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.pcap4j.packet.IllegalRawDataException;
import org.pcap4j.packet.LengthBuilder;
import org.pcap4j.packet.TcpPacket;
import org.pcap4j.packet.namednumber.TcpOptionKind;
import org.pcap4j.util.ByteArrays;

public final class TcpSackOption
implements TcpPacket.TcpOption {
    private static final long serialVersionUID = -3308738405807657257L;
    private final TcpOptionKind kind = TcpOptionKind.SACK;
    private final byte length;
    private final List<Sack> sacks = new ArrayList<Sack>();

    public static TcpSackOption newInstance(byte[] rawData, int offset, int length) throws IllegalRawDataException {
        ByteArrays.validateBounds(rawData, offset, length);
        return new TcpSackOption(rawData, offset, length);
    }

    private TcpSackOption(byte[] rawData, int offset, int length) throws IllegalRawDataException {
        if (length < 2) {
            StringBuilder sb = new StringBuilder(50);
            sb.append("The raw data length must be more than 1. rawData: ").append(ByteArrays.toHexString(rawData, " ")).append(", offset: ").append(offset).append(", length: ").append(length);
            throw new IllegalRawDataException(sb.toString());
        }
        if (rawData[offset] != (Byte)this.kind.value()) {
            StringBuilder sb = new StringBuilder(100);
            sb.append("The kind must be: ").append(this.kind.valueAsString()).append(" rawData: ").append(ByteArrays.toHexString(rawData, " ")).append(", offset: ").append(offset).append(", length: ").append(length);
            throw new IllegalRawDataException(sb.toString());
        }
        this.length = rawData[1 + offset];
        int lengthFieldAsInt = this.getLengthAsInt();
        if (lengthFieldAsInt < 2) {
            throw new IllegalRawDataException("The value of length field must be  more than 1 but: " + lengthFieldAsInt);
        }
        if ((lengthFieldAsInt - 2) % 8 != 0) {
            StringBuilder sb = new StringBuilder(100);
            sb.append("The value of length field must be an integer multiple of 8 octets long but: ").append(lengthFieldAsInt);
            throw new IllegalRawDataException(sb.toString());
        }
        if (length < lengthFieldAsInt) {
            StringBuilder sb = new StringBuilder(100);
            sb.append("rawData is too short. length field: ").append(lengthFieldAsInt).append(", rawData: ").append(ByteArrays.toHexString(rawData, " ")).append(", offset: ").append(offset).append(", length: ").append(length);
            throw new IllegalRawDataException(sb.toString());
        }
        for (int i2 = 2; i2 < lengthFieldAsInt; i2 += 8) {
            this.sacks.add(new Sack(ByteArrays.getInt(rawData, i2 + offset), ByteArrays.getInt(rawData, i2 + 4 + offset)));
        }
    }

    private TcpSackOption(Builder builder) {
        if (builder == null || builder.sacks == null) {
            StringBuilder sb = new StringBuilder();
            sb.append("builder: ").append(builder).append(" builder.sacks: ").append(builder.sacks);
            throw new NullPointerException(sb.toString());
        }
        this.sacks.addAll(builder.sacks);
        this.length = builder.correctLengthAtBuild ? (byte)this.length() : builder.length;
    }

    @Override
    public TcpOptionKind getKind() {
        return this.kind;
    }

    public byte getLength() {
        return this.length;
    }

    public int getLengthAsInt() {
        return 0xFF & this.length;
    }

    @Override
    public int length() {
        return this.sacks.size() * 4 * 2 + 2;
    }

    @Override
    public byte[] getRawData() {
        byte[] rawData = new byte[this.length()];
        rawData[0] = (Byte)this.kind.value();
        rawData[1] = this.length;
        int offset = 2;
        for (Sack sack : this.sacks) {
            System.arraycopy(ByteArrays.toByteArray(sack.leftEdge), 0, rawData, offset, 4);
            System.arraycopy(ByteArrays.toByteArray(sack.rightEdge), 0, rawData, offset + 4, 4);
            offset += 8;
        }
        return rawData;
    }

    public Builder getBuilder() {
        return new Builder(this);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("[Kind: ").append(this.kind);
        sb.append("] [Length: ").append(this.getLengthAsInt()).append(" bytes]");
        for (Sack sack : this.sacks) {
            sb.append(" [LE: ").append(sack.getLeftEdgeAsLong()).append(" RE: ").append(sack.getRightEdgeAsLong()).append("]");
        }
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!this.getClass().isInstance(obj)) {
            return false;
        }
        TcpSackOption other = (TcpSackOption)obj;
        return this.length == other.length && this.sacks.equals(other.sacks);
    }

    public int hashCode() {
        int result2 = 17;
        result2 = 31 * result2 + this.length;
        result2 = 31 * result2 + this.sacks.hashCode();
        return result2;
    }

    public static final class Sack
    implements Serializable {
        private static final long serialVersionUID = 1218420566089129438L;
        private final int leftEdge;
        private final int rightEdge;

        public Sack(int leftEdge, int rightEdge) {
            this.leftEdge = leftEdge;
            this.rightEdge = rightEdge;
        }

        public int getLeftEdge() {
            return this.leftEdge;
        }

        public long getLeftEdgeAsLong() {
            return 0xFFFFFFFFL & (long)this.leftEdge;
        }

        public int getRightEdge() {
            return this.rightEdge;
        }

        public long getRightEdgeAsLong() {
            return 0xFFFFFFFFL & (long)this.rightEdge;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!this.getClass().isInstance(obj)) {
                return false;
            }
            Sack other = (Sack)obj;
            return this.leftEdge == other.leftEdge && this.rightEdge == other.rightEdge;
        }

        public int hashCode() {
            int result2 = 17;
            result2 = 31 * result2 + this.leftEdge;
            result2 = 31 * result2 + this.rightEdge;
            return result2;
        }
    }

    public static final class Builder
    implements LengthBuilder<TcpSackOption> {
        private byte length;
        private boolean correctLengthAtBuild;
        private List<Sack> sacks;

        public Builder() {
        }

        private Builder(TcpSackOption option) {
            this.length = option.length;
        }

        public Builder length(byte length) {
            this.length = length;
            return this;
        }

        public Builder sacks(List<Sack> sacks) {
            this.sacks = sacks;
            return this;
        }

        public Builder correctLengthAtBuild(boolean correctLengthAtBuild) {
            this.correctLengthAtBuild = correctLengthAtBuild;
            return this;
        }

        @Override
        public TcpSackOption build() {
            return new TcpSackOption(this);
        }
    }
}

