/*
 * Decompiled with CFR 0.152.
 */
package org.pcap4j.packet;

import org.pcap4j.packet.IllegalRawDataException;
import org.pcap4j.packet.LlcPacket;
import org.pcap4j.packet.namednumber.LlcControlSupervisoryFunction;
import org.pcap4j.util.ByteArrays;

public final class LlcControlSupervisory
implements LlcPacket.LlcControl {
    private static final long serialVersionUID = 2248935134729569341L;
    private final byte receiveSequenceNumber;
    private final boolean pfBit;
    private final byte reserved;
    private final LlcControlSupervisoryFunction supervisoryFunction;

    public static LlcControlSupervisory newInstance(short value) throws IllegalRawDataException {
        return new LlcControlSupervisory(value);
    }

    private LlcControlSupervisory(short value) throws IllegalRawDataException {
        if ((value & 0x300) != 256) {
            StringBuilder sb = new StringBuilder(50);
            sb.append("value & 0x0300 must be 0x0100. value: ").append(ByteArrays.toHexString(value, " "));
            throw new IllegalRawDataException(sb.toString());
        }
        this.receiveSequenceNumber = (byte)(value >> 1 & 0x7F);
        this.pfBit = (value & 1) != 0;
        this.reserved = (byte)(value >> 12 & 0xF);
        this.supervisoryFunction = LlcControlSupervisoryFunction.getInstance((byte)(value >> 10 & 3));
    }

    private LlcControlSupervisory(Builder builder) {
        if (builder == null || builder.supervisoryFunction == null) {
            StringBuilder sb = new StringBuilder();
            sb.append("builder: ").append(builder).append(" builder.supervisoryFunction: ").append(builder.supervisoryFunction);
            throw new NullPointerException(sb.toString());
        }
        if (builder.receiveSequenceNumber < 0) {
            throw new IllegalArgumentException("receiveSequenceNumber must be positive. receiveSequenceNumber: " + builder.receiveSequenceNumber);
        }
        if ((builder.reserved & 0xFF00) != 0) {
            throw new IllegalArgumentException("reserved & 0xFF00 must be 0. reserved: " + builder.reserved);
        }
        this.receiveSequenceNumber = builder.receiveSequenceNumber;
        this.pfBit = builder.pfBit;
        this.reserved = builder.reserved;
        this.supervisoryFunction = builder.supervisoryFunction;
    }

    public byte getReceiveSequenceNumber() {
        return this.receiveSequenceNumber;
    }

    public int getReceiveSequenceNumberAsInt() {
        return this.receiveSequenceNumber;
    }

    public boolean getPfBit() {
        return this.pfBit;
    }

    public byte getReserved() {
        return this.reserved;
    }

    public LlcControlSupervisoryFunction getLlcSupervisoryFunction() {
        return this.supervisoryFunction;
    }

    @Override
    public int length() {
        return 2;
    }

    @Override
    public byte[] getRawData() {
        byte[] data = new byte[2];
        data[1] = (byte)(this.receiveSequenceNumber << 1);
        if (this.pfBit) {
            data[1] = (byte)(data[1] | 1);
        }
        data[0] = (byte)(1 | (Byte)this.supervisoryFunction.value() << 2 | this.reserved << 4);
        return data;
    }

    public Builder getBuilder() {
        return new Builder(this);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("[receive sequence number: ").append(this.receiveSequenceNumber).append("] [P/F bit: ").append(this.pfBit ? 1 : 0).append("] [reserved: ").append(this.reserved).append("] [supervisory function: ").append(this.supervisoryFunction).append("]");
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int result2 = 1;
        result2 = 31 * result2 + this.receiveSequenceNumber;
        result2 = 31 * result2 + (this.pfBit ? 1231 : 1237);
        result2 = 31 * result2 + this.reserved;
        result2 = 31 * result2 + this.supervisoryFunction.hashCode();
        return result2;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!this.getClass().isInstance(obj)) {
            return false;
        }
        LlcControlSupervisory other = (LlcControlSupervisory)obj;
        return this.receiveSequenceNumber == other.receiveSequenceNumber && this.supervisoryFunction.equals(other.supervisoryFunction) && this.reserved == other.reserved && this.pfBit == other.pfBit;
    }

    public static final class Builder {
        private byte receiveSequenceNumber;
        private boolean pfBit;
        private byte reserved;
        private LlcControlSupervisoryFunction supervisoryFunction;

        public Builder() {
        }

        private Builder(LlcControlSupervisory ctrl) {
            this.receiveSequenceNumber = ctrl.receiveSequenceNumber;
            this.pfBit = ctrl.pfBit;
            this.reserved = ctrl.reserved;
            this.supervisoryFunction = ctrl.supervisoryFunction;
        }

        public Builder receiveSequenceNumber(byte receiveSequenceNumber) {
            this.receiveSequenceNumber = receiveSequenceNumber;
            return this;
        }

        public Builder pfBit(boolean pfBit) {
            this.pfBit = pfBit;
            return this;
        }

        public Builder reserved(byte reserved) {
            this.reserved = reserved;
            return this;
        }

        public Builder supervisoryFunction(LlcControlSupervisoryFunction supervisoryFunction) {
            this.supervisoryFunction = supervisoryFunction;
            return this;
        }

        public LlcControlSupervisory build() {
            return new LlcControlSupervisory(this);
        }
    }
}

