/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.micrometer.impl;

import io.micrometer.core.instrument.Meter;
import io.micrometer.core.instrument.MeterRegistry;
import io.vertx.core.net.SocketAddress;
import io.vertx.core.spi.metrics.ClientMetrics;
import io.vertx.micrometer.Label;
import io.vertx.micrometer.MetricsNaming;
import io.vertx.micrometer.impl.AbstractMetrics;
import io.vertx.micrometer.impl.meters.Counters;
import io.vertx.micrometer.impl.meters.Gauges;
import io.vertx.micrometer.impl.meters.Timers;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.LongAdder;

class VertxClientMetrics
extends AbstractMetrics {
    private final Timers queueDelay;
    private final Gauges<LongAdder> queueSize;
    private final Timers processingTime;
    private final Gauges<LongAdder> processingPending;
    private final Counters resetCount;

    VertxClientMetrics(MeterRegistry registry, String type, MetricsNaming names, ConcurrentMap<Meter.Id, Object> gaugesTable) {
        super(registry, type, gaugesTable);
        this.queueDelay = this.timers(names.getClientQueueTime(), "Time spent in queue before being processed", Label.REMOTE, Label.NAMESPACE);
        this.queueSize = this.longGauges(names.getClientQueuePending(), "Number of pending elements in queue", Label.REMOTE, Label.NAMESPACE);
        this.processingTime = this.timers(names.getClientProcessingTime(), "Processing time, from request start to response end", Label.REMOTE, Label.NAMESPACE);
        this.processingPending = this.longGauges(names.getClientProcessingPending(), "Number of elements being processed", Label.REMOTE, Label.NAMESPACE);
        this.resetCount = this.counters(names.getClientResetsCount(), "Total number of resets", Label.REMOTE, Label.NAMESPACE);
    }

    ClientMetrics forInstance(SocketAddress remoteAddress, String namespace) {
        return new Instance(remoteAddress, namespace);
    }

    class Instance
    implements ClientMetrics<Timers.EventTiming, Timers.EventTiming, Object, Object> {
        private final String remote;
        private final String namespace;

        Instance(SocketAddress remoteAddress, String namespace) {
            this.remote = remoteAddress == null ? "" : remoteAddress.toString();
            this.namespace = namespace == null ? "" : namespace;
        }

        @Override
        public Timers.EventTiming enqueueRequest() {
            ((LongAdder)VertxClientMetrics.this.queueSize.get(this.remote, this.namespace)).increment();
            return VertxClientMetrics.this.queueDelay.start();
        }

        @Override
        public void dequeueRequest(Timers.EventTiming taskMetric) {
            ((LongAdder)VertxClientMetrics.this.queueSize.get(this.remote, this.namespace)).decrement();
            taskMetric.end(this.remote, this.namespace);
        }

        @Override
        public Timers.EventTiming requestBegin(String uri, Object request) {
            ((LongAdder)VertxClientMetrics.this.processingPending.get(this.remote, this.namespace)).increment();
            return VertxClientMetrics.this.processingTime.start();
        }

        @Override
        public void requestEnd(Timers.EventTiming requestMetric) {
        }

        @Override
        public void responseBegin(Timers.EventTiming requestMetric, Object response) {
        }

        @Override
        public void requestReset(Timers.EventTiming requestMetric) {
            ((LongAdder)VertxClientMetrics.this.processingPending.get(this.remote, this.namespace)).decrement();
            requestMetric.end(this.remote, this.namespace);
            VertxClientMetrics.this.resetCount.get(this.remote, this.namespace).increment();
        }

        @Override
        public void responseEnd(Timers.EventTiming requestMetric) {
            ((LongAdder)VertxClientMetrics.this.processingPending.get(this.remote, this.namespace)).decrement();
            requestMetric.end(this.remote, this.namespace);
        }

        @Override
        public void close() {
        }
    }
}

