/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.config.impl.spi;

import io.vertx.config.spi.ConfigProcessor;
import io.vertx.core.Future;
import io.vertx.core.Vertx;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.impl.VertxInternal;
import io.vertx.core.impl.future.PromiseInternal;
import io.vertx.core.json.JsonObject;

public class RawProcessor
implements ConfigProcessor {
    @Override
    public String name() {
        return "raw";
    }

    @Override
    public Future<JsonObject> process(Vertx vertx, JsonObject configuration, Buffer input) {
        PromiseInternal<JsonObject> promise = ((VertxInternal)vertx).promise();
        String key = configuration.getString("raw.key");
        String type = configuration.getString("raw.type", "string");
        if (key == null) {
            promise.fail("The `raw.key` is required in the configuration when using the `raw` processor.");
        } else {
            JsonObject json = new JsonObject();
            try {
                switch (type) {
                    case "string": {
                        json.put(key, input.toString(configuration.getString("raw.encoding", "utf-8")));
                        promise.complete(json);
                        break;
                    }
                    case "json-object": {
                        json.put(key, input.toJsonObject());
                        promise.complete(json);
                        break;
                    }
                    case "json-array": {
                        json.put(key, input.toJsonArray());
                        promise.complete(json);
                        break;
                    }
                    case "binary": {
                        json.put(key, input.getBytes());
                        promise.complete(json);
                        break;
                    }
                    default: {
                        promise.fail("Unrecognized `raw.type` : " + type);
                        break;
                    }
                }
            }
            catch (Exception e) {
                promise.fail(e);
            }
        }
        return promise.future();
    }
}

