/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.shaded.reactor.netty.tcp;

import io.micrometer.shaded.io.netty.channel.EventLoopGroup;
import io.micrometer.shaded.io.netty.channel.group.ChannelGroup;
import io.micrometer.shaded.io.netty.handler.logging.LogLevel;
import io.micrometer.shaded.io.netty.handler.ssl.JdkSslContext;
import io.micrometer.shaded.io.netty.handler.ssl.OpenSsl;
import io.micrometer.shaded.org.reactorstreams.Publisher;
import io.micrometer.shaded.reactor.core.publisher.Mono;
import io.micrometer.shaded.reactor.netty.Connection;
import io.micrometer.shaded.reactor.netty.DisposableServer;
import io.micrometer.shaded.reactor.netty.NettyInbound;
import io.micrometer.shaded.reactor.netty.NettyOutbound;
import io.micrometer.shaded.reactor.netty.ReactorNetty;
import io.micrometer.shaded.reactor.netty.channel.ChannelMetricsRecorder;
import io.micrometer.shaded.reactor.netty.resources.LoopResources;
import io.micrometer.shaded.reactor.netty.tcp.SslProvider;
import io.micrometer.shaded.reactor.netty.tcp.TcpServerBind;
import io.micrometer.shaded.reactor.netty.tcp.TcpServerConfig;
import io.micrometer.shaded.reactor.netty.transport.ServerTransport;
import io.micrometer.shaded.reactor.util.Logger;
import io.micrometer.shaded.reactor.util.Loggers;
import java.net.SocketAddress;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Supplier;

public abstract class TcpServer
extends ServerTransport<TcpServer, TcpServerConfig> {
    static final Logger log = Loggers.getLogger(TcpServer.class);

    public static TcpServer create() {
        return TcpServerBind.INSTANCE;
    }

    @Override
    public TcpServer bindAddress(Supplier<? extends SocketAddress> bindAddressSupplier) {
        return (TcpServer)super.bindAddress(bindAddressSupplier);
    }

    @Override
    public TcpServer channelGroup(ChannelGroup channelGroup) {
        return (TcpServer)super.channelGroup(channelGroup);
    }

    @Override
    public TcpServer doOnBind(Consumer<? super TcpServerConfig> doOnBind) {
        return (TcpServer)super.doOnBind(doOnBind);
    }

    @Override
    public TcpServer doOnBound(Consumer<? super DisposableServer> doOnBound) {
        return (TcpServer)super.doOnBound(doOnBound);
    }

    @Override
    public TcpServer doOnConnection(Consumer<? super Connection> doOnConnection) {
        return (TcpServer)super.doOnConnection(doOnConnection);
    }

    @Override
    public TcpServer doOnUnbound(Consumer<? super DisposableServer> doOnUnbound) {
        return (TcpServer)super.doOnUnbound(doOnUnbound);
    }

    public TcpServer handle(BiFunction<? super NettyInbound, ? super NettyOutbound, ? extends Publisher<Void>> handler) {
        Objects.requireNonNull(handler, "handler");
        return this.doOnConnection((Consumer)new OnConnectionHandle(handler));
    }

    @Override
    public TcpServer host(String host) {
        return (TcpServer)super.host(host);
    }

    @Override
    public TcpServer metrics(boolean enable) {
        return (TcpServer)super.metrics(enable);
    }

    @Override
    public TcpServer metrics(boolean enable, Supplier<? extends ChannelMetricsRecorder> recorder) {
        return (TcpServer)super.metrics(enable, recorder);
    }

    public TcpServer noSSL() {
        if (((TcpServerConfig)this.configuration()).isSecure()) {
            TcpServer dup = (TcpServer)this.duplicate();
            ((TcpServerConfig)dup.configuration()).sslProvider = null;
            return dup;
        }
        return this;
    }

    @Override
    public TcpServer port(int port) {
        return (TcpServer)super.port(port);
    }

    @Override
    public TcpServer runOn(EventLoopGroup eventLoopGroup) {
        return (TcpServer)super.runOn(eventLoopGroup);
    }

    @Override
    public TcpServer runOn(LoopResources channelResources) {
        return (TcpServer)super.runOn(channelResources);
    }

    @Override
    public TcpServer runOn(LoopResources loopResources, boolean preferNative) {
        return (TcpServer)super.runOn(loopResources, preferNative);
    }

    public TcpServer secure(Consumer<? super SslProvider.SslContextSpec> sslProviderBuilder) {
        Objects.requireNonNull(sslProviderBuilder, "sslProviderBuilder");
        TcpServer dup = (TcpServer)this.duplicate();
        SslProvider.SslContextSpec builder = SslProvider.builder();
        sslProviderBuilder.accept(builder);
        ((TcpServerConfig)dup.configuration()).sslProvider = ((SslProvider.Builder)((Object)builder)).build();
        return dup;
    }

    public TcpServer secure(SslProvider sslProvider) {
        Objects.requireNonNull(sslProvider, "sslProvider");
        TcpServer dup = (TcpServer)this.duplicate();
        ((TcpServerConfig)dup.configuration()).sslProvider = sslProvider;
        return dup;
    }

    @Override
    public Mono<Void> warmup() {
        return Mono.when(super.warmup(), Mono.fromRunnable(() -> {
            SslProvider provider = ((TcpServerConfig)this.configuration()).sslProvider();
            if (provider != null && !(provider.getSslContext() instanceof JdkSslContext)) {
                OpenSsl.version();
            }
        }));
    }

    @Override
    public TcpServer wiretap(boolean enable) {
        return (TcpServer)super.wiretap(enable);
    }

    @Override
    public TcpServer wiretap(String category) {
        return (TcpServer)super.wiretap(category);
    }

    @Override
    public TcpServer wiretap(String category, LogLevel level) {
        return (TcpServer)super.wiretap(category, level);
    }

    static final class OnConnectionHandle
    implements Consumer<Connection> {
        final BiFunction<? super NettyInbound, ? super NettyOutbound, ? extends Publisher<Void>> handler;

        OnConnectionHandle(BiFunction<? super NettyInbound, ? super NettyOutbound, ? extends Publisher<Void>> handler) {
            this.handler = handler;
        }

        @Override
        public void accept(Connection c) {
            if (log.isDebugEnabled()) {
                log.debug(ReactorNetty.format(c.channel(), "Handler is being applied: {}"), this.handler);
            }
            Mono.fromDirect(this.handler.apply(c.inbound(), c.outbound())).subscribe(c.disposeSubscriber());
        }
    }
}

