/*
 * Decompiled with CFR 0.152.
 */
package org.pcap4j.util;

import org.pcap4j.packet.ChecksumBuilder;
import org.pcap4j.packet.LengthBuilder;
import org.pcap4j.packet.Packet;
import org.pcap4j.packet.UnknownPacket;
import org.pcap4j.util.ByteArrays;

public final class IcmpV6Helper {
    private IcmpV6Helper() {
        throw new AssertionError();
    }

    public static Packet makePacketForInvokingPacketField(Packet packet, int size) {
        int length;
        if (packet == null || packet.getHeader() == null || packet.getPayload() == null) {
            StringBuilder sb = new StringBuilder();
            sb.append("packet: ").append(packet).append(" packet.getHeader(): ").append(packet.getHeader()).append(" packet.getPayload(): ").append(packet.getPayload());
            throw new NullPointerException(sb.toString());
        }
        if (packet.length() <= size) {
            return packet;
        }
        int prelength = length = packet.getHeader().length();
        int pos = 0;
        Packet last2 = null;
        for (Packet p : packet.getPayload()) {
            if (p.getHeader() != null) {
                prelength = length;
                ++pos;
                if ((length += p.getHeader().length()) <= size) continue;
                last2 = p;
                break;
            }
            prelength = length;
            length += p.length();
            ++pos;
            last2 = p;
            break;
        }
        Packet.Builder resultBuilder = packet.getBuilder();
        for (Packet.Builder b : resultBuilder) {
            if (b instanceof LengthBuilder) {
                ((LengthBuilder)((Object)b)).correctLengthAtBuild(false);
            }
            if (b instanceof ChecksumBuilder) {
                ((ChecksumBuilder)((Object)b)).correctChecksumAtBuild(false);
            }
            if (--pos != 0) continue;
            if (size - prelength > 0) {
                b.payloadBuilder(new UnknownPacket.Builder().rawData(ByteArrays.getSubArray(last2.getRawData(), 0, size - prelength)));
                break;
            }
            b.payloadBuilder(null);
            break;
        }
        return resultBuilder.build();
    }

    public static Packet makePacketForRedirectHeaderOption(Packet packet, int size) {
        if (packet.length() > size) {
            return IcmpV6Helper.makePacketForInvokingPacketField(packet, size - size % 8);
        }
        int length = packet.length();
        return IcmpV6Helper.makePacketForInvokingPacketField(packet, length - length % 8);
    }
}

