/*
 * Decompiled with CFR 0.152.
 */
package org.pcap4j.packet;

import org.pcap4j.packet.DnsDomainName;
import org.pcap4j.packet.DnsResourceRecord;
import org.pcap4j.packet.IllegalRawDataException;
import org.pcap4j.util.ByteArrays;

public final class DnsRDataMx
implements DnsResourceRecord.DnsRData {
    private static final long serialVersionUID = -5914050306503756427L;
    private final short preference;
    private final DnsDomainName exchange;

    public static DnsRDataMx newInstance(byte[] rawData, int offset, int length) throws IllegalRawDataException {
        ByteArrays.validateBounds(rawData, offset, length);
        return new DnsRDataMx(rawData, offset, length);
    }

    private DnsRDataMx(byte[] rawData, int offset, int length) throws IllegalRawDataException {
        if (length < 3) {
            StringBuilder sb = new StringBuilder(200);
            sb.append("The data is too short to build a DnsRDataMx (").append(3).append(" bytes at least). data: ").append(ByteArrays.toHexString(rawData, " ")).append(", offset: ").append(offset).append(", length: ").append(length);
            throw new IllegalRawDataException(sb.toString());
        }
        this.preference = ByteArrays.getShort(rawData, offset);
        this.exchange = DnsDomainName.newInstance(rawData, offset + 2, length - 2);
    }

    private DnsRDataMx(Builder builder) {
        if (builder == null || builder.exchange == null) {
            StringBuilder sb = new StringBuilder();
            sb.append("builder: ").append(builder).append(" builder.exchange: ").append(builder.exchange);
            throw new NullPointerException(sb.toString());
        }
        this.preference = builder.preference;
        this.exchange = builder.exchange;
    }

    public short getPreference() {
        return this.preference;
    }

    public int getPreferenceAsInt() {
        return this.preference;
    }

    public DnsDomainName getExchange() {
        return this.exchange;
    }

    @Override
    public int length() {
        return this.exchange.length() + 2;
    }

    @Override
    public byte[] getRawData() {
        byte[] exRawData = this.exchange.getRawData();
        byte[] data = new byte[exRawData.length + 2];
        System.arraycopy(ByteArrays.toByteArray(this.preference), 0, data, 0, 2);
        System.arraycopy(exRawData, 0, data, 2, exRawData.length);
        return data;
    }

    public Builder getBuilder() {
        return new Builder(this);
    }

    public String toString() {
        return this.convertToString("", null);
    }

    @Override
    public String toString(String indent) {
        return this.convertToString(indent, null);
    }

    @Override
    public String toString(String indent, byte[] headerRawData) {
        if (headerRawData == null) {
            throw new NullPointerException("headerRawData is null.");
        }
        return this.convertToString(indent, headerRawData);
    }

    private String convertToString(String indent, byte[] headerRawData) {
        StringBuilder sb = new StringBuilder();
        String ls = System.getProperty("line.separator");
        sb.append(indent).append("MX RDATA:").append(ls).append(indent).append("  PREFERENCE: ").append(this.preference).append(ls).append(indent).append("  EXCHANGE: ").append(headerRawData != null ? this.exchange.toString(headerRawData) : this.exchange.toString()).append(ls);
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int result2 = 1;
        result2 = 31 * result2 + this.exchange.hashCode();
        result2 = 31 * result2 + this.preference;
        return result2;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DnsRDataMx other = (DnsRDataMx)obj;
        if (!this.exchange.equals(other.exchange)) {
            return false;
        }
        return this.preference == other.preference;
    }

    public static final class Builder {
        private short preference;
        private DnsDomainName exchange;

        public Builder() {
        }

        private Builder(DnsRDataMx obj) {
            this.preference = obj.preference;
            this.exchange = obj.exchange;
        }

        public Builder preference(short preference) {
            this.preference = preference;
            return this;
        }

        public Builder exchange(DnsDomainName exchange) {
            this.exchange = exchange;
            return this;
        }

        public DnsRDataMx build() {
            return new DnsRDataMx(this);
        }
    }
}

