/*
 * Decompiled with CFR 0.152.
 */
package io.sip3.captain.ce.capturing;

import io.micrometer.core.instrument.Counter;
import io.micrometer.core.instrument.Metrics;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.sip3.captain.ce.capturing.DpdkEngine;
import io.sip3.captain.ce.domain.Packet;
import io.sip3.captain.ce.pipeline.EthernetHandler;
import io.sip3.commons.domain.payload.ByteBufPayload;
import io.sip3.commons.vertx.annotations.ConditionalOnProperty;
import io.sip3.commons.vertx.annotations.Instance;
import io.sip3.commons.vertx.util.VertxUtilKt;
import io.vertx.core.AbstractVerticle;
import io.vertx.core.Vertx;
import io.vertx.core.json.JsonObject;
import java.nio.ByteBuffer;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicLong;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import mu.KLogger;
import mu.KotlinLogging;
import org.jetbrains.annotations.NotNull;

@Instance(singleton=true)
@ConditionalOnProperty(pointer="/dpdk")
@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0007\b\u0007\u0018\u00002\u00020\u0001:\u0001'B\u0005\u00a2\u0006\u0002\u0010\u0002J!\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0011\u001a\u00020\u00042\u0006\u0010\u0014\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u0004H\u0086 J!\u0010\u0019\u001a\u00020\u00182\u0006\u0010\u001a\u001a\u00020\u00042\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001d0\u001c\u00a2\u0006\u0002\u0010\u001eJ&\u0010\u001f\u001a\u00020\u00182\u0006\u0010\u001a\u001a\u00020\u00042\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020\u00042\u0006\u0010#\u001a\u00020!J\b\u0010$\u001a\u00020\u0018H\u0016J\b\u0010%\u001a\u00020\u0018H\u0016J\t\u0010&\u001a\u00020\u0018H\u0086 R\u001a\u0010\u0003\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR\u001a\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000e\u001a\n \u0010*\u0004\u0018\u00010\u000f0\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0011\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0006\"\u0004\b\u0013\u0010\bR\u001a\u0010\u0014\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u0006\"\u0004\b\u0016\u0010\b\u00a8\u0006("}, d2={"Lio/sip3/captain/ce/capturing/DpdkEngine;", "Lio/vertx/core/AbstractVerticle;", "()V", "bulkSize", "", "getBulkSize", "()I", "setBulkSize", "(I)V", "cores", "", "Lio/sip3/captain/ce/capturing/DpdkEngine$Core;", "logger", "Lmu/KLogger;", "packetsCaptured", "Lio/micrometer/core/instrument/Counter;", "kotlin.jvm.PlatformType", "port", "getPort", "setPort", "rxQueueSize", "getRxQueueSize", "setRxQueueSize", "bind", "", "initDpdkCore", "coreId", "buffers", "", "Ljava/nio/ByteBuffer;", "(I[Ljava/nio/ByteBuffer;)V", "onDpdkPackets", "sec", "", "usec", "packetsReceived", "start", "stop", "unbind", "Core", "sip3-captain-ce"})
public final class DpdkEngine
extends AbstractVerticle {
    @NotNull
    private final KLogger logger = KotlinLogging.INSTANCE.logger(logger.1.INSTANCE);
    private int port;
    private int rxQueueSize;
    private int bulkSize;
    private final Counter packetsCaptured;
    @NotNull
    private final Map<Integer, Core> cores;

    public DpdkEngine() {
        try {
            System.loadLibrary("sip3-dpdk");
        }
        catch (Throwable t) {
            this.logger.error("System 'loadLibrary()' failed. Make sure that you are using SIP3 Captain `Enterprise Edition`.", t);
            Vertx vertx = this.vertx;
            Intrinsics.checkNotNullExpressionValue(vertx, "vertx");
            VertxUtilKt.closeAndExitProcess$default(vertx, 0, 1, null);
        }
        this.rxQueueSize = 1;
        this.bulkSize = 1;
        String[] stringArray = new String[]{"source", "dpdk"};
        this.packetsCaptured = Metrics.counter("packets_captured", stringArray);
        this.cores = new LinkedHashMap();
    }

    public final native void bind(int var1, int var2, int var3);

    public final native void unbind();

    public final int getPort() {
        return this.port;
    }

    public final void setPort(int n) {
        this.port = n;
    }

    public final int getRxQueueSize() {
        return this.rxQueueSize;
    }

    public final void setRxQueueSize(int n) {
        this.rxQueueSize = n;
    }

    public final int getBulkSize() {
        return this.bulkSize;
    }

    public final void setBulkSize(int n) {
        this.bulkSize = n;
    }

    @Override
    public void start() {
        int it;
        Integer n;
        JsonObject config2 = this.config().getJsonObject("dpdk");
        boolean bl = false;
        Integer n2 = n = config2.getInteger("port");
        if (n2 != null) {
            Intrinsics.checkNotNullExpressionValue(n2, "getInteger(\"port\")");
            it = ((Number)n).intValue();
            boolean bl2 = false;
            this.port = it;
        }
        Integer n3 = n = config2.getInteger("rx_queue_size");
        if (n3 != null) {
            Intrinsics.checkNotNullExpressionValue(n3, "getInteger(\"rx_queue_size\")");
            it = ((Number)n).intValue();
            boolean bl3 = false;
            this.rxQueueSize = it;
        }
        Integer n4 = n = config2.getInteger("bulk_size");
        if (n4 != null) {
            Intrinsics.checkNotNullExpressionValue(n4, "getInteger(\"bulk_size\")");
            it = ((Number)n).intValue();
            boolean bl4 = false;
            this.bulkSize = it;
        }
        Executors.newSingleThreadExecutor().execute(() -> DpdkEngine.start$lambda$4(this));
        this.vertx.setPeriodic(1000L, arg_0 -> DpdkEngine.start$lambda$7(this, arg_0));
    }

    public final synchronized void initDpdkCore(int coreId, @NotNull ByteBuffer[] buffers) {
        Core core;
        Intrinsics.checkNotNullParameter(buffers, "buffers");
        Map<Integer, Core> map2 = this.cores;
        Integer n = coreId;
        Core $this$initDpdkCore_u24lambda_u248 = core = new Core();
        boolean bl = false;
        $this$initDpdkCore_u24lambda_u248.setPacketsCaptured(new AtomicLong(0L));
        $this$initDpdkCore_u24lambda_u248.setBuffers(buffers);
        Vertx vertx = this.vertx;
        Intrinsics.checkNotNullExpressionValue(vertx, "vertx");
        JsonObject jsonObject = this.config();
        Intrinsics.checkNotNullExpressionValue(jsonObject, "config()");
        $this$initDpdkCore_u24lambda_u248.setEthernetHandler(new EthernetHandler(vertx, jsonObject, true));
        map2.put(n, core);
    }

    /*
     * WARNING - void declaration
     */
    public final void onDpdkPackets(int coreId, long sec, int usec, long packetsReceived) {
        block1: {
            long timestamp = sec * (long)1000 + (long)(usec / 1000);
            int nanos = usec % 1000 * 1000;
            Core core = this.cores.get(coreId);
            if (core == null) break block1;
            Core core2 = core;
            boolean bl = false;
            core2.getPacketsCaptured().addAndGet(packetsReceived);
            ByteBuffer[] $this$forEachIndexed$iv = core2.getBuffers();
            boolean $i$f$forEachIndexed = false;
            int index$iv = 0;
            for (ByteBuffer item$iv : $this$forEachIndexed$iv) {
                void buffer;
                Packet packet;
                int n = index$iv++;
                ByteBuffer byteBuffer = item$iv;
                int i2 = n;
                boolean bl2 = false;
                if ((long)i2 >= packetsReceived) continue;
                Packet $this$onDpdkPackets_u24lambda_u2411_u24lambda_u2410_u24lambda_u249 = packet = new Packet();
                boolean bl3 = false;
                $this$onDpdkPackets_u24lambda_u2411_u24lambda_u2410_u24lambda_u249.setTimestamp(timestamp);
                $this$onDpdkPackets_u24lambda_u2411_u24lambda_u2410_u24lambda_u249.setNanos(nanos);
                ByteBuf byteBuf = Unpooled.wrappedBuffer((ByteBuffer)buffer);
                Intrinsics.checkNotNullExpressionValue(byteBuf, "wrappedBuffer(buffer)");
                $this$onDpdkPackets_u24lambda_u2411_u24lambda_u2410_u24lambda_u249.setPayload(new ByteBufPayload(byteBuf));
                Packet packet2 = packet;
                core2.getEthernetHandler().handle(packet2);
            }
        }
    }

    @Override
    public void stop() {
        this.unbind();
    }

    private static final void start$lambda$4(DpdkEngine this$0) {
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        try {
            this$0.bind(this$0.port, this$0.rxQueueSize, this$0.bulkSize);
        }
        catch (Exception e) {
            this$0.logger.error("Got exception...", e);
            Vertx vertx = this$0.vertx;
            Intrinsics.checkNotNullExpressionValue(vertx, "vertx");
            VertxUtilKt.closeAndExitProcess$default(vertx, 0, 1, null);
        }
    }

    private static final Unit start$lambda$7$lambda$6(DpdkEngine this$0) {
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        long packetsCapturedSum = 0L;
        Map<Integer, Core> $this$forEach$iv = this$0.cores;
        boolean $i$f$forEach = false;
        Iterator<Map.Entry<Integer, Core>> iterator2 = $this$forEach$iv.entrySet().iterator();
        while (iterator2.hasNext()) {
            Map.Entry<Integer, Core> element$iv;
            Map.Entry<Integer, Core> entry = element$iv = iterator2.next();
            boolean bl = false;
            Core core = entry.getValue();
            packetsCapturedSum += core.getPacketsCaptured().getAndSet(0L);
        }
        this$0.packetsCaptured.increment(packetsCapturedSum);
        return Unit.INSTANCE;
    }

    private static final void start$lambda$7(DpdkEngine this$0, Long it) {
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        this$0.vertx.executeBlocking(() -> DpdkEngine.start$lambda$7$lambda$6(this$0));
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002R\"\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0086.\u00a2\u0006\u0010\n\u0002\u0010\n\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR\u001a\u0010\u000b\u001a\u00020\fX\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u001a\u0010\u0011\u001a\u00020\u0012X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016\u00a8\u0006\u0017"}, d2={"Lio/sip3/captain/ce/capturing/DpdkEngine$Core;", "", "()V", "buffers", "", "Ljava/nio/ByteBuffer;", "getBuffers", "()[Ljava/nio/ByteBuffer;", "setBuffers", "([Ljava/nio/ByteBuffer;)V", "[Ljava/nio/ByteBuffer;", "ethernetHandler", "Lio/sip3/captain/ce/pipeline/EthernetHandler;", "getEthernetHandler", "()Lio/sip3/captain/ce/pipeline/EthernetHandler;", "setEthernetHandler", "(Lio/sip3/captain/ce/pipeline/EthernetHandler;)V", "packetsCaptured", "Ljava/util/concurrent/atomic/AtomicLong;", "getPacketsCaptured", "()Ljava/util/concurrent/atomic/AtomicLong;", "setPacketsCaptured", "(Ljava/util/concurrent/atomic/AtomicLong;)V", "sip3-captain-ce"})
    public static final class Core {
        public AtomicLong packetsCaptured;
        public ByteBuffer[] buffers;
        public EthernetHandler ethernetHandler;

        @NotNull
        public final AtomicLong getPacketsCaptured() {
            AtomicLong atomicLong = this.packetsCaptured;
            if (atomicLong != null) {
                return atomicLong;
            }
            Intrinsics.throwUninitializedPropertyAccessException("packetsCaptured");
            return null;
        }

        public final void setPacketsCaptured(@NotNull AtomicLong atomicLong) {
            Intrinsics.checkNotNullParameter(atomicLong, "<set-?>");
            this.packetsCaptured = atomicLong;
        }

        @NotNull
        public final ByteBuffer[] getBuffers() {
            if (this.buffers != null) {
                return this.buffers;
            }
            Intrinsics.throwUninitializedPropertyAccessException("buffers");
            return null;
        }

        public final void setBuffers(@NotNull ByteBuffer[] byteBufferArray) {
            Intrinsics.checkNotNullParameter(byteBufferArray, "<set-?>");
            this.buffers = byteBufferArray;
        }

        @NotNull
        public final EthernetHandler getEthernetHandler() {
            EthernetHandler ethernetHandler2 = this.ethernetHandler;
            if (ethernetHandler2 != null) {
                return ethernetHandler2;
            }
            Intrinsics.throwUninitializedPropertyAccessException("ethernetHandler");
            return null;
        }

        public final void setEthernetHandler(@NotNull EthernetHandler ethernetHandler2) {
            Intrinsics.checkNotNullParameter(ethernetHandler2, "<set-?>");
            this.ethernetHandler = ethernetHandler2;
        }
    }
}

