/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.statsd;

import io.micrometer.core.instrument.Clock;
import io.micrometer.core.instrument.Meter;
import io.micrometer.core.instrument.Statistic;
import io.micrometer.core.instrument.distribution.DistributionStatisticConfig;
import io.micrometer.core.instrument.internal.DefaultLongTaskTimer;
import io.micrometer.shaded.reactor.core.publisher.FluxSink;
import io.micrometer.statsd.StatsdLineBuilder;
import io.micrometer.statsd.StatsdPollable;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;

public class StatsdLongTaskTimer
extends DefaultLongTaskTimer
implements StatsdPollable {
    private final StatsdLineBuilder lineBuilder;
    private final FluxSink<String> sink;
    private final AtomicReference<Long> lastActive = new AtomicReference<Long>(Long.MIN_VALUE);
    private final AtomicReference<Double> lastDuration = new AtomicReference<Double>(Double.NEGATIVE_INFINITY);
    private final boolean alwaysPublish;

    StatsdLongTaskTimer(Meter.Id id, StatsdLineBuilder lineBuilder, FluxSink<String> sink2, Clock clock, boolean alwaysPublish, DistributionStatisticConfig distributionStatisticConfig, TimeUnit baseTimeUnit) {
        super(id, clock, baseTimeUnit, distributionStatisticConfig, false);
        this.lineBuilder = lineBuilder;
        this.sink = sink2;
        this.alwaysPublish = alwaysPublish;
    }

    @Override
    public void poll() {
        long active = this.activeTasks();
        if (this.alwaysPublish || this.lastActive.getAndSet(active) != active) {
            this.sink.next(this.lineBuilder.gauge(active, Statistic.ACTIVE_TASKS));
        }
        double duration = this.duration(TimeUnit.MILLISECONDS);
        if (this.alwaysPublish || this.lastDuration.getAndSet(duration) != duration) {
            this.sink.next(this.lineBuilder.gauge(duration, Statistic.DURATION));
        }
        double max = this.max(TimeUnit.MILLISECONDS);
        if (this.alwaysPublish || this.lastDuration.getAndSet(duration) != duration) {
            this.sink.next(this.lineBuilder.gauge(max, Statistic.MAX));
        }
    }
}

