/*
 * Decompiled with CFR 0.152.
 */
package org.pcap4j.packet;

import org.pcap4j.packet.IllegalRawDataException;
import org.pcap4j.packet.LengthBuilder;
import org.pcap4j.packet.TcpPacket;
import org.pcap4j.packet.namednumber.TcpOptionKind;
import org.pcap4j.util.ByteArrays;

public final class TcpMaximumSegmentSizeOption
implements TcpPacket.TcpOption {
    private static final long serialVersionUID = 7552907605220130850L;
    private final TcpOptionKind kind = TcpOptionKind.MAXIMUM_SEGMENT_SIZE;
    private final byte length;
    private final short maxSegSize;

    public static TcpMaximumSegmentSizeOption newInstance(byte[] rawData, int offset, int length) throws IllegalRawDataException {
        ByteArrays.validateBounds(rawData, offset, length);
        return new TcpMaximumSegmentSizeOption(rawData, offset, length);
    }

    private TcpMaximumSegmentSizeOption(byte[] rawData, int offset, int length) throws IllegalRawDataException {
        if (length < 4) {
            StringBuilder sb = new StringBuilder(50);
            sb.append("The raw data length must be more than 3. rawData: ").append(ByteArrays.toHexString(rawData, " ")).append(", offset: ").append(offset).append(", length: ").append(length);
            throw new IllegalRawDataException(sb.toString());
        }
        if (rawData[offset] != (Byte)this.kind.value()) {
            StringBuilder sb = new StringBuilder(100);
            sb.append("The kind must be: ").append(this.kind.valueAsString()).append(" rawData: ").append(ByteArrays.toHexString(rawData, " ")).append(", offset: ").append(offset).append(", length: ").append(length);
            throw new IllegalRawDataException(sb.toString());
        }
        this.length = rawData[1 + offset];
        if (this.length != 4) {
            throw new IllegalRawDataException("Invalid value of length field: " + this.length);
        }
        this.maxSegSize = ByteArrays.getShort(rawData, 2 + offset);
    }

    private TcpMaximumSegmentSizeOption(Builder builder) {
        if (builder == null) {
            throw new NullPointerException("builder: " + builder);
        }
        this.maxSegSize = builder.maxSegSize;
        this.length = builder.correctLengthAtBuild ? (byte)this.length() : builder.length;
    }

    @Override
    public TcpOptionKind getKind() {
        return this.kind;
    }

    public byte getLength() {
        return this.length;
    }

    public int getLengthAsInt() {
        return 0xFF & this.length;
    }

    public short getMaxSegSize() {
        return this.maxSegSize;
    }

    public int getMaxSegSizeAsInt() {
        return 0xFFFF & this.maxSegSize;
    }

    @Override
    public int length() {
        return 4;
    }

    @Override
    public byte[] getRawData() {
        byte[] rawData = new byte[this.length()];
        rawData[0] = (Byte)this.kind.value();
        rawData[1] = this.length;
        rawData[2] = (byte)(this.maxSegSize >> 8);
        rawData[3] = (byte)this.maxSegSize;
        return rawData;
    }

    public Builder getBuilder() {
        return new Builder(this);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("[Kind: ").append(this.kind);
        sb.append("] [Length: ").append(this.getLengthAsInt());
        sb.append(" bytes] [Maximum Segment Size: ").append(this.getMaxSegSizeAsInt());
        sb.append(" bytes]");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!this.getClass().isInstance(obj)) {
            return false;
        }
        TcpMaximumSegmentSizeOption other = (TcpMaximumSegmentSizeOption)obj;
        return this.length == other.length && this.maxSegSize == other.maxSegSize;
    }

    public int hashCode() {
        int result2 = 17;
        result2 = 31 * result2 + this.length;
        result2 = 31 * result2 + this.maxSegSize;
        return result2;
    }

    public static final class Builder
    implements LengthBuilder<TcpMaximumSegmentSizeOption> {
        private byte length;
        private short maxSegSize;
        private boolean correctLengthAtBuild;

        public Builder() {
        }

        private Builder(TcpMaximumSegmentSizeOption option) {
            this.length = option.length;
            this.maxSegSize = option.maxSegSize;
        }

        public Builder length(byte length) {
            this.length = length;
            return this;
        }

        public Builder maxSegSize(short maxSegSize) {
            this.maxSegSize = maxSegSize;
            return this;
        }

        public Builder correctLengthAtBuild(boolean correctLengthAtBuild) {
            this.correctLengthAtBuild = correctLengthAtBuild;
            return this;
        }

        @Override
        public TcpMaximumSegmentSizeOption build() {
            return new TcpMaximumSegmentSizeOption(this);
        }
    }
}

