/*
 * Decompiled with CFR 0.152.
 */
package org.pcap4j.packet;

import org.pcap4j.packet.IllegalRawDataException;
import org.pcap4j.packet.LlcPacket;
import org.pcap4j.util.ByteArrays;

public final class LlcControlInformation
implements LlcPacket.LlcControl {
    private static final long serialVersionUID = -4014592337107864662L;
    private final byte receiveSequenceNumber;
    private final boolean pfBit;
    private final byte sendSequenceNumber;

    public static LlcControlInformation newInstance(short value) throws IllegalRawDataException {
        return new LlcControlInformation(value);
    }

    private LlcControlInformation(short value) throws IllegalRawDataException {
        if ((value & 0x100) != 0) {
            StringBuilder sb = new StringBuilder(50);
            sb.append("value & 0x0100 must be 0. value: ").append(ByteArrays.toHexString(value, " "));
            throw new IllegalRawDataException(sb.toString());
        }
        this.receiveSequenceNumber = (byte)(value >> 1 & 0x7F);
        this.pfBit = (value & 1) != 0;
        this.sendSequenceNumber = (byte)(value >> 9 & 0x7F);
    }

    private LlcControlInformation(Builder builder) {
        if (builder == null) {
            throw new NullPointerException("builder must not be null.");
        }
        if (builder.receiveSequenceNumber < 0) {
            throw new IllegalArgumentException("receiveSequenceNumber must be positive. receiveSequenceNumber: " + builder.receiveSequenceNumber);
        }
        if (builder.sendSequenceNumber < 0) {
            throw new IllegalArgumentException("sendSequenceNumber must be positive. sendSequenceNumber: " + builder.sendSequenceNumber);
        }
        this.receiveSequenceNumber = builder.receiveSequenceNumber;
        this.pfBit = builder.pfBit;
        this.sendSequenceNumber = builder.sendSequenceNumber;
    }

    public byte getReceiveSequenceNumber() {
        return this.receiveSequenceNumber;
    }

    public int getReceiveSequenceNumberAsInt() {
        return this.receiveSequenceNumber;
    }

    public boolean getPfBit() {
        return this.pfBit;
    }

    public byte getSendSequenceNumber() {
        return this.sendSequenceNumber;
    }

    public int getSendSequenceNumberAsInt() {
        return this.sendSequenceNumber;
    }

    @Override
    public int length() {
        return 2;
    }

    @Override
    public byte[] getRawData() {
        byte[] data = new byte[2];
        data[1] = (byte)(this.receiveSequenceNumber << 1);
        if (this.pfBit) {
            data[1] = (byte)(data[1] | 1);
        }
        data[0] = (byte)(this.sendSequenceNumber << 1);
        return data;
    }

    public Builder getBuilder() {
        return new Builder(this);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("[receive sequence number: ").append(this.receiveSequenceNumber).append("] [P/F bit: ").append(this.pfBit ? 1 : 0).append("] [send sequence number: ").append(this.sendSequenceNumber).append("]");
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int result2 = 1;
        result2 = 31 * result2 + this.receiveSequenceNumber;
        result2 = 31 * result2 + (this.pfBit ? 1231 : 1237);
        result2 = 31 * result2 + this.sendSequenceNumber;
        return result2;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!this.getClass().isInstance(obj)) {
            return false;
        }
        LlcControlInformation other = (LlcControlInformation)obj;
        return this.receiveSequenceNumber == other.receiveSequenceNumber && this.sendSequenceNumber == other.sendSequenceNumber && this.pfBit == other.pfBit;
    }

    public static final class Builder {
        private byte receiveSequenceNumber;
        private boolean pfBit;
        private byte sendSequenceNumber;

        public Builder() {
        }

        private Builder(LlcControlInformation ctrl) {
            this.receiveSequenceNumber = ctrl.receiveSequenceNumber;
            this.pfBit = ctrl.pfBit;
            this.sendSequenceNumber = ctrl.sendSequenceNumber;
        }

        public Builder receiveSequenceNumber(byte receiveSequenceNumber) {
            this.receiveSequenceNumber = receiveSequenceNumber;
            return this;
        }

        public Builder pfBit(boolean pfBit) {
            this.pfBit = pfBit;
            return this;
        }

        public Builder sendSequenceNumber(byte sendSequenceNumber) {
            this.sendSequenceNumber = sendSequenceNumber;
            return this;
        }

        public LlcControlInformation build() {
            return new LlcControlInformation(this);
        }
    }
}

