/*
 * Decompiled with CFR 0.152.
 */
package org.pcap4j.packet;

import java.util.ArrayList;
import java.util.List;
import org.pcap4j.packet.AbstractPacket;
import org.pcap4j.packet.IllegalRawDataException;
import org.pcap4j.util.ByteArrays;

public class IcmpV6HomeAgentAddressDiscoveryRequestPacket
extends AbstractPacket {
    private static final long serialVersionUID = -4921942983336579680L;
    private final IcmpV6HomeAgentAddressDiscoveryRequestHeader header;

    public static IcmpV6HomeAgentAddressDiscoveryRequestPacket newPacket(byte[] rawData, int offset, int length) throws IllegalRawDataException {
        ByteArrays.validateBounds(rawData, offset, length);
        return new IcmpV6HomeAgentAddressDiscoveryRequestPacket(rawData, offset, length);
    }

    private IcmpV6HomeAgentAddressDiscoveryRequestPacket(byte[] rawData, int offset, int length) throws IllegalRawDataException {
        this.header = new IcmpV6HomeAgentAddressDiscoveryRequestHeader(rawData, offset, length);
    }

    private IcmpV6HomeAgentAddressDiscoveryRequestPacket(Builder builder) {
        this.header = new IcmpV6HomeAgentAddressDiscoveryRequestHeader(builder);
    }

    @Override
    public IcmpV6HomeAgentAddressDiscoveryRequestHeader getHeader() {
        return this.header;
    }

    @Override
    public Builder getBuilder() {
        return new Builder(this);
    }

    public static final class IcmpV6HomeAgentAddressDiscoveryRequestHeader
    extends AbstractPacket.AbstractHeader {
        private static final long serialVersionUID = -1367204926945263009L;
        private static final int IDENTIFIER_OFFSET = 0;
        private static final int IDENTIFIER_SIZE = 2;
        private static final int RESERVED_OFFSET = 2;
        private static final int RESERVED_SIZE = 2;
        private static final int ICMPV6_HOME_AGENT_ADDRESS_DISCOVERY_REQUEST_HEADER_SIZE = 4;
        private final short identifier;
        private final short reserved;

        private IcmpV6HomeAgentAddressDiscoveryRequestHeader(byte[] rawData, int offset, int length) throws IllegalRawDataException {
            if (length < 4) {
                StringBuilder sb = new StringBuilder();
                sb.append("The data is too short to build an ICMPv6 Home Agent Address Discovery Request Header(").append(4).append(" bytes). data: ").append(ByteArrays.toHexString(rawData, " ")).append(", offset: ").append(offset).append(", length: ").append(length);
                throw new IllegalRawDataException(sb.toString());
            }
            this.identifier = ByteArrays.getShort(rawData, 0 + offset);
            this.reserved = ByteArrays.getShort(rawData, 2 + offset);
        }

        private IcmpV6HomeAgentAddressDiscoveryRequestHeader(Builder builder) {
            this.identifier = builder.identifier;
            this.reserved = builder.reserved;
        }

        public short getIdentifier() {
            return this.identifier;
        }

        public int getIdentifierAsInt() {
            return this.identifier & 0xFFFF;
        }

        public short getReserved() {
            return this.reserved;
        }

        @Override
        protected List<byte[]> getRawFields() {
            ArrayList<byte[]> rawFields = new ArrayList<byte[]>();
            rawFields.add(ByteArrays.toByteArray(this.identifier));
            rawFields.add(ByteArrays.toByteArray(this.reserved));
            return rawFields;
        }

        @Override
        public int length() {
            return 4;
        }

        @Override
        protected String buildString() {
            StringBuilder sb = new StringBuilder();
            String ls = System.getProperty("line.separator");
            sb.append("[ICMPv6 Home Agent Address Discovery Request Header (").append(this.length()).append(" bytes)]").append(ls);
            sb.append("  Identifier: ").append(this.getIdentifierAsInt()).append(ls);
            sb.append("  Reserved: ").append(this.reserved).append(ls);
            return sb.toString();
        }

        @Override
        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (!this.getClass().isInstance(obj)) {
                return false;
            }
            IcmpV6HomeAgentAddressDiscoveryRequestHeader other = (IcmpV6HomeAgentAddressDiscoveryRequestHeader)obj;
            return this.identifier == other.identifier && this.reserved == other.reserved;
        }

        @Override
        protected int calcHashCode() {
            int result2 = 17;
            result2 = 31 * result2 + this.identifier;
            result2 = 31 * result2 + this.reserved;
            return result2;
        }
    }

    public static final class Builder
    extends AbstractPacket.AbstractBuilder {
        private short identifier;
        private short reserved;

        public Builder() {
        }

        private Builder(IcmpV6HomeAgentAddressDiscoveryRequestPacket packet) {
            this.identifier = packet.header.identifier;
            this.reserved = packet.header.reserved;
        }

        public Builder identifier(short identifier) {
            this.identifier = identifier;
            return this;
        }

        public Builder reserved(short reserved) {
            this.reserved = reserved;
            return this;
        }

        @Override
        public IcmpV6HomeAgentAddressDiscoveryRequestPacket build() {
            return new IcmpV6HomeAgentAddressDiscoveryRequestPacket(this);
        }
    }
}

