/*
 * Decompiled with CFR 0.152.
 */
package org.pcap4j.packet;

import java.util.Arrays;
import org.pcap4j.packet.Dot11InformationElement;
import org.pcap4j.packet.IllegalRawDataException;
import org.pcap4j.packet.namednumber.Dot11AccessNetworkType;
import org.pcap4j.packet.namednumber.Dot11InformationElementId;
import org.pcap4j.packet.namednumber.Dot11VenueInfo;
import org.pcap4j.util.ByteArrays;

public final class Dot11InterworkingElement
extends Dot11InformationElement {
    private static final long serialVersionUID = -5151120333283703306L;
    private final Dot11AccessNetworkType accessnetworkType;
    private final boolean internet;
    private final boolean asra;
    private final boolean esr;
    private final boolean uesa;
    private final Dot11VenueInfo venueInfo;
    private final byte[] hessid;

    public static Dot11InterworkingElement newInstance(byte[] rawData, int offset, int length) throws IllegalRawDataException {
        ByteArrays.validateBounds(rawData, offset, length);
        return new Dot11InterworkingElement(rawData, offset, length);
    }

    private Dot11InterworkingElement(byte[] rawData, int offset, int length) throws IllegalRawDataException {
        super(rawData, offset, length, Dot11InformationElementId.INTERWORKING);
        int infoLen = this.getLengthAsInt();
        if (infoLen != 1 && infoLen != 3 && infoLen != 7 && infoLen != 9) {
            throw new IllegalRawDataException("The length must be 1 or 3 or 7 or 9 but is actually: " + infoLen);
        }
        this.accessnetworkType = Dot11AccessNetworkType.getInstance((byte)(rawData[offset + 2] & 0xF));
        this.internet = (rawData[offset + 2] & 0x10) != 0;
        this.asra = (rawData[offset + 2] & 0x20) != 0;
        this.esr = (rawData[offset + 2] & 0x40) != 0;
        this.uesa = (rawData[offset + 2] & 0x80) != 0;
        this.venueInfo = infoLen == 3 || infoLen == 9 ? Dot11VenueInfo.getInstance(ByteArrays.getShort(rawData, offset + 3)) : null;
        this.hessid = infoLen == 7 ? ByteArrays.getSubArray(rawData, offset + 3, 6) : (byte[])(infoLen == 9 ? ByteArrays.getSubArray(rawData, offset + 5, 6) : null);
    }

    private Dot11InterworkingElement(Builder builder) {
        super(builder);
        if (builder.accessnetworkType == null) {
            throw new NullPointerException("builder.accessnetworkType is null.");
        }
        if (builder.hessid.length != 6) {
            throw new IllegalArgumentException("builder.hessid.length must be 6. builder.hessid.length: " + ByteArrays.toHexString(builder.hessid, " "));
        }
        this.accessnetworkType = builder.accessnetworkType;
        this.internet = builder.internet;
        this.asra = builder.asra;
        this.esr = builder.esr;
        this.uesa = builder.uesa;
        this.venueInfo = builder.venueInfo;
        this.hessid = builder.hessid;
    }

    public Dot11AccessNetworkType getAccessnetworkType() {
        return this.accessnetworkType;
    }

    public boolean isInternetAccessible() {
        return this.internet;
    }

    public boolean isAsra() {
        return this.asra;
    }

    public boolean isEsr() {
        return this.esr;
    }

    public boolean isUesa() {
        return this.uesa;
    }

    public Dot11VenueInfo getVenueInfo() {
        return this.venueInfo;
    }

    public byte[] getHessid() {
        if (this.hessid == null) {
            return null;
        }
        return ByteArrays.clone(this.hessid);
    }

    @Override
    public int length() {
        int len = 3;
        if (this.venueInfo != null) {
            len += 2;
        }
        if (this.hessid != null) {
            len += 6;
        }
        return len;
    }

    @Override
    public byte[] getRawData() {
        byte[] rawData = new byte[this.length()];
        rawData[0] = (Byte)this.getElementId().value();
        rawData[1] = this.getLength();
        rawData[2] = (Byte)this.accessnetworkType.value();
        if (this.internet) {
            rawData[2] = (byte)(rawData[2] | 0x10);
        }
        if (this.asra) {
            rawData[2] = (byte)(rawData[2] | 0x20);
        }
        if (this.esr) {
            rawData[2] = (byte)(rawData[2] | 0x40);
        }
        if (this.uesa) {
            rawData[2] = (byte)(rawData[2] | 0x80);
        }
        int offset = 3;
        if (this.venueInfo != null) {
            System.arraycopy(ByteArrays.toByteArray((Short)this.venueInfo.value()), 0, rawData, offset, 2);
            offset += 2;
        }
        if (this.hessid != null) {
            System.arraycopy(this.hessid, 0, rawData, offset, 6);
        }
        return rawData;
    }

    public Builder getBuilder() {
        return new Builder(this);
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result2 = super.hashCode();
        result2 = 31 * result2 + this.accessnetworkType.hashCode();
        result2 = 31 * result2 + (this.asra ? 1231 : 1237);
        result2 = 31 * result2 + (this.esr ? 1231 : 1237);
        result2 = 31 * result2 + Arrays.hashCode(this.hessid);
        result2 = 31 * result2 + (this.internet ? 1231 : 1237);
        result2 = 31 * result2 + (this.uesa ? 1231 : 1237);
        result2 = 31 * result2 + (this.venueInfo == null ? 0 : this.venueInfo.hashCode());
        return result2;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Dot11InterworkingElement other = (Dot11InterworkingElement)obj;
        if (!this.accessnetworkType.equals(other.accessnetworkType)) {
            return false;
        }
        if (this.asra != other.asra) {
            return false;
        }
        if (this.esr != other.esr) {
            return false;
        }
        if (!Arrays.equals(this.hessid, other.hessid)) {
            return false;
        }
        if (this.internet != other.internet) {
            return false;
        }
        if (this.uesa != other.uesa) {
            return false;
        }
        return !(this.venueInfo == null ? other.venueInfo != null : !this.venueInfo.equals(other.venueInfo));
    }

    public String toString() {
        return this.toString("");
    }

    public String toString(String indent) {
        StringBuilder sb = new StringBuilder();
        String ls = System.getProperty("line.separator");
        sb.append(indent).append("Interworking:").append(ls);
        sb.append(indent).append("  Element ID: ").append(this.getElementId()).append(ls);
        sb.append(indent).append("  Length: ").append(this.getLengthAsInt()).append(" bytes").append(ls);
        sb.append(indent).append("  Access Network Type: ").append(this.accessnetworkType).append(ls);
        sb.append(indent).append("  Internet Accessible: ").append(this.internet).append(ls);
        sb.append(indent).append("  ASRA: ").append(this.asra).append(ls);
        sb.append(indent).append("  ESR: ").append(this.esr).append(ls);
        sb.append(indent).append("  UESA: ").append(this.uesa).append(ls);
        if (this.venueInfo != null) {
            sb.append(indent).append("  Venue Info: ").append(this.venueInfo).append(ls);
        }
        if (this.hessid != null) {
            sb.append(indent).append("  HESSID: 0x").append(ByteArrays.toHexString(this.hessid, "")).append(ls);
        }
        return sb.toString();
    }

    public static final class Builder
    extends Dot11InformationElement.Builder {
        private Dot11AccessNetworkType accessnetworkType;
        private boolean internet;
        private boolean asra;
        private boolean esr;
        private boolean uesa;
        private Dot11VenueInfo venueInfo;
        private byte[] hessid;

        public Builder() {
            this.elementId(Dot11InformationElementId.getInstance((Byte)Dot11InformationElementId.INTERWORKING.value()));
        }

        private Builder(Dot11InterworkingElement obj) {
            super(obj);
            this.accessnetworkType = obj.accessnetworkType;
            this.internet = obj.internet;
            this.asra = obj.asra;
            this.esr = obj.esr;
            this.uesa = obj.uesa;
            this.venueInfo = obj.venueInfo;
            this.hessid = obj.hessid;
        }

        public Builder accessnetworkType(Dot11AccessNetworkType accessnetworkType) {
            this.accessnetworkType = accessnetworkType;
            return this;
        }

        public Builder internet(boolean internet) {
            this.internet = internet;
            return this;
        }

        public Builder asra(boolean asra) {
            this.asra = asra;
            return this;
        }

        public Builder esr(boolean esr) {
            this.esr = esr;
            return this;
        }

        public Builder uesa(boolean uesa) {
            this.uesa = uesa;
            return this;
        }

        public Builder venueInfo(Dot11VenueInfo venueInfo) {
            this.venueInfo = venueInfo;
            return this;
        }

        public Builder hessid(byte[] hessid) {
            this.hessid = hessid;
            return this;
        }

        @Override
        public Builder length(byte length) {
            super.length(length);
            return this;
        }

        @Override
        public Builder correctLengthAtBuild(boolean correctLengthAtBuild) {
            super.correctLengthAtBuild(correctLengthAtBuild);
            return this;
        }

        @Override
        public Dot11InterworkingElement build() {
            if (this.getCorrectLengthAtBuild()) {
                int len = 1;
                if (this.venueInfo != null) {
                    len += 2;
                }
                if (this.hessid != null) {
                    len += 6;
                }
                this.length((byte)len);
            }
            return new Dot11InterworkingElement(this);
        }
    }
}

