/*
 * Decompiled with CFR 0.152.
 */
package org.pcap4j.packet;

import org.pcap4j.packet.DnsDomainName;
import org.pcap4j.packet.DnsResourceRecord;
import org.pcap4j.packet.IllegalRawDataException;
import org.pcap4j.util.ByteArrays;

public final class DnsRDataSoa
implements DnsResourceRecord.DnsRData {
    private static final long serialVersionUID = -5916011849950625284L;
    private final DnsDomainName mName;
    private final DnsDomainName rName;
    private final int serial;
    private final int refresh;
    private final int retry;
    private final int expire;
    private final int minimum;

    public static DnsRDataSoa newInstance(byte[] rawData, int offset, int length) throws IllegalRawDataException {
        ByteArrays.validateBounds(rawData, offset, length);
        return new DnsRDataSoa(rawData, offset, length);
    }

    private DnsRDataSoa(byte[] rawData, int offset, int length) throws IllegalRawDataException {
        int cursor = 0;
        this.mName = DnsDomainName.newInstance(rawData, offset, length);
        int mNameLen = this.mName.length();
        if ((cursor += mNameLen) == length) {
            StringBuilder sb = new StringBuilder(200);
            sb.append("The data is too short to build rName in DnsRDataSoa. data: ").append(ByteArrays.toHexString(rawData, " ")).append(", offset: ").append(offset).append(", length: ").append(length).append(", cursor: ").append(cursor);
            throw new IllegalRawDataException(sb.toString());
        }
        this.rName = DnsDomainName.newInstance(rawData, offset + cursor, length - cursor);
        int rNameLen = this.rName.length();
        if ((cursor += rNameLen) + 20 > length) {
            StringBuilder sb = new StringBuilder(200);
            sb.append("The data is too short to build serial, refresh, retry, expire, and minimumin DnsRDataSoa. data: ").append(ByteArrays.toHexString(rawData, " ")).append(", offset: ").append(offset).append(", length: ").append(length).append(", cursor: ").append(cursor);
            throw new IllegalRawDataException(sb.toString());
        }
        this.serial = ByteArrays.getInt(rawData, offset + cursor);
        this.refresh = ByteArrays.getInt(rawData, offset + (cursor += 4));
        this.retry = ByteArrays.getInt(rawData, offset + (cursor += 4));
        this.expire = ByteArrays.getInt(rawData, offset + (cursor += 4));
        this.minimum = ByteArrays.getInt(rawData, offset + (cursor += 4));
    }

    private DnsRDataSoa(Builder builder) {
        if (builder == null || builder.mName == null || builder.rName == null) {
            StringBuilder sb = new StringBuilder();
            sb.append("builder: ").append(builder).append(" builder.mName: ").append(builder.mName).append(" builder.rName: ").append(builder.rName);
            throw new NullPointerException(sb.toString());
        }
        this.mName = builder.mName;
        this.rName = builder.rName;
        this.serial = builder.serial;
        this.refresh = builder.refresh;
        this.retry = builder.retry;
        this.expire = builder.expire;
        this.minimum = builder.minimum;
    }

    public DnsDomainName getMName() {
        return this.mName;
    }

    public DnsDomainName getRName() {
        return this.rName;
    }

    public int getSerial() {
        return this.serial;
    }

    public long getSerialAsLong() {
        return (long)this.serial & 0xFFFFFFFFL;
    }

    public int getRefresh() {
        return this.refresh;
    }

    public long getRefreshAsLong() {
        return (long)this.refresh & 0xFFFFFFFFL;
    }

    public int getRetry() {
        return this.retry;
    }

    public long getRetryAsLong() {
        return (long)this.retry & 0xFFFFFFFFL;
    }

    public int getExpire() {
        return this.expire;
    }

    public long getExpireAsLong() {
        return (long)this.expire & 0xFFFFFFFFL;
    }

    public int getMinimum() {
        return this.minimum;
    }

    public long getMinimumAsLong() {
        return (long)this.minimum & 0xFFFFFFFFL;
    }

    @Override
    public int length() {
        return this.mName.length() + this.rName.length() + 20;
    }

    @Override
    public byte[] getRawData() {
        byte[] rawMName = this.mName.getRawData();
        byte[] rawRName = this.rName.getRawData();
        byte[] data = new byte[rawMName.length + rawRName.length + 20];
        int cursor = 0;
        System.arraycopy(rawMName, 0, data, cursor, rawMName.length);
        System.arraycopy(rawRName, 0, data, cursor += rawMName.length, rawRName.length);
        System.arraycopy(ByteArrays.toByteArray(this.serial), 0, data, cursor += rawRName.length, 4);
        System.arraycopy(ByteArrays.toByteArray(this.refresh), 0, data, cursor += 4, 4);
        System.arraycopy(ByteArrays.toByteArray(this.retry), 0, data, cursor += 4, 4);
        System.arraycopy(ByteArrays.toByteArray(this.expire), 0, data, cursor += 4, 4);
        System.arraycopy(ByteArrays.toByteArray(this.minimum), 0, data, cursor += 4, 4);
        return data;
    }

    public Builder getBuilder() {
        return new Builder(this);
    }

    public String toString() {
        return this.convertToString("", null);
    }

    @Override
    public String toString(String indent) {
        return this.convertToString(indent, null);
    }

    @Override
    public String toString(String indent, byte[] headerRawData) {
        if (headerRawData == null) {
            throw new NullPointerException("headerRawData is null.");
        }
        return this.convertToString(indent, headerRawData);
    }

    private String convertToString(String indent, byte[] headerRawData) {
        StringBuilder sb = new StringBuilder();
        String ls = System.getProperty("line.separator");
        sb.append(indent).append("SOA RDATA:").append(ls).append(indent).append("  MNAME: ").append(headerRawData != null ? this.mName.toString(headerRawData) : this.mName.toString()).append(ls).append(indent).append("  RNAME: ").append(headerRawData != null ? this.rName.toString(headerRawData) : this.rName.toString()).append(ls).append(indent).append("  SERIAL: ").append(this.getSerialAsLong()).append(ls).append(indent).append("  REFRESH: ").append(this.getRefreshAsLong()).append(ls).append(indent).append("  RETRY: ").append(this.getRetryAsLong()).append(ls).append(indent).append("  EXPIRE: ").append(this.getExpireAsLong()).append(ls).append(indent).append("  MINIMUM: ").append(this.getMinimumAsLong()).append(ls);
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int result2 = 1;
        result2 = 31 * result2 + this.expire;
        result2 = 31 * result2 + this.mName.hashCode();
        result2 = 31 * result2 + this.minimum;
        result2 = 31 * result2 + this.rName.hashCode();
        result2 = 31 * result2 + this.refresh;
        result2 = 31 * result2 + this.retry;
        result2 = 31 * result2 + this.serial;
        return result2;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DnsRDataSoa other = (DnsRDataSoa)obj;
        if (this.expire != other.expire) {
            return false;
        }
        if (!this.mName.equals(other.mName)) {
            return false;
        }
        if (this.minimum != other.minimum) {
            return false;
        }
        if (!this.rName.equals(other.rName)) {
            return false;
        }
        if (this.refresh != other.refresh) {
            return false;
        }
        if (this.retry != other.retry) {
            return false;
        }
        return this.serial == other.serial;
    }

    public static final class Builder {
        private DnsDomainName mName;
        private DnsDomainName rName;
        private int serial;
        private int refresh;
        private int retry;
        private int expire;
        private int minimum;

        public Builder() {
        }

        private Builder(DnsRDataSoa obj) {
            this.mName = obj.mName;
            this.rName = obj.rName;
            this.serial = obj.serial;
            this.refresh = obj.refresh;
            this.retry = obj.retry;
            this.expire = obj.expire;
            this.minimum = obj.minimum;
        }

        public Builder mName(DnsDomainName mName) {
            this.mName = mName;
            return this;
        }

        public Builder rName(DnsDomainName rName) {
            this.rName = rName;
            return this;
        }

        public Builder serial(int serial) {
            this.serial = serial;
            return this;
        }

        public Builder refresh(int refresh) {
            this.refresh = refresh;
            return this;
        }

        public Builder retry(int retry2) {
            this.retry = retry2;
            return this;
        }

        public Builder expire(int expire) {
            this.expire = expire;
            return this;
        }

        public Builder minimum(int minimum) {
            this.minimum = minimum;
            return this;
        }

        public DnsRDataSoa build() {
            return new DnsRDataSoa(this);
        }
    }
}

