/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.net.ftp;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.Inet6Address;
import java.net.Socket;
import java.net.SocketException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Base64;
import org.apache.commons.net.ftp.FTPClient;
import org.apache.commons.net.ftp.FTPReply;

public class FTPHTTPClient
extends FTPClient {
    private static final byte[] CRLF = new byte[]{13, 10};
    private final String proxyHost;
    private final int proxyPort;
    private final String proxyUsername;
    private final String proxyPassword;
    private final Charset charset;
    private String tunnelHost;

    public FTPHTTPClient(String proxyHost, int proxyPort) {
        this(proxyHost, proxyPort, null, null);
    }

    public FTPHTTPClient(String proxyHost, int proxyPort, Charset encoding) {
        this(proxyHost, proxyPort, null, null, encoding);
    }

    public FTPHTTPClient(String proxyHost, int proxyPort, String proxyUser, String proxyPass) {
        this(proxyHost, proxyPort, proxyUser, proxyPass, StandardCharsets.UTF_8);
    }

    public FTPHTTPClient(String proxyHost, int proxyPort, String proxyUser, String proxyPass, Charset encoding) {
        this.proxyHost = proxyHost;
        this.proxyPort = proxyPort;
        this.proxyUsername = proxyUser;
        this.proxyPassword = proxyPass;
        this.tunnelHost = null;
        this.charset = encoding;
    }

    @Override
    @Deprecated
    protected Socket _openDataConnection_(int command2, String arg) throws IOException {
        return super._openDataConnection_(command2, arg);
    }

    @Override
    protected Socket _openDataConnection_(String command2, String arg) throws IOException {
        String passiveHost;
        boolean attemptEPSV;
        if (this.getDataConnectionMode() != 2) {
            throw new IllegalStateException("Only passive connection mode supported");
        }
        boolean isInet6Address = this.getRemoteAddress() instanceof Inet6Address;
        boolean bl = attemptEPSV = this.isUseEPSVwithIPv4() || isInet6Address;
        if (attemptEPSV && this.epsv() == 229) {
            this._parseExtendedPassiveModeReply((String)this._replyLines.get(0));
            passiveHost = this.tunnelHost;
        } else {
            if (isInet6Address) {
                return null;
            }
            if (this.pasv() != 227) {
                return null;
            }
            this._parsePassiveModeReply((String)this._replyLines.get(0));
            passiveHost = this.getPassiveHost();
        }
        Socket socket = this._socketFactory_.createSocket(this.proxyHost, this.proxyPort);
        InputStream is = socket.getInputStream();
        OutputStream os = socket.getOutputStream();
        this.tunnelHandshake(passiveHost, this.getPassivePort(), is, os);
        if (this.getRestartOffset() > 0L && !this.restart(this.getRestartOffset())) {
            socket.close();
            return null;
        }
        if (!FTPReply.isPositivePreliminary(this.sendCommand(command2, arg))) {
            socket.close();
            return null;
        }
        return socket;
    }

    @Override
    public void connect(String host, int port) throws SocketException, IOException {
        BufferedReader socketIsReader;
        this._socket_ = this._socketFactory_.createSocket(this.proxyHost, this.proxyPort);
        this._input_ = this._socket_.getInputStream();
        this._output_ = this._socket_.getOutputStream();
        try {
            socketIsReader = this.tunnelHandshake(host, port, this._input_, this._output_);
        }
        catch (Exception e) {
            IOException ioe = new IOException("Could not connect to " + host + " using port " + port);
            ioe.initCause(e);
            throw ioe;
        }
        super._connectAction_(socketIsReader);
    }

    private BufferedReader tunnelHandshake(String host, int port, InputStream input, OutputStream output) throws IOException, UnsupportedEncodingException {
        String connectString = "CONNECT " + host + ":" + port + " HTTP/1.1";
        String hostString = "Host: " + host + ":" + port;
        this.tunnelHost = host;
        output.write(connectString.getBytes(this.charset));
        output.write(CRLF);
        output.write(hostString.getBytes(this.charset));
        output.write(CRLF);
        if (this.proxyUsername != null && this.proxyPassword != null) {
            String auth = this.proxyUsername + ":" + this.proxyPassword;
            String header = "Proxy-Authorization: Basic " + Base64.getEncoder().encodeToString(auth.getBytes(this.charset));
            output.write(header.getBytes(this.charset));
        }
        output.write(CRLF);
        ArrayList<String> response = new ArrayList<String>();
        BufferedReader reader = new BufferedReader(new InputStreamReader(input, this.getCharset()));
        String line = reader.readLine();
        while (line != null && !line.isEmpty()) {
            response.add(line);
            line = reader.readLine();
        }
        int size = response.size();
        if (size == 0) {
            throw new IOException("No response from proxy");
        }
        String resp = (String)response.get(0);
        if (!resp.startsWith("HTTP/") || resp.length() < 12) {
            throw new IOException("Invalid response from proxy: " + resp);
        }
        String code = resp.substring(9, 12);
        if (!"200".equals(code)) {
            StringBuilder msg = new StringBuilder();
            msg.append("HTTPTunnelConnector: connection failed\r\n");
            msg.append("Response received from the proxy:\r\n");
            for (String line2 : response) {
                msg.append(line2);
                msg.append("\r\n");
            }
            throw new IOException(msg.toString());
        }
        return reader;
    }
}

