/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.http.impl;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufHolder;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.ChannelPipeline;
import io.netty.handler.codec.TooLongFrameException;
import io.netty.handler.codec.http.FullHttpResponse;
import io.netty.handler.codec.http.HttpClientCodec;
import io.netty.handler.codec.http.HttpClientUpgradeHandler;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaderValues;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.util.ReferenceCountUtil;
import io.netty.util.concurrent.EventExecutor;
import io.vertx.codegen.annotations.Nullable;
import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.MultiMap;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.GoAway;
import io.vertx.core.http.Http2Settings;
import io.vertx.core.http.HttpClientRequest;
import io.vertx.core.http.HttpConnection;
import io.vertx.core.http.HttpFrame;
import io.vertx.core.http.HttpVersion;
import io.vertx.core.http.StreamPriority;
import io.vertx.core.http.impl.Http1xClientConnection;
import io.vertx.core.http.impl.Http2ClientConnection;
import io.vertx.core.http.impl.HttpClientBase;
import io.vertx.core.http.impl.HttpClientConnection;
import io.vertx.core.http.impl.HttpClientImpl;
import io.vertx.core.http.impl.HttpClientPush;
import io.vertx.core.http.impl.HttpClientStream;
import io.vertx.core.http.impl.HttpRequestHead;
import io.vertx.core.http.impl.HttpResponseHead;
import io.vertx.core.http.impl.VertxHttp2ClientUpgradeCodec;
import io.vertx.core.http.impl.VertxHttp2ConnectionHandler;
import io.vertx.core.impl.ContextInternal;
import io.vertx.core.impl.logging.Logger;
import io.vertx.core.impl.logging.LoggerFactory;
import io.vertx.core.net.SocketAddress;
import io.vertx.core.streams.WriteStream;
import java.security.cert.Certificate;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLSession;
import javax.security.cert.X509Certificate;

public class Http2UpgradeClientConnection
implements HttpClientConnection {
    private static final Object SEND_BUFFERED_MESSAGES = new Object();
    private static final Logger log = LoggerFactory.getLogger(Http2UpgradeClientConnection.class);
    private HttpClientBase client;
    private HttpClientConnection current;
    private boolean upgradeProcessed;
    private Handler<Void> closeHandler;
    private Handler<Void> shutdownHandler;
    private Handler<GoAway> goAwayHandler;
    private Handler<Throwable> exceptionHandler;
    private Handler<Buffer> pingHandler;
    private Handler<Void> evictionHandler;
    private Handler<Object> invalidMessageHandler;
    private Handler<Long> concurrencyChangeHandler;
    private Handler<Http2Settings> remoteSettingsHandler;

    Http2UpgradeClientConnection(HttpClientBase client2, Http1xClientConnection connection) {
        this.client = client2;
        this.current = connection;
    }

    public HttpClientConnection unwrap() {
        return this.current;
    }

    @Override
    public long concurrency() {
        return this.upgradeProcessed ? this.current.concurrency() : 1L;
    }

    @Override
    public long activeStreams() {
        return this.current.concurrency();
    }

    @Override
    public ChannelHandlerContext channelHandlerContext() {
        return this.current.channelHandlerContext();
    }

    @Override
    public Channel channel() {
        return this.current.channel();
    }

    @Override
    public Future<Void> close() {
        return this.current.close();
    }

    @Override
    public Object metric() {
        return this.current.metric();
    }

    @Override
    public long lastResponseReceivedTimestamp() {
        return this.current.lastResponseReceivedTimestamp();
    }

    @Override
    public void createStream(ContextInternal context, Handler<AsyncResult<HttpClientStream>> handler) {
        if (this.current instanceof Http1xClientConnection && !this.upgradeProcessed) {
            this.current.createStream(context, ar -> {
                if (ar.succeeded()) {
                    HttpClientStream stream = (HttpClientStream)ar.result();
                    UpgradingStream upgradingStream = new UpgradingStream(stream, this, (Http1xClientConnection)this.current);
                    handler.handle(Future.succeededFuture(upgradingStream));
                } else {
                    handler.handle((AsyncResult<HttpClientStream>)ar);
                }
            });
        } else {
            this.current.createStream(context, ar -> {
                if (ar.succeeded()) {
                    handler.handle(Future.succeededFuture(new DelegatingStream(this, (HttpClientStream)ar.result())));
                } else {
                    handler.handle((AsyncResult<HttpClientStream>)ar);
                }
            });
        }
    }

    @Override
    public Future<HttpClientRequest> createRequest(ContextInternal context) {
        return ((HttpClientImpl)this.client).createRequest(this, context);
    }

    @Override
    public ContextInternal getContext() {
        return this.current.getContext();
    }

    @Override
    public HttpConnection remoteSettingsHandler(Handler<Http2Settings> handler) {
        if (this.current instanceof Http1xClientConnection) {
            this.remoteSettingsHandler = handler;
        } else {
            this.current.remoteSettingsHandler(handler);
        }
        return this;
    }

    @Override
    public HttpConnection pingHandler(@Nullable Handler<Buffer> handler) {
        if (this.current instanceof Http1xClientConnection) {
            this.pingHandler = handler;
        } else {
            this.current.pingHandler(handler);
        }
        return this;
    }

    @Override
    public HttpConnection goAwayHandler(@Nullable Handler<GoAway> handler) {
        if (this.current instanceof Http1xClientConnection) {
            this.goAwayHandler = handler;
        } else {
            this.current.goAwayHandler(handler);
        }
        return this;
    }

    @Override
    public HttpConnection shutdownHandler(@Nullable Handler<Void> handler) {
        if (this.current instanceof Http1xClientConnection) {
            this.shutdownHandler = handler;
        } else {
            this.current.shutdownHandler(handler);
        }
        return this;
    }

    @Override
    public HttpConnection closeHandler(Handler<Void> handler) {
        if (this.current instanceof Http1xClientConnection) {
            this.closeHandler = handler;
        }
        this.current.closeHandler(handler);
        return this;
    }

    @Override
    public HttpConnection exceptionHandler(Handler<Throwable> handler) {
        if (this.current instanceof Http1xClientConnection) {
            this.exceptionHandler = handler;
        }
        this.current.exceptionHandler(handler);
        return this;
    }

    @Override
    public HttpClientConnection evictionHandler(Handler<Void> handler) {
        if (this.current instanceof Http1xClientConnection) {
            this.evictionHandler = handler;
        }
        this.current.evictionHandler(handler);
        return this;
    }

    @Override
    public HttpClientConnection invalidMessageHandler(Handler<Object> handler) {
        if (this.current instanceof Http1xClientConnection) {
            this.invalidMessageHandler = handler;
        }
        this.current.invalidMessageHandler(handler);
        return this;
    }

    @Override
    public HttpClientConnection concurrencyChangeHandler(Handler<Long> handler) {
        if (this.current instanceof Http1xClientConnection) {
            this.concurrencyChangeHandler = handler;
        }
        this.current.concurrencyChangeHandler(handler);
        return this;
    }

    @Override
    public HttpConnection goAway(long errorCode, int lastStreamId, Buffer debugData) {
        return this.current.goAway(errorCode, lastStreamId, debugData);
    }

    @Override
    public Future<Void> shutdown(long timeout2, TimeUnit unit) {
        return this.current.shutdown(timeout2, unit);
    }

    @Override
    public Future<Void> updateSettings(Http2Settings settings) {
        return this.current.updateSettings(settings);
    }

    @Override
    public HttpConnection updateSettings(Http2Settings settings, Handler<AsyncResult<Void>> completionHandler) {
        return this.current.updateSettings(settings, completionHandler);
    }

    @Override
    public Http2Settings settings() {
        return this.current.settings();
    }

    @Override
    public Http2Settings remoteSettings() {
        return this.current.remoteSettings();
    }

    @Override
    public HttpConnection ping(Buffer data, Handler<AsyncResult<Buffer>> pongHandler) {
        return this.current.ping(data, pongHandler);
    }

    @Override
    public Future<Buffer> ping(Buffer data) {
        return this.current.ping(data);
    }

    @Override
    public SocketAddress remoteAddress() {
        return this.current.remoteAddress();
    }

    @Override
    public SocketAddress remoteAddress(boolean real) {
        return this.current.remoteAddress(real);
    }

    @Override
    public SocketAddress localAddress() {
        return this.current.localAddress();
    }

    @Override
    public SocketAddress localAddress(boolean real) {
        return this.current.localAddress(real);
    }

    @Override
    public boolean isSsl() {
        return this.current.isSsl();
    }

    @Override
    public SSLSession sslSession() {
        return this.current.sslSession();
    }

    @Override
    public X509Certificate[] peerCertificateChain() throws SSLPeerUnverifiedException {
        return this.current.peerCertificateChain();
    }

    @Override
    public List<Certificate> peerCertificates() throws SSLPeerUnverifiedException {
        return this.current.peerCertificates();
    }

    @Override
    public boolean isValid() {
        return this.current.isValid();
    }

    @Override
    public String indicatedServerName() {
        return this.current.indicatedServerName();
    }

    private static class UpgradingStream
    implements HttpClientStream {
        private final Http1xClientConnection upgradingConnection;
        private final HttpClientStream upgradingStream;
        private final Http2UpgradeClientConnection upgradedConnection;
        private HttpClientStream upgradedStream;
        private Handler<HttpResponseHead> headHandler;
        private Handler<Buffer> chunkHandler;
        private Handler<MultiMap> endHandler;
        private Handler<StreamPriority> priorityHandler;
        private Handler<Throwable> exceptionHandler;
        private Handler<Void> drainHandler;
        private Handler<Void> continueHandler;
        private Handler<MultiMap> earlyHintsHandler;
        private Handler<HttpClientPush> pushHandler;
        private Handler<HttpFrame> unknownFrameHandler;
        private Handler<Void> closeHandler;

        UpgradingStream(HttpClientStream stream, Http2UpgradeClientConnection upgradedConnection, Http1xClientConnection upgradingConnection) {
            this.upgradedConnection = upgradedConnection;
            this.upgradingConnection = upgradingConnection;
            this.upgradingStream = stream;
        }

        @Override
        public HttpClientConnection connection() {
            return this.upgradedConnection;
        }

        @Override
        public void writeHead(HttpRequestHead request, boolean chunked, ByteBuf buf, boolean end, StreamPriority priority, boolean connect2, Handler<AsyncResult<Void>> handler) {
            final ChannelPipeline pipeline = this.upgradingConnection.channel().pipeline();
            HttpClientCodec httpCodec = pipeline.get(HttpClientCodec.class);
            VertxHttp2ClientUpgradeCodec upgradeCodec = new VertxHttp2ClientUpgradeCodec(this.upgradedConnection.client.options().getInitialSettings()){

                @Override
                public void upgradeTo(ChannelHandlerContext ctx, FullHttpResponse upgradeResponse) throws Exception {
                    VertxHttp2ConnectionHandler<Http2ClientConnection> handler = Http2ClientConnection.createHttp2ConnectionHandler(upgradedConnection.client, ((UpgradingStream)this).upgradingConnection.metrics, upgradingConnection.getContext(), true, upgradedConnection.current.metric());
                    upgradingConnection.channel().pipeline().addLast(handler);
                    handler.connectFuture().addListener(future -> {
                        if (!future.isSuccess()) {
                            log.error(future.cause().getMessage(), future.cause());
                            return;
                        }
                        Http2ClientConnection conn = (Http2ClientConnection)future.getNow();
                        conn.upgradeStream(upgradingStream.metric(), upgradingStream.trace(), upgradingStream.getContext(), ar -> {
                            upgradingConnection.closeHandler((Handler)null);
                            upgradingConnection.exceptionHandler((Handler)null);
                            upgradingConnection.evictionHandler(null);
                            upgradingConnection.concurrencyChangeHandler(null);
                            if (ar.succeeded()) {
                                upgradedStream = (HttpClientStream)ar.result();
                                upgradedStream.headHandler(headHandler);
                                upgradedStream.chunkHandler(chunkHandler);
                                upgradedStream.endHandler(endHandler);
                                upgradedStream.priorityHandler(priorityHandler);
                                upgradedStream.exceptionHandler(exceptionHandler);
                                upgradedStream.drainHandler(drainHandler);
                                upgradedStream.continueHandler(continueHandler);
                                upgradedStream.earlyHintsHandler(earlyHintsHandler);
                                upgradedStream.pushHandler(pushHandler);
                                upgradedStream.unknownFrameHandler(unknownFrameHandler);
                                upgradedStream.closeHandler(closeHandler);
                                upgradingStream.headHandler(null);
                                upgradingStream.chunkHandler(null);
                                upgradingStream.endHandler(null);
                                upgradingStream.priorityHandler(null);
                                upgradingStream.exceptionHandler((Handler)null);
                                upgradingStream.drainHandler(null);
                                upgradingStream.continueHandler(null);
                                upgradingStream.earlyHintsHandler(null);
                                upgradingStream.pushHandler(null);
                                upgradingStream.unknownFrameHandler(null);
                                upgradingStream.closeHandler(null);
                                headHandler = null;
                                chunkHandler = null;
                                endHandler = null;
                                priorityHandler = null;
                                exceptionHandler = null;
                                drainHandler = null;
                                continueHandler = null;
                                earlyHintsHandler = null;
                                pushHandler = null;
                                closeHandler = null;
                                upgradedConnection.current = conn;
                                conn.closeHandler(upgradedConnection.closeHandler);
                                conn.exceptionHandler(upgradedConnection.exceptionHandler);
                                conn.pingHandler(upgradedConnection.pingHandler);
                                conn.goAwayHandler(upgradedConnection.goAwayHandler);
                                conn.shutdownHandler(upgradedConnection.shutdownHandler);
                                conn.remoteSettingsHandler(upgradedConnection.remoteSettingsHandler);
                                conn.evictionHandler(upgradedConnection.evictionHandler);
                                conn.concurrencyChangeHandler(upgradedConnection.concurrencyChangeHandler);
                                Handler concurrencyChangeHandler = upgradedConnection.concurrencyChangeHandler;
                                upgradedConnection.closeHandler = null;
                                upgradedConnection.exceptionHandler = null;
                                upgradedConnection.pingHandler = null;
                                upgradedConnection.goAwayHandler = null;
                                upgradedConnection.shutdownHandler = null;
                                upgradedConnection.remoteSettingsHandler = null;
                                upgradedConnection.evictionHandler = null;
                                upgradedConnection.concurrencyChangeHandler = null;
                                concurrencyChangeHandler.handle(conn.concurrency());
                            } else {
                                log.error(ar.cause().getMessage(), ar.cause());
                            }
                        });
                    });
                    handler.clientUpgrade(ctx);
                }
            };
            HttpClientUpgradeHandler upgradeHandler = new HttpClientUpgradeHandler(httpCodec, upgradeCodec, 65536){
                private long bufferedSize;
                private Deque<Object> buffered;
                {
                    super(x0, x1, x2);
                    this.bufferedSize = 0L;
                    this.buffered = new ArrayDeque<Object>();
                }

                @Override
                public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
                    if (this.buffered != null) {
                        boolean lower;
                        int maxContent = this.maxContentLength();
                        boolean bl = lower = this.bufferedSize < (long)maxContent;
                        if (msg instanceof ByteBufHolder) {
                            this.bufferedSize += (long)((ByteBufHolder)msg).content().readableBytes();
                        } else if (msg instanceof ByteBuf) {
                            this.bufferedSize += (long)((ByteBuf)msg).readableBytes();
                        }
                        this.buffered.add(msg);
                        if (this.bufferedSize >= (long)maxContent && lower) {
                            ctx.fireExceptionCaught(new TooLongFrameException("Max content exceeded " + this.maxContentLength() + " bytes."));
                        }
                    } else {
                        super.channelRead(ctx, msg);
                    }
                }

                @Override
                public void userEventTriggered(ChannelHandlerContext ctx, Object evt) throws Exception {
                    if (SEND_BUFFERED_MESSAGES == evt) {
                        Object msg;
                        Deque<Object> messages = this.buffered;
                        this.buffered = null;
                        while ((msg = messages.poll()) != null) {
                            super.channelRead(ctx, msg);
                        }
                    } else {
                        super.userEventTriggered(ctx, evt);
                    }
                }

                @Override
                public void handlerRemoved(ChannelHandlerContext ctx) throws Exception {
                    if (this.buffered != null) {
                        Object msg;
                        Deque<Object> messages = this.buffered;
                        this.buffered = null;
                        while ((msg = messages.poll()) != null) {
                            ReferenceCountUtil.release(msg);
                        }
                    }
                    super.handlerRemoved(ctx);
                }
            };
            class UpgradeRequestHandler
            extends ChannelInboundHandlerAdapter {
                UpgradeRequestHandler() {
                }

                @Override
                public void userEventTriggered(ChannelHandlerContext ctx, Object evt) throws Exception {
                    super.userEventTriggered(ctx, evt);
                    ChannelPipeline pipeline2 = ctx.pipeline();
                    if (evt instanceof HttpClientUpgradeHandler.UpgradeEvent) {
                        switch ((HttpClientUpgradeHandler.UpgradeEvent)((Object)evt)) {
                            case UPGRADE_SUCCESSFUL: {
                                pipeline2.remove(UpgradingStream.this.upgradingConnection.channelHandlerContext().handler());
                            }
                            case UPGRADE_REJECTED: {
                                pipeline2.remove(this);
                                UpgradingStream.this.upgradedConnection.upgradeProcessed = true;
                            }
                        }
                    }
                }

                @Override
                public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
                    if (msg instanceof HttpResponseHead) {
                        pipeline.remove(this);
                        HttpResponseHead resp = (HttpResponseHead)msg;
                        if (resp.statusCode != HttpResponseStatus.SWITCHING_PROTOCOLS.code()) {
                            resp.headers.set((CharSequence)HttpHeaderNames.CONNECTION, HttpHeaderValues.CLOSE);
                        }
                    }
                    super.channelRead(ctx, msg);
                }
            }
            pipeline.addAfter("codec", null, new UpgradeRequestHandler());
            pipeline.addAfter("codec", null, upgradeHandler);
            this.doWriteHead(request, chunked, buf, end, priority, connect2, handler);
        }

        private void doWriteHead(HttpRequestHead head, boolean chunked, ByteBuf buf, boolean end, StreamPriority priority, boolean connect2, Handler<AsyncResult<Void>> handler) {
            EventExecutor exec = this.upgradingConnection.channelHandlerContext().executor();
            if (exec.inEventLoop()) {
                this.upgradingStream.writeHead(head, chunked, buf, end, priority, connect2, handler);
                if (end) {
                    ChannelPipeline pipeline = this.upgradingConnection.channelHandlerContext().pipeline();
                    pipeline.fireUserEventTriggered(SEND_BUFFERED_MESSAGES);
                }
            } else {
                exec.execute(() -> this.doWriteHead(head, chunked, buf, end, priority, connect2, handler));
            }
        }

        @Override
        public int id() {
            return 1;
        }

        @Override
        public Object metric() {
            return this.upgradingStream.metric();
        }

        @Override
        public Object trace() {
            return this.upgradingStream.trace();
        }

        @Override
        public HttpVersion version() {
            HttpClientStream s = this.upgradedStream;
            if (s == null) {
                s = this.upgradingStream;
            }
            return s.version();
        }

        @Override
        public ContextInternal getContext() {
            return this.upgradingStream.getContext();
        }

        @Override
        public void continueHandler(Handler<Void> handler) {
            if (this.upgradedStream != null) {
                this.upgradedStream.continueHandler(handler);
            } else {
                this.upgradingStream.continueHandler(handler);
                this.continueHandler = handler;
            }
        }

        @Override
        public void earlyHintsHandler(Handler<MultiMap> handler) {
            if (this.upgradedStream != null) {
                this.upgradedStream.earlyHintsHandler(handler);
            } else {
                this.upgradingStream.earlyHintsHandler(handler);
                this.earlyHintsHandler = handler;
            }
        }

        @Override
        public void pushHandler(Handler<HttpClientPush> handler) {
            if (this.upgradedStream != null) {
                this.upgradedStream.pushHandler(handler);
            } else {
                this.upgradingStream.pushHandler(handler);
                this.pushHandler = handler;
            }
        }

        @Override
        public void closeHandler(Handler<Void> handler) {
            if (this.upgradedStream != null) {
                this.upgradedStream.closeHandler(handler);
            } else {
                this.upgradingStream.closeHandler(handler);
                this.closeHandler = handler;
            }
        }

        public UpgradingStream drainHandler(Handler<Void> handler) {
            if (this.upgradedStream != null) {
                this.upgradedStream.drainHandler(handler);
            } else {
                this.upgradingStream.drainHandler(handler);
                this.drainHandler = handler;
            }
            return this;
        }

        @Override
        public UpgradingStream exceptionHandler(Handler<Throwable> handler) {
            if (this.upgradedStream != null) {
                this.upgradedStream.exceptionHandler((Handler)handler);
            } else {
                this.upgradingStream.exceptionHandler((Handler)handler);
                this.exceptionHandler = handler;
            }
            return this;
        }

        @Override
        public void headHandler(Handler<HttpResponseHead> handler) {
            if (this.upgradedStream != null) {
                this.upgradedStream.headHandler(handler);
            } else {
                this.upgradingStream.headHandler(handler);
                this.headHandler = handler;
            }
        }

        @Override
        public void chunkHandler(Handler<Buffer> handler) {
            if (this.upgradedStream != null) {
                this.upgradedStream.chunkHandler(handler);
            } else {
                this.upgradingStream.chunkHandler(handler);
                this.chunkHandler = handler;
            }
        }

        @Override
        public void endHandler(Handler<MultiMap> handler) {
            if (this.upgradedStream != null) {
                this.upgradedStream.endHandler(handler);
            } else {
                this.upgradingStream.endHandler(handler);
                this.endHandler = handler;
            }
        }

        @Override
        public void unknownFrameHandler(Handler<HttpFrame> handler) {
            if (this.upgradedStream != null) {
                this.upgradedStream.unknownFrameHandler(handler);
            } else {
                this.upgradingStream.unknownFrameHandler(handler);
                this.unknownFrameHandler = handler;
            }
        }

        @Override
        public void priorityHandler(Handler<StreamPriority> handler) {
            if (this.upgradedStream != null) {
                this.upgradedStream.priorityHandler(handler);
            } else {
                this.upgradingStream.priorityHandler(handler);
                this.priorityHandler = handler;
            }
        }

        @Override
        public WriteStream<Buffer> setWriteQueueMaxSize(int maxSize) {
            if (this.upgradedStream != null) {
                this.upgradedStream.setWriteQueueMaxSize(maxSize);
            } else {
                this.upgradingStream.setWriteQueueMaxSize(maxSize);
            }
            return this;
        }

        @Override
        public boolean writeQueueFull() {
            if (this.upgradedStream != null) {
                return this.upgradedStream.writeQueueFull();
            }
            return this.upgradingStream.writeQueueFull();
        }

        @Override
        public void writeBuffer(ByteBuf buf, boolean end, Handler<AsyncResult<Void>> handler) {
            EventExecutor exec = this.upgradingConnection.channelHandlerContext().executor();
            if (exec.inEventLoop()) {
                this.upgradingStream.writeBuffer(buf, end, handler);
                if (end) {
                    ChannelPipeline pipeline = this.upgradingConnection.channelHandlerContext().pipeline();
                    pipeline.fireUserEventTriggered(SEND_BUFFERED_MESSAGES);
                }
            } else {
                exec.execute(() -> this.writeBuffer(buf, end, handler));
            }
        }

        @Override
        public void writeFrame(int type, int flags, ByteBuf payload) {
            if (this.upgradedStream != null) {
                this.upgradedStream.writeFrame(type, flags, payload);
            } else {
                this.upgradingStream.writeFrame(type, flags, payload);
            }
        }

        @Override
        public void doSetWriteQueueMaxSize(int size) {
            if (this.upgradedStream != null) {
                this.upgradedStream.doSetWriteQueueMaxSize(size);
            } else {
                this.upgradingStream.doSetWriteQueueMaxSize(size);
            }
        }

        @Override
        public boolean isNotWritable() {
            if (this.upgradedStream != null) {
                return this.upgradedStream.isNotWritable();
            }
            return this.upgradingStream.isNotWritable();
        }

        @Override
        public void doPause() {
            if (this.upgradedStream != null) {
                this.upgradedStream.doPause();
            } else {
                this.upgradingStream.doPause();
            }
        }

        @Override
        public void doFetch(long amount) {
            if (this.upgradedStream != null) {
                this.upgradedStream.doFetch(amount);
            } else {
                this.upgradingStream.doFetch(amount);
            }
        }

        @Override
        public void reset(Throwable cause) {
            if (this.upgradedStream != null) {
                this.upgradedStream.reset(cause);
            } else {
                this.upgradingStream.reset(cause);
            }
        }

        @Override
        public StreamPriority priority() {
            if (this.upgradedStream != null) {
                return this.upgradedStream.priority();
            }
            return this.upgradingStream.priority();
        }

        @Override
        public void updatePriority(StreamPriority streamPriority) {
            if (this.upgradedStream != null) {
                this.upgradedStream.updatePriority(streamPriority);
            } else {
                this.upgradingStream.updatePriority(streamPriority);
            }
        }
    }

    private static class DelegatingStream
    implements HttpClientStream {
        private final Http2UpgradeClientConnection connection;
        private final HttpClientStream delegate;

        DelegatingStream(Http2UpgradeClientConnection connection, HttpClientStream delegate) {
            this.connection = connection;
            this.delegate = delegate;
        }

        @Override
        public int id() {
            return this.delegate.id();
        }

        @Override
        public Object metric() {
            return this.delegate.metric();
        }

        @Override
        public Object trace() {
            return this.delegate.trace();
        }

        @Override
        public HttpVersion version() {
            return this.delegate.version();
        }

        @Override
        public HttpClientConnection connection() {
            return this.connection;
        }

        @Override
        public ContextInternal getContext() {
            return this.delegate.getContext();
        }

        @Override
        public void writeHead(HttpRequestHead request, boolean chunked, ByteBuf buf, boolean end, StreamPriority priority, boolean connect2, Handler<AsyncResult<Void>> handler) {
            this.delegate.writeHead(request, chunked, buf, end, priority, connect2, handler);
        }

        @Override
        public void writeBuffer(ByteBuf buf, boolean end, Handler<AsyncResult<Void>> listener) {
            this.delegate.writeBuffer(buf, end, listener);
        }

        @Override
        public void writeFrame(int type, int flags, ByteBuf payload) {
            this.delegate.writeFrame(type, flags, payload);
        }

        @Override
        public void continueHandler(Handler<Void> handler) {
            this.delegate.continueHandler(handler);
        }

        @Override
        public void earlyHintsHandler(Handler<MultiMap> handler) {
            this.delegate.earlyHintsHandler(handler);
        }

        @Override
        public void pushHandler(Handler<HttpClientPush> handler) {
            this.delegate.pushHandler(handler);
        }

        @Override
        public void unknownFrameHandler(Handler<HttpFrame> handler) {
            this.delegate.unknownFrameHandler(handler);
        }

        @Override
        public void headHandler(Handler<HttpResponseHead> handler) {
            this.delegate.headHandler(handler);
        }

        @Override
        public void chunkHandler(Handler<Buffer> handler) {
            this.delegate.chunkHandler(handler);
        }

        @Override
        public void endHandler(Handler<MultiMap> handler) {
            this.delegate.endHandler(handler);
        }

        @Override
        public void priorityHandler(Handler<StreamPriority> handler) {
            this.delegate.priorityHandler(handler);
        }

        @Override
        public void closeHandler(Handler<Void> handler) {
            this.delegate.closeHandler(handler);
        }

        @Override
        public void doSetWriteQueueMaxSize(int size) {
            this.delegate.doSetWriteQueueMaxSize(size);
        }

        @Override
        public boolean isNotWritable() {
            return this.delegate.isNotWritable();
        }

        @Override
        public void doPause() {
            this.delegate.doPause();
        }

        @Override
        public void doFetch(long amount) {
            this.delegate.doFetch(amount);
        }

        @Override
        public void reset(Throwable cause) {
            this.delegate.reset(cause);
        }

        @Override
        public StreamPriority priority() {
            return this.delegate.priority();
        }

        @Override
        public void updatePriority(StreamPriority streamPriority) {
            this.delegate.updatePriority(streamPriority);
        }

        @Override
        public WriteStream<Buffer> exceptionHandler(@Nullable Handler<Throwable> handler) {
            this.delegate.exceptionHandler((Handler)handler);
            return this;
        }

        @Override
        public WriteStream<Buffer> setWriteQueueMaxSize(int maxSize) {
            this.delegate.setWriteQueueMaxSize(maxSize);
            return this;
        }

        @Override
        public boolean writeQueueFull() {
            return this.delegate.writeQueueFull();
        }

        @Override
        public WriteStream<Buffer> drainHandler(@Nullable Handler<Void> handler) {
            this.delegate.drainHandler(handler);
            return this;
        }
    }
}

