/*
 * Decompiled with CFR 0.152.
 */
package io.sip3.captain.ce.sender;

import io.micrometer.core.instrument.Counter;
import io.micrometer.core.instrument.Metrics;
import io.sip3.captain.ce.RoutesCE;
import io.sip3.captain.ce.sender.Sender;
import io.sip3.commons.vertx.annotations.Instance;
import io.vertx.core.AbstractVerticle;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.datagram.DatagramPacket;
import io.vertx.core.datagram.DatagramSocket;
import io.vertx.core.datagram.DatagramSocketOptions;
import io.vertx.core.eventbus.Message;
import io.vertx.core.http.WebSocket;
import io.vertx.core.json.JsonObject;
import io.vertx.core.net.NetClientOptions;
import io.vertx.core.net.NetSocket;
import io.vertx.core.streams.ReadStream;
import java.net.URI;
import java.util.List;
import kotlin.Metadata;
import kotlin.NotImplementedError;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import mu.KLogger;
import mu.KotlinLogging;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Instance
@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010.\u001a\u00020/H\u0016J\b\u00100\u001a\u00020/H\u0016J\b\u00101\u001a\u00020/H\u0016J\u0014\u00102\u001a\u00020/2\f\u00103\u001a\b\u0012\u0004\u0012\u00020\u000404J\b\u00105\u001a\u00020/H\u0016J\b\u00106\u001a\u000207H\u0016R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\b\u001a\n \u0005*\u0004\u0018\u00010\t0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\n\u001a\u00020\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u001a\u0010\u0010\u001a\u00020\u0011X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015R\u001c\u0010\u0016\u001a\u0004\u0018\u00010\u0017X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\u0019\"\u0004\b\u001a\u0010\u001bR\u001c\u0010\u001c\u001a\u0004\u0018\u00010\u001dX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001e\u0010\u001f\"\u0004\b \u0010!R\u001a\u0010\"\u001a\u00020#X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b$\u0010%\"\u0004\b&\u0010'R\u001c\u0010(\u001a\u0004\u0018\u00010)X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b*\u0010+\"\u0004\b,\u0010-\u00a8\u00068"}, d2={"Lio/sip3/captain/ce/sender/Sender;", "Lio/vertx/core/AbstractVerticle;", "()V", "delimiter", "Lio/vertx/core/buffer/Buffer;", "kotlin.jvm.PlatformType", "logger", "Lmu/KLogger;", "packetsSent", "Lio/micrometer/core/instrument/Counter;", "reconnectionTimeout", "", "getReconnectionTimeout", "()J", "setReconnectionTimeout", "(J)V", "reusePort", "", "getReusePort", "()Z", "setReusePort", "(Z)V", "tcp", "Lio/vertx/core/net/NetSocket;", "getTcp", "()Lio/vertx/core/net/NetSocket;", "setTcp", "(Lio/vertx/core/net/NetSocket;)V", "udp", "Lio/vertx/core/datagram/DatagramSocket;", "getUdp", "()Lio/vertx/core/datagram/DatagramSocket;", "setUdp", "(Lio/vertx/core/datagram/DatagramSocket;)V", "uri", "Ljava/net/URI;", "getUri", "()Ljava/net/URI;", "setUri", "(Ljava/net/URI;)V", "ws", "Lio/vertx/core/http/WebSocket;", "getWs", "()Lio/vertx/core/http/WebSocket;", "setWs", "(Lio/vertx/core/http/WebSocket;)V", "openTcpConnection", "", "openUdpConnection", "openWsConnection", "send", "buffers", "", "start", "tcpConnectionOptions", "Lio/vertx/core/net/NetClientOptions;", "sip3-captain-ce"})
public class Sender
extends AbstractVerticle {
    @NotNull
    private final KLogger logger = KotlinLogging.INSTANCE.logger(logger.1.INSTANCE);
    public URI uri;
    private long reconnectionTimeout = 1000L;
    private boolean reusePort = true;
    private Buffer delimiter = Buffer.buffer("\r\n\r\n3PIS\r\n\r\n");
    @Nullable
    private DatagramSocket udp;
    @Nullable
    private NetSocket tcp;
    @Nullable
    private WebSocket ws;
    private final Counter packetsSent = Metrics.counter("packets_sent", new String[0]);

    @NotNull
    public final URI getUri() {
        URI uRI = this.uri;
        if (uRI != null) {
            return uRI;
        }
        Intrinsics.throwUninitializedPropertyAccessException("uri");
        return null;
    }

    public final void setUri(@NotNull URI uRI) {
        Intrinsics.checkNotNullParameter(uRI, "<set-?>");
        this.uri = uRI;
    }

    public final long getReconnectionTimeout() {
        return this.reconnectionTimeout;
    }

    public final void setReconnectionTimeout(long l) {
        this.reconnectionTimeout = l;
    }

    public final boolean getReusePort() {
        return this.reusePort;
    }

    public final void setReusePort(boolean bl) {
        this.reusePort = bl;
    }

    @Nullable
    public final DatagramSocket getUdp() {
        return this.udp;
    }

    public final void setUdp(@Nullable DatagramSocket datagramSocket) {
        this.udp = datagramSocket;
    }

    @Nullable
    public final NetSocket getTcp() {
        return this.tcp;
    }

    public final void setTcp(@Nullable NetSocket netSocket) {
        this.tcp = netSocket;
    }

    @Nullable
    public final WebSocket getWs() {
        return this.ws;
    }

    public final void setWs(@Nullable WebSocket webSocket) {
        this.ws = webSocket;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void start() {
        String string;
        JsonObject config2 = this.config().getJsonObject("sender");
        boolean bl = false;
        Object object = config2.getString("uri");
        String string2 = object;
        if (string2 == null) {
            throw new IllegalArgumentException("uri");
        }
        Intrinsics.checkNotNullExpressionValue(string2, "config.getString(\"uri\") \u2026lArgumentException(\"uri\")");
        this.setUri(new URI((String)object));
        Object object2 = object = config2.getLong("reconnection_timeout");
        if (object2 != null) {
            Intrinsics.checkNotNullExpressionValue(object2, "getLong(\"reconnection_timeout\")");
            long it = ((Number)object).longValue();
            boolean bl2 = false;
            this.reconnectionTimeout = it;
        }
        Object object3 = object = config2.getBoolean("reuse_port");
        if (object3 != null) {
            Intrinsics.checkNotNullExpressionValue(object3, "getBoolean(\"reuse_port\")");
            boolean it = (Boolean)object;
            boolean bl3 = false;
            this.reusePort = it;
        }
        Object object4 = object = config2.getString("delimiter");
        if (object4 != null) {
            Intrinsics.checkNotNullExpressionValue(object4, "getString(\"delimiter\")");
            Object it = object;
            boolean bl4 = false;
            this.delimiter = Buffer.buffer((String)it);
        }
        if ((string = this.getUri().getScheme()) == null) throw new NotImplementedError("Unknown protocol: " + this.getUri());
        int n = -1;
        switch (string.hashCode()) {
            case 115649: {
                if (string.equals("udp")) {
                    n = 1;
                }
                break;
            }
            case 114657: {
                if (string.equals("tcp")) {
                    n = 2;
                }
                break;
            }
            case 3804: {
                if (string.equals("ws")) {
                    n = 3;
                }
                break;
            }
        }
        switch (n) {
            case 1: {
                this.openUdpConnection();
                break;
            }
            case 2: {
                this.openTcpConnection();
                break;
            }
            case 3: {
                this.openWsConnection();
                break;
            }
            default: {
                throw new NotImplementedError("Unknown protocol: " + this.getUri());
            }
        }
        this.vertx.eventBus().localConsumer(RoutesCE.Companion.getSender(), arg_0 -> Sender.start$lambda$4(this, arg_0));
    }

    public void openUdpConnection() {
        DatagramSocketOptions datagramSocketOptions;
        DatagramSocketOptions $this$openUdpConnection_u24lambda_u245 = datagramSocketOptions = new DatagramSocketOptions();
        boolean bl = false;
        String string = this.getUri().getHost();
        Intrinsics.checkNotNullExpressionValue(string, "uri.host");
        CharSequence charSequence = string;
        $this$openUdpConnection_u24lambda_u245.setIpV6(new Regex("\\[.*]").matches(charSequence));
        $this$openUdpConnection_u24lambda_u245.setReusePort(this.reusePort);
        DatagramSocketOptions options = datagramSocketOptions;
        this.udp = this.vertx.createDatagramSocket(options);
        this.logger.info("UDP connection opened: " + this.getUri());
    }

    public void openTcpConnection() {
        NetClientOptions options = this.tcpConnectionOptions();
        this.vertx.createNetClient(options).connect(this.getUri().getPort(), this.getUri().getHost()).onFailure(arg_0 -> Sender.openTcpConnection$lambda$7(this, arg_0)).onSuccess(arg_0 -> Sender.openTcpConnection$lambda$10(this, arg_0));
    }

    @NotNull
    public NetClientOptions tcpConnectionOptions() {
        NetClientOptions netClientOptions;
        NetClientOptions $this$tcpConnectionOptions_u24lambda_u2411 = netClientOptions = new NetClientOptions();
        boolean bl = false;
        $this$tcpConnectionOptions_u24lambda_u2411.setReusePort(this.reusePort);
        return netClientOptions;
    }

    public void openWsConnection() {
        throw new NotImplementedError("WebSocket transport is available in EE version");
    }

    public final void send(@NotNull List<? extends Buffer> buffers) {
        block5: {
            Buffer it;
            boolean $i$f$forEach;
            Iterable $this$forEach$iv;
            ReadStream<DatagramPacket> socket;
            Intrinsics.checkNotNullParameter(buffers, "buffers");
            this.packetsSent.increment(buffers.size());
            DatagramSocket datagramSocket = this.udp;
            if (datagramSocket != null) {
                socket = datagramSocket;
                boolean bl = false;
                $this$forEach$iv = buffers;
                $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    it = (Buffer)element$iv;
                    boolean bl2 = false;
                    socket.send(it, this.getUri().getPort(), this.getUri().getHost());
                }
            }
            NetSocket netSocket = this.tcp;
            if (netSocket != null) {
                socket = netSocket;
                boolean bl = false;
                $this$forEach$iv = buffers;
                $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    it = (Buffer)element$iv;
                    boolean bl3 = false;
                    socket.write((DatagramPacket)((Object)it.appendBuffer(this.delimiter)));
                }
            }
            WebSocket webSocket = this.ws;
            if (webSocket == null) break block5;
            socket = webSocket;
            boolean bl = false;
            $this$forEach$iv = buffers;
            $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                it = (Buffer)element$iv;
                boolean bl4 = false;
                socket.write((DatagramPacket)((Object)it));
            }
        }
    }

    private static final void start$lambda$4(Sender this$0, Message event) {
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        try {
            List buffers = (List)event.body();
            Intrinsics.checkNotNullExpressionValue(buffers, "buffers");
            this$0.send(buffers);
        }
        catch (Exception e) {
            this$0.logger.error("Sender 'send()' failed.", e);
        }
    }

    private static final void openTcpConnection$lambda$7$lambda$6(Sender this$0, Long it) {
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        this$0.openTcpConnection();
    }

    private static final void openTcpConnection$lambda$7(Sender this$0, Throwable t) {
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        this$0.logger.error("Sender 'openTcpConnection()' failed.", t);
        this$0.tcp = null;
        this$0.vertx.setTimer(this$0.reconnectionTimeout, arg_0 -> Sender.openTcpConnection$lambda$7$lambda$6(this$0, arg_0));
    }

    private static final void openTcpConnection$lambda$10$lambda$9$lambda$8(Sender this$0, Long it) {
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        this$0.openTcpConnection();
    }

    private static final void openTcpConnection$lambda$10$lambda$9(Sender this$0, Void it) {
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        this$0.logger.info("TCP connection closed: " + this$0.getUri());
        this$0.tcp = null;
        this$0.vertx.setTimer(this$0.reconnectionTimeout, arg_0 -> Sender.openTcpConnection$lambda$10$lambda$9$lambda$8(this$0, arg_0));
    }

    private static final void openTcpConnection$lambda$10(Sender this$0, NetSocket socket) {
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        this$0.logger.info("TCP connection opened: " + this$0.getUri());
        this$0.tcp = socket.closeHandler(arg_0 -> Sender.openTcpConnection$lambda$10$lambda$9(this$0, arg_0));
    }
}

