/*
 * Decompiled with CFR 0.152.
 */
package io.sip3.captain.ce.pipeline;

import io.netty.buffer.ByteBuf;
import io.sip3.captain.ce.RoutesCE;
import io.sip3.captain.ce.domain.Packet;
import io.sip3.captain.ce.pipeline.Handler;
import io.sip3.captain.ce.recording.RecordingManager;
import io.sip3.commons.domain.payload.Encodable;
import io.sip3.commons.domain.payload.Payload;
import io.sip3.commons.domain.payload.RecordingPayload;
import io.sip3.commons.domain.payload.RtpPacketPayload;
import io.sip3.commons.util.StringUtilKt;
import io.sip3.commons.vertx.util.EventBusUtilKt;
import io.vertx.core.Vertx;
import io.vertx.core.eventbus.EventBus;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0010\t\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0002\u0010\u0005\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 #2\u00020\u0001:\u0001#B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\u001b\u001a\u00020\u00072\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J\u0010\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u0011H\u0016J\u0012\u0010!\u001a\u0004\u0018\u00010\"2\u0006\u0010\u001c\u001a\u00020\u001dH\u0002R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R \u0010\r\u001a\u0014\u0012\u0004\u0012\u00020\u000f\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00110\u00100\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00160\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lio/sip3/captain/ce/pipeline/RtpHandler;", "Lio/sip3/captain/ce/pipeline/Handler;", "vertx", "Lio/vertx/core/Vertx;", "config", "Lio/vertx/core/json/JsonObject;", "bulkOperationsEnabled", "", "(Lio/vertx/core/Vertx;Lio/vertx/core/json/JsonObject;Z)V", "bulkSize", "", "collectorEnabled", "instances", "packets", "", "", "", "Lio/sip3/captain/ce/domain/Packet;", "payloadTypes", "", "", "portRanges", "Lkotlin/ranges/IntRange;", "recordingManager", "Lio/sip3/captain/ce/recording/RecordingManager;", "recordings", "rtpEventsEnabled", "isRtpEvent", "buffer", "Lio/netty/buffer/ByteBuf;", "onPacket", "", "packet", "readRtpHeader", "Lio/sip3/commons/domain/payload/RtpPacketPayload;", "Companion", "sip3-captain-ce"})
public final class RtpHandler
extends Handler {
    @NotNull
    public static final Companion Companion;
    @NotNull
    private final Map<Long, List<Packet>> packets;
    @NotNull
    private final List<Packet> recordings;
    private int bulkSize;
    @NotNull
    private final List<IntRange> portRanges;
    private int instances;
    @NotNull
    private Set<Byte> payloadTypes;
    private boolean collectorEnabled;
    private boolean rtpEventsEnabled;
    @NotNull
    private final RecordingManager recordingManager;
    @NotNull
    private static final Set<Byte> DYNAMIC_PT;

    /*
     * WARNING - void declaration
     */
    public RtpHandler(@NotNull Vertx vertx, @NotNull JsonObject config2, boolean bulkOperationsEnabled) {
        block11: {
            Object object;
            Boolean bl;
            Object object2;
            JsonArray jsonArray;
            Intrinsics.checkNotNullParameter(vertx, "vertx");
            Intrinsics.checkNotNullParameter(config2, "config");
            super(vertx, config2, bulkOperationsEnabled);
            this.packets = new LinkedHashMap();
            this.recordings = new ArrayList();
            this.bulkSize = 1;
            this.portRanges = new ArrayList();
            this.instances = 1;
            this.payloadTypes = new LinkedHashSet();
            this.recordingManager = RecordingManager.INSTANCE.getInstance(vertx, config2);
            Object object3 = config2.getJsonObject("vertx");
            if (object3 != null && (object3 = ((JsonObject)object3).getInteger("instances")) != null) {
                int it = ((Number)object3).intValue();
                boolean bl2 = false;
                this.instances = it;
            }
            JsonObject jsonObject = config2.getJsonObject("rtp");
            if (jsonObject == null) break block11;
            JsonObject rtpConfig = jsonObject;
            boolean bl3 = false;
            if (bulkOperationsEnabled) {
                Integer n;
                Integer n2 = n = rtpConfig.getInteger("bulk_size");
                if (n2 != null) {
                    Intrinsics.checkNotNullExpressionValue(n2, "getInteger(\"bulk_size\")");
                    int it = ((Number)n).intValue();
                    boolean bl4 = false;
                    this.bulkSize = it;
                }
            }
            JsonArray jsonArray2 = jsonArray = rtpConfig.getJsonArray("port_ranges");
            if (jsonArray2 != null) {
                void $this$mapTo$iv$iv;
                Intrinsics.checkNotNullExpressionValue(jsonArray2, "getJsonArray(\"port_ranges\")");
                Iterable $this$map$iv = jsonArray;
                boolean $i$f$map = false;
                Iterable bl4 = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
                boolean $i$f$mapTo = false;
                Iterator iterator2 = $this$mapTo$iv$iv.iterator();
                while (iterator2.hasNext()) {
                    void portRange;
                    Object item$iv$iv;
                    Object t = item$iv$iv = iterator2.next();
                    Collection collection = destination$iv$iv;
                    boolean bl5 = false;
                    Intrinsics.checkNotNull(portRange, "null cannot be cast to non-null type kotlin.String");
                    String cfr_ignored_0 = (String)portRange;
                    collection.add(this.portRanges.add(StringUtilKt.toIntRange((String)portRange)));
                }
                List cfr_ignored_1 = (List)destination$iv$iv;
            }
            JsonArray jsonArray3 = jsonArray = rtpConfig.getJsonArray("payload_types");
            if (jsonArray3 != null) {
                Intrinsics.checkNotNullExpressionValue(jsonArray3, "getJsonArray(\"payload_types\")");
                Iterable $this$forEach$iv = jsonArray;
                boolean $i$f$forEach = false;
                Iterator $this$mapTo$iv$iv = $this$forEach$iv.iterator();
                while ($this$mapTo$iv$iv.hasNext()) {
                    Object element$iv;
                    Object payloadType = element$iv = $this$mapTo$iv$iv.next();
                    boolean bl6 = false;
                    Object t = payloadType;
                    if (t instanceof Integer) {
                        this.payloadTypes.add((byte)((Number)payloadType).intValue());
                        continue;
                    }
                    if (!(t instanceof String)) continue;
                    Intrinsics.checkNotNullExpressionValue(payloadType, "payloadType");
                    Iterable $this$forEach$iv2 = StringUtilKt.toIntRange((String)payloadType);
                    boolean $i$f$forEach2 = false;
                    Iterator iterator3 = $this$forEach$iv2.iterator();
                    while (iterator3.hasNext()) {
                        int element$iv2;
                        int it = element$iv2 = ((IntIterator)iterator3).nextInt();
                        boolean bl7 = false;
                        this.payloadTypes.add((byte)it);
                    }
                }
            }
            if ((object2 = rtpConfig.getJsonObject("collector")) != null && (object2 = (bl = ((JsonObject)object2).getBoolean("enabled"))) != null) {
                Intrinsics.checkNotNullExpressionValue(object2, "getBoolean(\"enabled\")");
                boolean it = bl;
                boolean bl8 = false;
                this.collectorEnabled = it;
            }
            if ((object = rtpConfig.getJsonObject("events")) != null && (object = (bl = ((JsonObject)object).getBoolean("enabled"))) != null) {
                Intrinsics.checkNotNullExpressionValue(object, "getBoolean(\"enabled\")");
                boolean it = bl;
                boolean bl9 = false;
                this.rtpEventsEnabled = it;
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void onPacket(@NotNull Packet packet) {
        RecordingPayload recording;
        Packet $i$f$none;
        block21: {
            block22: {
                boolean bl;
                block20: {
                    int n;
                    int n2;
                    int n3;
                    IntRange it;
                    boolean bl2;
                    boolean $i$f$none2;
                    Iterable $this$none$iv;
                    block19: {
                        Intrinsics.checkNotNullParameter(packet, "packet");
                        if (!(!((Collection)this.portRanges).isEmpty())) break block21;
                        $this$none$iv = this.portRanges;
                        $i$f$none2 = false;
                        if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                            bl2 = true;
                        } else {
                            for (Object element$iv : $this$none$iv) {
                                it = (IntRange)element$iv;
                                boolean bl3 = false;
                                n3 = it.getFirst();
                                n2 = it.getLast();
                                n = packet.getSrcPort();
                                boolean bl4 = n3 <= n ? n <= n2 : false;
                                if (!bl4) continue;
                                bl2 = false;
                                break block19;
                            }
                            bl2 = true;
                        }
                    }
                    if (bl2) break block22;
                    $this$none$iv = this.portRanges;
                    $i$f$none2 = false;
                    if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                        bl = true;
                    } else {
                        for (Object element$iv : $this$none$iv) {
                            it = (IntRange)element$iv;
                            boolean bl5 = false;
                            n3 = it.getFirst();
                            n2 = it.getLast();
                            n = packet.getDstPort();
                            boolean bl6 = n3 <= n ? n <= n2 : false;
                            if (!bl6) continue;
                            bl = false;
                            break block20;
                        }
                        bl = true;
                    }
                }
                if (!bl) break block21;
            }
            return;
        }
        Payload payload = packet.getPayload();
        Intrinsics.checkNotNull(payload, "null cannot be cast to non-null type io.sip3.commons.domain.payload.Encodable");
        ByteBuf buffer = ((Encodable)payload).encode();
        Packet $this$onPacket_u24lambda_u2410 = $i$f$none = packet;
        boolean bl = false;
        $this$onPacket_u24lambda_u2410.setProtocolCode((byte)2);
        $this$onPacket_u24lambda_u2410.setRecordingMark(buffer.readerIndex());
        RtpPacketPayload rtpPacketPayload = this.readRtpHeader(buffer);
        if (rtpPacketPayload == null) {
            return;
        }
        RtpPacketPayload rtpPacketPayload2 = rtpPacketPayload;
        if (this.rtpEventsEnabled && DYNAMIC_PT.contains(rtpPacketPayload2.getPayloadType()) && this.isRtpEvent(buffer)) {
            rtpPacketPayload2.setEvent(buffer.readInt());
        }
        if ((recording = this.recordingManager.record(packet)) != null) {
            Packet p;
            Packet packet2;
            Packet packet3 = packet.getRejected();
            if (packet3 == null) {
                packet3 = packet.clone();
            }
            Packet $this$onPacket_u24lambda_u2411 = packet2 = (p = packet3);
            boolean bl7 = false;
            $this$onPacket_u24lambda_u2411.setProtocolCode((byte)7);
            $this$onPacket_u24lambda_u2411.setPayload(recording);
            this.recordings.add(p);
            if (this.recordings.size() >= this.bulkSize) {
                EventBus eventBus = this.getVertx().eventBus();
                Intrinsics.checkNotNullExpressionValue(eventBus, "vertx.eventBus()");
                EventBusUtilKt.localSend$default(eventBus, RoutesCE.Companion.getEncoder(), CollectionsKt.toList((Iterable)this.recordings), null, 4, null);
                this.recordings.clear();
            }
            rtpPacketPayload2.setRecorded(true);
        }
        if (this.collectorEnabled) {
            Packet packet4;
            Object object;
            void $this$getOrPut$iv;
            long index = rtpPacketPayload2.getSsrc() % (long)this.instances;
            Map<Long, List<Packet>> bl7 = this.packets;
            Long key$iv = index;
            boolean $i$f$getOrPut = false;
            Object value$iv = $this$getOrPut$iv.get(key$iv);
            if (value$iv == null) {
                boolean bl8 = false;
                List answer$iv = new ArrayList();
                $this$getOrPut$iv.put(key$iv, answer$iv);
                object = answer$iv;
            } else {
                object = value$iv;
            }
            List packetsByIndex = (List)object;
            Packet $this$onPacket_u24lambda_u2413 = packet4 = packet;
            boolean bl9 = false;
            $this$onPacket_u24lambda_u2413.setPayload(rtpPacketPayload2);
            packetsByIndex.add(packet);
            if (packetsByIndex.size() >= this.bulkSize) {
                EventBus eventBus = this.getVertx().eventBus();
                Intrinsics.checkNotNullExpressionValue(eventBus, "vertx.eventBus()");
                EventBusUtilKt.localSend$default(eventBus, RoutesCE.Companion.getRtp() + "_" + index, CollectionsKt.toList(packetsByIndex), null, 4, null);
                packetsByIndex.clear();
            }
        }
    }

    private final RtpPacketPayload readRtpHeader(ByteBuf buffer) {
        RtpPacketPayload rtpPacketPayload;
        RtpPacketPayload $this$readRtpHeader_u24lambda_u2415 = rtpPacketPayload = new RtpPacketPayload();
        boolean bl = false;
        byte flags = buffer.readByte();
        boolean x = (byte)(flags & 0x10) == 16;
        byte cc = (byte)(flags & 0xF);
        short s = buffer.readUnsignedByte();
        boolean bl2 = false;
        $this$readRtpHeader_u24lambda_u2415.setMarker((short)(s & 0x80) == 128);
        $this$readRtpHeader_u24lambda_u2415.setPayloadType((byte)(s & 0x7F));
        $this$readRtpHeader_u24lambda_u2415.setSequenceNumber(buffer.readUnsignedShort());
        $this$readRtpHeader_u24lambda_u2415.setTimestamp(buffer.readUnsignedInt());
        $this$readRtpHeader_u24lambda_u2415.setSsrc(buffer.readUnsignedInt());
        if ($this$readRtpHeader_u24lambda_u2415.getSsrc() <= 0L || $this$readRtpHeader_u24lambda_u2415.getPayloadType() < 0 || !((Collection)this.payloadTypes).isEmpty() && !this.payloadTypes.contains($this$readRtpHeader_u24lambda_u2415.getPayloadType())) {
            return null;
        }
        if (cc > 0) {
            buffer.skipBytes(cc * 4);
        }
        if (x) {
            buffer.skipBytes(2);
            int length = buffer.readUnsignedShort();
            buffer.skipBytes(4 * length);
        }
        return rtpPacketPayload;
    }

    private final boolean isRtpEvent(ByteBuf buffer) {
        return buffer.readableBytes() == 4 && (buffer.getInt(buffer.readerIndex()) >> 22 & 1) == 0;
    }

    /*
     * WARNING - void declaration
     */
    static {
        void var3_3;
        void $this$mapTo$iv$iv;
        Companion = new Companion(null);
        Iterable $this$map$iv = new IntRange(96, 127);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        Iterator iterator2 = $this$mapTo$iv$iv.iterator();
        while (iterator2.hasNext()) {
            void it;
            int item$iv$iv;
            int n = item$iv$iv = ((IntIterator)iterator2).nextInt();
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add((byte)it);
        }
        DYNAMIC_PT = CollectionsKt.toSet((List)var3_3);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0010\u0005\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lio/sip3/captain/ce/pipeline/RtpHandler$Companion;", "", "()V", "DYNAMIC_PT", "", "", "getDYNAMIC_PT", "()Ljava/util/Set;", "sip3-captain-ce"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Set<Byte> getDYNAMIC_PT() {
            return DYNAMIC_PT;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

