/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.core.instrument.kotlin;

import io.micrometer.common.lang.Nullable;
import io.micrometer.context.ContextRegistry;
import io.micrometer.context.ContextSnapshot;
import io.micrometer.context.ContextSnapshotFactory;
import io.micrometer.observation.Observation;
import io.micrometer.observation.ObservationRegistry;
import kotlin.coroutines.CoroutineContext;
import kotlin.jvm.functions.Function2;
import kotlinx.coroutines.ThreadContextElement;

class KotlinObservationContextElement
implements ThreadContextElement<ContextSnapshot.Scope> {
    static final CoroutineContext.Key<KotlinObservationContextElement> KEY = new CoroutineContext.Key<KotlinObservationContextElement>(){};
    private final ObservationRegistry observationRegistry;
    private final ContextSnapshot contextSnapshot;

    KotlinObservationContextElement(ObservationRegistry observationRegistry, ContextRegistry contextRegistry) {
        this.observationRegistry = observationRegistry;
        this.contextSnapshot = ContextSnapshotFactory.builder().captureKeyPredicate("micrometer.observation"::equals).contextRegistry(contextRegistry).build().captureAll(new Object[0]);
    }

    @Override
    public CoroutineContext.Key<?> getKey() {
        return KEY;
    }

    Observation getCurrentObservation() {
        return this.observationRegistry.getCurrentObservation();
    }

    @Override
    public ContextSnapshot.Scope updateThreadContext(CoroutineContext coroutineContext2) {
        return this.contextSnapshot.setThreadLocals("micrometer.observation"::equals);
    }

    @Override
    public void restoreThreadContext(CoroutineContext coroutineContext2, ContextSnapshot.Scope scope) {
        scope.close();
    }

    @Override
    public CoroutineContext plus(CoroutineContext coroutineContext2) {
        return CoroutineContext.DefaultImpls.plus(this, coroutineContext2);
    }

    @Override
    public <R> R fold(R initial, Function2<? super R, ? super CoroutineContext.Element, ? extends R> operation) {
        return CoroutineContext.Element.DefaultImpls.fold(this, initial, operation);
    }

    @Override
    @Nullable
    public <E extends CoroutineContext.Element> E get(CoroutineContext.Key<E> key) {
        return CoroutineContext.Element.DefaultImpls.get(this, key);
    }

    @Override
    public CoroutineContext minusKey(CoroutineContext.Key<?> key) {
        return CoroutineContext.Element.DefaultImpls.minusKey(this, key);
    }
}

